#! /bin/sh
# check script for Zutils - Utilities dealing with compressed files
# Copyright (C) 2009 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
ZCAT="${objdir}"/zcat
ZDIFF="${objdir}"/zdiff
ZGREP="${objdir}"/zgrep
compressors="gzip bzip2 lzip"
extensions="gz bz2 lz"
framework_failure() { echo 'failure in testing framework'; exit 1; }

if [ ! -x "${ZCAT}" ] ; then
	echo "${ZCAT}: cannot execute"
	exit 1
fi

if [ -d tmp ] ; then rm -r tmp ; fi
mkdir tmp
echo -n "testing zutils..."
cd "${objdir}"/tmp

for i in ${compressors}; do
	cat "${testdir}"/../COPYING > in || framework_failure
	$i in || framework_failure
	echo -n .
done

cat "${testdir}"/../COPYING > in || framework_failure
cat in > -in- || framework_failure
cat in.lz > -in-.lz || framework_failure
cat in in in in in > in5 || framework_failure
fail=0


for i in ${extensions}; do
	"${ZCAT}" in.$i > copy || fail=1
	cmp in copy || fail=1
	echo -n .
done

"${ZCAT}" in in.gz in.bz2 in.lz -- -in- > copy5 || fail=1
cmp in5 copy5 || fail=1
echo -n .


for i in ${extensions}; do
	"${ZDIFF}" in.$i || fail=1
	echo -n .
	"${ZDIFF}" in in.$i || fail=1
	echo -n .
	"${ZDIFF}" in.$i in || fail=1
	echo -n .
done

"${ZDIFF}" in || fail=1
echo -n .
"${ZDIFF}" in.lz in.gz || fail=1
echo -n .
"${ZDIFF}" in.gz -- -in-.lz || fail=1
echo -n .
"${ZDIFF}" -- -in-.lz in.gz || fail=1
echo -n .
"${ZDIFF}" in -- -in-.lz || fail=1
echo -n .
"${ZDIFF}" -- -in- in.lz || fail=1
echo -n .
"${ZDIFF}" in.lz -- -in- || fail=1
echo -n .
"${ZDIFF}" -- -in-.lz in || fail=1
echo -n .
"${ZDIFF}" -- -in- in || fail=1
echo -n .
"${ZDIFF}" in -- -in- || fail=1
echo -n .


for i in ${extensions}; do
	"${ZDIFF}" --cmp in.$i || fail=1
	echo -n .
	"${ZDIFF}" --cmp in in.$i || fail=1
	echo -n .
	"${ZDIFF}" --cmp in.$i in || fail=1
	echo -n .
done


for i in ${extensions}; do
	"${ZGREP}" License in.$i 2>&1 > /dev/null || fail=1
	echo -n .
done

"${ZGREP}" License in in.gz in.bz2 in.lz -- -in- 2>&1 > /dev/null || fail=1
echo -n .


echo
if test ${fail} = 0; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
