/*
 * Copyright (C) 2019 Alexandros Theodotou <alex at zrythm dot org>
 *
 * This file is part of Zrythm
 *
 * Zrythm is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Zrythm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Zrythm.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file
 *
 * Modulator view in the bottom panel.
 */

#ifndef __GUI_WIDGETS_MODULATOR_VIEW_H__
#define __GUI_WIDGETS_MODULATOR_VIEW_H__

#include <gtk/gtk.h>

#define MODULATOR_VIEW_WIDGET_TYPE \
  (modulator_view_widget_get_type ())
G_DECLARE_FINAL_TYPE (
  ModulatorViewWidget,
  modulator_view_widget,
  Z, MODULATOR_VIEW_WIDGET,
  GtkBox)

#define MW_MODULATOR_VIEW \
  MW_BOT_DOCK_EDGE->modulator_view

/**
 * Brings up the ModulatorViewWidget in the notebook.
 */
#define SHOW_MODULATOR_VIEW \
  gtk_notebook_set_current_page ( \
    MW_MODULATOR_VIEW->bot_notebook, 2)

typedef struct _ModulatorWidget ModulatorWidget;
typedef struct _ColorAreaWidget ColorAreaWidget;
typedef struct Track Track;

/**
 * The ModulatorViewWidget contains the
 * ModulatorWidgets for the selected Track.
 */
typedef struct _ModulatorViewWidget
{
  GtkBox            parent_instance;
  GtkBox *          modulators_box;
  ColorAreaWidget * color;
  GtkLabel *        track_name;
  Track *           track;
  ModulatorWidget * modulators[14];
} ModulatorViewWidget;

void
modulator_view_widget_refresh (
  ModulatorViewWidget * self,
  Track *               track);

#endif
