#!/usr/bin/perl -w
##############################################################################
=pod

=head1 NAME

toutou-starter

=head1 DESCRIPTION

starter for the GUI that connects through SSL to a running zebot instance and
gives a IRC-client functionality

=head1 COPYRIGHT and LICENCE

Copyright (c) 2002 Bruno Boettcher

tougui.pl is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
use strict;
use warnings;

use Gtk2;
use POE;

use zebot::configHandler;
use zebot::gui::toutouGui;

use constant FALSE => 0;
use constant TRUE  => 1;
my $VERSION = '$Revision: 1.2 $';
$VERSION =~ s/.*(\d+\.\d+).*/$1/;


my $allowedSettings = { "--config" => "rootpath" };
my $settings = {
  "configpath" => $ENV{HOME}."/.zebot/",
  "bufferlength" => 500,
  "frame_alias" => "mainframe_alias",
  "frame_title" => "Toutou - GUI",
};

#$settings->{"rootpath"} .= "/" if(!($settings->{"rootpath"} =~ /\/$/));

  my $configs = new zebot::configHandler($settings);
  $configs->init();

  $configs->loadSettings($settings->{"configpath"});
  $configs->parseArgs(\@ARGV);

my $client = zebot::gui::toutouGui->new($settings);
$client->init();
$poe_kernel->run();
exit 0;
__END__


=back

=head1 THANKS

ya for creating the first version of this framework

=head1 AUTHOR

Bruno Bttcher <bboett <at> adlp <dot> org>

=head1 SEE ALSO

  zebot home page  http://www.freesoftware.fsf.org/zebot/ 
  Net::IRC, 
  RFC 1459,
  http://www.irchelp.org/, 
  http://poe.perl.org/
  http://www.cs.cmu.edu/~lenzo/perl/, 
  http://www.infobot.org/,


=cut
