##############################################################################
=pod

=head1 NAME

test module

=head1 DESCRIPTION

test module to test new functionalies

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  testmod.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
#!/usr/bin/perl -w
package zebot::testmod;
use strict;

#use IO::Socket;
use Data::Dumper;
#use ObjectTemplate;
#use Net::IRC;
# sub POE::Kernel::ASSERT_DEFAULT () { 1 }
# sub POE::Kernel::ASSERT_PONY () { 1 }
# sub POE::Kernel::ASSERT_EVENTS () { 1 }
# sub POE::Kernel::ASSERT_STATES () { 1 }

#use POE::Kernel;
use POE::Session;
#use POE::Component::IRC;

use POSIX qw(strftime);
use DBI;

#use Data::Dumper;
use zebot::baseactor;

#========================================================
our @ISA = ("zebot::baseactor");
#attributes("users","deb","active","errmsg","dbh");
zebot::baseactor::_define_constructor("zebot::testmod");
my $localkernel = "";

######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "testmod";
}#sub isa
######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.7 $';
}#sub isa

#########################################################
=pod

=item _default 

the stuff  that couldn't be identifyed

=cut

#########################################################
sub _default 
{
  my ($state, $event, $args,$context) = @_[STATE, ARG0, ARG1,SENDER];
  $args ||= [];
  my $localkernel = $_[KERNEL];
  my $this = shift;

  # Uncomment for noisy operation.
  # testmod: _default -- irc_public Errk!bboett@AStrasbourg-202-1-4-53.abo.wanadoo.fr ARRAY(0x8649af4) bot debbugging!
  if($event eq 'irc_public')
  {
    #testmod: _default -- irc_public $VAR1 = [
    #          'Errk!bboett@AStrasbourg-202-1-4-53.abo.wanadoo.fr',
    #                    [
    #                                '#lem'
    #                                          ],
    #                                                    'next run!'
    #                                                            ];
    #
    my ($sender,$targets,$text) = @$args;
    my $channel = $targets->[0];
     # $this->print("testmod: $state -- $event ".Dumper($args)."\n");
     my $subargs = { "channel" => $channel, "sender" => $sender, "text" => $text };
     $localkernel->post( $this->isa(), 'PM', "from ".$this->isa()." : ".$text );
     $localkernel->post( $context, 'PM', "from zebot : ".$text );

     $localkernel->delay( 'pubtrig', 5, $subargs );
     # $this->print("testmod: $state -- $event\@$channel ".Dumper($args)."\n");
  }#if($event eq 'irc_public')
  else
  {
  # $this->print("testmod: $state -- $event @$args\n");
  }#else
  return 0;
}

#########################################################
=pod

=item uncatched

the stuff  that couldn't be identifyed

=cut

#########################################################
sub uncatched
{
  my $this = shift;
  my $splittedline  = shift;
  # Uncomment for noisy operation.
  # $this->print("testmod[uncatched]: @_\n");
  
  return 0;
}# sub uncatched
#########################################################
=pod

=item _start 

This gets executed as soon as the kernel sets up this session.

=cut

#########################################################
sub _start 
{
  my ($kernel, $session) = @_[KERNEL, SESSION];
  my $this = shift;
  $this->SUPER::_start(@_);

  # Uncomment this to turn on more verbose POE debugging information.
  # $session->option( trace => 1 );

  # Make an alias for our session, to keep it from getting GC'ed.
  #$kernel->alias_set( 'testmod' );

  # Ask the IRC component to send us all IRC events it receives. This
  # is the easy, indiscriminate way to do it.
  #$kernel->post( 'testmod', 'register', 'all');
  #$kernel->post( $context, 'register', 'all');
  $this->print("\nstarting test module\n");

}# sub _start 

#########################################################
# This gets executed as soon as the kernel stops this session.
#########################################################
# sub _stop
# {
#   my ($kernel, $session) = @_[KERNEL, SESSION];
#
#   $this->print("testmod stopped\n");
# }# sub stop

#########################################################
=pod

=item init

make the connection to th e POE system

=cut

#########################################################
sub init
{
  my @securedargs = @_;
  my $this = shift;
  my $sysref = shift;
  my $sysrefe = $sysref;
  # $this->print("obj = $this\n");
  # $this->print("syse[botname] = ".$sysrefe{"botname"}."\n");


  $this->print("testmod[".isa()."] calling super::init\n");
  $this->SUPER::init($sysref);
  $this->sysdata($sysref); #why is this vital for other objects????
 #  POE::Session->new( 'testmod' =>
 #      [ qw( _start _stop _default)
 #      ],
 #      );
        # irc_public => \&_default,
        # irc_quit => \&_default,
        # irc_part => \&_default,
        # irc_mode => \&_default,
        # irc_join => \&_default,
        # irc_msg => \&_default,
        # irc_notice => \&_default,
   #package_states => {
   #  testmod => [ qw( _start _stop _default ) ],
   #},
  #POE::Session->create(
  #  package_states => [
  #    testmod => [ qw( _start _stop _default ) ],
  #  ],
  #  inline_states => {
  #    irc_public => \&_default,
  #    irc_quit => \&_default,
  #    irc_part => \&_default,
  #    irc_mode => \&_default,
  #    irc_join => \&_default,
  #    irc_msg  => \&_default,
  #    irc_notice => \&_default,
  #  },
  #);

  # $this->print("tempmod starting kernel\n");
#$poe_kernel->run();
  # $this->print("tempmod kernel started \n");

}# sub init
#########################################################
=pod

=item pubtrig

react on a trigger send through public means

=cut

#########################################################
sub pubtrig
{
  print("pubtrig triggered with :".Dumper(@_)."\n");
}#sub pubtrig
1
__END__

=back

=head1 NAME

POE::Component::testmod - a fully event-driven test module.

=head1 SYNOPSIS

  use POE::Component::testmod;

  # Do this when you create your sessions. 'my client' is just a

=head1 METHODS

Well, OK, there's only actually one, so it's more like "METHOD".

=over

=item new

Takes one argument: a name (kernel alias) which this new connection

=back

=head1 INPUT

How to talk to your new IRC component... here's the events we'll accept.

=head2 Important Commands

=over

=item ctcp and ctcpreply

Sends a CTCP query or response to the nick(s) or channel(s) which you

=item connect

Takes one argument: a hash reference of attributes for the new

=item dcc

Send a DCC SEND or CHAT request to another person. Takes at least two

=item dcc_accept

Accepts an incoming DCC connection from another host. First argument:

=item dcc_chat

Sends lines of data to the person on the other side of a DCC CHAT

=item dcc_close

Terminates a DCC SEND or GET connection prematurely, and causes DCC CHAT

=item join

Tells your IRC client to join a single channel of your choice. Takes

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

