package zebot::test;
use Data::Dumper;
use POE::Session;
use XML::Simple;
use zebot::configHandler;
use zebot::testLink;


sub new 
{
  my $this = bless {}, "zebot::test";
  #print("SPAWNER CTOR incoming args: ".Dumper(\@_)."\n");
  return $this;
}
sub setting 
{
  my ($this,$key,$value) = @_;
  if(!$value)
  {
    return $this->{"settings"}->{$key};
  }# if ($key)
  $this->{"settings"}->{$key} = $value;
}#setting
#########################################################
=pod

=item loadSettings

load form the conf file the different bot settings

=cut

#########################################################
sub loadSettings 
{
  my ($this) = @_;
  my $configs = new zebot::configHandler($this->{"settings"});
  $configs->init();
  #print("loading settings from ".$this->{"settings"}->{"configpath"}."\n");

  $configs->loadSettings($this->{"settings"}->{"configpath"});

  #print( "laodSettings : ".Dumper($this->{"settings"})."\n" );
  $this->{"servers"} = $this->{"settings"}->{"subsettings"}->{"servers"};
  delete $this->{"settings"}->{"subsettings"}->{"servers"};
  $this->{"actornames"} = $this->{"settings"}->{"subsettings"}->{"actors"};
  delete $this->{"settings"}->{"subsettings"}->{"actors"};
  #print("dumping1 actors ".Dumper($this->{"actornames"})."\n");

  if($_[KERNEL])
  {
    my $line = $_[ARG0];
    $_[KERNEL]->post( $line->{"context"}, 'privmsg',$line->{"usernick"},"loaded settings ok");
  }# if($_[KERNEL])

}# sub loadSettings 
#########################################################
=pod

=item language

fetch the language for a given channel, otherwise return the list of installed
channels and languages

in otherterms setter and getter for the language...

=cut

#########################################################
sub language
{
  my ($this,$channel,$lang) = @_;
  my $languageRef = $this->{"channelLangs"};
  if($channel)
  {
    $channel = lc($channel);
    if($lang)
    {
      $languageRef->{$channel} = $lang;
    }# if($lang)
    return($languageRef->{$channel}); 
  }# if($arg)

  my $msg;
  foreach my $i (keys(%$languageRef))
  {
    $msg .= "$i ->".$languageRef->{$i}."\n";
  }#foreach $i (keys(%$this->{"actors"}))
  $msg .= "...X\n";
  return $msg;
}# sub language
#########################################################
=pod

=item module

issue the list of installed modules
ir if an argument was given return the asked module

=cut

#########################################################
sub module
{
  my ($this,$name,$module) = @_;
  my $actorRef = $this->{"actors"};
  if($name)
  {
    if($module)
    {
      $actorRef->{$name} = $module;
    }# if($module)
    my $toreturn = $actorRef->{$name};
    print("couldn't return module $name!! list is:".Dumper(keys(%$actorRef))) if(!$toreturn);
   return($actorRef->{$name}); 
  }# if($arg)

  #foreach my $i (keys(%$actorRef))
  #{
  #  print("debMainTest: $i ->".$actorRef->{$i}."\n");
  #}#foreach $i (keys(%$this->{"actors"}))
  return $actorRef;
}# sub module
#########################################################
=pod

=item connectServer

use the data from the serverlist and the nickname for a given network to
connect to a server

=cut

#########################################################
sub connectServer
{
  my ($this,$kernel,$name,$mode) = @_;
  my $msg ;
  my $arg = { "target" => $name };
  print("trying to connect to $name\n");
  if(!$name)
  {
    $msg .= $this->getMesg("You must specify a servername")."\n";
    return $msg; 
  }# if(!$name)
  print("name valid\n");

  $this->{"servers"}->{"pingouin"} = 
  {
    "debug" => 0,
    "autoconnect" => 1,
    "nick" => "toutou",
    "server" => "irc.botheaven.org",
    "port" => "6667",
    "username" => "Lasade",
    "ircname" => "Laureline de Monmarchel",
    "channel" => [ '#toutouland' ],
    "activeChans" => '#toutouland%fr%',
    "authpass"	=> 'titi',
    "authcmd"	=> 'IDENTIFY',
    "authhandler"	=> 'NickServ'
  };

  if($this->{"servers"}->{$name})
  {
  print("record valid\n");
    $msg .= $this->getMesg("INSTSERVHAND",$arg)."\n";
    $this->{"handles"}->{$name} = new zebot::testLink(); 
    $msg .= $this->getMesg("INITSERVHAND",$arg)."\n";
    $this->{"handles"}->{$name}->init($name, $this->{"servers"}->{$name},$this);
    $msg .= $this->getMesg("SERVINSTOK")."\n"; 
  }# if($this->{"servers"}->{$name})
  else
  {
    $msg .= $this->getMesg("There is no template for server %rest",$arg)."\n"; 
  }# else
  print($msg);
  return $msg;
}# sub connectServer
#########################################################
=pod

=item getMesg

fetch the message handler and ask it for the given translation of a token into a localized string
 this method takes the arguments in the following order:  
     language,
     token to be translated,
     the mode of the actual message
     a default string in case the token couldn't be found

=cut

#########################################################
sub getMesg
{
  my($this,$token,$line) = @_;
  return "toto" if(!$token);
  $line->{"lang"} = $this->setting("language") if(!($line->{"lang"}));
  my $Msg = $this->module("messageHandler");

  my $msg = $token;
  if($Msg)
  {
  $msg = $Msg->getMesg($token,$line);
  }# if($Msg)
  else
  {
    $msg = "ZEBOT AYEEEEH no messagehandler : $msg\n";
  }# else
  return $msg;
}# sub getMesg
1
