#!/usr/bin/perl -w
##############################################################################
#  operator operations of the bot
#  author Bruno BTTCHER <bboett at adlp.org>
#  Copyright (c) 2002 Bruno Boettcher
#
# zebot is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##############################################################################
sub POE::Kernel::ASSERT_EVENTS () { 1 };
sub POE::Kernel::ASSERT_STATES () { 1 };
sub POE::Kernel::ASSERT_DEFAULT () { 1 };
use POE::Kernel;
use POE::Session;
use Data::Dumper;
use XML::Simple;
use strict;

sub BEGIN
{
    #push (@INC,$ENV{HOME}.'/',$ENV{HOME}.'/ircbots')
    #      if(!( (join(' ',@INC)) =~ /$ENV{HOME}\/ircbots/));
    #push (@INC,$ENV{HOME}.'/',$ENV{HOME}.'/ircbots/zebot')
    #      if(!( (join(' ',@INC)) =~ /$ENV{HOME}\/ircbots\/zebot/));
    my $pwd = $ENV{PWD};
    my @fullpath = split('/',$pwd);
    pop @fullpath;
    my $pwdup = join('/',@fullpath);
    push (@INC,$pwdup)
          if(!( (join(' ',@INC)) =~ /$pwdup/));
    #we also need to include .., since our modules are searched in zebot/*
    #print "added $pwdup to path\n";
    push (@INC,$pwd)
          if(!( (join(' ',@INC)) =~ /$pwd/));
    #print "added also $pwd to path\n";
}
sub SendServer
{
  my $line = shift;
  print "SendServer: $line\n";
}#sub SendServer

my $settings = {
   "configpath" => "$ENV{HOME}/.zebot/",			#path to configfiles
           "botname" => "toutou",
           "owner" => "Lasade",
           "originhost" => "kalman.u-strasbg.fr",
           "fullname" => "Laureline de Monmarchel",
           "ircserver" => "irc.skroz.net",
           "streamName" => 'botlog',
           "reconnect" => 1,
           "operatorfile" => "users.conf",
           "channel" => "#toutouland",
           "emotesfile" => "zebot.emotes",
           "userfile" => "passwd",
           "actornames" => ["mailbox"],
           "reactionsfile" => "reactions.pl",
           "operationsfile" => "operations.pl",
   "ownerpass" => "toto",
   "xmlreactionsfile" => "res_emotes.xml",
   "xmlmessagesfile" => "res_messages.xml",
   "language" => "fr",
   "rejoininterval" => 60,
   "reconnectinterval" => 60,
   "debug" => 1,
           "instmodules" => {},
   "database" => 'DBI:Pg:dbname=zebot',
   "dbuser" => 'bboett'
               };

use zebot::test;
my $tester = new zebot::test();
print("tester is a ".ref($tester)."\n");
$tester->{"settings"} = $settings;
print("tester is still a ".ref($tester)."\n");
$tester->loadSettings(); 
print("tester is it? : ".ref($tester)."\n");

my %systemres;
$tester->{"modules"} = [];
$tester->{"actors"} = {};


print "loading i8n\n";
use zebot::messageHandler;
my $MSobj = new zebot::messageHandler();
$tester->module($MSobj->isa(),$MSobj);
print "loading PAM\n";
use zebot::pam;
my $pam = new zebot::pam();
$tester->module($pam->isa(),$pam);

use zebot::connector;
my $connector = new zebot::connector();
$tester->module($connector->isa(),$connector);


#use zebot::emoteparser;
#$genObj = new zebot::emoteparser();

print "Pam inint:\n";
$pam->init($tester);
print "MSobj inint:\n";
$MSobj->init($tester);
print "initialising connector\n";
$connector->init($tester);

$tester->connectServer("","pingouin",""); 

my $fakeLine = {
  "heap" => { "nick" => "toutou", "channels" => {"#toutouland" => 1}},
  "channel" => "#toutouland",
  "usernick" => "Lasade",
  "username" => "auser",
  "userhost" => "amchine",
  "lang" => "fr",
  "line" => "distribue Lasade 100",
  "context"	=> 1,
};
my $orgLine;
%$orgLine = %$fakeLine;

print("calling distribue\n");
$connector->PRIVMSGaction($fakeLine);
%$fakeLine = %$orgLine;
$fakeLine->{"line"} = "taxe Lasade 10";
$connector->PRIVMSGaction($fakeLine);
print($connector->help($fakeLine));
$poe_kernel->run();
