#!/usr/bin/perl -w
package zebot::roulette;
##############################################################################
=pod

=head1 NAME

roulette module

=head1 DESCRIPTION

play a game of roulette with your bot

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  roulette.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
use strict;

use Data::Dumper;

use POE::Session;

use POSIX qw(strftime);
use DBI;

use zebot::baseactor;

#========================================================
our @ISA = ("zebot::baseactor");
#attributes("users","deb","active","errmsg","dbh");
zebot::baseactor::_define_constructor("zebot::roulette");

######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "roulette";
}#sub isa
######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.6 $';
}#sub isa

#########################################################
=pod

=item _start 

This gets executed as soon as the kernel sets up this session.

=cut

#########################################################
sub _start 
{
  my ($kernel, $session) = @_[KERNEL, SESSION];
  my $this = shift;
  $this->{"kernel"} = $kernel;
  $this->{"context"} = $session;
  #$this->SUPER::_start(@_);

  # Make an alias for our session, to keep it from getting GC'ed.
  $kernel->alias_set( $this->{"sessionname"});

  # Ask the IRC component to send us all IRC events it receives. This
  # is the easy, indiscriminate way to do it.
  #$kernel->post( 'roulette', 'register', 'all');
  #$kernel->post( $context, 'register', 'all');
  #$this->print("\nstarting roulette\n");

}# sub _start 
######################################################################
=pod

=item stop

This gets executed as soon as the kernel stops this session.

=cut

######################################################################
sub _stop
{
  my ($kernel, $session,$this) = @_[KERNEL, SESSION,OBJECT];
  $kernel->alias_remove($this->{"sessionname"});
  delete $this->{"sessionname"};

  #$this->print("roulette stopped\n");
}# sub stop

#########################################################
=pod

=item init

make the connection to th e POE system

=cut

#########################################################
sub init
{
  my @securedargs = @_;
  my $this = shift;
  my $sysref = shift;
  my $sysrefe = $sysref;
  # $this->print("obj = $this\n");
  # $this->print("syse[botname] = ".$sysrefe{"botname"}."\n");
  $this->{"status"} = 0;
  $this->{"running"} = 0;
  $this->{"sessionname"} = "roulette";
  $this->{"history"} = [];


  $this->SUPER::init($sysref);
  $this->sysdata($sysref); #why is this vital for other objects????
    my $network = $this->setting("activenet")|| die("no network specifyed! sets are ".Dumper($this->{"subsettings"})."\n");
  #print("active net = '$network'");
  #$this->{"lastactivated"} = time();
  $this->{"lastactivated"} = 0;
  # my $path = $this->setting("configpath")."ressources/";
  # $path .= $this->setting("messages");
  # my $msgHand = ($this->sysdata())->module("messageHandler");
  # $msgHand->load($path);

  $this->{"gains"} = {
    "noir"	=> 1,
    "rouge"	=> 1,
    "passe"	=> 1,
    "manque"	=> 1,
    "pair"	=> 1,
    "impair"	=> 1,
    "douzaine"	=> 2,
    "colonne"	=> 2,
    "trans6"	=> 5,
    "carre"	=> 8,
    "trans3"	=> 11,
    "cheval"	=> 17,
    "nombre"	=> 35,
  };
  $this->{"gainsorder"} = [
    "rouge",
    "noir",
    "passe",
    "manque",
    "pair",
    "impair",
    "douzaine",
    "colonne",
    "trans6",
    "carre",
    "trans3",
    "cheval",
    "nombre",
  ];

 $this->{"bank"} = $this->setting("initialcash");

  $this->{"context"} = $this->setting("activenet");

  POE::Session->create( 
      object_states => 
      [ 

      $this =>
      {  
      _start		=> "_start",
      _stop		=> "_stop",
      "keepalive"	=> "keepalive",
      "roule"	=> "roule",
      "privmsg"	=> "default",
      }
  ]
    );


}# sub init
######################################################################
=pod

=item keepalive

Initiaize, means set up this module

=cut

######################################################################
sub keepalive
{
  my ($this,$kernel, $session,$heap) = @_[OBJECT,KERNEL, SESSION, HEAP];

  #$this->print("roulette keepalive\n");
  my $msgHand = ($this->sysdata())->module("messageHandler");
  #  $this->post( $usernick,$msgHand->getMesg("PAMPASSHELP",$splittedline));
  my $channel = $this->setting("channel");
  my $network = $this->setting("activenet");
  my $botref = $this->sysdata();
  my $botname = $this->setting("botname");
  my $lang = $botref->language($channel);
  $this->{"keepaliveactive"} = 1;

  $lang = "fr" if(!$lang);
  #print("so far : $botname, $lang, $network,$channel\n");

  my $args = {
    "heap" => $heap,
    "usernick" => $this->setting("botname"),
    "lang" => $lang,
    "network" => $network,
    "addressed" =>$channel,
    "channel" =>$channel,
    "context" =>$network,
  };

  my $delay = $this->setting("keepalive") * 60;
  my $timediff = time() - $this->{"lastactivated"};
  #print("keepalive time diff : $timediff\n");
  if($timediff >= $delay && $this->{"running"} && $this->{"bank"}>0)
  {
    #print("timediff trop grand declenche yawn\n");
    my $kernel = $this->{"kernel"};
    my $msg = $msgHand->getMesg("ROULETTEYAWN",$args);
    $this->action($channel,$msg);
    #$kernel->post( $network, 'privmsg', $channel,'ACTION '.$msg.'');
  }
  #print("next possible  yawn at $delay\n");
  $kernel->delay_add('keepalive',$delay)  if($this->{"sessionname"});
}# sub stop
######################################################################
=pod

=item sysdata

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
    $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
######################################################################
=pod

=item PRIVMSGaction

react on a message addressed directly to this script

This module reacts only to messages send on the channels is active by invoquing the base  L<zebot::baseactor/"PRIVMSGaction">

=cut

######################################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  return 0 if($this->SUPER::activeForThisChan($splittedline));
  my $activeChannel = $this->setting("channel");
  return 0 if(!($this->setting("channel") =~ /$activeChannel/i ));

  $this->{"lastactivated"} = time();

  my $line = $splittedline->{"line"};
  #print("roulette PRIVMSGaction with $line\n");
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  $this->{"kernel"} = $splittedline->{"kernel"} if($splittedline->{"kernel"});
  $this->{"context"} = $splittedline->{"context"} if($splittedline->{"context"});
  #$this->print( "pam::PRIVMSGaction just set kernel=". $this->{"kernel"} );

  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $actLang = $splittedline->{"lang"};

  #bail out if the line is empty
  return 0 if(!$line);

  $line =~ s/^\s+//;
  $line =~ s/\s+$//;
  $line =~ s/\s+/ /;

  my($command, $rest) = split(/ /,$line,2);
  $line = $rest;

  my $pam = ($this->sysdata())->module("pam");

  my $accessRights = $pam->findOperator($splittedline);
  

  my %temp = %{$splittedline};

  $splittedline = \%temp;
  $splittedline->{"line"} = $line;

  if($command =~ /mise/)
  {
    return 1 if($this->checkFunds($msgHand,$splittedline,$activeChannel));
    return $this->nouvelleMise($msgHand,$splittedline);
  }# if($line =~ /passwd\s+(\S+)/)
  elsif($command =~ /score/)
  {
    return $this->score($msgHand,$splittedline,$usernick);
  }# if($line =~ /auth\s+(\S+)/)
  elsif($command =~ /compte/)
  {
    return $this->compte($msgHand,$splittedline,$accessRights);
  }# if $line =~ /register

  return 0
    if(!($this->isOwnerOrOper($splittedline)));

  if($command =~ /distribue/)
  {
    return $this->fillAccount($msgHand,$splittedline,$accessRights);
  }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
  elsif($command =~ /taxe/)
  {
    return $this->emptyAccount($msgHand,$splittedline,$accessRights);
  }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
  #else {print "no command for me $line\n"; }
  return 0;
}#sub PRIVMSGaction
######################################################################
=pod

=item fillAccount

an oper or owner asked to give or fill an account of someone

=cut

######################################################################
sub fillAccount
{
  my ($this,$msgHand,$splittedline,$accessRights) = @_;
  $this->{"accounts"} = {} if(!($this->{"accounts"}));
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my($user,$amount) = split(/ /,$line);
  $user = "" if(!($user =~ /[a-zA-Z]+/));

  if(!$user || !$amount)
  {
    $this->post( $usernick,$msgHand->getMesg("ROULETTEFILLHELP",$splittedline));
    return;
  }# if(!$user || !$amount)
  my $botname = $splittedline->{"heap"}->{"nick"};
  if($user =~ $botname)
  {
    $this->{"bank"} += $amount;
  }# if($user =~ $botname)
  elsif(!($this->{"accounts"}->{$user}))
  {
    $this->{"accounts"}->{$user} = {
      "credit"	=> int($amount),
      "activation"	=> time(),
    };
  }# if(!($this->{"accounts"}->{$user}))
  else
  {
    $this->{"accounts"}->{$user}->{"credit"} += int($amount);
  }#else
  $splittedline->{"usernick"} = $user;
  $splittedline->{"line"} = $this->{"accounts"}->{$user}->{"credit"};
  $this->post( $usernick,$msgHand->getMesg("ROULETTESTATUS",$splittedline));
  return 1;
}#sub fillAccount
######################################################################
=pod

=item emptyAccount

an oper or owner asked to take something out of an account

=cut

######################################################################
sub emptyAccount
{
  my ($this,$msgHand,$splittedline,$accessRights) = @_;
  $this->{"accounts"} = {} if(!($this->{"accounts"}));
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my($user,$amount) = split(/ /,$line);
  $user = "" if(!($user =~ /[a-zA-Z]+/));
  if(!$user || !$amount)
  {
    $this->post( $usernick,$msgHand->getMesg("ROULETTETAKEHELP",$splittedline));
    return;
  }# if(!$user || !$amount)
  my $botname = $splittedline->{"heap"}->{"nick"};
  if($user =~ $botname)
  {
    $this->{"bank"} -= $amount;
    $this->{"bank"} = 0 if($this->{"bank"}  < 0);
  }# if($user =~ $botname)
  elsif($this->{"accounts"}->{$user})
  {
    $this->{"accounts"}->{$user}->{"credit"} -= int($amount);
    $this->{"accounts"}->{$user}->{"credit"} = 0
      if($this->{"accounts"}->{$user}->{"credit"} < 0);
    $splittedline->{"usernick"} = $user;
    $splittedline->{"line"} = $this->{"accounts"}->{$user}->{"credit"};
    $this->post( $usernick,$msgHand->getMesg("ROULETTESTATUS",$splittedline));
    return 1;
  }# if(!($this->{"accounts"}->{$user}))
  $this->post( $usernick,$msgHand->getMesg("ROULETTEVALIDUSER",$splittedline));
  return 1;
}#sub emptyAccount
######################################################################
=pod

=item compte

ask the actual status of a player

=cut

######################################################################
sub compte
{
  my ($this,$msgHand,$splittedline,$accessRights) = @_;
  $this->{"accounts"} = {} if(!($this->{"accounts"}));
  my $user = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};

  if($accessRights =~ /oper/ || $accessRights =~ /owner/)
  {
    if(!$user)
    {
      my $msg = "Bank	".$this->{"bank"}."\n";
      foreach my $aUser (keys(%{$this->{"accounts"}}))
      {
	$msg .= "$aUser	".$this->{"accounts"}->{$aUser}->{"credit"}."\n";
      }# foreach my $aUser (keys(%{$this->{"accounts"}}))
      $splittedline->{"line"} = $msg;
      $this->post( $usernick,$msgHand->getMesg("ROULETTEUSERLIST",$splittedline));
      return 1;
    }# if(!$usernick)
  }# if(!($accessRights =~ /oper/ || $accessRights =~ /owner/))
  else
  {
    $user = $usernick; 
  }# else


  my $msg;
  if($this->{"accounts"}->{$user})
  {
    $splittedline->{"line"} = $this->{"accounts"}->{$user}->{"credit"};
    $msg = $msgHand->getMesg("ROULETTESTATUS",$splittedline);
  }# if(!($this->{"accounts"}->{$user}))
  else
  {
    $msg = $msgHand->getMesg("ROULETTENOSTATUS",$splittedline);
  }# else
  $this->post( $usernick,$msg);
  return 1;
}#sub compte
######################################################################
=pod

=item score

ask the actual status of a player

=cut

######################################################################
sub score
{
  my ($this,$msgHand,$splittedline,$usernick) = @_;

  my $msg = $msgHand->getMesg("ROULETTESCORING",$splittedline);
   
  $msg .= sprintf("   %-10s        %2d\n",$_,$this->{"gains"}->{$_}) foreach(@{$this->{"gainsorder"}});
  $msg .= "---\n";
  if(scalar(@{$this->{"history"}}) > 0)
  {
    my $submsg = join("\n",@{$this->{"history"}}); 
    $splittedline->{"line"} = $submsg;
    $msg .= $msgHand->getMesg("ROULETTEHISTORY",$splittedline);
  }# if(!($this->{"accounts"}->{$user}))
  else
  {
    $msg .= $msgHand->getMesg("ROULETTENOHISTORY",$splittedline);
  }# else
  $this->post( $usernick,$msg);
  return 1;
}#sub score
######################################################################
=pod

=item nouvelleMise

ask the actual status of a player

=cut

######################################################################
sub nouvelleMise
{
  my ($this,$msgHand,$splittedline) = @_;
  my $user = $splittedline->{"usernick"};
  my $channel = $this->setting("channel");

  $this->{"accounts"} = {} if(!($this->{"accounts"}));

  #print("users '$user' credit:".$this->{"accounts"}->{$user}->{"credit"}."\n");
  if(!($this->{"accounts"}->{$user}) ||
      $this->{"accounts"}->{$user}->{"credit"} <= 0)
  {
    $this->action( $channel,$msgHand->getMesg("ROULETTENOCREDIT",$splittedline));
    return 1;
  }# if(!($this->{"accounts"}->{$user}))

  if($this->{"status"} > 3)
  {
    $this->action( $channel,$msgHand->getMesg("ROULETTETMOUT",$splittedline));
    return 1;
  }# if(!($this->{"accounts"}->{$user}))

  my $line = $splittedline->{"line"};
  if($line =~ /(\d+) sur (\S+)\s*(.*)/)
  {
    my ($creds, $type, $rest) = ($1,$2,$3); 
    $creds = $this->{"accounts"}->{$user}->{"credit"} 
    if( $this->{"accounts"}->{$user}->{"credit"} < $creds);
    if($creds <= 0)
    {
      $this->action( $channel,$msgHand->getMesg("ROULETTENOCREDIT",$splittedline));
      return 1;
    }# if($cred <= 0)

    $this->{"accounts"}->{$user}->{"bets"} = []
      if(!($this->{"accounts"}->{$user}->{"bets"}));

    my $newBet = $this->parseBet($creds,$type,$rest);

    if($newBet->{"type"})
    {

      $this->{"accounts"}->{$user}->{"credit"} -= $creds;
      $this->{"bank"} += $creds;

      push(@{$this->{"accounts"}->{$user}->{"bets"}},$newBet);
      $splittedline->{"arg1"} = $newBet->{"value"};
      $splittedline->{"arg2"} = $newBet->{"type"};
      $splittedline->{"arg3"} = join(',',@{$newBet->{"num"}}) if($newBet->{"num"});
      my $msg = $msgHand->getMesg("ROULETTEBETACCEPTED",$splittedline);
      $this->action( $channel,$msg);
      if($this->{"status"} == 0)
      {
	#time to wake the bot!
	$this->{"status"} = 1;
	#print("posting roulette!!\n");
	$this->{"kernel"}->post($this->{"sessionname"} , 'roule');
      }# if($this->{"status"} == 0)
    }
    else
    {
      $this->post( $user,$msgHand->getMesg("ROULETTEBETHELP",$splittedline));
    }# else
    #print("status of user:".Dumper($this->{"accounts"}->{$user})."\n");

  }# if($line =~ /(\d+) sur (\S+)\s*(.*)/)
  else
  {
    $this->post( $user,$msgHand->getMesg("ROULETTEBETHELP",$splittedline));
    return 1;

  }# els

  return 1;
}#sub score
######################################################################
=pod

=item roule

the event loop to make a draw

=cut

######################################################################
sub roule
{
  my ($this,$kernel, $session) = @_[OBJECT,KERNEL, SESSION];
  my $channel = $this->setting("channel");
  my $network = $this->setting("activenet");
  $this->{"context"} = $this->setting("activenet");
  my $msgHand = ($this->sysdata())->module("messageHandler");
  #print("running roulette with status ".$this->{"status"}."!!\n");
  if($this->{"status"} >0  && $this->{"status"} <4)
  {
    my $delay = $this->setting("roundlength") * 60;
    my $round = $this->{"status"};
    $delay = int($delay/(2**$round));
    $delay = 1 if($delay <= 0);

    my $tag = "ROULETTESTART".$this->{"status"};
    $this->{"status"} += 1;
    my $arg = {};
    $this->action( $channel,$msgHand->getMesg($tag,$arg));
    $kernel->delay_add('roule',$delay);
    return 1;
  }# if($this->{"status"} == 1)
  elsif($this->{"status"} == 4)
  {
    #yep time to make the drawing 
    my $cast =  int(rand(36));
    #my $cast = 5;
    my $msg = "sort le $cast";
    my ($impair,$couleur,$passe);
    my $gagne = 
    {
      "noir"	=> 0,
      "rouge"	=> 0,
      "passe"	=> 0,
      "manque"	=> 0,
      "pair"	=> 0,
      "impair"	=> 0,
      "douzaine"	=> 0,
      "colonne"	=> 0,
      "trans3"	=> 0,
      "nombre"	=> $cast,
    };

    if($cast > 0)
    {
      if($cast > 18)
      {
	$passe = "manque";
	$gagne->{"manque"} = 1; 
      }
      else
      {
	$passe = "passe";
	$gagne->{"passe"} = 1; 
      }

      $impair = $cast - 2 * int($cast/2);

      $gagne->{"impair"} = 1 if($impair); 
      $gagne->{"pair"} = 1 if(!$impair); 

      $couleur = "rouge";
      $gagne->{"rouge"} = 1; 
      if(($cast > 10 && $cast < 19) || $cast > 28)
      {
	if($impair)
	{
	  $couleur = "noir";
	  $gagne->{"rouge"} = 0; 
	  $gagne->{"noir"} = 1; 
	}
      }# if($cast > 10 && $cast < 19)
      elsif(!$impair)
      {
	$couleur = "noir";
	$gagne->{"rouge"} = 0; 
	$gagne->{"noir"} = 1; 
      }# elseif($impair)

      my $col = computeColumn ($cast);
      $gagne->{"colonne"} = $col;
      $col--;
      $gagne->{"trans3"} = $cast - $col;

      $gagne->{"douzaine"} = int($cast /12) + 1; 

    }# if($cast > 0)


    $msg .= " $couleur" if($couleur);
    if($cast > 0)
    {
      $msg .= " pair" if(!$impair);
      $msg .= " impair" if($impair);
      $msg .= " $passe";
    }# if($cast > 0)
    my $arg = {};
    $arg->{"line"} = $msg;

    push(@{$this->{"history"}},$msg);
    shift(@{$this->{"history"}}) 
      while(scalar(@{$this->{"history"}}) > $this->setting("history"));
    $this->action( $channel,$msgHand->getMesg("ROULETTERESULT",$arg));
    $this->computeWins($gagne,$msgHand);
    $this->{"status"} = 0;
  }# elsif($this->{"status"} == 4)
  return 1;
}#sub roule
######################################################################
=pod

=item computeWins

compute the winning streaks of everybody

=cut

######################################################################
sub computeWins
{
  my ($this,$gagne,$msgHand) = @_;

  my $result;
  my $gains = $this->{"gains"};
  my $banqueroute = 0;
  my $completerun = 0;
  my $winners = {};

  foreach my $username (sort(keys(%{$this->{"accounts"}})))
  {
    my $user =  $this->{"accounts"}->{$username};
    my $gain = 0;
    my $transaction;
    while( $transaction = shift(@{$user->{"bets"}}))
    {
      my $mise = $transaction->{"type"};
      my $valeur = $transaction->{"value"};
      my $rest = $transaction->{"num"};
      #print("checking bet $mise of $valeur");
      #print(" on ".join(' ',@$rest)) if($rest);
      #print("\n");

      next if(!$mise);
      my $chances = "noir rouge passe manque pair impair";
      my $groupes = "douzaine colonne trans6  trans3";
      my $nombres = "carre cheval nombre";

      if($chances =~ /\Q$mise\E/i)
      {
	$mise = lc($mise);
	if($gagne->{$mise} )
	{
	  $gain += ($gains->{$mise} + 1) * $valeur;
	}# if($gagne->{$mise} )
      }# if $chances =~ /\Q$bet\E/i
      else
      {
	my $gaintype = $mise;
	$gaintype = "nombre" if($nombres =~ /\Q$mise\E/i);
	$gaintype = "trans3" if("trans6" =~ /\Q$mise\E/i);

	my $iwin = 0;

	#print("checking for non color: compare $mise with ".$gagne->{$gaintype}."\n");
	foreach(@$rest)
	{
	  $iwin = $iwin || ($_ == $gagne->{$gaintype});
	  #print("having $iwin after comparing with $_ \n");
	}
	$gain += ($gains->{$mise} + 1) * $valeur if($iwin);
	#print("we win $gain\n") if($iwin);
	#print("we loose $gain\n") if(!$iwin);
      }# else
    }#foreach my $transaction (@{$user->{"bets"}})))

    if($gain >= $this->{"bank"})
    {
      $gain = $this->{"bank"};
      $banqueroute = $username;
    }# if($gain > $this->{"bank"})

    $this->{"accounts"}->{$username}->{"credit"} += $gain;
    my $bourse = $this->{"accounts"}->{$username}->{"credit"};
    if($gain > 0)
    {
      $result .= sprintf("  %-10s      %5d(\$\$=%5d)\n",$username,$gain,$bourse); 
    }# if($gain > 0)
    $this->{"bank"} -= $gain;
    last if($banqueroute); 
  }#foreach my $user (sort(keys(%{$this->{"accounts"}})))

  my $splittedline = { "line" => $result};
  my $channel = $this->setting("channel");
  if($result)
  {
    $this->action( $channel,$msgHand->getMesg("ROULETTEWINS",$splittedline));
    if($banqueroute)
    {
      my $splittedline = { "line" => $banqueroute};
      $this->action( $channel,$msgHand->getMesg("ROULETTEBANQUEROUTE",$splittedline));
    }# if($banqueroute)
  }
  else
  {
    if($banqueroute)
    {
      my $splittedline = { "line" => $banqueroute};
      $this->action( $channel,$msgHand->getMesg("ROULETTEBANQUEROUTE",$splittedline));
    }# if($banqueroute)
    else
    {
      $this->action( $channel,$msgHand->getMesg("ROULETTEBANKWINS",$splittedline));
    }
  }# else
}#sub computeWins
######################################################################
=pod

=item default

stuff that doesn't goes somewhere else...

=cut

######################################################################
sub default
{
  my ($this,$kernel, $session,$heap,$arg) = @_[OBJECT,KERNEL, SESSION, HEAP,ARG0];
 my $msg = $_[ARG0] if($_[ARG0]);
 $msg .= ",".$_[ARG1] if($_[ARG1]);
 $msg .= ",".$_[ARG2] if($_[ARG2]);
 $msg .= ",".$_[ARG3] if($_[ARG3]);
 print("got unnkown event... $msg\n");
}# sub stop
#########################################################
=pod

=item JOINaction

react on some user joining the channel

=cut

#########################################################
sub JOINaction
{
  my ($this,$splittedline) = @_;

  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  my $incomingChannel = $splittedline->{"channel"};
  my $activeChannel = $this->setting("channel");
  chomp($activeChannel);
  $activeChannel =~ s/^\s*//;
  $activeChannel =~ s/\s*$//;
  $this->{"running"} = 1
    if($this->setting("channel") =~ /$activeChannel/i );
  $kernel->post($this->{"sessionname"},'keepalive')
    if(!($this->{"keepaliveactive"}));
}#sub JOINaction

#########################################################
=pod

=item parseBet

par the string a user send to see if its valid, and if yes register the bet

=cut

#########################################################
sub parseBet
{
  my ($this,$creds,$mise,$rest) = @_;

  $mise = lc($mise);

  my $newBet = { "value" => $creds };
  $rest =~ s/\s+//g if($rest);
  $newBet->{"args"} = $rest if($rest);


  my $chances = "noir rouge passe manque pair impair";
 # if($chances =~ /\Q$mise\E/i)
 # {
 #   $mise = lc($mise);
 #   $newBet->{"type"} = $mise;
 # }# if $chances =~ 
  #elsif($mise =~ /douze/i)
  if($mise =~ /douze/i)
  {
    my $colonne = int($rest);
    if($colonne >0 && $colonne <4)
    {
      $newBet->{"type"} = "douzaine" ;
      $newBet->{"num"} = [$colonne] ;
    }
  }# elsif($mise =~ /douze (\d+)/)
  elsif($mise =~ /col/)
  {
    my $colonne = int($rest);
    if($colonne >0 && $colonne <4)
    {
      $newBet->{"type"} = "colonne" ;
      $newBet->{"num"} = [$colonne] ;
    }
  }# elsif($mise =~ /douze (\d+)/)
  elsif($mise =~ /trans/)
  {
    my $colonne = int($rest);
    if($colonne >0 && $colonne <37)
    {
      $colonne = computeColumn ($colonne);
      $newBet->{"type"} = "trans3" ;
      $newBet->{"num"} = [$colonne];
    }# if($colonne >0 && $colonne <37)
  }# elsif($mise =~ /douze (\d+)/)
  elsif($mise =~ /trans6/)
  {
    my ($col1,$col2) = split(/,/,$rest);
    $col1 = int($col1);
    $col2 = int($col2);
    if($col1 >0 && $col1 <37 && $col2 >0 && $col2 <37)
    {
      $col1 = computeColumn($col1);
      $col2 = computeColumn($col2);
      $newBet->{"type"} = "trans6" ;
      $newBet->{"num"} = [$col1,$col2];
    }# if($colonne >0 && $colonne <37)
  }# elsif($mise =~ /douze (\d+)/)
  if($this->{"gains"}->{$mise})
  {
    #probably a simple chance...
    $mise = lc($mise);
    $newBet->{"type"} = $mise;
  }# if $chances =~ 
  elsif($mise =~ /(\d+)+/)
  {
    #rejoin with the rest in case the user applied spaces in his line
    $rest =~ s/\s+/,/g;
    $rest =~ s/,+/,/g;
    $mise .= ",$rest";
    $mise =~ s/,+/,/g;
    $mise =~ s/\s+//g;
    my @numbers = split(/\,/,$mise);
    #$this->print("FETCHED nums: ".Dumper(\@numbers)." out of $mise\n");
    my $valid = 1;
    foreach my $number (@numbers)
    {
      $valid = $valid && ($number >= 0 && $number < 37);
    }# foreach my $number (@numbers)

    return if(!$valid);
    my $num = scalar(@numbers);
    if($num == 1)
    {
      $newBet->{"type"} = "nombre" ;
      $newBet->{"num"} = \@numbers;
    }# if($num == 1)
    elsif($num == 2)
    {
      $newBet->{"type"} = "cheval" ;
      $newBet->{"num"} = \@numbers;
    }# elsif($num == 2)
    elsif($num == 4)
    {
      $newBet->{"type"} = "carre" ;
      $newBet->{"num"} = \@numbers;
    }# elsif($num == 4)
  }# elsif($mise =~ /douze (\d+)/)

  return $newBet;
}#end parseBet
#########################################################
=pod

=item computeColumn

compute the head of colum for a given number

=cut

#########################################################
sub computeColumn
{
  my ( $cast) = @_;
  my $col = 2; 
  if(int($cast/3)*3 == $cast)
  {
    $col = 3;
  }# if(int($cast/3)*3 == $cast)
  elsif(int(($cast - 1)/3)*3 == ($cast - 1))
  {
    $col = 1;
  }# if(int($cast/3)*3 == $cast)

  return $col;
}#end computeColumn
#########################################################
=pod

=item checkFunds

check for existingfunds otherwise bail out

=cut

#########################################################
sub checkFunds
{
  my ( $this, $msgHand,$splittedline,$activeChannel) = @_;
  if($this->{"bank"} <= 0)
  {
    $this->action($activeChannel,$msgHand->getMesg("ROULETTENOFUNDS",$splittedline));
    return 1;
  }# if(!($this->{"accounts"}->{$user}))

  return 0; 
}#end checkFunds

### EOC
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

