##############################################################################
=pod

=head1 NAME

 pam_pg.pm 

=head1 DESCRIPTION

PAM module, authentification module for zebot, database backed, each request
 is directly piped through to the database

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  pam_pg.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::pam_pg;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);
use DBI;

use Data::Dumper;


# sub POE::Kernel::ASSERT_DEFAULT () { 1 }
# sub POE::Kernel::ASSERT_PONY () { 1 }
# sub POE::Kernel::ASSERT_EVENTS () { 1 }
# sub POE::Kernel::ASSERT_STATES () { 1 }

use POE::Session;

our @ISA = ("zebot::baseactor");
#attributes("users","deb","active","errmsg","dbh");
zebot::baseactor::_define_constructor("zebot::pam_pg");



######################################################################
=pod

=item init

Initiaize, means set up this module

=cut

######################################################################
sub init
{
  my @securedargs = @_;
  my $this = shift;
  my $sysref = shift;
  my $sysrefe = $sysref;
  # $this->print("obj = $this\n");
  $this->print("PAM init\n");


  $this->SUPER::init($sysref);
  $this->sysdata($sysref);


  #$this->users($ref);

  # $this->print("disconnecting from DB!\n");
  my $dbh = $this->dbh();

  $dbh -> disconnect() if($dbh);

  # $this->print("connecting to DB!\n");
  $dbh = DBI->connect($this->setting("database"),$this->setting("dbuser"),$this->setting("dbpasswd"),{AutoCommit => 0,PrintError =>0})
    or $this->print("pam_pg: Couldn't connect to database: ".DBI->errstr."\n");
  # $this->print("CONNECTED TO DB=$dbh\n");
  $this->dbh($dbh);
  # $this->print("set obnj ref DB!\n");
  #resetting all the status for the online people
  my $sql_query = 'UPDATE "users" SET logged=\'f\'';
  my $sth = $this->doQuery("pam_pg::init",$sql_query);
  $this->print("### clean prob:".$sth->errstr."\n") if(!$sth);
}#sub init
######################################################################
=pod

=item PRIVMSGaction

react on a message addressed directly to this script
propose commands passwd auth adduser addgroup listgroups deluser dispuser

=cut

######################################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};
  #$this->print( "pam_pg::PRIVMSGaction just set kernel=". $this->{"kernel"}."\n" );

  my $msgHand = ($this->sysdata())->module("messageHandler");
  #my $actLang = $msgHand->fetchChannelLang($splittedline->{"channel"});
  #$splittedline->{"lang"} = $actLang;
  my $actLang = $splittedline->{"lang"};

  my $botname = $splittedline->{"heap"}->{"nick"};
  # $this->print("pam_pg: debug '$botname': received $line\n");

  # $this->print("findOp, req by $usernick $username\@$userhost\n");
  # $this->print("full-line was ".$splittedline->{"fulline"}."\n");
  # $this->print("findOp, botname='$botname'\n");
  # $this->print("PRIVMSGaction of PAM line='$line'\n");
  # $this->print("-- PRIVMSGaction FO with ".Dumper($splittedline)."\n");
  my $accessRights = findOperator($this,$splittedline);
  # $this->print("pam_pg: debug '$botname': rights= $accessRights\n");
  # $this->print("pam_pg: debug '$botname': line= $line\n");
  #$this->print( "pam_pg::PRIVMSGaction intro kernel=". $this->{"kernel"}."\n" );
  if($line =~ /passwd\s+(.*)/)
  {
    # $this->print("case is passwd\n");
    # $this->print("m4: search for $usernick\n");
    my @authaargs = split(/ /,$1);
  my $msgHand = ($this->sysdata())->module("messageHandler");
  
    if(scalar(@authaargs) != 2 )
    {
      #$this->print("wrong number of args....\n");
      #$this->post( $usernick,"wrong number of args....");
      $this->post( $usernick,$msgHand->getMesg("PAMPASSHELP",$splittedline));
      return;
    }# if(scalar(@authaargs)<3)
    #my $oldpass = $1;
    #my $newpass = $2;
    my $oldpass = $authaargs[0];
    my $newpass = $authaargs[1];
    $username =~ s/~//g;
    ##removing the hostname of the hostpart, for dynamic addressing
    my @hostparts = split(/\./,$userhost);
    shift @hostparts;
    $userhost = join('.',@hostparts);

    my $sql_query = 'SELECT id FROM users where ';
    $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
    $sql_query .= "AND passwd='$oldpass'";
    my $sth = $this->doQuery($usernick,$sql_query);
    if( $sth->rows != 0)
    {
      $this->debug("old pass ok\n");
      #$this->post( $usernick,'old pass ok');
      $this->post( $usernick,$msgHand->getMesg("PAMOLDPASSOK",$splittedline));
      my $data = $sth->fetchrow_hashref();
      my $userid = $data->{"id"};
      $sql_query = "UPDATE users SET passwd='$newpass' WHERE id=$userid";
      $this->doQuery($usernick,$sql_query);
      #$this->post(  $usernick,'change pass ok');
      $this->post(  $usernick,$msgHand->getMesg("PAMPASSCHANGEOK",$splittedline));
      $this->debug("change pass ok\n");
    }#if( $sth->rows != 0)
    else
    {
      $this->debug("no pass change to $usernick\n");
      #$this->post( $usernick,"no pass change for $usernick $username\@$userhost");
      $this->post( $usernick,$msgHand->getMesg("PAMPASSNOTOK",$splittedline)." $usernick $username\@$userhost");
    }
    return 1;
  }# if($line =~ /passwd\s+(\S+)/)
  elsif($line =~ /auth\s+(.*)/)
  {
    # $this->print("case is auth restline='$line'\n");
    # $this->print("m4: search for $usernick\n");
    my @authaargs = split(/ /,$1);
      #$this->print( "pam_pg::PRIVMSGaction auth kernel=". $this->{"kernel"}."\n" );
    if(scalar(@authaargs) != 2 )
    {
      #$this->print("wrong number of args....\n");
      #$this->post(  $usernick,"wrong number of args....");
      $this->post(  $usernick,$msgHand->getMesg("PAMAUTHHELP",$splittedline));
      return;
    }# if(scalar(@authaargs)<3)
    #my $authuser = $1;
    #my $itspass = $2;
    my $authuser = $authaargs[0];
    my $itspass = $authaargs[1];
    $username =~ s/~//g;
    ##removing the hostname of the hostpart, for dynamic addressing
    my @hostparts = split(/\./,$userhost);
    shift @hostparts;
    $userhost = join('.',@hostparts);
    #check if we need to kick someone
      #$this->print( "pam_pg::PRIVMSGaction auth kernel=". $this->{"kernel"}."\n" );
    if($authuser ne $usernick)
    {
      #check if the pass is valid
      #$this->post( $usernick,"Discordance between your nick and given nick");
      $this->post( $usernick,$msgHand->getMesg("PAMDIFFNICK",$splittedline));
      my $sql_query = 'SELECT * FROM users where ';
      $sql_query .= "nick='$authuser' AND name='$username' AND host='$userhost'";
      $sql_query .= " AND passwd='$itspass'";
      my $sth = $this->doQuery($usernick,$sql_query);
      if( $sth->rows != 0)
      {
	#we really have an usurpator! kick him!
	$this->action($splittedline->{"channel"},'chases the usurpator '.$authuser.' to hell!!');
	$this->kick($splittedline->{"channel"}, $authuser,'Usurpator!!');
	$usernick = $authuser;
      }#if( $sth->rows != 0)
      else
      {
	#uhm wrong nick, wrong pass.....
	$this->action($splittedline->{"channel"},'eats the balls of '.$usernick);
	$this->kick($splittedline->{"channel"}, $usernick,'Usurpator!!');
	#bail out
	return;
      }#else
    }#if($username ne $usernick)

    my $sql_query = 'SELECT * FROM users where ';
    $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
    $sql_query .= " AND passwd='$itspass'";
    #$this->print("comparing:$sql_query\n");
    my $sth = $this->doQuery($usernick,$sql_query);
    if( $sth->rows != 0)
    {
      #$this->print( "pam_pg::PRIVMSGaction kernel=". $this->{"kernel"}."\n" );
      #$this->post(  $usernick,"User detected");
      $this->post(  $usernick,$msgHand->getMesg("PAMUSERFOUND",$splittedline));
      my $data = $sth->fetchrow_hashref();
      my $userid = $data->{"id"};
      my $usepass = $data->{"passwd"};
      $sql_query = "UPDATE users SET logged='t',auth='t' WHERE id=$userid";
      $this->doQuery($usernick,$sql_query);
      #$this->print( "pam_pg::PRIVMSGaction kernel=". $this->{"kernel"}."\n" );
      #$this->post( $usernick,'authentifyed');
      $this->post( $usernick,$msgHand->getMesg("PAMAUTHOK",$splittedline));
    }#if( $sth->rows != 0)
    else
    {
      #wrong pass, or inexistent user...
      #$this->post( $usernick,"User with wrong credentials");
      $this->post( $usernick,$msgHand->getMesg("PAMNOAUTH",$splittedline));
      my $sql_query = 'SELECT * FROM users where ';
      $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
      my $sth = $this->doQuery($usernick,$sql_query);
      if( $sth->rows == 0)
      {
	#$this->post(  $usernick,"inexistent user");
	$this->post(  $usernick,$msgHand->getMesg("PAMUNKOWNUSER",$splittedline));
	#indeed inexistent user, create it
	$this->addUser($usernick,$username,$userhost,$kernel,'t');
	$sql_query = 'SELECT * FROM users where ';
	$sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
	$sth = $this->doQuery($usernick,$sql_query);
	#$this->post( $usernick,"created $usernick $username\@$userhost");
	$this->post( $usernick,$msgHand->getMesg("PAMUSERCREATE",$splittedline)." $usernick $username\@$userhost");
      }#if( $sth->rows != 0)
      my $data = $sth->fetchrow_hashref();
      my $userid = $data->{"id"};

      #check for root passwd
      if($itspass eq $this->setting("ownerpass"))
      {
	#$this->post(  $usernick,"you used the ownerpass!!");
	$this->post(  $usernick,$msgHand->getMesg("PAMOWNERPASS",$splittedline));
	#set this user as owner
	if(index($accessRights,"owner") == -1)
	{
	  #$this->post(  $usernick,"but your are not yet owner");
	  $this->post(  $usernick,$msgHand->getMesg("PAMNOTYETOWNER",$splittedline));
	  $this->addToGroup($splittedline,"owner",$userid);
	  #$this->post(  $usernick,"new owner $usernick $username\@$userhost");
	  $this->post(  $usernick,$msgHand->getMesg("PAMNEWOWNER",$splittedline)." $usernick $username\@$userhost");
	}#if(index($accessRights,"owner") == -1)
      }
    }
    #$this->post(  $usernick,"end auth for $usernick $username\@$userhost");
    $this->post(  $usernick,$msgHand->getMesg("PAMENDAUTH",$splittedline)." $usernick $username\@$userhost");
    return 1;
  }# if($line =~ /passwd\s+(\S+)/)

  return 0
  if(!($this->isOwnerOrOper($splittedline)));
  
    # $this->print("pam_pg: debug '$botname': has rights !\n");
    #$this->post(  $usernick,'user is owner or oper');
    if($line =~ /\s*adduser\s+(.*)/)
    {
      my ($usertoadd,$usergroup,$userchan) = split(/ /,$1);
      if(!$usertoadd || !$usergroup)
      {
	  #$this->post(  $usernick,"you forgot the args user grp chan");
	  $this->post(  $usernick,$msgHand->getMesg("PAMADDUSERHELP",$splittedline));
	  return 1;
      }# if(!$usertoadd)
      # $this->print("pam_pg: debug '$botname': case is adduser !\n");
      # $this->print("case is adduser\n");
      # $this->print("m1: search for $usernick\n");
      return 1 if($usergroup eq "owner" && index($accessRights,"owner")==-1);

      my $sql_query = 'SELECT id FROM users where ';
      $sql_query .= "nick='$usertoadd'";
      #$sql_query .= "logged='t' AND nick='$usertoadd'";
      my $sth = $this->doQuery($usernick,$sql_query);
      if( $sth->rows != 0)
      {
	my $data = $sth->fetchrow_hashref();
	my $userid = $data->{"id"};
	  $this->addToGroup($splittedline,$usergroup,$userid);

      }#if( $sth->rows != 0)
      else
      {
	#$this->post(  $usernick,'user not found or not logged in');
	$this->post(  $usernick,$msgHand->getMesg("PAMUSERNOTFOUND",$splittedline));
      }#else

      return 1;
    }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
    #drop table "users";
    #drop table "groups";
    #drop table "group2user";
    #drop SEQUENCE groups_id_seq;
    #drop SEQUENCE users_id_seq;
    #drop SEQUENCE group2user_id_seq;
    # elsif($line =~ /$botname\s*:\s*destroy/)
    # {
      #    $sql_query = 'drop table users';
      #    my $sth = $dbh->prepare($sql_query)
      #      or { $success=1;$errmsg .="Couldn't prepare statement: ".$dbh->errstr;}
      #    $sth->execute()             # Execute the query
      #      or { $success=1;$errmsg .="Couldn't execute statement: ".$sth->errstr;}

      #    $sql_query = 'drop table groups';
      #    $sth = $dbh->prepare($sql_query)
      #      or { $success=1;$errmsg .="Couldn't prepare statement: ".$dbh->errstr;}
      #    $sth->execute()             # Execute the query
      #      or { $success=1;$errmsg .="Couldn't execute statement: ".$sth->errstr;}

      #    $sql_query = 'drop SEQUENCE groups_id_seq';
      #    $sth = $dbh->prepare($sql_query)
      #      or { $success=1;$errmsg .="Couldn't prepare statement: ".$dbh->errstr;}
      #    $sth->execute()             # Execute the query
      #      or { $success=1;$errmsg .="Couldn't execute statement: ".$sth->errstr;}

      #    $sql_query = 'drop SEQUENCE users_id_seq';
      #    $sth = $dbh->prepare($sql_query)
      #      or { $success=1;$errmsg .="Couldn't prepare statement: ".$dbh->errstr;}
      #    $sth->execute()             # Execute the query
      #      or { $success=1;$errmsg .="Couldn't execute statement: ".$sth->errstr;}
      #    if($success == 0) { $sth->finish; $dbh->commit();}
      #    else { $dbh->rollback(); }
      # }#elsif($line =~ /$botname\s*:\s*deluser (\S+)\s+(\S+)\@(\S+)/)
    elsif($line =~ /addgroup\s+(\S+)/)
    {
      my $newgroup = $1;
      # $this->print("case is addgroup\n");
      # $this->print("m2: search for $usernick\n");

      my $sql_query = 'INSERT INTO "groups" ( "name") VALUES (';
	  $sql_query .= "'$newgroup')";
	  my $sth = $this->doQuery($usernick,$sql_query);
	  #$this->post(  $usernick,''." adding group performed...");
	  $this->post(  $usernick,$msgHand->getMesg("PAMADDGROUP",$splittedline));
	  }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
      elsif($line =~ /listgroups/)
      {
	# $this->print("case is listgroup\n");
	# $this->print("m2: search for $usernick\n");

	my $sql_query = 'SELECT * FROM "groups"';
	my $sth = $this->doQuery($usernick,$sql_query);
	if( $sth->rows != 0)
	{
	  #$this->post( $usernick,'List of available groups');
	  $this->post( $usernick,$msgHand->getMesg("PAMLISTGROUPS",$splittedline));
	  $this->post( $usernick,'num='.$sth->rows);
	  #$this->post( $usernick,'id  name');
	  $this->post( $usernick,$msgHand->getMesg("PAMLISTGROUPSHEAD",$splittedline));
	  # Read the matching records and $this->print them out          
	  while (my $data = $sth->fetchrow_hashref())
	  {
	    $this->post(  $usernick,''.$data->{"id"}." ".$data->{"name"});
	  }

	}#if( $sth->rows != 0)
	#$this->post($usernick,''." listgroup performed...");
	$this->post($usernick,$msgHand->getMesg("PAMLISTGROUPOK",$splittedline));
	return 1;
      }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
      elsif($line =~ /deluser\s+(\S+)\s+(\S+)/)
      {
	my $usertoadd = $1;
	my $newgroup = $2;
	# $this->print("case is deluser\n");
	return 1 if($newgroup eq "owner" && index($accessRights,"owner")==-1);
	# $this->print("m2: search for $usernick\n");
	my $sql_query = "SELECT id FROM users where nick='$usertoadd'";
	my $sth = $this->doQuery($usernick,$sql_query);
	if( $sth->rows != 0)
	{
	  while (my $data = $sth->fetchrow_hashref())
	  {
	    my $userid = $data->{"id"};
	    $sql_query = 'SELECT id FROM groups where ';
	    $sql_query .= "name='$newgroup'";
	    my $sth = $this->doQuery($usernick,$sql_query);
	    if( $sth->rows != 0)
	    {
	      $data = $sth->fetchrow_hashref();
	      my $groupid = $data->{"id"};

	      $sql_query = "DELETE FROM group2user where \"user\"='$userid'";
	      $sql_query .= " AND \"group\"='$groupid'";
	      $this->doQuery($usernick,$sql_query);
	      #$this->post( $usernick,''." deluser performed...");
	      $this->post( $usernick,$msgHand->getMesg("PAMDELUSEROK",$splittedline));
	    }#if( $sth->rows != 0)
	  }#while ($data = $sth->fetchrow_hashref())
	}#if( $sth->rows != 0)
	return 1;
      }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
      elsif(($line =~ /dispuser/)  || ($line =~ /dispuser\s+(\S+)/)|| ($line =~ /dispuser\s+(\S+)\s+(\S+)/))
      {
	my $askChan = $1;
	my $askMode = $2;
	my $sql_query = undef;
	# $this->print("case is dispuser\n");
	# $this->print("m3: search for $usernick\n");
	#my $list = findOperator($this,$splittedline);
	#if($list)
	#{
	  my $topmsg = 'List of users';
	  if($askChan)
	  {
	    $topmsg .= ' with chan';
	    if($askMode)
	    {
	      $topmsg .= ' with and mode';

	      $sql_query = 'SELECT nick,users.name,host FROM "users","groups","group2user" where ';
	      $sql_query .= "\"channel\"='$askChan' AND ";
	      $sql_query .= "\"user\"=users.id AND \"group\"=groups.id AND ";
	      $sql_query .= "groups.name='$askMode')";
	    }# if($askMode)
	    else
	    {
	      $sql_query = 'SELECT nick,users.name,host FROM "users","group2user" where ';
	      $sql_query .= "\"channel\"='$askChan' AND ";
	      $sql_query .= "\"user\"=users.id";
	    }
	  }#if($evArg)
	  else
	  {
	    $sql_query = 'SELECT DISTINCT nick,users.name,host,groups.name AS gname FROM "users","groups","group2user" where ';
	    $sql_query .= "\"user\"=users.id AND \"group\"=groups.id ";
	  }#else
	  my $sth = $this->doQuery($usernick,$sql_query);
	  if( $sth->rows != 0)
	  {
	    $this->post( $usernick,$topmsg);
	    $this->post( $usernick,'nick   email');
	    # Read the matching records and $this->print(them out          
	    #foreach my $i (keys(%$data))
	    #{
	    #  # $this->print("dispuser: deb k=$i,v='".$data->{$i}."'\n"));
	    #}#foreach $i (keys(%$data))
	    while (my $data = $sth->fetchrow_hashref())
	    {
	      my $theMsg = $data->{"nick"}." ";
	      $theMsg .= $data->{"name"}.'@'.$data->{"host"}." ".$data->{"gname"};
	      $this->post( $usernick, $theMsg);
	    }
	  }#if( $sth->rows != 0)
	      #$this->post($usernick, "end of user listing");
	      $this->post($usernick, $msgHand->getMesg("PAMENDUSERLIST",$splittedline));

	  return 1;
	  #}#if($list ne "")
      }#dispuser (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
      #else {print "no command for me $line\n"; }
  #}# if($list)
  return 0;
}#sub PRIVMSGaction
######################################################################
=pod

=item setNicksLogged

since nicks can be assigned to different hostmasks, it is not possible to
identify a user only by its nick, so its easier to send the users a message
that they need to auth if they want to use the services of this bot

=cut

######################################################################
sub setNicksLogged
{
  my ($this,$splittedline) = @_;
  my $names = $splittedline->{"userlist"};
  my $kernel = $splittedline->{"kernel"};
  my $context = $splittedline->{"context"};
  my $channel = $splittedline->{"channel"};

  foreach my $username (@$names)
  {
    $username =~ s/~//g;
    $username =~ s/^@//g;
    ##removing the hostname of the jostpart, for dynamic addressing
    #my @hostparts = split(/\./,$userhost);
    #shift @hostparts;
    #$userhost = join('.',@hostparts);
    #bail out if its the same bot joinning
    my $botname = $splittedline->{"heap"}->{"nick"};
    if($username ne $botname) 
    {
      # $this->print("updating: $username\n");
      my $msgHand = ($this->sysdata())->module("messageHandler");
      my $actLang = "";
      $this->post($username,$botname.' '.$msgHand->getMesg("PAMREAUTH",$splittedline));
    }# if$usernick ne $botname 
  }#foreach my $username (@$names)
  return 0;
}#sub setNicksLogged
######################################################################
=pod

=item JOINaction

react on a user joining

=cut

######################################################################
sub JOINaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));

  # $this->print("pam_pg dumping obj ".$this."\n");
  # $this->print("pam_pg dumping sysdata ".Dumper($this->sysdata())."\n");
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  $username =~ s/~//g;
  $username =~ s/\@//g;
  ##removing the hostname of the jostpart, for dynamic addressing
  #my @hostparts = split(/\./,$userhost);
  #shift @hostparts;
  #$userhost = join('.',@hostparts);
  $this->print("someone joins: $usernick $username\@$userhost\n");
  #bail out if its the same bot joinning
  my $botname = $splittedline->{"heap"}->{"nick"};
  if($usernick eq $botname) 
  {
    return 0;
  }

  my $sql_query = 'SELECT * FROM "users" WHERE ';
  $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
  my $sth = $this->doQuery($usernick,$sql_query);
  # $this->print("RRRRR first try with $sql_query res=".$sth->rows."\n");

  my @matches = [];
  if( $sth->rows == 0)
  {
    $this->print("couldn't find $usernick $username\@$userhost with $sql_query\n");

    $userhost = substr ($userhost,index($userhost,".")+1);
    $sql_query = 'SELECT * FROM "users" WHERE ';
    $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
    $sth = $this->doQuery($usernick,$sql_query);
    # $this->print("RRRRR second try with $sql_query res=".$sth->rows."\n");
  }#if( $sth->rows == 0)
  else
  {
    # $this->print("RRRRR first was a success\n");
  }

  my $atleastone = 0;
  while (my $data = $sth->fetchrow_hashref())
  {
    push (@matches,$data);
    # $this->print("OOOOOOOOOO foudnd one: ".Dumper($data)."\n");
    $atleastone = 1;
  }

  my  $now_string = strftime "%a %b %e %H:%M:%S %Y", gmtime;
  if( $sth->rows == 0 && $atleastone == 0)
  {
    $this->print("unknown: $usernick $username\@$userhost: $sql_query\n");
    $this->addUser($usernick,$username,$userhost,$kernel,'t');
    #$sql_query = 'SELECT * FROM "users";';
    # $this->print(("### dumping all users:$sql_query\n"));
    #$sth = $this->doQuery($usernick,$sql_query);
    ## $this->print(("### dumping handler:".Dumper($sth)."\n"));
    #while ($data = $sth->fetchrow_hashref())
    #{
      #  $this->print("OOOOOOOOOO: ".Dumper($data)."\n");
      #}
    # $this->print(("### done dumping all users:\n"));
    $this->print("### Join prob:".$sth->errstr."\n") if(!$sth);
  }#if( $sth->rows == 0)
  else
  {
    $this->print("refreshing date: $usernick $username\@$userhost\n");
    $sql_query = 'UPDATE "users" SET access=CURRENT_DATE,logged=\'t\' WHERE ';
    $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
    $sth = $this->doQuery($usernick,$sql_query);
    $this->print("### Join prob:".$sth->errstr."\n") if(!$sth);
  }#else
  return 0;
}#sub JOINaction
######################################################################
=pod

=item PARTaction

react on a user leaving

=cut

######################################################################
sub PARTaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  $username =~ s/~//g;
  # $this->print("someone leaves: $usernick $username\@$userhost\n");

  my $sql_query = 'SELECT * FROM "users" WHERE ';
  $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
  my $sth = $this->doQuery($usernick,$sql_query);
  if( $sth->rows == 0)
  {
    $userhost = substr ($userhost,index($userhost,".")+1);
    $this->print("trying $usernick $username\@$userhost and $sql_query\n");
    $sql_query = 'SELECT * FROM "users" WHERE ';
    $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
    $sth = $this->doQuery($usernick,$sql_query);
  }#if( $sth->rows == 0)

  my  $now_string = strftime "%a %b %e %H:%M:%S %Y", gmtime;
  if( $sth->rows == 0)
  {
    $this->addUser($usernick,$username,$userhost,$kernel,'f');
  }#if( $sth->rows == 0)
  else
  {
    # $this->print("refreshing date: $usernick $username\@$userhost\n");
    $sql_query = 'UPDATE "users" SET access=CURRENT_DATE,logged=\'f\',auth=\'f\' WHERE ';
    $sql_query .= "nick='$usernick' AND name='$username' AND host='$userhost'";
    $sth = $this->doQuery($usernick,$sql_query);
  }#else
  return 0;
}#sub PARTaction
######################################################################
=pod

=item help

issue the help for this module

=cut

######################################################################
sub help
{
  my $this = shift;
  my $splittedline = shift;
  my $botname = $splittedline->{"heap"}->{"nick"};
  # $this->print("m6: search for $usernick\n");
  # $this->print("ref = '$splittedline'\n");
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};


  # $this->print("help, req by $usernick $username\@$userhost\n");
  # $this->print("full-line was ".$splittedline->{"fulline"}."\n");
  # $this->print("-- help FO with ".Dumper($splittedline)."\n");
  my $list = findOperator($this,$splittedline);
  my $helpmsg = "PAM-help:\n";
  $helpmsg   .= "   set password: passwd <old passwd> <new passwd>\n";
  $helpmsg   .= "   authenticate: auth <nick> <passwd>\n";
  if($list ne "")
  {
    $helpmsg   .= "   add user: adduser nick [oper|teki|ally]\n";
    $helpmsg   .= "   add group: addgroup name\n";
    $helpmsg   .= "   remove user: deluser nick [oper|teki|ally]\n";
    $helpmsg   .= "   display user: dispuser [groupname]\n";
    $helpmsg   .= "   display groups: listgroups\n";
    return $helpmsg;
  }#if($list ne "")
  else 
  { 
    $helpmsg .= "user $usernick, $username\@$userhost is not ";
    $helpmsg .= "Operator, help not available!\n";
    #$helpmsg .= "result query gave: $list";
    return $helpmsg;
  }
}#sub help
######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "pam_pg";
}#sub isa
######################################################################
=pod

=item findLogged

search for the online status of someone

=cut

######################################################################
sub findLogged
{
  my $this = shift;
  my $nick = shift;

  my $sql_query = 'SELECT * FROM users where ';
  $sql_query .= "\"nick\"='$nick' AND logged='t'";

  my $sth = $this->doQuery($nick,$sql_query);
  if( $sth->rows != 0)
  {
    return 1;
  }#if( $sth->rows == 0)
  return 0;
}# sub findLogged
######################################################################
=pod

=item getLogged

spit the list of logged ones

=cut

######################################################################
sub getLogged
{
  my ($this, $usernick, $searched) = @_;


  my $sql_query = 'SELECT * FROM users ';
  if($searched)
  {
    $sql_query .=  "WHERE nick='$searched' ";
    #$sql_query .=  "nick='$searched' AND ";
  }# if(!$searched)
  #$sql_query .= " logged='t'";
  #$sql_query .= " channel='".$splittedline->{"channel"}."'";
  #$this->print("ACTUAL QUERY ".$sql_query."\n");

  my $sth = $this->doQuery($usernick,$sql_query);
  if( $sth->rows != 0)
  {
    #$this->print("QUERY expected num of rows:".$sth->rows."\n");
    my $theMsg = "List  :\n";
    while (my $data = $sth->fetchrow_hashref())
    {
      #$this->print("QUERY adding:".$sth->data->{"nick"}."\n");
      $theMsg .= $data->{"nick"}." ";
      $theMsg .= $data->{"name"}.'@'.$data->{"host"};
      if($data->{"logged"})
      {
	$theMsg .= " actually logged";
      }# if($data->{"logged"})
      else
      {
	$theMsg .= " last logged: ".$data->{"access"};
      }# else
      $theMsg .= "\n";
      #$this->post( $usernick, $theMsg);
    }
    $theMsg .= "\nEnd of List";
    return $theMsg;
  }#if( $sth->rows == 0)
  return "no match";
}
######################################################################
=pod

=item findOperator 

find out if a person shoudl be operator

=cut

######################################################################
sub findOperator 
{
  my ($this,$line) = @_;
  my $i;
  my $listing = "";
  my $nick = $line->{"usernick"};
  my $name = $line->{"username"};
  my $host = $line->{"userhost"};
  my $kernel = $line->{"kernel"};
  my $botname = $line->{"heap"}->{"nick"};
  $this->{"kernel"} = $line->{"kernel"};
  $this->{"context"} = $line->{"context"};

  #delete $line->{"kernel"};
  #$this->print("STATUS dumping incoming : ".Dumper($line)."\n");


  my $sql_query = '';
  if($nick)
  {
  $sql_query = 'SELECT groups.name FROM users,groups,group2user where ';
    if($line->{"channel"} ne $botname)
    {
      $sql_query .= "\"channel\"='".$line->{"channel"}."' AND ";
    }# if($line->{"channel"} eq botname)
  #$sql_query .= "\"user\"=users.id AND \"group\"=groups.id AND logged='t'";
  $sql_query .= "\"user\"=users.id AND \"group\"=groups.id ";
  $sql_query .= "AND nick='$nick'";
  # $this->print("findoperator query='$sql_query'\n");

  my $sth = $this->doQuery($nick,$sql_query);
  if( $sth->rows != 0)
  {
    while (my $data = $sth->fetchrow_hashref())
    {
      $listing .= $data->{"name"}.",";
    }
  }#if( $sth->rows == 0)
  }#if($nick)
  else
  {
   $this->print("STATUS no nick defined in : ".Dumper($line)."\n");
  }
 $this->print("STATUS $nick: $listing by $sql_query\n");
  return $listing;
}
######################################################################
=pod

=item shutdown

close down the activity for a safe shutdown

=cut

######################################################################
sub shutdown
{
  my $this = shift;
  my $owner = $this->setting("owner");
  my $dbh = $this->dbh();
  $dbh->disconnect();
}#sub shutdown
######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.12 $';
}#sub isa

######################################################################
=pod

=item doQuery

perform a query to the database

=cut

######################################################################
sub doQuery
{
  my ($this, $usernick, $sql_query, $kernel) = @_;
  # $this->print("--------------- actquery='$sql_query'\n");

  my $sth;
  my $dbh = $this->dbh();
  # $this->print(("## connecting to $this->setting("database") with $this->setting("dbuser")$passwd\n"));
  #my $dbh = DBI->connect($this->setting("database"),$this->setting("dbuser"),$this->setting("dbpasswd"),{AutoCommit => 0,PrintError =>0});
  if($sth = $dbh->prepare($sql_query))
  {
    if($sth->execute())             # Execute the query
    {
      #$this->post( $usernick,''." SQL success!");
      #$sth->finish; 
      $dbh->commit();

      return $sth;
    }
    else
    {
      my $errmsg .="pam_pg: Couldn't execute statement: ".$sth->errstr."\n";
      if($errmsg =~ /Relation "users" does not exist/)
      {
	$this->createTables();
      }
      #$this->post( $usernick,"$errmsg");

      #$this->post( $usernick,'line was '.$sql_query);
      $this->print("### doQuery prob: '$errmsg' for '$usernick' and '$sql_query'\n");
      $dbh->rollback(); 
    }
  }
  else
  {
    my $errmsg .="pam_pg: Couldn't prepare statement: ".$dbh->errstr."\n";
    #$this->post( $usernick,''.$errmsg);
    #$this->post( $usernick,'line was '.$sql_query);
    $this->print("### doQuery prob: '$errmsg' for '$usernick' and '$sql_query'\n");
  }#else
  $this->print("doQuery done\n");
  #$dbh->disconnect();
  return $sth;
}#sub doQuery    
######################################################################
=pod

=item createTables

create the tables to hold the data

=cut

######################################################################
sub createTables
{
  my $this = shift;
  my $errmsg = "";
  my $dbh = DBI->connect($this->setting("database"),$this->setting("dbuser"),$this->setting("dbpasswd"),{AutoCommit => 0,PrintError =>0})
    or $this->print("pam_pg: Couldn't connect to database: ".DBI->errstr."\n");
  #$sql_query = 'CREATE TABLE "users" ( "id" SERIAL PRIMARY KEY, "nick" text UNIQUE,';
      my $sql_query = 'CREATE TABLE "users" ( "id" SERIAL PRIMARY KEY, "nick" text,';
	$sql_query .= '"name" text, "host" text, "passwd" text, "access"
	timestamp,"logged" boolean,"auth" boolean)';

      my $sth = "";
      if(!($sth = $dbh->prepare($sql_query)))
      {
	$errmsg .="pam_pg: Couldn't prepare statement: ".$dbh->errstr."\n";
	$errmsg .="sql : $sql_query\n";
	die($errmsg);
	$dbh->rollback(); 
	#bail out 
	return;
      };
      if(!$sth->execute())           # Execute the query
      { 
	$errmsg .="pam_pg: Couldn't execute statement: ".$sth->errstr."\n";
	$errmsg .="sql : $sql_query\n";
	die($errmsg);
	$dbh->rollback(); 
	#bail out 
	return;
      };
      $this->print("########## created users ###############\n");


      $sql_query = 'CREATE TABLE "groups" ( "id" SERIAL PRIMARY KEY, ';
	  $sql_query .= '"name" text UNIQUE)';
      if(!($sth = $dbh->prepare($sql_query)))
      { 
	$errmsg .="pam_pg: Couldn't prepare statement: ".$dbh->errstr."\n";
	$errmsg .="sql : $sql_query\n";
	die($errmsg);
	$dbh->rollback(); 
	#bail out 
	return;
      };
      if(!$sth->execute())             # Execute the query
      {
	$errmsg .="pam_pg: Couldn't execute statement: ".$sth->errstr."\n";
	$errmsg .="sql : $sql_query\n";
	die($errmsg);
	$dbh->rollback(); 
	#bail out 
	return;
      };
      #filling groups
      my @groups = ( "owner", "oper","ally","teki");
      $sql_query = 'INSERT INTO "groups" ("name") VALUES(?)';

      if(!($sth = $dbh->prepare($sql_query)))
      { 
	$errmsg .="pam_pg: Couldn't prepare statement: ".$dbh->errstr."\n";
	$errmsg .="sql : $sql_query\n";
	die($errmsg);
	$dbh->rollback(); 
	#bail out 
	return;
      };
      foreach my $groupname (@groups)
      {
	if(!$sth->execute($groupname))             # Execute the query
	{
	  $errmsg .="pam_pg: Couldn't execute statement: ".$sth->errstr."\n";
	  $errmsg .="sql : $sql_query\n";
	  die($errmsg);
	  $dbh->rollback(); 
	  #bail out 
	  return;
	};
      }#foreach my $groupname (@groups)

      $this->print("########## created groups ###############\n");



      $sql_query = 'CREATE TABLE "group2user" ( "id" SERIAL PRIMARY KEY, ';
	  $sql_query .= '"user" int4,"group" int4,"channel" text, ';
	  $sql_query .= 'CONSTRAINT acct1 FOREIGN KEY ("user") REFERENCES "users" (id),';
	  $sql_query .= 'CONSTRAINT acct2 FOREIGN KEY ("group") REFERENCES "groups" (id))';
      if(!($sth = $dbh->prepare($sql_query)))
      { 
	$errmsg .="pam_pg: Couldn't prepare statement: ".$dbh->errstr."\n";
	$errmsg .="sql : $sql_query\n";
	die($errmsg);
	$dbh->rollback(); 
	#bail out 
	return;
      };
      if(!$sth->execute())             # Execute the query
      { 
	$errmsg .="pam_pg: Couldn't execute statement: ".$sth->errstr."\n";
	$errmsg .="sql : $sql_query\n";
	die($errmsg);
	$dbh->rollback(); 
	#bail out 
	return;
      };
      $this->print("########## created groups2user ###############\n");

      #$sth->finish; 
      $dbh->commit();
      $dbh->disconnect();
}#sub createtable
######################################################################
=pod

=item addToGroup

check the presence and eventually add a user to a group

=cut

######################################################################
sub addToGroup
{
  my ($this,$line,$usergroup,$userid) = @_;
  my $usertoadd = $line->{"usernick"};
  my $usernick = $line->{"usernick"};
  my $kernel =   $line->{"kernel"};
  $this->{"kernel"} = $line->{"kernel"};
  $this->{"context"} = $line->{"context"};

  my $sql_query = 'SELECT id FROM groups where ';
  $sql_query .= "name='$usergroup'";
  $this->print("sending query:'$sql_query'\n");
  my $sth = $this->doQuery($usernick,$sql_query);
  if( $sth->rows != 0)
  {
    my $data = $sth->fetchrow_hashref();
    my $groupid = $data->{"id"};

    $sql_query = 'SELECT group2user.id FROM users,groups,group2user where ';
    $sql_query .= "\"channel\"='".$line->{"channel"}."' AND ";
    $sql_query .= "user=users.id AND \"group\"=groups.id AND logged='t' ";
    $sql_query .= "AND nick='$usertoadd' AND groups.name='$usergroup'";

    # $this->print("2sending query:'$sql_query'\n");
    my $sth = $this->doQuery($usernick,$sql_query);
    if( $sth->rows != 0)
    {
      $this->post( $usernick,'user allready in that group');
    }#if( $sth->rows != 0)
    else
    {
      $sql_query = 'INSERT INTO group2user ("user","group",channel) VALUES (';
	  $sql_query .= "'$userid','$groupid','".$line->{"channel"}."')";
	  # $this->print("3sending query:'$sql_query'\n");
	  $this->doQuery($usernick,$sql_query);
	  $this->post( $usernick,'user added to group');
	  }#else
	  }#if( $sth->rows != 0)
  else
  {
    $this->post( $usernick,'no such group');
  }#else

}#sub addToGroup
######################################################################
=pod

=item addUser

add a user to the database

=cut

######################################################################
sub addUser
{
  my ($this,$usernick,$username,$userhost,$kernel,$logged) = @_;
  my   $sql_query = 'INSERT INTO "users" (nick,name,host,access,logged,passwd) VALUES';
  $sql_query .= "('$usernick','$username','$userhost',CURRENT_DATE,'$logged','toto')";
  $this->print(("### inserting new user:$sql_query\n"));
  my   $sth = $this->doQuery($usernick,$sql_query);
  $this->print("### adduser prob:".$sth->errstr."\n") if(!$sth);
}#sub addUser
######################################################################
=pod

=item dbh

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub dbh
{
  my($this,$ldbh) = @_;

  if($ldbh)
  {
      $this->{"dbh"} = $ldbh;
  }
  return $this->{"dbh"};
}# sub dbh
######################################################################
=pod

=item sysdata

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

