##############################################################################
=pod

=head1 NAME

PAM module, authentification module for zebot

=head1 DESCRIPTION

this one loads the user list and accredentials at boot, and makes only fetches
to the db when necessary, the statemodifications are given through to the DB
immediately though

This is a subclass of L<zebot::baseactor>

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  pam.pam is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::pam;
use strict;
sub BEGIN
{
    #$this->print "BEGIN zebot::pam";
    #$this->print "include path is : ".Dumper(\@INC);
}
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);
use DBI;

use Data::Dumper;

use POE::Session;
#use zebot::DB::Helper;
use zebot::DB::DBspawner;

our @ISA = ("zebot::baseactor");
zebot::baseactor::_define_constructor("zebot::pam");


######################################################################
=pod

=item init

Initiaize, means set up this module

=cut

######################################################################
sub init
{
  my @securedargs = @_;
  my ($this,$sysref) = @_;
  my $sysrefe = $sysref;
  #$this->print "obj = $this";
  #$this->print "PAM init";
  #$this->print "syse[botname] = ".$sysrefe{"botname"};
  $this->{"users"} = {};
  $this->{"DBslave"} = 'DBagent';


  $this->SUPER::init($sysref);
  $this->sysdata($sysref);
  $sysref->module("pam",$this);

  $this->setting("database","DBI:Pg:dbname=zebot") if(!($this->setting("database")));
  #stat a session since we need an instance able to receive and process the DBI Agent callbacks
  #$this->{"DBAGENT"} = new zebot::DB::Helper();
  $this->{"DBAGENT"} = new zebot::DB::DBspawner("DBagent");
  $this->{"DBAGENT"}->init($sysref,$this);
  $this->session( 'pam_db_slave');


  POE::Session->create( 
      object_states => 
      [ 

      $this =>
      {  
      _start		=> "_start",
      _stop		=> "_stop",
      'createTables'	=> 'createTables',
      "passChanged"	=> "passChanged",
      "groupsDisplayed"	=> "groupsDisplayed",
      "privilegeRemoved"	=> "privilegeRemoved",
      "usergroupMatch"	=> "usergroupMatch",
      "usertogroupInserted"=> "usertogroupInserted",
      "ignoreReturn"	=> "ignoreReturn",
      "checkTables"	=> "checkTables",
      "fetchedGroups"	=> "fetchedGroups",
      "fetchedUsers"	=> "fetchedUsers",
      "shutdown"	=> "shutdown",
      "tablesCreated"	=> "shutdown",
      }
  ]
    );


}#sub init
######################################################################
=pod

=item PRIVMSGaction

react on a message addressed directly to this script

This module reacts only to messages send on the channels is active by invoquing the base  L<zebot::baseactor/"PRIVMSGaction">

=cut

######################################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  $this->print("PAM before active\n");
  return 0 if($this->SUPER::activeForThisChan($splittedline));
  $this->print("PAM after active\n");
  my $line = $splittedline->{"line"};
 print("PAM PRIVMSGaction with $line\n");
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};
  #$this->print( "pam::PRIVMSGaction just set kernel=". $this->{"kernel"} );

  my $msgHand = ($this->sysdata())->module("messageHandler");
  #my $actLang = $msgHand->fetchChannelLang($splittedline->{"channel"});
  my $actLang = $splittedline->{"lang"};
  #$splittedline->{"lang"} = $actLang;


  my $botname = $splittedline->{"heap"}->{"nick"};
  #$this->print( "pam: debug '$botname': received $line");

  #bail out if the line is empty
  return 0 if(!$line);
  my($command, $evChan, $rest) = split(/ /,$line,3);
  if($evChan && ($evChan =~ /^#/))
  {
    $splittedline->{"channel"} = $evChan;
    $line = $rest;
  }# if($evChan =~ /^#/)
  else
  {
    $line = $evChan;
    if($rest) {$line .= " ".$rest;}
  }# else
  my $accessRights = findOperator($this,$splittedline);

  my %temp = %{$splittedline};

  $splittedline = \%temp;
  $splittedline->{"line"} = $line;

  $this->print("PAM commans is $command\n");

  if($command =~ /passwd/)
  {
    return $this->changePasswd($msgHand,$splittedline);
  }# if($line =~ /passwd\s+(\S+)/)
  elsif($command =~ /auth/)
  {
    return $this->authenticate($msgHand,$splittedline,$accessRights);
  }# if($line =~ /auth\s+(\S+)/)
  elsif($command =~ /unregister/)
  {
    return $this->unregister($msgHand,$splittedline,$accessRights);
  }# if $line =~ /register
  elsif($command =~ /register/)
  {
    return $this->register($msgHand,$splittedline,$accessRights);
  }# if $line =~ /register
  elsif($command =~ /dispuser/)
  {
    return $this->diplayUser($msgHand,$splittedline);
  }#dispuser (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)

  #end of public section, now we have to check for correct rights... format is generally cmd [chan] other args... so we split this up....

  #$this->print( "PAM: end of user commands for  '$command'");
  return 0
    if(!($this->isOwnerOrOper($splittedline)));
  #if(!(index($accessRights,"owner") != -1 || index($accessRights,"oper") != -1));

  #$this->print( "PAM: begin of op commands for  '$command'");
  #$this->print( "pam: debug '$botname': has rights !");
  #$this->post(  $usernick,'user is owner or oper');
  if($command =~ /adduser/)
  {
    return $this->addUserToGroup($msgHand,$splittedline,$accessRights);
  }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
  elsif($command =~ /destroy/)
  {
    #return $this->destroyTables($msgHand,$splittedline);
  }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
  elsif($command =~ /addgroup/i)
  {
    return $this->addAGroup($msgHand,$splittedline);
  }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
  elsif($command =~ /listgroups/)
  {
    return $this->showAllGroups($msgHand,$splittedline);
  }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
  elsif($command =~ /deluser/)
  {
    return $this->removeUserFromGroup($msgHand,$splittedline,$accessRights);
  }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
  #else {print "no command for me $line\n"; }
  return 0;
}#sub PRIVMSGaction
######################################################################
=pod

=item changePasswd

a change of password was rquested..

=cut

######################################################################
sub changePasswd
{
  my($this,$msgHand,$splittedline) = @_;

  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  #$this->print( "case is passwd");
  #$this->print( "m4: search for $usernick");
  my @authaargs = split(/ /,$line);
  #print("Dumping args:".Dumper(\@authaargs)."\n");
  if(scalar(@authaargs) != 2 )
  {
    #$this->print("wrong number of args....");
    #$this->post( $usernick,"syntax: passwd [#chan] oldpass newpass");
    $splittedline->{"line"} = $msgHand->getMesg("PAMPASSHELP",$splittedline);
	$this->post($usernick,$splittedline);
    return 1;
  }# if(scalar(@authaargs)<3)
  #my $oldpass = $1;
  #my $newpass = $2;
  my $oldpass = $authaargs[0];
  my $newpass = $authaargs[1];
  $username =~ s/~//g;
  ##removing the hostname of the hostpart, for dynamic addressing
  my @hostparts = split(/\./,$userhost);
  shift @hostparts;
  $userhost = join('.',@hostparts);

  my $lcnick = lc($usernick);
  if($this->{"users"}-> {$lcnick} && 
      $this->{"users"}->{$lcnick}->{"host"} eq $userhost && 
      $this->{"users"}->{$lcnick}->{"name"} eq $username && 
      $this->{"users"}->{$lcnick}->{"passwd"} eq $oldpass)
  {
    $this->debug("old pass ok : $oldpass vs ".$this->{"users"}->{$lcnick}->{"passwd"});
    $this->{"users"}->{$lcnick}->{"passwd"} = $oldpass;
    #$this->post( $usernick,'old pass ok');
    $splittedline->{"line"} = $msgHand->getMesg("PAMOLDPASSOK",$splittedline);
	$this->post($usernick,$splittedline);
    if($this->{"users"}->{$lcnick})
    {
      my $userid = $this->{"users"}->{$lcnick}->{"id"};
      my $sql_query = "UPDATE users SET passwd='$newpass' WHERE id='$lcnick'";


      $splittedline->{"query"} = $sql_query;
      $splittedline->{"type"} = "none";
      $splittedline->{"newpass"} = $newpass;

      $splittedline->{"session"} = $this->session();
      $splittedline->{"event"} = "passChanged";
      $kernel->post( $this->{"DBslave"}, 'doQuery',$splittedline);

    }# if($this->{"users"}->{$usernick})
    else
    {
      $this->debug("no pass change to $usernick");
      #$this->post( $usernick,"DB prob, no pass change for $usernick $username\@$userhost: $sql_query");
    $splittedline->{"line"} = $msgHand->getMesg("PAMDBPROB",$splittedline)." $usernick $username\@$userhost: ";
	$this->post($usernick,$splittedline);
    }

  }# if($this->{"users"}->{$data->{"nick"}}->{"passwd"})
  else
  {
    $this->debug("wrong credentials: no pass change to $usernick");
    #$this->post( $usernick,"wrong credentials: no pass change for $usernick $username\@$userhost");
    $splittedline->{"line"} = $msgHand->getMesg("PAMLOGINERROR",$splittedline)." $usernick $username\@$userhost: ";
	$this->post($usernick,$splittedline);
  }
  return 1;
}#sub changePasswd
######################################################################
=pod

=item authenticate

authenticate a user

=cut

######################################################################
sub authenticate
{
  my($this,$msgHand,$splittedline,$accessRights) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  #$this->print( "case is auth restline='$line'");
  #$this->print( "m4: search for $usernick");
  my @authaargs = split(/ /,$line);
  #print("Dumping args:".Dumper(\@authaargs)."\n");
  #$this->print( "pam::PRIVMSGaction auth kernel=". $this->{"kernel"} );
  my $authuser = "";
  my $itspass = "";
  #$this->print( "pam::PRIVMSGaction auth args=".Dumper(@authaargs) );
  if(scalar(@authaargs) == 0 )
  {
    #$this->post( $usernick,"syntax: auth [#chan] [user] passwd ");
    $splittedline->{"line"} = $msgHand->getMesg("PAMAUTHHELP",$splittedline);
    $this->post($usernick,$splittedline);
    return 1;
  }# if(scalar(@authaargs)<3)

  if(scalar(@authaargs) == 2 )
  {
    ($authuser, $itspass) = @authaargs;
  }# if(scalar(@authaargs)<3)
  else
  {
    $itspass = shift @authaargs;
    $authuser = $usernick;
  }# else
  #$this->print( "pam::PRIVMSGaction pass=$itspass" );
  $username =~ s/~//g;
  ##removing the hostname of the hostpart, for dynamic addressing
  my @hostparts = split(/\./,$userhost);
  shift @hostparts;
  $userhost = join('.',@hostparts);
  #check if we need to kick someone
  #$this->print( "pam::PRIVMSGaction auth kernel=". $this->{"kernel"} );
  if($authuser ne $usernick)
  {
    #check if the pass is valid
    #$this->post( $usernick,"Discordance between your nick and given nick");
    $splittedline->{"line"} = $msgHand->getMesg("PAMDIFFNICK",$splittedline);
    $this->post($usernick,$splittedline);
    my $lcnick = lc($authuser);
    if($this->{"users"}->{$lcnick} && 
	$this->{"users"}->{$lcnick}->{"passwd"} eq $itspass)
    {
      #we really have an usurpator! kick him!
      $this->action($splittedline->{"channel"},$msgHand->getMesg("CHASE",$splittedline));
      $this->kick($splittedline->{"channel"}, $authuser,$msgHand->getMesg("USURPATOR",$splittedline));
      #TODO needs a ban based on the ip of the usurpator!
      $usernick = $authuser;
    }# if($this->{"users"}->{$authuser} && 
	else
	{
	#uhm wrong nick, wrong pass.....
	$this->action($splittedline->{"channel"},'ACTION eats the balls of '.$usernick);
	$this->kick($splittedline->{"channel"}, $usernick,'Usurpator!!');
	#bail out
	return;
	}#else
  }#if($username ne $usernick)

  my $lcnick = lc($usernick);
  if($this->{"users"}->{$lcnick})
  {
    if($this->{"users"}->{$lcnick}->{"passwd"} eq $itspass)
    {
      #$this->print( "pam::PRIVMSGaction user seems valid" );
      #$this->post(  $usernick,"User detected");
      $splittedline->{"line"} = $msgHand->getMesg("PAMUSERFOUND",$splittedline);
      $this->post($usernick,$splittedline);
      #TODO security risk here, this bit should be resetted on user quit,
      #discon etc.. alas i don't know how to reliabily detect if the user that
      #authenticated is still there: scenarios, a user takes over the comp
      #after the legitimate one: user and hostmaks are the same... but we don't
      #want either to have to authenticate at each discon... argh...
      $this->{"users"}->{$lcnick}->{"auth"} = 1;
      $this->{"users"}->{$lcnick}->{"lineID"} = $splittedline->{"lineID"}
      if($splittedline->{"lineID"});
      #$this->post( $usernick,'authentifyed');
      $splittedline->{"line"} = $msgHand->getMesg("PAMAUTHOK",$splittedline);
      $this->post($usernick,$splittedline);
    }# if $this->{"users"}->{$usernick} && 
    else
    {
      #wrong pass,
      #$this->print( "pam::PRIVMSGaction pass not ok" );
      #$this->post( $usernick,"User with wrong credentials");
      $splittedline->{"line"} = $msgHand->getMesg("PAMNOAUTH",$splittedline);
      $this->post($usernick,$splittedline);
      #check for root passwd
      if($itspass eq $this->setting("ownerpass"))
      {
	#$this->print( "pam::PRIVMSGaction owner!" );
	#$this->post(  $usernick,"you used the ownerpass!!");
	$splittedline->{"line"} = $msgHand->getMesg("PAMOWNERPASS",$splittedline);
	$this->post($usernick,$splittedline);
	#set this user as owner
	if(index($accessRights,"owner") == -1)
	{
	  #$this->post(  $usernick,"but your are not yet owner");
	  $splittedline->{"line"} = $msgHand->getMesg("PAMNOTYETOWNER",$splittedline);
	  $this->post($usernick,$splittedline);
	  $this->addToGroup($splittedline,"owner",$usernick);
	  #$this->post(  $usernick,"new owner $usernick $username\@$userhost");
	  $splittedline->{"line"} = $msgHand->getMesg("PAMNEWOWNER",$splittedline);
	  $splittedline->{"line"} .= " $usernick $username\@$userhost";
	  $this->post($usernick,$splittedline);
	  $this->{"users"}->{$lcnick}->{"auth"} = 1;

	  my $network = $splittedline->{"network"};
	  my $channel = $splittedline->{"channel"};

	  $this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} = "owner" if(!($this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel}));

	  $this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} .=
	    ",owner" if(!($this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} =~ /owner/));

	  $this->{"users"}->{$lcnick}->{"lineID"} = $splittedline->{"lineID"}
	  if($splittedline->{"lineID"});
	}#if(index($accessRights,"owner") == -1)
      }
      #$this->print( "pam::PRIVMSGaction exiting!" );
      #$this->post(  $usernick,"userrecord for $usernick =
	  #".Dumper($this->{"users"}->{$lcnick}));
    }
  }#if($this->{"users"}->{$usernick})
  else
  {
    #inexistent user...
    #$this->print( "pam::PRIVMSGaction no userk" );
    #$this->post(  $usernick,"inexistent user");
    #$this->post(  $usernick,Dumper($this->{"users"}));
    #my $kernel = $splittedline->{"kernel"};
    #delete($splittedline->{"kernel"});
    #print("pam error: ".Dumper($splittedline)."\n");
    $splittedline->{"line"} = $msgHand->getMesg("PAM you have to register prior
	to authenticate",$splittedline);
    $this->post($usernick,$splittedline);
  }
  #$this->print( "pam::PRIVMSGaction exiting!" );
  #$this->post(  $usernick,"userrecord for $usernick = ".Dumper($this->{"users"}->{$usernick}));
  #$this->post(  $usernick,"end auth for $usernick $username\@$userhost");
  #$this->post(  $usernick,$msgHand->getMesg("PAMENDAUTH",$splittedline)." $usernick $username\@$userhost");
  $splittedline->{"line"} = $msgHand->getMesg("PAMENDAUTH",$splittedline);
  $this->post($usernick,$splittedline);
  return 1;
}#sub authenticate
######################################################################
=pod

=item register

register a user

=cut

######################################################################
sub register
{
  my($this,$msgHand,$splittedline,$accessRights) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  $splittedline->{"username"} =~ s/^~//;
  $splittedline->{"username"} =~ s/^@//;
  $splittedline->{"username"} =~ s/^\+//;
  my $username = $splittedline->{"username"};
  my $kernel = $splittedline->{"kernel"};
  my $userhost = $splittedline->{"userhost"};
      my $network = $splittedline->{"network"};
      my $channel = $splittedline->{"channel"};
  $this->print( "case is register restline='$line'");
  #$this->print( "m4: search for $usernick");
  my @authaargs = split(/ /,$line);
  if(scalar(@authaargs) == 0 )
  {
    #$this->post(  $usernick,"syntax: register [#chan] passwd [email]");
    $splittedline->{"line"} = $msgHand->getMesg("PAMREGISTERHELP",$splittedline);
	$this->post($usernick,$splittedline);
    return 1;
  }# if(scalar(@authaargs) == 0 )
  #$this->print( "pam::PRIVMSGaction auth kernel=". $this->{"kernel"} );
  my $email = "";
  my $itspass = "";
  $itspass =$authaargs[0]; 
  if(scalar(@authaargs) == 2 )
  {
    $email = $authaargs[1];
  }# if(scalar(@authaargs)<3)

  ##removing the hostname of the hostpart, for dynamic addressing
  my @hostparts = split(/\./,$userhost);
  shift @hostparts;
  $userhost = join('.',@hostparts);
  #check if we need to kick someone
  #$this->print( "pam::PRIVMSGaction auth kernel=". $this->{"kernel"} );
  my $lcnick = lc($usernick);
  if($this->{"users"}->{$lcnick})
  {
    #print("Dump the whole... ".Dumper($this->{"users"}->{$lcnick})."\n");
    my $deb = "CMP ".$this->{"users"}->{$lcnick}->{"name"};
    $deb .= " vs $username ";
    $deb .= $this->{"users"}->{$lcnick}->{"host"};
    $deb .= " vs $userhost ";
    $deb .= $this->{"users"}->{$lcnick}->{"passwd"};
    $deb .= " vs $itspass ";
    #print("$deb\n");

    if( $this->{"users"}->{$lcnick}->{"passwd"} ne $itspass)
      {
      #$this->post(  $usernick,"requested nick allready exists");
    $splittedline->{"line"} = $msgHand->getMesg("PAMNICKTAKEN",$splittedline);
	$this->post($usernick,$splittedline);
      return;
      }
    if( $this->{"users"}->{$lcnick}->{"host"} ne $userhost)
      {
	#TODO problem here... we should allow multiple hosts...
	$this->{"users"}->{$lcnick}->{"host"} .= ' '.$userhost;
      }

	if(!($this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel}))
	{
           $this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} .= "user";
	}# if channel
	else
	{
      $this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} .= ",user" 
	if(!($this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} =~ /user/));
	  
	}# else
  }# if($this->{"users"}->{$authuser})
  else
  {
    
      $this->{"users"}->{$lcnick} = {
	"name" => $username,
	"auth" => 0,
	"passwd" => $itspass,
	"host" => $userhost,
	"network" => { $network => {$channel => "user"} }
      };
  }

    $splittedline->{"username"} = $username;
    $splittedline->{"passwd"} = $itspass;
    $splittedline->{"userhost"} = $userhost;
    $splittedline->{"email"} = $email if($email);

    $this->addUser($splittedline);
    #$this->post(  $usernick,"user $usernick registered with $itspass");
    $splittedline->{"line"} = $msgHand->getMesg("PAMREGISTEROK",$splittedline);
	$this->post($usernick,$splittedline);
    #TODO add user to user basis
    #check for root passwd
    if($itspass eq $this->setting("ownerpass"))
    {
      $this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} .=
	",owner" if(!($this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} =~ /owner/));
      #$this->post(  $usernick,"you used the ownerpass!!");
    $splittedline->{"line"} = $msgHand->getMesg("PAMOWNERPASS",$splittedline);
	$this->post($usernick,$splittedline);
      #set this user as owner
      if(index($accessRights,"owner") == -1)
      {
	#$this->post(  $usernick,"but your are not yet owner");
    $splittedline->{"line"} = $msgHand->getMesg("PAMNOTYETOWNER",$splittedline);
	$this->post($usernick,$splittedline);
	$this->addToGroup($splittedline,"owner",$usernick);
	#$this->post(  $usernick,"new owner $usernick $username\@$userhost");
    $splittedline->{"line"} = $msgHand->getMesg("PAMNEWOWNER",$splittedline);
	$this->post($usernick,$splittedline);
      }#if(index($accessRights,"owner") == -1)
    }# if($itspass eq $this->setting("ownerpass"))
  
  #$this->post(  $usernick,"end register for $usernick $username\@$userhost");
    $splittedline->{"line"} = $msgHand->getMesg("PAMENDREGISTER",$splittedline);
    $splittedline->{"line"} .= " $usernick $username\@$userhost";
	$this->post($usernick,$splittedline);
  #$this->post(  $usernick,"act list of users: ".Dumper($this->{"users"}));
  return 1;
}#sub register
######################################################################
=pod

=item unregister

unregister a user

=cut

######################################################################
sub unregister
{
  my($this,$msgHand,$splittedline,$accessRights) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $kernel = $splittedline->{"kernel"};
  my $userhost = $splittedline->{"userhost"};
  #$this->print( "case is register restline='$line'");
  #$this->print( "m4: search for $usernick");
  #$this->print( "pam::PRIVMSGaction auth kernel=". $this->{"kernel"} );
  if(!$line)
  {
    #$this->post(  $usernick,"syntax: register [#chan] passwd [email]");
    $splittedline->{"line"} = $msgHand->getMesg("PAMYou have to supply the password",$splittedline);
	$this->post($usernick,$splittedline);
    return 1;
  }# if(scalar(@authaargs) == 0 )
  my $lcnick = lc($usernick);
  if($this->{"users"}->{$lcnick})
  {
    delete $this->{"users"}->{$lcnick};
    $this->delUser($splittedline);
    $splittedline->{"line"} = $msgHand->getMesg("PAMSuccessfully unregistered user",$splittedline)." $usernick";
	$this->post($usernick,$splittedline);
  }# if($this->{"users"}->{$authuser})
  else
  {
    $splittedline->{"line"} = $msgHand->getMesg("PAM This user wasn't registered",$splittedline);
	$this->post($usernick,$splittedline);
    #check for root passwd
  }#else
  #$this->post(  $usernick,"end register for $usernick $username\@$userhost");
    $splittedline->{"line"} = $msgHand->getMesg("PAMENDREGISTER",$splittedline);
    $splittedline->{"line"} .= " $usernick $username\@$userhost";
	$this->post($usernick,$splittedline);
  #$this->post(  $usernick,"act list of users: ".Dumper($this->{"users"}));
  return 1;
}#sub unregister
######################################################################
=pod

=item diplayUser

register a user

=cut

######################################################################
sub diplayUser
{
  my($this,$msgHand,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  my ($askChan, $askMode) = split(/ /,$line) if($line);

  my @users;
  print("DEBUG ".Dumper($this->{"users"})."\n");
  foreach my $user (sort(keys(%{$this->{"users"}})))
  {
    my $aUser = $this->{"users"}->{$user};
    my $line;
    my $userEntry = "$user $aUser->{name}\@$aUser->{host} ";
    foreach my $netname (sort(keys(%{$aUser->{"network"}})))
    {
      my $net = $aUser->{"network"}->{$netname};
      foreach my $channame (sort(keys(%{$net})))
      {
	my @userModes = split(/,/,$net->{"$channame"});
	foreach my $aMode (@userModes)
	{
	  push(@users,"$userEntry $netname $channame $aMode");
	}# foreach $aMode (@userModes)
      }# foreach my $channame (sort(keys($net)))
    }# foreach my $net (sort(keys($aUser->{network})))
  }# foreach my $user (keys($this->{"users"}))
  my @cleared =  @users;
  @cleared = grep((/\Q$askChan\E/), @users) if($askChan);
  @cleared = grep((/\Q$askMode\E/), @cleared) if($askMode);

  my $listing = join("\n",@cleared);
  $listing  = $msgHand->getMesg("PAMCACHEDUSERS",$splittedline)."\n$listing";
  $listing .= "\n".$msgHand->getMesg("PAMENDUSERLIST",$splittedline)."\n";
  $this->post( $usernick,$listing);
    $splittedline->{"line"} .= $listing;
	$this->post($usernick,$splittedline);

  return 1;
}#sub diplayUser
######################################################################
=pod

=item addUserToGroup

register a user

=cut

######################################################################
sub addUserToGroup
{
  my($this,$msgHand,$splittedline,$accessRights) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  my ($usertoadd,$usergroup) = split(/ /,$line);
  if(!$usertoadd || !$usergroup)
  {
    #$this->post(  $usernick,"you forgot the args user grp");
    $splittedline->{"line"} = $msgHand->getMesg("PAMADDUSERHELP",$splittedline);
    $this->post($usernick,$splittedline);
    return 1;
  }# if(!$usertoadd)
  #$this->post(  $usernick,"asdduser: $usertoadd to grp $usergroup");
    $splittedline->{"line"} = $msgHand->getMesg("PAMADDUSERDEBUG",$splittedline);
    $this->post($usernick,$splittedline);


  #$this->print( "pam: debug '$botname': case is adduser !");
  #$this->print( "case is adduser");
  #$this->print( "m1: search for $usernick");
  return 1 if($usergroup eq "owner" && index($accessRights,"owner")==-1);

  #print("casting PAM addToGroup \n");
  $this->addToGroup($splittedline,$usergroup,$usertoadd);

  return 1;
}#sub addUserToGroup
######################################################################
=pod

=item destroyTables

register a user

=cut

######################################################################
sub destroyTables
{
  my($this,$msgHand,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};

  #drop table "users";
  #drop table "groups";
  #drop table "group2user";
  #drop SEQUENCE groups_id_seq;
  #drop SEQUENCE users_id_seq;
  #drop SEQUENCE group2user_id_seq;

  my $queries = [];

  my $sql_query = 'drop table users';
  my $query = { "query" => $sql_query, "type" => "none" };
  push(@$queries,$query);

  $sql_query = 'drop table groups';
  $query = { "query" => $sql_query, "type" => "none" };
  push(@$queries,$query);

  $sql_query = 'drop SEQUENCE groups_id_seq';
  $query = { "query" => $sql_query, "type" => "none" };
  push(@$queries,$query);

  $sql_query = 'drop SEQUENCE users_id_seq';
  $query = { "query" => $sql_query, "type" => "none" };
  push(@$queries,$query);

      $splittedline->{"query"} = $queries;
      $splittedline->{"type"} = "none";

      $splittedline->{"session"} = $this->session();
      $splittedline->{"event"} = "tablesDestroyed";
      $kernel->post( $this->{"DBslave"}, 'batch',$splittedline);
  #my $result = $this->{"DBAGENT"}->batch($queries);
  #if($result->{"status"} eq "failure")
  #{
    #  $this->print("something went wrong with PAM::destroyTables ".$result->{"values"}."\n");
    #}# if($result->{"status"} eq "failure")
}#sub destroyTables
######################################################################
=pod

=item addAGroup

create a new group

=cut

######################################################################
sub addAGroup
{
  my($this,$msgHand,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel =   $splittedline->{"kernel"};

  my ($newgroup) = split(/ /,$line);

  my $queries = [];
  my $sql_query = 'INSERT INTO "groups" ( "name") VALUES (\''.$newgroup.'\')';

  push(@$queries,$sql_query);

  $splittedline->{"query"} = $queries;
  $splittedline->{"type"} = "none";

  $splittedline->{"session"} = $this->session();
  $splittedline->{"event"} = "addedAgroup";
  $kernel->post( $this->{"DBslave"}, 'batch',$splittedline);
  return 1;
}#sub addAGroup
######################################################################
=pod

=item addAGroup

register a user

=cut

######################################################################
sub showAllGroups
{
  my($this,$msgHand,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};

  my $sql_query = 'SELECT * FROM "groups"';

  $splittedline->{"query"} = $sql_query;
  $splittedline->{"type"} = "hash";

  $splittedline->{"session"} = $this->session();
  $splittedline->{"event"} = "groupsDisplayed";
  $kernel->post( $this->{"DBslave"}, 'doQuery',$splittedline);
  return 1;
}#sub showAllGroups
######################################################################
=pod

=item removeUserFromGroup

register a user

=cut

######################################################################
sub removeUserFromGroup
{
  my($this,$msgHand,$splittedline,$accessRights) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $channel = $splittedline->{"channel"};
  my $network = $splittedline->{"network"};
  my $kernel = $splittedline->{"kernel"};

  my ($usertoadd, $newgroup) = split(/ /,$line);
  return 1 if($newgroup eq "owner" && index($accessRights,"owner")==-1);

  my $lcnick = lc($usertoadd);
  my $sql_query = "DELETE FROM group2user WHERE \"user\"=(SELECT users.id ";
  $sql_query   .= "FROM users,group2user WHERE \"nick\"='$lcnick' AND ";
  $sql_query   .= "\"channel\"='$channel' AND \"network\"='$network' AND ";
  $sql_query   .= "users.id=\"user\") AND \"group\"=(SELECT id FROM groups ";
  $sql_query   .= "WHERE \"name\"='$newgroup') AND \"channel\"='$channel' AND";
  $sql_query   .= "\"network\"='$network';";


      $splittedline->{"query"} = $sql_query;
      $splittedline->{"type"} = "none";

      $splittedline->{"session"} = $this->session();
      $splittedline->{"event"} = "privilegeRemoved";
      $kernel->post( $this->{"DBslave"}, 'doQuery',$splittedline);
  return 1;
}#sub removeUserFromGroup
######################################################################
=pod

=item setNicksLogged

since nicks can be assigned to different hostmasks, it is not possible to
identify a user only by its nick, so its easier to send the users a message
that they need to auth if they want to use the services of this bot

=cut

######################################################################
sub setNicksLogged
{
  my ($this,$splittedline) = @_;
  my $names = $splittedline->{"userlist"};
  my $kernel = $splittedline->{"kernel"};
  my $context = $splittedline->{"context"};
  my $channel = $splittedline->{"channel"};


  my $fakeLine = {};
  $fakeLine->{"kernel"} = $kernel;
  $fakeLine->{"context"} = $context;
  $fakeLine->{"channel"} = $channel;
  foreach my $username (@$names)
  {
    $username =~ s/~//g;
    $username =~ s/^@//g;
    ##removing the hostname of the jostpart, for dynamic addressing
    #my @hostparts = split(/\./,$userhost);
    #shift @hostparts;
    #$userhost = join('.',@hostparts);
    #bail out if its the same bot joinning

    my $botname = $splittedline->{"heap"}->{"nick"};
    if($username && ($username ne $botname))
    {
      #$this->print "updating: $username";
      $fakeLine->{"usernick"} = $username;
      $fakeLine->{"username"} = $username;
      $fakeLine->{"userhost"} = $username;
      my $accessRights = findOperator($this,$fakeLine);
      #if(index($accessRights,"owner") != -1 || index($accessRights,"oper") != -1)
      if($this->isOwnerOrOper($fakeLine))
      {
	my $msgHand = ($this->sysdata())->module("messageHandler");
	#my $actLang = $msgHand->fetchChannelLang($channel);
	my $actLang = $splittedline->{"lang"};
	#$splittedline->{"lang"} = $actLang;
	$splittedline->{"line"} = $botname.' ';
	$splittedline->{"line"} .= $msgHand->getMesg("PAMREAUTH",$splittedline);
	$this->post($username,$splittedline);
      }# if(!(index($accessRights,"owner") != -1 || index($accessRights,"oper") != -1))
    }# if($usernick ne $botname")) 
  }#foreach my $username (@$names)
  return 0;
}#sub setNicksLogged
######################################################################
=pod

=item JOINaction

react on a user joining

=cut

######################################################################
sub JOINaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  return 0;

  #$this->print "pam dumping obj ".$this;
  #$this->print "pam dumping sysdata ".Dumper($this->sysdata());
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  $username =~ s/~//g;
  $username =~ s/\@//g;
  ##removing the hostname of the jostpart, for dynamic addressing
  #my @hostparts = split(/\./,$userhost);
  #shift @hostparts;
  #$userhost = join('.',@hostparts);
  #$this->print "someone joins: $usernick $username\@$userhost";
  #bail out if its the same bot joinning
  my $botname = $splittedline->{"heap"}->{"nick"};
  if($usernick eq $botname) 
  {
    return 0;
  }
  return 0;
}#sub JOINaction
######################################################################
=pod

=item PARTaction

react on a user leaving

=cut

######################################################################
sub PARTaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  return 0;

  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  $username =~ s/~//g;
  #$this->print "someone leaves: $usernick $username\@$userhost";

  my $lcnick = lc($usernick);
  if($this->{"users"}->{$lcnick})
  {
    $this->{"users"}->{$lcnick}->{"auth"} = 0;
  }# if($this->{"users"}->{$lcnick})
  return 0;
}#sub PARTaction

######################################################################
=pod

=item help

issue the help for this module

=cut


######################################################################
sub help
{
  my ($this, $splittedline) = @_;
  my $msgHand = ($this->sysdata())->module("messageHandler");


  my $helpmsg = $msgHand->getMesg("PAMHELP",$splittedline);
  return $helpmsg;
}#sub help
######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "pam";
}#sub isa
######################################################################
=pod

=item findLogged

search for the online status of someone

=cut

######################################################################
sub findLogged
{
  my ($this, $nick) = @_;

  if($this->{"users"}->{lc($nick)}->{"auth"})
  {
    return 1;
  }#if($this->{"users"}->{$nick}->{"auth"})
  return 0;
}# sub findLogged
######################################################################
=pod

=item getLogged

spit the list of logged ones

=cut

######################################################################
sub getLogged
{
  my ($this, $usernick, $searched) = @_;

  my $lcnick = lc($searched);
  if($searched)
  {
    if($this->{"users"}->{$lcnick} && $this->{"users"}->{$lcnick}->{"auth"})
    {
      return "user $searched is logged";
    }# if($this->{"users"}->{$searched} && $this->{"users"}->{$searched}->{"auth"})
  }# if(!$searched)
  #$sql_query .= " logged='t'";
  #$sql_query .= " channel='".$splittedline->{"channel"}."'";
  #$this->print("ACTUAL QUERY ".$sql_query);

  my $theMsg = "List  :\n";

  foreach my $name (sort(keys(%{$this->{"users"}})))
  {
    if($this->{"users"}->{$name}->{"auth"})
    {
      my $data = $this->{"users"}->{$name};
      $theMsg .= $data->{"nick"}." ";
      $theMsg .= $data->{"name"}.'@'.$data->{"host"};
      $theMsg .= " actually logged";
      $theMsg .= "\n";
    }# if($this->{"users"}->{$data}->{"auth"})

    my $theMsg = "\nEnd of List";
    return $theMsg;
  }# foreach my $name (sort(keys(%{$this->{"users"}})))
  return "no match";
}# sub getLogged
######################################################################
=pod

=item findOperator 

return the rights of this user, rights owner and oper are normally only given
if the user is authentificated, possible to bypass by giving a second argument
set to true

=cut

######################################################################
sub findOperator 
{
  my ($this,$line) = @_;
  my $i;
  my $listing = "";
  my $nick = $line->{"usernick"};
  my $name = $line->{"username"};
  my $host = $line->{"userhost"};
  my $network = $line->{"network"};
  my $noauth = $line->{"noauth"};
  my $kernel = $line->{"kernel"};
  my $botname = $line->{"heap"}->{"nick"};
  $this->{"kernel"} = $line->{"kernel"};
  $this->{"context"} = $line->{"context"};

  #delete $line->{"kernel"};
  #$this->print("STATUS dumping incoming : ".Dumper($line));


  #$this->{"users"};
  my $sql_query = '';
  my $rights = "";
  if($nick)
  {
    $nick = lc($nick);
    if($this->{"users"}->{$nick})
    {
      #$this->print("pam user exists ");
      if($line->{"channel"} ne $botname)
      {
	$rights =  $this->{"users"}->{$nick}->{"network"}->{$network}->{$line->{"channel"}};
	#$this->print("extracted rights: $rights");
      }#if($line->{"channel"} ne $botname")
      else
      {
	foreach my $chan (keys(%{$this->{"users"}->{$nick}->{"network"}->{$network}}))
	{
	  $rights .=  $this->{"users"}->{$nick}->{"network"}->{$network}->{$chan}.",";
	}# foreach my $chan (keys($this->{"users"}->{$nick}->{"network"}->{$network}))
	#$this->print("extracted all rights: $rights");
      }# else

      #$this->print("removing rights eventually:");
      if(!($noauth || $this->{"users"}->{$nick}->{"auth"}))
      {
	#print("noauth ");
	$rights =~ s/owner|oper//gi if($rights);
      }# if(!($noauth || $this->{"users"}->{$nick}->{"auth"}))
      #internal modus, push the session id onto the stack
      $rights .= " ".$this->{"users"}->{$nick}->{"lineID"} if($this->{"users"}->{$nick}->{"lineID"});
    }# if($this->{"users"}->{$nick})
    else
    {
      #$this->print("pam::findOperator STATUS nothing known of  $nick");
      return $rights;
    }
  }#if($nick)
  else
  {
    $this->print("STATUS no nick defined in : ".Dumper($line));
  }
  #$this->print("STATUS $nick: $rights");
  return $rights;
}# sub findOperator 
######################################################################
=pod

=item shutdown

close down the activity for a safe shutdown

=cut

######################################################################
sub shutdown
{
  my ($this,$args,$kernel) = @_[OBJECT,ARG0,KERNEL];
  print("PAM post sutdown to DBagent\n");
  $kernel = $args->{"kernel"} if(!$kernel);
  if($kernel)
  {
    $kernel->post( $this->{"DBslave"}, 'shutdown');
    $kernel->alias_remove( $this->session );
  }# if($kernel)
  else
  {
    $this->print("coudlnt close down dbagent nor remove pam alias..");
  }# else
  #$this->{"DBAGENT"}->shutdown();
}#sub shutdown
######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.38 $';
}#sub isa
######################################################################
=pod

=item createTables

create the tables to hold the data

=cut

######################################################################
sub createTables
{
  my ($this,$kernel, $heap, $args) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  my $queries = [];

  my $sql_query = 'CREATE TABLE "users" ( "id" SERIAL PRIMARY KEY, "nick" text,';
      $sql_query .= '"name" text, "host" text, "passwd" text, "access"';
      $sql_query .= ' timestamp,"logged" boolean,"auth" boolean)';

  my $query = { "query" => $sql_query, "type" => "none" };
  push(@$queries,$query);

  $sql_query = 'CREATE TABLE "groups" ( "id" SERIAL PRIMARY KEY, ';
      $sql_query .= '"name" text UNIQUE)';
  $query = { "query" => $sql_query, "type" => "none" };
  push(@$queries,$query);


  my @groups = ( "owner", "oper","ally","teki","user");
  $sql_query = 'INSERT INTO "groups" ("name") VALUES(?)';
  my $result = $this->{"DBAGENT"}->prepare($sql_query);
  #$this->print("createTAbles: ".Dumper($result)."\n");

  if(!$result || $result->{"status"} eq "failure" )
  {
    $errmsg .="Couldn't prepare statement: ";
    $errmsg .= $result->{"values"} if($result->{"values"});
    $errmsg .= "\n";
    $errmsg .="sql : $sql_query\n";
    die($errmsg);
  }# if($returns->{"status"} eq "success" )

  my $strid = $result->{"values"};

  foreach my $groupname (@groups)
  {
    $query = { "query" => $strid, "type" => "none" , "values" => [$groupname]};
    push(@$queries,$query);
  }#foreach my $groupname (@groups)

  $sql_query  = 'CREATE TABLE "group2user" ( "id" SERIAL PRIMARY KEY, ';
      $sql_query .= '"user" int4,"group" int4,"channel" text, "network" text, ';
      $sql_query .= 'CONSTRAINT acct1 FOREIGN KEY ("user") REFERENCES "users" (id),';
      $sql_query .= 'CONSTRAINT acct2 FOREIGN KEY ("group") REFERENCES "groups" (id))';
  $query = { "query" => $sql_query, "type" => "none" };
  push(@$queries,$query);

  $args->{"query"} = $queries;
  $args->{"type"} = "none";

  $args->{"session"} = $this->session();
  $args->{"event"} = "tablesCreated";
  #print("issuing batch with ".Dumper($args)."\n");
  $kernel->post( $this->{"DBslave"}, 'batch',$args);
  #$result = $this->{"DBAGENT"}->batch($queries);
  #if($result->{"status"} eq "failure")
  #{
    #  die("something went wrong with PAM;createTables: ".$result->{"values"}."\n");
    #}# if($result->{"status"} eq "failure")
}#sub createtable
######################################################################
=pod

=item addToGroup

check the presence and eventually add a user to a group

=cut

######################################################################
sub addToGroup
{
  my ($this,$line,$usergroup,$userid) = @_;
  my $usertoadd = $line->{"usernick"};
  my $usernick = $line->{"usernick"};
  my $kernel =   $line->{"kernel"};
  my $network = $line->{"network"};
  $this->{"kernel"} = $line->{"kernel"};
  $this->{"context"} = $line->{"context"};

  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $actLang = $line->{"lang"};

  print("PAM::addToGroup $userid to $usergroup\n");
  $userid = lc($userid);
  my $user = $this->{"users"}->{$userid};

  if($user)
  {
    print("PAM::addToGroup $userid exists!\n");
    #$userid =  $this->{"users"}->{$userid}->{"id"},

    my $groupid = $this->{"groups"}->{$usergroup}; 
    if($groupid)
    {
      print("PAM::addToGroup $usergroup exists!\n");
      my $sql_query = 'SELECT group2user.id FROM users,groups,group2user where ';
      $sql_query .= "\"channel\"='".$line->{"channel"}."' AND ";
      $sql_query .= "\"user\"=users.id AND \"group\"=groups.id ";
      $sql_query .= "AND nick='$userid' AND groups.name='$usergroup' ";
      $sql_query .= "AND network='".$line->{"network"}."'";

      $line->{"group"} = $usergroup;
      $line->{"userid"} = $userid;
      $line->{"groupid"} = $groupid;

      $line->{"query"} = $sql_query;
      $line->{"type"} = "count";

      $line->{"session"} = $this->session();
      $line->{"event"} = "usergroupMatch";
      $this->print("pam::addToGroup posting $sql_query\n");
      $kernel->post( $this->{"DBslave"}, 'doQuery',$line);

      my $network = $line->{"network"};
      my $channel = $line->{"channel"};
      my $userRecord = $this->{"users"}->{$userid}->{"network"}->{$network};

      $userRecord->{$channel} = $usergroup if(!($userRecord->{$channel}));

      $userRecord->{$channel} .= ",$usergroup"
	if(!($userRecord->{$channel} =~ /$usergroup/));
    }# if($groupid)
    else
    {
      #$this->post( $usernick,'no such group');
    $line->{"line"} = $msgHand->getMesg("PAMGROUPUNKNOWN",$line);
    $this->post($usernick,$line);
    }#else
  }# if($this->{"users"}->{$userid})
  else
  {
    #print("register the user first.... !\n");
    $line->{"line"} = $msgHand->getMesg("PAM you have to register the user first",$line);
    $this->post($usernick,$line);
  }# else
}#sub addToGroup
######################################################################
=pod

=item addUser

add a user to the database

=cut

######################################################################
sub addUser
{
  my ($this,$splittedline) = @_;
  #my ($this,$kernel,$usernick,$username,$userhost,$passwd) = @_;
  my $kernel = $splittedline->{"kernel"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $passwd = $splittedline->{"passwd"};
  my $channel = $splittedline->{"channel"};
  my $network = $splittedline->{"network"};

  my @queries = ();
  my $lcnick = lc($usernick);
  my   $sql_query = 'INSERT INTO "users" (nick,name,host,access,passwd) VALUES';
  $sql_query .= "('$lcnick','$username','$userhost',CURRENT_DATE,'$passwd')";
  #$this->print ("### inserting new user:$sql_query");
  push(@queries,$sql_query);
  $sql_query = 'INSERT INTO group2user ("user","group",channel,network) VALUES';
  $sql_query .= "( (SELECT id from \"users\" where nick='$lcnick'),";
  $sql_query .= "  (SELECT id from \"groups\" where name='user'),";
  $sql_query .= "  '$channel','$network')";
  push(@queries,$sql_query);

  $splittedline->{"query"} = \@queries;
  $splittedline->{"type"} = "none";

  $splittedline->{"session"} = $this->session();
  $splittedline->{"event"} = "ignoreReturn";
  #$this->print("posting to ".$this->{"DBslave"}." data ".Dumper(@queries)."\n");
  $kernel->post( $this->{"DBslave"}, 'batch',$splittedline);
  #TODO send ignoreReturn event
  #$this->print "### adduser prob:".$sth->errstr if(!$sth);
}#sub addUser
######################################################################
=pod

=item delUser

scrap a user from the database

=cut

######################################################################
sub delUser
{
  my ($this,$splittedline) = @_;
  #my ($this,$kernel,$usernick,$username,$userhost,$passwd) = @_;
  $splittedline->{"username"} =~ s/^~//;
  $splittedline->{"username"} =~ s/^@//;
  $splittedline->{"username"} =~ s/^\+//;
  my $kernel = $splittedline->{"kernel"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $passwd = $splittedline->{"passwd"};
  my $channel = $splittedline->{"channel"};
  my $network = $splittedline->{"network"};

  my @queries = ();
  my $condition = "nick='".lc($usernick)."' AND name='".$username."' AND ";
  $condition   .= "host='".$userhost."'";
  my   $sql_query = 'DELETE FROM group2user WHERE "user"=';
  $sql_query .= "(SELECT id from \"users\" WHERE $condition)";
  push(@queries,$sql_query);
  $sql_query = 'DELETE FROM "users" WHERE '.$condition;
  #$this->print ("### inserting new user:$sql_query");
  push(@queries,$sql_query);

  $splittedline->{"query"} = \@queries;
  $splittedline->{"type"} = "none";

  $splittedline->{"session"} = $this->session();
  $splittedline->{"event"} = "ignoreReturn";
  #print("delUser sending batch: ".Dumper(\@queries)."\n");
  $kernel->post( $this->{"DBslave"}, 'batch',$splittedline);
}#sub delUser
######################################################################
=pod

=item dbh

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub dbh
{
  my($this,$ldbh) = @_;

  if($ldbh)
  {
    $this->{"dbh"} = $ldbh;
  }
  return $this->{"dbh"};
}# sub dbh
######################################################################
=pod

=item sysdata

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
    $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
######################################################################
=pod

=item _stop

close down this thing

=cut

######################################################################
sub _stop
{
  my ($this,$dbh_id, $errtype, $errstr, $err) = @_[OBJECT,ARG0..ARG3];
  $this->print("PAM _STOP!!!!!");
  #$this->{"DBAGENT"}->shutdown() if($this->{"DBAGENT"});
  #$_[KERNEL]->post( $this->{"DBslave"}, 'shutdown');
  $_[KERNEL]->yield('shutdown');
  #exit(0);
}#sub _stop

######################################################################
=pod

=item _start

session start, here we initalize the DBIAgent

=cut

######################################################################
sub _start
{

  my ($this,$kernel, $heap) = @_[OBJECT, KERNEL, HEAP];
  $kernel->alias_set( $this->session );

  #check the presence of the tables....
  my $query = { "query" => 'SELECT * FROM users', "type" => "count" };
  $query->{"session"} = $this->session();
  $query->{"event"} = "checkTables";
  $kernel->post( $this->{"DBslave"}, 'doQuery', $query);

  my $sql_query = 'SELECT * FROM "groups"';
  $query = { "query" => $sql_query, "type" => "hash" };


  $query->{"session"} = $this->session();
  $query->{"event"} = "fetchedGroups";
  $kernel->post( $this->{"DBslave"}, 'doQuery', $query);

}# sub _start
##############################################################################
=pod

=item join_success

we managed to join safely a channel

=cut


##############################################################################
sub join_success
{
  my ($this,$args) = @_;
  #$this->print("pam::joinsuccess if ".$this->activeForThisChan($args));
  return 0 if($this->activeForThisChan($args));

  #$this->print("JOINSUCCES!!!! starting events for DB handling !");

  my $sql_query = 'SELECT users.id as id,nick,users.name,host,passwd,';
  $sql_query   .= 'groups.name AS group,';
  $sql_query   .= 'channel,network FROM users,groups,group2user WHERE ';
  $sql_query   .= "\"channel\"=? AND \"network\"=?";
  $sql_query   .= "AND ";
  $sql_query   .= "\"user\"=users.id AND \"group\"=groups.id ";

  print("PAM fetchig users for net: ".$args->{"heap"}->{"network"}."\n");
  #$this->print("JOINSUCCES!!!! casting events for DB handling !");

  $args->{"values"} = [$args->{"channel"},$args->{"heap"}->{"network"}];
  $args->{"query"} = $sql_query;
  $args->{"type"} = "hash";

  $args->{"session"} = $this->session();
  $args->{"event"} = "fetchedUsers";
  $args->{"kernel"}->post( $this->{"DBslave"}, 'doQuery',$args);
  return 0;
}#sub join_success
##############################################################################
=pod

=item make_queries

build up all the queries we will need in this script...

=cut

##############################################################################
# sub make_queries
# {
#   my ($this,$args) = @_;
#   my %queries = ();
#   my $sql_query;
#
#   #-------------------------------------------
#   $sql_query = 'CREATE TABLE "users" ( "id" SERIAL PRIMARY KEY, "nick" text,';
#   $sql_query .= '"name" text, "host" text, "passwd" text, "access" timestamp,';
#   $sql_query .= '"logged" boolean,"auth" boolean)';
#   $queries{"createusers"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'CREATE TABLE "groups" ( "id" SERIAL PRIMARY KEY, ';
#   $sql_query .= '"name" text UNIQUE)';
#   $queries{"creategroups"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'CREATE TABLE "group2user" ( "id" SERIAL PRIMARY KEY, ';
#   $sql_query .= '"user" int4,"group" int4,"channel" text, "network" text, ';
#   $sql_query .= 'CONSTRAINT acct1 FOREIGN KEY ("user") REFERENCES "users" (id),';
#   $sql_query .= 'CONSTRAINT acct2 FOREIGN KEY ("group") REFERENCES "groups" (id))';
#   $queries{"createlinks"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = "DELETE FROM group2user where \"user\"=?";
#   $sql_query .= " AND \"group\"=?";
#   $queries{"deletefromgroup"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'INSERT INTO "groups" ( "name") VALUES (';
#   $sql_query .= "?)";
#   $queries{"addgroup"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'INSERT INTO group2user ("user","group",channel) VALUES (';
#   $sql_query .= "?,?,?)";
#   $queries{"addlink"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'INSERT INTO "users" (nick,name,host,access,passwd) VALUES';
#   $sql_query .= "(?,?,?,CURRENT_DATE,?)";
#   $queries{"adduser"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT nick,groups.name AS group,users.name,passwd,channel,host ';
#   $sql_query .= 'FROM users,groups,group2user WHERE ';
#   $sql_query .= "\"channel\"=? ";
#   $sql_query .= "AND ";
#   $sql_query .= "\"user\"=users.id AND \"group\"=groups.id ";
#   $queries{"fetchchannel"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT id FROM users where ';
#   $sql_query .= "nick=? AND name=? AND host=?";
#   $sql_query .= "AND passwd=?";
#   $queries{"getuserid"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT nick,users.name,host FROM "users","groups","group2user" where ';
#   $sql_query .= "\"channel\"=? AND ";
#   $sql_query .= "\"user\"=users.id AND \"group\"=groups.id AND ";
#   $sql_query .= "groups.name=?)";
#   $queries{"fetchchannelgroup"} = $sql_query;
#   #-------------------------------------------
#
#   $sql_query = 'SELECT nick,users.name,host FROM "users","group2user" where ';
#   $sql_query .= "\"channel\"=? AND ";
#   $sql_query .= "\"user\"=users.id";
#   $queries{"fetchchanneluser"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT DISTINCT nick,users.name,host,groups.name AS gname FROM "users","groups","group2user" where ';
#   $sql_query .= "\"user\"=users.id AND \"group\"=groups.id ";
#   $queries{"fetchusers"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT * FROM "groups"';
#   $queries{"getgroups"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = "SELECT id FROM users where nick=?";
#   $queries{"getuserbynick"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT id FROM groups where ';
#   $sql_query .= "name=?";
#   $queries{"getgroupids"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT id FROM users where ';
#   $sql_query .= "nick=?";
#   $queries{"getuseridbynick"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT group2user.id FROM users,groups,group2user where ';
#   $sql_query .= "\"channel\"=? AND ";
#   $sql_query .= "user=users.id AND \"group\"=groups.id ";
#   $sql_query .= "AND nick=? AND groups.name=?";
#   $queries{"getlinkid"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'SELECT nick,groups.name AS group,users.name,passwd,channel,host ';
#   $sql_query .= 'FROM users,groups,group2user WHERE ';
#   $sql_query .= "\"channel\"=? ";
#   $sql_query .= "AND \"user\"=users.id AND \"group\"=groups.id ";
#   $sql_query .= "AND \"network\"=?";
#   $queries{"fetchuserbychannel"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = 'UPDATE "users" SET logged=\'f\'';
#   $queries{"unlogged"} = $sql_query;
#   #-------------------------------------------
#   $sql_query = "UPDATE users SET passwd=? WHERE id=?";
#   $queries{"setpasswd"} = $sql_query;
#   #-------------------------------------------
#
#
#       return \%queries;
# }#sub make_queries
######################################################################
=pod

=item passChanged

create the tables to hold the data

=cut

######################################################################
sub passChanged
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $usernick = $result->{"nick"};

  if($result->{"status"} eq "failure")
  {
    $this->print("something went wrong with PAM::changepass ".$result->{"values"}."\n");
    $result->{"line"} = $msgHand->getMesg("PAM failed to change the passwd in the database",$result);
    $this->post($usernick,$result);
  return;
  }# if($result->{"status"} eq "failure")
    $result->{"line"} = $msgHand->getMesg("PAMNEWPASSOK",$result);
    $this->post($usernick,$result);
  $this->{"users"}->{lc($usernick)}->{"passwd"} = $result->{"newpass"};
  $this->debug("change pass ok");
}#sub passChanged
######################################################################
=pod

=item groupsDisplayed

create the tables to hold the data

=cut

######################################################################
sub groupsDisplayed
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $usernick = $result->{"usernick"};

  if($result->{"status"} eq "failure")
  {
    $result->{"line"} = $msgHand->getMesg("PAM database error for display groups",$result);
    $this->post($usernick,$result);
    return;
  }# if($result->{"status"} eq "failure")
  $result->{"values"} = [] if(!($result->{"values"}));
  my $numentries =  scalar(@{$result->{"values"}});
  if($numentries)
  {
    #$this->post( $usernick,'List of available groups');
    print("posting to $usernick ".$msgHand->getMesg("PAMLISTGROUPS",$result)." altnick:".$result->{"usernick"}."\n");
    $result->{"line"} = $msgHand->getMesg("PAMLISTGROUPS",$result)."\n";
    $result->{"line"} .= 'num='.$numentries."\n";
    $result->{"line"} .= $msgHand->getMesg("PAMLISTGROUPSHEAD",$result);
    # Read the matching records and$this->print them out          
    foreach my $data (@{$result->{"values"}})
    {
    $result->{"line"} .= $data->{"id"}." ".$data->{"name"}."\n";
    }
    $this->post($usernick,$result);
  }#if( $sth->rows != 0)
  else
  {
    print("posting to $usernick no entries in the DB response... \n");
    $result->{"line"} = $msgHand->getMesg("PAM no groups to display",$result);
    $this->post($usernick,$result);
  }
    $result->{"line"} = $msgHand->getMesg("PAMLISTGROUPOK",$result);
    $this->post($usernick,$result);
}#sub groupsDisplayed
######################################################################
=pod

=item privilegeRemoved

create the tables to hold the data

=cut

######################################################################
sub privilegeRemoved
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  if($result->{"status"} eq "failure")
  {
    $this->print("something went wrong with PAM::removeUserFromGroup ".$result->{"values"}."\n");
    return 1;
  }# if($result->{"status"} eq "failure")
}#sub privilegeRemoved
######################################################################
=pod

=item usergroupMatch

create the tables to hold the data

=cut

######################################################################
sub usergroupMatch
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  my $network =  $result->{"network"};
  my $channel =  $result->{"channel"};
  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $usernick = $result->{"nick"};
  my $usergroup = $result->{"group"};
  my $userid = $result->{"userid"};
  my $groupid = $result->{"groupid"};

  print("PAM::usergroupMatch!\n");
  if($result->{"status"} eq "failure")
  {
    $this->print("something went wrong with PAM::addToGroup: ".$result->{"values"}."\n");
    $this->updateGroupSubscription($kernel,$result);
  }# if($result->{"status"} eq "failure")
  else
  {
    #print("Dumping the DB result: ".Dumper($result)."\n");
    my $num = shift(@{$result->{"values"}});
    $num = shift(@{$num});
    if($num >0)
    {
      print("PAM::usergroupMatch allready in group!\n");
    $result->{"line"} = $msgHand->getMesg("PAMALLREADYINGROUP",$result);
    $this->post($usernick,$result);
    }# if($num >0)
    else
    {
      $this->updateGroupSubscription($kernel,$result);
   }#else
  }# else
}#sub usergroupMatch
###########################################result###############
=pod

=item usertogroupInserted

create the tables to hold the data

=cut

######################################################################
sub usertogroupInserted
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $usernick = $result->{"nick"};

  if($result->{"status"} eq "failure")
  {
    $this->print("something went wrong with PAM::addToGroup2 ".$result->{"values"}."\n");
    $result->{"line"} = $msgHand->getMesg("PAM database error for insert user into group ",$result);
    $this->post($usernick,$result);
  return;
  }# if($result->{"status"} eq "failure")
    $result->{"line"} = $msgHand->getMesg("PAMADD2GROUPOK",$result);
    $this->post($usernick,$result);
}#sub usertogroupInserted
######################################################################
=pod

=item ignoreReturn

create the tables to hold the data

=cut

######################################################################
sub ignoreReturn
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
}#sub ignoreReturn
######################################################################
=pod

=item checkTables

create the tables to hold the data

=cut

######################################################################
sub checkTables
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";

  if($result->{"status"} eq "failure")
  {
    print("pam  checked for tables, was a failure... need to create some\n");
    $kernel->post( $this->session, 'createTables',$result);
  }# if($result->{"status"} eq "failure")
}#sub checkTables
######################################################################
=pod

=item fetchedGroups

retrieved the available groups...

=cut

######################################################################
sub fetchedGroups
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  if($result->{"status"} eq "failure")
  {
    my $msg = "something went wrong with PAM::showAllGroups ";
    $msg .= $result->{"values"} if($result->{"values"});
    $msg .= "\n";

    $this->print($msg);
  }# if($result->{"status"} eq "failure")
  else
  {
    $this->{"groups"} = {};
    foreach my $grouphash (@{$result->{"values"}})
    {
      $this->{"groups"}->{$grouphash->{"name"}} = $grouphash->{"id"}; 
    }# foreach my $grouphash (@{$result->{"values"}})
  }# else
}#sub fetchedGroups
######################################################################
=pod

=item tablesDestroyed

create the tables to hold the data

=cut

######################################################################
sub tablesDestroyed
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";

  if($result->{"status"} eq "failure")
  {
    $this->print("something went wrong with PAM::destroyTables ".$result->{"values"}."\n");
  }# if($result->{"status"} eq "failure")
}#sub tablesDestroyed
######################################################################
=pod

=item addedAgroup

create the tables to hold the data

=cut

######################################################################
sub addedAgroup
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $usernick = $result->{"nick"};

  if($result->{"status"} eq "failure")
  {
    $this->print("something went wrong with PAM::destroyTables ".$result->{"values"}."\n");
  }# if($result->{"status"} eq "failure")
  else
  {
    $result->{"line"} = $msgHand->getMesg("PAMADDGROUP",$result);
    $this->post($usernick,$result);
  }
}#sub addedAgroup
######################################################################
=pod

=item tablesCreated

create the tables to hold the data

=cut

######################################################################
sub tablesCreated
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  die("tablesCreated with return: ".Dumper($result)."\n");

  if($result->{"status"} eq "failure")
  {
    die("something went wrong with PAM::tablesCreated: ".$result->{"values"}."\n");
  }# if($result->{"status"} eq "failure")
}#sub addedAgroup
######################################################################
=pod

=item fetchedUsers

retrieved the listings of users for a given server/channel

=cut

######################################################################
sub fetchedUsers
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";

  #$this->print("fetchedUsers::pam retrieved data ".Dumper($result));

  if($result->{"status"} eq "failure")
  {
    my $msg = "DBproblem in join_success:";
    $msg .= $result->{"values"} if($result->{"values"});
    $msg .= "\n";
    $this->print($msg);
    return;
  }# if($result->{"status"} eq "failure")


  #my $listing = "Userlisting to load:\n";

  foreach my $data (@{$result->{"values"}})
  {
    #$this->print("pam retrieved data ".Dumper($data));
    my $usernick = $data->{"nick"};
    my $lcnick = lc($usernick);
    my $network = $data->{"network"};
    my $channel = $data->{"channel"};
    my $group = $data->{"group"};
    if(!($this->{"users"}->{$lcnick}))
    {
      #$this->print("new entry");

      $this->{"users"}->{$lcnick} = {
	"id" => $data->{"id"},
	"name" => $data->{"name"},
	"auth" => 0,
	"passwd" => $data->{"passwd"},
	"host" => $data->{"host"},
	"network" => {
	  $network => { $channel => $group },
	}
      };
    }# if(!($this->{"users"}->{$data->{"nick"}}))
    else
    {
      #$this->print("updating entry ".Dumper($this->{"users"}->{$data->{"nick"}}));
      if($this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel})
      {
      my $net = $this->{"users"}->{$lcnick}->{"network"}->{$network};
        $net->{$channel} .= ",$group" if(!($net->{$channel} =~ /$group/));
      }# if($net->{$channel})
      else
      {
	  $this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} = "$group";
      }
    }# else
  }# foreach $data (@{$result->{"values"}})

  #$this->print("PAM DB fetch of users complete:: ".Dumper($this->{"users"}));
}# sub fetchedUsers
#########################################################
=pod

=item updateGroupSubscription

update the database with the subscription of a user to a group

=cut

#########################################################
sub updateGroupSubscription
{
  my ($this,$kernel,$result) = @_;
  
  my $network =  $result->{"network"};
  my $channel =  $result->{"channel"};
  my $msgHand = ($this->sysdata())->module("messageHandler");
  my $usernick = $result->{"nick"};
  my $usergroup = $result->{"group"};
  my $userid = $result->{"userid"};
  my $groupid = $result->{"groupid"};

  print("PAM::usergroupMatch adding to group!\n");
    $result->{"line"} = $msgHand->getMesg("PAMADDTOGROUP",$result);
    $this->post($usernick,$result);
  my $lcnick = lc($userid);
  if($this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel})
  {
    $this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} .= ",".$usergroup;
  }# if($this->{"users"}->{$data->{"nick"}}->{"channels"})
  else
  {
    $this->{"users"}->{$lcnick}->{"network"}->{$network}->{$channel} = $usergroup;
  }#else
  print("PAM::usergroupMatch user updated to ".Dumper($this->{"users"}->{$userid})."!\n");

  my $sql_query = 'INSERT INTO group2user ("user","group",channel,network)';
  $sql_query .= ' VALUES (';
  if($this->{"users"}->{$lcnick}->{"id"})
  {
    $sql_query .= "'".$this->{"users"}->{$lcnick}->{"id"}."',";
  }# if($this->{"users"}->{$lcnick}->{"id"})
  else
  {
    $sql_query .= "(SELECT id FROM \"users\" WHERE nick='$lcnick'),";
  }# else
  $sql_query .= "'$groupid','$channel','$network')";

  $this->print("PAM::updateGroupSubscription  issuing : $sql_query\n");
  $result->{"query"} = $sql_query;
  $result->{"type"} = "count";

  $result->{"session"} = $this->session();
  $result->{"event"} = "usertogroupInserted";
  $kernel->post( $this->{"DBslave"}, 'doQuery',$result);

  return;
}#end updateGroupSubscription
######################################################################
=pod

=item countRegisteredUsers 

give out how many registered users there are for a given channel

=cut

######################################################################
sub countRegisteredUsers 
{
  my ($this,$network,$channel) = @_;

  my $count = 0;
  foreach my $nick (keys(%{$this->{"users"}}))
  {
   my $user = $this->{"users"}->{$nick}; 
   $count++ if($user->{"network"}->{$network}->{$channel});
  }# foreach $user (keys(%{$this->{"users"}}))

  return $count;
}# sub countRegisteredUsers 
### EOC
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

