=pod

=head1 NAME

messageHandler 

=head1 DESCRIPTION

messageHandler copes with all messages that are meant to be localized, notably
the actions of the bot, e.g. the toutou mode. New mechanism taking xml
formalism to save and load the reactions. 2 hashes are set up to be able to
fetch a command from a token, and a token from a trigger...

The ressource files are fetched from configpath/ressources/* if the given
ressource name doesn't begin with a /

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  messageHandler is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################

package zebot::messageHandler;
use strict;
use zebot::baseactor;
use zebot::emoteparser;
#use ObjectTemplate;
use POSIX qw(strftime);

use Data::Dumper;

use POE::Session;

our @ISA = ("zebot::baseactor");

zebot::baseactor::_define_constructor("zebot::messageHandler");

######################################################################
=pod

=item init

Initiaize, means set up this module

=cut

######################################################################
sub init
{
  my @securedargs = @_;
  my ($this, $botref) = @_;
  $this->SUPER::init($botref);
  $this->sysdata($botref);
  $this->setting("xmlreactionsfile","res_emotes.xml") if(!($this->setting("xmlreactionsfile"))); 
  $this->setting("xmlmessagesfile","res_messages.xml") if(!($this->setting("xmlmessagesfile"))); 


  #$this->print "load reactions: ".$this->setting("xmlreactionsfile")."\n";

  my $path = $this->setting("xmlreactionsfile"); 
  if(!($path =~ /^\//))
  {
    $path = $this->setting("configpath")."ressources/$path"; 
  }# if(!($root =~ /^\//))
  $this->load($path); 
  #$this->print "load msges ".$this->setting("xmlmessagesfile")."\n";
  $path = $this->setting("xmlmessagesfile"); 
  if(!($path =~ /^\//))
  {
    $path = $this->setting("configpath")."ressources/$path"; 
  }# if(!($root =~ /^\//))
  $this->load($path);
  #$this->print("loaded reactions and messages:".Dumper(keys(%{$this->{"tags"}})));
}#sub init

######################################################################
=pod

=item help

issue the help for this module

=cut

######################################################################
sub help
{
  my ($this, $splittedline) = @_;
  
  my $botref = $this->sysdata();
  my $botname = $splittedline->{"heap"}->{"nick"};
  my $rest = $splittedline->{"line"};
  my $channel = $splittedline->{"channel"};
  #$this->print "m6: search for $usernick\n";
  #$this->print "ref = '$splittedline'\n";
  #my $usernick = $splittedline->{"usernick"};
  #my $username = $splittedline->{"username"};
  #my $userhost = $splittedline->{"userhost"};
  #my $kernel = $splittedline->{"kernel"};

  #$this->print("trying to fetch lang $actLang from chan $channel\n");
  #$actLang = "en" if(!$actLang);
  #my $actLang = $this->fetchChannelLang($channel);
  my $actLang = $splittedline->{"lang"};
  #$splittedline->{"lang"} = $actLang;

  my  $helpmsg = "";
  #$helpmsg = "XML-reactions, general format: cmd [#chan] action target, available commands:";
  $helpmsg = $botref->getMesg("XMLHELPTITLE",$splittedline)."\n";
  #$helpmsg .= $this->dumpLangs();
  $helpmsg .= "   ".$botref->getMesg("XMLHELPINTCMD",$splittedline);
  $helpmsg .= "      addmsg addemote\n";
  $helpmsg .= "   ".$botref->getMesg("XMLHELPEMOTES",$splittedline)."\n      ";

  #$helpmsg .= "dumping help in $actLang:\n";
  my $localTokens = $this->{"langs"}->{$actLang};
  #$this->print("dumping local tokens ".Dumper($localTokens));
  foreach my $token (keys(%$localTokens))
  {
    $helpmsg .= "$token ";
  }# foreach my $token (keys($this->{"langs"}))
  return $helpmsg;
}#sub help

######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "messageHandler";
}#sub isa
######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.20 $';
}#sub isa
#########################################################
=pod

=item load

load the file with the basic reactions of the bot

=cut

#########################################################
sub load 
{
  my ($this,$line) = @_;
  $this->{"tags"} = {} if(!$this->{"tags"});
  $this->{"langs"} = {} if(!$this->{"langs"});
  my $TokTree = $this->{"tags"};
  my $LanTree = $this->{"langs"};

  my $emoteparser = new zebot::emoteparser();

  $emoteparser->init();

  $this->print("Official reactions parsing $line!! \n");
  $emoteparser->parse($line,$TokTree,$LanTree);
  #$this->print "Official reactions!! \n";
  #$this->print dumpLangs();
  #$this->print "Official end of reactions!! \n";
}# sub load
#########################################################
=pod

=item dumpLangs

make a listing of the actual loaded language ressources

=cut

#########################################################
sub dumpLangs 
{
  my ($this,$lang) = @_;
  my $i;
  my $listing = "";
  if($lang)
  {
    return $this->dumpLang($lang);
  }# if($this->{"reactions"})

    my $ressource = $this->{"langs"};
    foreach $i (keys(%$ressource))
    {
      $listing .= "Listing in $i\n";
      $listing .= $this->dumpLang($i);
      $listing .= "\n";
    }# foreach $i (keys(%theActions))
  return $listing;
}# sub dump 
#########################################################
=pod

=item dumpLang

dumps the ressources for 1 language

=cut

#########################################################
sub dumpLang 
{
  my ($this,$lang) = @_;
  my $i;
  my $listing = "";
  if($this->{"langs"}->{$lang})
  {
    my $langRes = $this->{"langs"}->{$lang};
    $listing = Dumper($this->{"langs"}->{$lang});
  }# if($this->{"reactions"})md
  return $listing;
}# sub dump 
#########################################################
=pod

=item dumpXml

rebuild the xml structure from the data structure n sight of saving it t a file...

2 structures hidden inside: the emotes, where the toke has a validity range, and the messages, which use the same grammar but without a validity range.

=cut

#########################################################
sub dumpXML 
{
  my ($this) = @_;
  my $i;
  my $msg = {"emotes" => "", "mesg" => ""};

  my $visited = {};

  my $ressource = $this->{"tags"};
  
  my @allkeys = sort(keys(%$ressource));
  my $allactors = ($this->sysdata())->module();
  foreach my $actor (sort(keys(%$allactors)))
  {
    my $key = uc($actor);
    my @actorKeys = grep { /^$key/ }@allkeys;
    my $listing;
    foreach my $actorkey (sort(@actorKeys))
    {
      $visited->{$actorkey}++;
      my $line = $ressource->{$actorkey};
      $listing .= $this->emoteToXml($actorkey,$line)."\n";
    }# foreach my $actorkey (sort(@actorKeys))
    $msg->{$actor} = $listing;
  }# foreach my $actor (sort(keys(%$allactors)))

  foreach $i (sort(keys(%$ressource)))
  {
    next if($visited->{$i});
    my $line = $ressource->{$i};
    my $entry = $this->emoteToXml($i,$line);
    if($line->{"active"})
    {
      $msg->{"emotes"} .= $entry;
    }# if($line->{"active"})
    else
    {
      $msg->{"mesg"} .= $entry;
    }# else
  }# foreach $i (keys(%theActions))

  foreach my $name (keys(%$msg))
  {
    if($msg->{$name})
    {
      my $finalencode = '<?xml version="1.0" encoding="ISO-8859-1" ?>';
      $finalencode .=  "\n<emotes>\n".$msg->{$name}."</emotes>";
      $msg->{$name} = $finalencode;
    }
  }# foreach my $module (keys(%$msg))

  return $msg;
}# sub dumpXML 
#########################################################
=pod

=item dumpEmote

take a lang token entry and produce some XML code for it

2 structures hidden inside: the emotes, where the toke has a validity range, and the messages, which use the same grammar but without a validity range.

=cut

#########################################################
sub dumpEmote 
{
  my ($this,$dataset) = @_;

  my $entry  = " ";
  #$this->print("dunoEmote set = ".Dumper($dataset)."\n");
  foreach my $lang (sort(keys(%$dataset)))
  {
    if($lang ne "active")
    {
      my $line = $dataset->{$lang};
      #$this->print("dunoEmote parsing  = ".Dumper($line)."\n");
      $entry .= "  <lang name=\"$lang\"";
      $entry .= " trigger=\"".$line->{"trigger"}."\"" if($line->{"trigger"});
      $entry .= ">\n";
      my $modes = $line->{"modes"};
      foreach my $mode (sort(keys(%$modes)))
      {
	if($mode ne "token")
	{
	  $entry .= "    <mode type=\"$mode\"";
	  my @types = keys(%{$modes->{$mode}});

	  foreach my $name (@types)
	  {
	    $entry .= " $name=\"".$modes->{$mode}->{$name}."\"" if($name ne "body");
	  }# foreach my $entryType (@types)
	  if($modes->{$mode}->{"body"})
	  {
	    $modes->{$mode}->{"body"} =~ s/>/\&gt;/g;
	    $modes->{$mode}->{"body"} =~ s/</\&lt;/g;
	    $modes->{$mode}->{"body"} =~ s/(\\n)/$1
/g;
	    $entry .= ">".$modes->{$mode}->{"body"}."\n</mode>\n";
	  }# if($modes->{$mode}->{"body"})
	  else
	  {
	    $entry .= "/>\n";
	  }
	}# if($mode ne "token")
      }# foreach $mode (sort(keys(%$modes)))

      $entry .= "  </lang>\n";
    }# if($lang ne "active")
  }# foreach $i (keys(%theActions))
  #$this->print ("returnin $entry\n");
  return $entry;
}# sub dumpEmote 
#########################################################
=pod

=item sysdata

getter for for the holder instance with the global data and methods

=cut

#########################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
#########################################################
=pod

=item shutdown

closing operations, saving emotes!

=cut

#########################################################
sub shutdown
{
  my $this = shift;
  $this->save();
}#sub shutdown
#########################################################
=pod

=item save 

save the datastructures if needed, preparation of a shutdown, or a saveguard point...

=cut

#########################################################
sub save 
{
  my ($this) = @_;
  my $datapack = $this->dumpXML();
  my %nameToFile = ();
  my $root = $this->setting("configpath")."ressources/"; 

  foreach my $name (keys(%$datapack))
  {
    if($name eq "emotes")
    {
      $nameToFile{$name} = $root.$this->setting("xmlreactionsfile");
    }# if($name eq "emotes")
    elsif($name eq "mesg")
    {
      $nameToFile{$name} = $root.$this->setting("xmlmessagesfile");
    }# elsif($name eq "mesg")
    else
    {
      my $filename = $this->sysdata()->module($name)->setting("messages");
      $filename = "res_$name.xml" if(!$filename);
      $nameToFile{$name} = $root.$filename;
    }# else
  }# foreach my $name (keys(%$datapack))
  
  #$this->print("messageHandler::shutdown saving the stuff: $datapack\n");
  #$this->post( $usernick,"messageHandler::shutdown saving the stuff: $datapack\n");
  #$this->print("messageHandler::shutdown saving emotes to : ".$this->setting("xmlreactionsfile")."\n");

  foreach my $name (keys(%nameToFile))
  {
    #$this->post( $usernick,"messageHandler::shutdown saving text ressources for $name  to : ".$nameToFile->{$name});
    if($datapack->{$name})
    {
      $this->saveToFile($nameToFile{$name},$datapack->{$name});
    }
  }
  return 0;
}# sub save
#########################################################
=pod

=item getMesg

return for the given token a translation into a localized string
 this method takes the arguments in the following order:  
     token to be translated,
     language (defautet to an existing lang),
     the mode of the actual message (defaultet to 'default'
     a default string in case the token couldn't be found (default lower case toekn)

=cut

#########################################################
sub getMesg
{
  #my($this,$token,$lang,$mode,$default) = @_;
  my($this,$token,$line) = @_;
  if(ref($line) eq 'ARRAY' )
  {
   print("messageHandler cant handle ".Dumper($line)."\n");
   return $line;
  }# if(ref($line) eq 'ARRAY' )
  my $lang = $line->{"lang"};
  my $mode = $line->{"mode"};
  my $default = $line->{"default"};


  $mode = "default" if(!$mode);
  #print("printing $token with $mode\n");
  #$this->print("getMesg lag bef : $lang\n");
  $lang = $this->setting("language") if(!$lang || $lang eq '');
  #$this->print("getMesg lag aft : $lang\n");
  $default = lc($token) if(!$default);
  $lang = lc($lang);
  $token = uc($token);
  my $tokList = $this->{"tags"};

  #$this->print("MESSAGEhANDLER::GETmSG entering $token,$lang,$mode,$default\n");
  my $actToken = $tokList->{$token};
  if(!$actToken)
  {
   #$this->print("messageHandler::getMsg nothing known about $token\n");
   #$this->print("messageHandler::getMsg known tokens: ".keys(%{$tokList})."\n");
    #add an empty token to remind that it needs to be filled...
    my %subargs = (
    "lang"	=>	$lang,
    "token"	=>	$token,
    "mode"	=>	"default",
    "msg"	=>	uc($token)
	);
    #$this->print("unkown token trying to add it:".Dumper(\%subargs)."\n");
    $this->addEmote(\%subargs);
    return $default;
  }# if(!($tokList->{uc($token)}))


  if(!$lang || !($actToken->{$lang}))
  {
   $this->print("messageHandler::getMsg unknown language: $lang\n");
    #$lang = shift(split(/ /,sort(keys(%$actToken))));
    my @availLanguages = sort(keys(%$actToken));
    $lang = shift(@availLanguages);
    #$this->print("messageHandler::getMsg switching to language: $lang\n");
  }# if(!$lang)
  my $actEntry = $actToken->{$lang}->{"modes"};

  #$this->print("MESSAGEhANDLER::GETmSG dumping record ".Dumper($actEntry)."\n");
  #$this->print("MESSAGEhANDLER::GETmSG returning ".$actEntry->{$mode}->{"reply"}."\n");
  my $toReturn = $default;
  if($actEntry->{$mode}->{"reply"} || $actEntry->{$mode}->{"body"})
  {
    $toReturn = $actEntry->{$mode}->{"reply"} if($actEntry->{$mode}->{"reply"}); 
    $toReturn .= "\n".$actEntry->{$mode}->{"body"} if($actEntry->{$mode}->{"body"}); 
    #$this->print("success resolving $token in $lang mode \[$mode\] to ".$actEntry->{$mode}->{"reply"}."\n");
  }
  else
  {
    $mode = "default" if(!($mode =~ /default/i));
    if($actEntry->{$mode}->{"reply"} || $actEntry->{$mode}->{"body"})
    {
    $toReturn = $actEntry->{$mode}->{"reply"} if($actEntry->{$mode}->{"reply"}); 
    $toReturn .= $actEntry->{$mode}->{"body"} if($actEntry->{$mode}->{"body"}); 
      #$this->print("success resolving $token in $lang mode \[$mode\] to ".$actEntry->{$mode}->{"reply"}."\n");
    }
    else
    {
      #$this->print("problem resolving $token in $lang mode \[$mode\] entry: ".Dumper($actEntry)."\n");
      $this->print("problem resolving $token in $lang mode \[$mode\] \n");

    }# else
  }# else
  $toReturn = "" if($toReturn eq 'NONE');
  
  $toReturn = $this->completeMsg($toReturn,$line);
  #$this->print("end getMesg after correction: $toReturn\n");
  return($toReturn);
 
}# sub getMesg
#########################################################
=pod

=item getEmote

return for the given localized trigger a translation into a localized string
 this method takes the arguments in the following order:  
     trigger to be searched,
     language,
     the mode of the actual message

=cut

#########################################################
sub getEmote
{
  my($this,$subargs) = @_;
  #my($this,$trigger,$lang,$mode,$actiontype) = @_;
  my $trigger = $subargs->{"trigger"};
  my $lang = $subargs->{"lang"};
  my $mode = $subargs->{"mode"};
  my $actiontype = $subargs->{"activationtype"};

  $mode = "default" if(!$mode);
  $mode = lc($mode);
  $lang = lc($lang);
  $trigger = lc($trigger);
  my $langList = $this->{"langs"};

  #$this->print("MESSAGEhANDLER::GETmSG entering $trigger,$lang,$mode,$actiontype\n");

  my $actTriggers = $langList->{$lang};
  if(!$actTriggers)
  {
    $this->print("messageHandler::getMsg nothing known about $lang\n");
    return "";
  }# if(!($langList->{uc($trigger)}))

  my $actTrigger = $actTriggers->{$trigger};
  if(!$actTrigger)
  {
    $this->print("messageHandler::getMsg nothing known about $trigger\n");
    #$this->print("messageHandler::getMsg dumping available ones: ".Dumper($actTriggers)."\n");
    return "";
  }# if(!($langList->{uc($trigger)}))
  #$this->print("dumping act trigger: ".Dumper($actTrigger)."\n");
  my $actToken = $this->{"tags"}->{$actTrigger->{"token"}};
  #$this->print("dumping act token ".Dumper($actToken)."\n");
  if($actToken->{"active"} =~ /$actiontype|all/i )
  {
    my $actEntry = $actToken->{$lang};
    #$this->print("dumping act language ".Dumper($actEntry)."\n");

    #last check if the given mode points to something, bail out if even the default one doesn't match
    #$this->print("checking mode $mode... in entry: ".Dumper($actEntry->{"modes"})."\n");
    if(!($actEntry->{"modes"}->{$mode}))
    {
      if($mode =~ /arg$/)
      {
	if($mode =~ /^user/i)
	{
	  $mode =~ s/user/default/;
	  if(!($actEntry->{"modes"}->{$mode}))
	  {
	      $mode = "user" if($actEntry->{"modes"}->{"user"});
	      $mode = "default" if(!($actEntry->{"modes"}->{"user"}));
	  }#if(!($actEntry->{"modes"}->{$mode}))
	}# if($mode ~= /^user/i)
	else
	{
	  $mode =~ s/arg$//;
	  $mode = "default" if(!($actEntry->{"modes"}->{$mode}));
	}
      }# if($mode =~ /arg$/)
      else
      {
	$mode = "default";
      }
      return "" if(!($actEntry->{"modes"}->{$mode}));
    }# if(!($actEntry->{"modes"}->{$mode}))


    my $actEmote = $actEntry->{"modes"}->{$mode};
    my $actReply = $actEmote->{"reply"};
    $actReply .= $actEmote->{"body"} if($actEmote->{"body"}); 

    #$this->print("messageHandler::getEmote is satisfying: ".$actEmote->{"reply"}."\n");
    my $toReturn = $actEmote->{"reply"};
    $toReturn .= $actEmote->{"body"} if($actEmote->{"body"}); 

    $toReturn = $this->completeMsg($toReturn,$subargs);
    $toReturn = "" if(!$toReturn || $toReturn eq 'NONE');
    return $toReturn if($toReturn);
    #return $actEmote->{"reply"} if($actEmote->{"reply"});
    #hmmm lets check if this wasn't some action...
    if( $actEmote->{"action"})
    {
      #indeed!!
      #$this->print("returning ".$this->getMesg(uc($actEmote->{"action"}),$lang,$mode)."\n");
      $subargs->{"mode"} = $mode;
      return $this->getMesg(uc($actEmote->{"action"}),$subargs);
    }# if( $actEmote->{"action"})
    #$subargs{"lastHandler"} = $this;
  }# if($actToken->{"active"} =~ /trigger/ )

  #my $actEntry = $actTriggers->{"modes"};

  #$this->print("MESSAGEhANDLER::GETmSG dumping record ".Dumper($actEntry)."\n");
  #$this->print("MESSAGEhANDLER::GETmSG returning ".$actEntry->{$mode}->{"reply"}."\n");
  #return $actEntry->{$mode}->{"reply"} if($actEntry->{$mode}->{"reply"});

  #return $default;
  return "";
}# sub getEmote
#########################################################
=pod

=item PRIVMSGaction

This module accepts also some commands, and is thus active also for private
messages send to the bot. this way a more dynmaic handling of the mesages and
the emotes is given. since writing by hand xml code isn't at all so fun....

Thus just add the needed tokens into the code, and then give them a real text
through the bot shell

=cut

#########################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  my $botname = $splittedline->{"heap"}->{"nick"};
  #my $actLang = $this->fetchChannelLang($splittedline->{"channel"});
  my $actLang = $splittedline->{"lang"};
  $splittedline->{"lang"} = $actLang;

  #check if first arg is a channel info
  my($command, $evChan, $rest) = split(/ /,$line,3);
  if($evChan && $evChan =~ /^#/)
  {
    $splittedline->{"channel"} = $evChan;
    $line = $rest;
  }# if($evChan =~ /^#/)
  else
  {
    $line = $evChan;
    if($rest) {$line .= " ".$rest;}
  }# else
  $command = lc($command);
    my $pam = ($this->sysdata())->module("pam");
  my $accessRights = $pam->findOperator($splittedline);
  if($command =~ /addmsg/)
  {
    my ($lang, $token, $message) = split(/ /,$line,3);
    if(!$lang || !$token || !$message)
    {
      $this->post( $usernick,$this->getMesg("MSGADDMSGHELP",$splittedline));
      return 1;
    }# if(!$lang || !$token || !$message)
    if(index($accessRights,"owner") == -1)
    {
      $this->post( $usernick,$this->getMesg("MSGADDMSGONLYOWNER",$splittedline));
      return 1;
    }# if(index($accessRights,"owner") != -1)
    #$lang = lc($lang);
    #$token = uc($token);

    #$this->{"tags"}->{$token}->{$lang}->{"modes"}->{"default"}->{"reply"} = $message;
    #my $submsg = $this->getMesg("MSGADDMSGOK",$lang);
    #$submsg =~ s/%s/$lang/;
    #$submsg =~ s/%s/$token/;
    #$submsg =~ s/%s/$message/;
    #$this->post( $usernick,$submsg);
    #my $mode = "default";
    #my %subargs = (
    $splittedline->{"usernick"} = $usernick;
    $splittedline->{"lang"} = $lang;
    $splittedline->{"token"} = $token;
    $splittedline->{"mode"} = "default";
    $splittedline->{"msg"} = $message;
    #	);
    #$this->addEmote($usernick,$lang,$token,"",$mode,$message);
    #$this->addEmote(\%subargs);
    $this->addEmote($splittedline);
    return 1;
  }# if($command =~ /addmsg/)
  elsif($command =~ /addemote/)
  {
    my ($lang, $token, $trigger, $activation, $mode,$message) = split(/ /,$line,6);
   $this->print("addemote!!!\n");
    if(!$lang || !$token || !$mode || !$message || !$activation || !$trigger)
    {
      $this->post( $usernick,$this->getMesg("MSGADDEMOTEHELP",$splittedline));
   $this->print("addemote not enough args!!!\n");
      return 1;
    }# if(!$lang || !$token || !$message)
    if(index($accessRights,"owner") == -1)
    {
      $this->post( $usernick,$this->getMesg("MSGADDMSGONLYOWNER",$splittedline));
   $this->print("not owner!!!\n");
      return 1;
    }# if(index($accessRights,"owner") != -1)
   $this->print("calling addemote with $usernick,$lang,$token,$trigger,$activation,$mode,$message!!!\n");
    $splittedline->{"usernick"} = $usernick;
    $splittedline->{"lang"} = $lang;
    $splittedline->{"token"} = $token;
    $splittedline->{"active"} = $activation;
    $splittedline->{"mode"} = "default";
    $splittedline->{"msg"} = $message;
    $splittedline->{"trigger"} = $trigger;
    #my %subargs = (
    #"usernick"	=> 	$usernick,
    #"lang"	=>	$lang,
    #"token"	=>	$token,
    #"active"	=>	$activation,
    #"mode"	=>	$mode,
    #"trigger"	=>	$trigger,
    #"msg"	=>	$message
    #);
    #$this->addEmote($usernick,$lang,$token,"",$mode,$message);
    #$this->addEmote(\%subargs);
    $this->addEmote($splittedline);
    #$this->addEmote($usernick,$lang,$token,$activation,$mode,$message);
    return 1;
  }# elsif($command =~ /addemote/)
  return 0;
}#sub PRIVMSGaction
#########################################################
=pod

=item fetchChannelLang

small function that retrieves the language of a channel

=cut

#########################################################
sub fetchChannelLang
{
  my($this,$channel) = @_;
  my $actLang = ($this->sysdata())->language($channel);
  $actLang = $this->setting("language") if(!$actLang);
  #$this->print("returning $actLang\n");
  return $actLang;
}#sub fetchChannelLang
#########################################################
=pod

=item addEmote

small function that retrieves the language of a channel

=cut

#########################################################
sub addEmote
{
  #my($this,$usernick,$lang,$token,$activation,$mode,$message) = @_;
  my($this,$subargs) = @_;
   #my %subargs = (
   #"usernick"	=> 	$usernick,
   #"lang"	=>	$lang,
   #"token"	=>	$token,
   #"active"	=>	$activation,
   #"mode"	=>	$mode,
   #"trigger"	=>	$trigger,
   #"msg"	=>	$message
#	);

  my $lang = lc($subargs->{"lang"});
  my $token = uc($subargs->{"token"});
  my $mode = lc($subargs->{"mode"});
  my $trigger = lc($subargs->{"trigger"});
  my $type  = "reply";
  my $message = $subargs->{"msg"};
  my $activation = $subargs->{"activation"};

  $this->{"tags"}->{$token}->{"active"} = $activation if($activation);
  if($message =~ /^action/)
  {
    $type  = "action";
    $message =~ s/^action\s+//;
  }# if($message =~ /^action/)
  $this->{"tags"}->{$token}->{$lang}->{"trigger"} = $trigger if($trigger);
  $this->{"tags"}->{$token}->{$lang}->{"modes"}->{$mode}->{$type} = $message;
  my $submsg = $this->getMesg("MSGADDEMOTEOK",$subargs);
  $submsg =~ s/%s/$lang/;
  $submsg =~ s/%s/$token/;
  $submsg =~ s/%s/$mode/;
  $submsg =~ s/%s/$message/;
  $this->post( $subargs->{"usernick"},$submsg) if($subargs->{"usernick"});
 #$this->print("addEmote:".Dumper( $this->{"tags"}->{$token})."\n");

  return 1;
}#sub addEmote
#########################################################
=pod

=item listTriggers

fetch the triggers in a given language for a given activation type

=cut

#########################################################
sub listTriggers 
{
  my ($this,$lang,$type) = @_;

  my $result = "";

    my $ressource = $this->{"tags"};
    #$this->print("listTriggers dumping whole tree:".Dumper($ressource)."\n");
    my @jobStack = grep( ($ressource->{$_}->{"active"} && $ressource->{$_}->{"active"} =~ /$type|all/), keys(%$ressource));
    #$this->print("listTriggers dumping only actives:".Dumper(\@jobStack)."\n");
   foreach my $i (sort(@jobStack))
   {
     if($i)
     {
     my $line = $ressource->{$i}->{$lang};
      #$this->print("listTriggers dumping one usable triggerentry:".Dumper($line)."\n");
     $result .= " ".$line->{"trigger"} if($line->{"trigger"});
     }# if($i)
   }# foreach $i (keys(%theActions))
  return $result;
}# sub listTriggers 
#########################################################
=pod

=item completeMsg

The message returned by getMesg or getEmote might contain some tags that need to be exchanged against the real data, the data hash is submitted through reference.

the stuff to be replaced is generally speaking taken from the html entities, since the & is a special perl char, it was replaced with standard +. otherwise... i  implemented only the signs i might use, thus if you need other ones feel free to extend this list...

  %sender	$data->{"usernick"}/g;
  %realname	$data->{"username"}/g;
  %host		$data->{"userhost"}/g;
  %target	$data->{"target"}/g;
  %channel	$data->{"channel"}/g;
  %rest		$data->{"line"}/g;
  %C		 #mirc style color codes
  +copy;	
  +reg;		
  +Auml;	
  +Ouml;	
  +Uuml;	
  +auml;	
  +ouml;	
  +uuml;	
  +szlig;	
  +Egrave;	
  +Eacute;	
  +Ecirc;	
  +egrave;	
  +eacute;	
  +ecirc;	
  +Ucirc;	
  +ucirc;	
  +Ugrave;	
  +ugrave;	
  +agrave;	
  +Agrave;	
  +acirc;	
  +aelig;	
  +ccedil;	
  +iuml;	
  +Iuml;	
  +ocirc;	
  +Ocirc;	

=cut

#########################################################
sub completeMsg
{
  my ($this,$msg, $data) = @_;
  #$this->print("called complete msg with $msg\n");
  my $botname = $data->{"heap"}->{"nick"};
  $botname = "toutou" if(!$botname);


  #initialize the vars in case they aren't initialized, avoid warnings...
  $data->{"usernick"} = " " if(!($data->{"usernick"}));
  $data->{"username"} = " " if(!($data->{"username"}));
  $data->{"userhost"} = " " if(!($data->{"userhost"}));
  $data->{"target"} = " " if(!($data->{"target"}));
  $data->{"channel"} = " " if(!($data->{"channel"}));
  $data->{"line"} = " " if(!($data->{"line"}));
  return $msg if(!$msg);

  
  $msg =~ s/%sender/$data->{"usernick"}/g;
  $msg =~ s/%realname/$data->{"username"}/g;
  $msg =~ s/%host/$data->{"userhost"}/g;
  $msg =~ s/%target/$data->{"target"}/g;
  $msg =~ s/%channel/$data->{"channel"}/g;
  $msg =~ s/%rest/$data->{"line"}/g;
  $msg =~ s/%arg1/$data->{"arg1"}/g;
  $msg =~ s/%arg2/$data->{"arg2"}/g;
  $msg =~ s/%arg3/$data->{"arg3"}/g;
  $msg =~ s/%arg4/$data->{"arg4"}/g;
  $msg =~ s/%botname/$botname/g if($botname);
  $msg =~ s/%C//g; #mirc style color codes

  $msg =~ s/\\n/\n/g;
  $msg =~ s/\+copy;//g;
  $msg =~ s/\+reg;//g;
  $msg =~ s/\+Auml;//g;
  $msg =~ s/\+Ouml;//g;
  $msg =~ s/\+Uuml;//g;
  $msg =~ s/\+auml;//g;
  $msg =~ s/\+ouml;//g;
  $msg =~ s/\+uuml;//g;
  $msg =~ s/\+szlig;//g;
  $msg =~ s/\+Egrave;//g;
  $msg =~ s/\+Eacute;//g;
  $msg =~ s/\+Ecirc;//g;
  $msg =~ s/\+egrave;//g;
  $msg =~ s/\+eacute;//g;
  $msg =~ s/\+ecirc;//g;
  $msg =~ s/\+Ucirc;//g;
  $msg =~ s/\+ucirc;//g;
  $msg =~ s/\+Ugrave;//g;
  $msg =~ s/\+ugrave;//g;
  $msg =~ s/\+agrave;//g;
  $msg =~ s/\+Agrave;//g;
  $msg =~ s/\+acirc;//g;
  $msg =~ s/\+aelig;//g;
  $msg =~ s/\+ccedil;//g;
  $msg =~ s/\+iuml;//g;
  $msg =~ s/\+Iuml;//g;
  $msg =~ s/\+ocirc;//g;
  $msg =~ s/\+Ocirc;//g;
  $msg =~ s/\&lt;/</g;
  $msg =~ s/\&gt;/>/g;
  $msg =~ s/lt;/</g;
  $msg =~ s/gt;/>/g;

  #until i understand how to convert to iso-latin....
  $msg =~ s//e/g;
  $msg =~ s//e/g;
  $msg =~ s//e/g;
  $msg =~ s//a/g;
  $msg =~ s//i/g;
  $msg =~ s//c/g;

  return $msg;
}#sub completeMsg
#########################################################
=pod

=item emoteToXml

transform an emote into a valid xml string

=cut

#########################################################
sub emoteToXml
{
  my($this,$name,$line) = @_;
  my $entry  = "<emote tag=\"$name\"";
  $entry .= " active=\"".$line->{"active"}."\"" if($line->{"active"});
  $entry .= ">\n";
  $entry .= $this->dumpEmote($line);
  $entry .= "</emote>\n";

  return $entry;
}#end emoteToXml

### EOC
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

