##############################################################################
=pod

=head1 NAME

mailbox_pg

=head1 DESCRIPTION

record message to other users and serve them to them , immediately or when
they connect again, using a postgres database for the messages

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  mailbox_pg.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::mailbox_pg;
use strict;
use zebot::baseactor;
use Data::Dumper;
#use ObjectTemplate;
use POSIX qw(strftime);

our @ISA = ("zebot::baseactor");
zebot::baseactor::_define_constructor("zebot::mailbox_pg");
use zebot::DB::DBspawner;

use POE;
use POE::Session;

#####################################################################
=pod

=item init

initialize this element, notably make the connection to the database

=cut

#####################################################################
sub init
{
   my @securedargs = @_;
   my $this = shift;
   my $sysref = shift;
   my $sysrefe = $sysref;
   # $this->print("obj = $this\n");
   # $this->print("syse[botname] = ".$sysrefe{"botname"}."\n");
  $this->SUPER::init($sysref);
   $this->sysdata($sysref);

   $this->{"messages"} = {};
   $this->session("mail_db_slave");
   $this->{"db_slave"} = "DBmail";

   $this->setting("database","DBI:Pg:dbname=zebot") if(!($this->setting("database")));

   $this->{"DBAGENT"} = new zebot::DB::DBspawner($this->{"db_slave"});
  $this->{"DBAGENT"}->init($sysref,$this);

    POE::Session->create(
    object_states => 
    [ 

    $this =>
    {  
    _start		=> "_start",
    _stop		=> "_stop",
    'createTables'	=> 'createTables',
    "checkTables"	=> "checkTables",
    "checkResponse"	=> "checkResponse",
    "tablesCreated"	=> "tablesCreated",
    "shutdown"	=> "shutdown",
    }
]
                 );
}#sub init

#####################################################################
=pod

=item PRIVMSGaction

look out for commands for this module, notably the mail command

=cut

#####################################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $pam = ($this->sysdata())->module("pam");
  my $botname = $splittedline->{"heap"}->{"nick"};
  my $line = $splittedline->{"line"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};
  my $sender = $splittedline->{"usernick"}; 


  if($line =~ /\s*mail (\S+)\s+(.*)$/)
  {
    my $receiver = $1;
    my $msg = $2; 
    my $email = $splittedline->{"userhost"};

    my $now_string = strftime "%a %b %e %H:%M:%S %Y", gmtime;
    $now_string .= " : ".$msg;
    #$now_string .= " : ".$msg." by ".$sender."\n";

    $this->post( $sender,$this->sysdata()->getMesg("MAILRECORDED",$splittedline)." $now_string by $sender");


    # $this->print("m5: search for $usernick\n");
    my $msgQueue = $this->{"messages"}->{$receiver};
    if(!$msgQueue)
    {
      $this->{"messages"}->{$receiver} = [];
      $msgQueue = $this->{"messages"}->{$receiver};
    }
    push(@$msgQueue,{ "message" => $now_string, "sender" => $sender});

    my $sql_query = 'INSERT INTO mail ("receiver","message","sender") VALUES';
    $sql_query .= "('".$receiver."','".$now_string."','".$sender."');";

    $splittedline->{"query"} = $sql_query;
    $splittedline->{"type"} = "count";
    $splittedline->{"session"} = $this->session();
    $splittedline->{"event"} = "checkResponse";

    $kernel->post( $this->{"db_slave"}, 'doQuery', $splittedline);

    return 1;
  }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
  elsif($line =~ /\s*insult (\S+)\s+(.*)$/)
  {
    my $receiver = $1;
    my $msg = $2; 
    my $email = $splittedline->{"userhost"};

    my $now_string = strftime "%a %b %e %H:%M:%S %Y", gmtime;
    $now_string .= " : ".$msg;
    #$now_string .= " : ".$msg." by ".$sender."\n";


    $this->post( $sender,$this->sysdata()->getMesg("MAILRECORDED",$splittedline)." $now_string");


    # $this->print("m5: search for $usernick\n");
    my $msgQueue = $this->{"messages"}->{$receiver};
    if(!$msgQueue)
    {
      $this->{"messages"}->{$receiver} = [];
      $msgQueue = $this->{"messages"}->{$receiver};
    }
    push(@$msgQueue,{ "message" => $now_string, "sender" => "ANON"});

    my $sql_query = 'INSERT INTO mail ("receiver","message","sender") VALUES';
    $sql_query .= "('".$receiver."','".$now_string."','".$sender."');";
    $splittedline->{"query"} = $sql_query;
    $splittedline->{"type"} = "none";
    $splittedline->{"session"} = $this->session();
    $splittedline->{"event"} = "checkResponse";
    $kernel->post( $this->{"db_slave"}, 'doQuery', $splittedline);
    return 1;
  }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
  return 0;
}#sub PRIVMSGaction

#####################################################################
=pod

=item JOINaction

look out for users joining a channel and where there are messages to be delivered

=cut

#####################################################################
sub JOINaction
{
  my ($this,$sLine) = @_;
  # $this->print("mail::JOINaction entering with ".Dumper($sLine)."\n");
  return if($this->SUPER::activeForThisChan($sLine));
  # $this->print("mail::JOINaction entering functio body... \n");

  my $usernick = $sLine->{"usernick"};
  my $username = $sLine->{"username"};
  my $userhost = $sLine->{"userhost"};
  my $kernel = $sLine->{"kernel"};
  $this->{"kernel"} = $sLine->{"kernel"};
  $this->{"context"} = $sLine->{"context"};
  my $addressed = $sLine->{"addressed"};

  my $msgQueue = $this->{"messages"}->{$usernick};
  if($msgQueue)
  {
    $this->action( $usernick,$this->sysdata()->getMesg("MAILBRING",$sLine));
    foreach my $msg (@$msgQueue)
    {
      my $missive = $msg->{"message"}." ";
      if($msg->{"sender"} ne 'ANON')
      {
	$missive .= $this->sysdata()->getMesg("MAILBY",$sLine)." ";
	$missive .= $msg->{"sender"} 
      }# if($msg->{"sender"} ne 'ANON')
      $this->post( $usernick,$missive);
    }# foreach my $msg (@$msgQueue)

    delete $this->{"messages"}->{$usernick};

    my $sql_query = 'DELETE FROM mail WHERE "receiver"=?';
    $sLine->{"query"} = $sql_query;
    $sLine->{"type"} = "none";
    $sLine->{"values"} = [$usernick];
    $sLine->{"session"} = $this->session();
    $sLine->{"event"} = "checkResponse";
    $kernel->post( $this->{"db_slave"}, 'doQuery', $sLine);
  }# if($msgQueue)

  return 0;
}#sub JOINaction
#####################################################################
=pod

=item help

issue the help for this module

=cut

#####################################################################
sub help
{
   my ($this,$args) = @_;
  my $msg =  $this->sysdata()->getMesg("MAILHELP",$args);
  return $msg;
}#sub help

#####################################################################
=pod

=item isa

issue the type of this module

=cut

#####################################################################
sub isa
{
  return "mailbox_pg";
}#sub isa

#####################################################################
=pod

=item version

issue the version of this module

=cut

#####################################################################
sub version
{
  return '$Revision: 1.29 $';
}#sub isa

#####################################################################
=pod

=item shutdown

close operations, save evenutally necessary data, remove datastructeres etc.
since we have a session, this will be called through POE!

=cut

#####################################################################
sub shutdown
{
  my ($this,$args,$kernel) = @_[OBJECT,ARG0,KERNEL];
  $kernel = $args->{"kernel"} if(!$kernel);
  if($kernel)
  {
  $kernel->alias_remove( $this->session() );
  $kernel->post( $this->{"db_slave"}, 'shutdown');
  #$this->{"DBAGENT"}->shutdown();
  }# if($kernel)
  else
  {
    $this->print("coudlnt close down dbagent nor remove ".$this->isa." alias..");
  }# else
}#sub shutdown

#####################################################################
=pod

=item createTables

create in the DB the tables necessary for the functonality of this bot

=cut

#####################################################################
sub createTables
{
  my ($this,$kernel, $heap, $dbh_id) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  #my $queries = [];

  my $sql_query = 'CREATE TABLE "mail" ( "id" SERIAL PRIMARY KEY, "receiver" text,';
      $sql_query .= '"message" text, "sender" text, "date" timestamp DEFAULT CURRENT_TIMESTAMP)';
  my $query = { "query" => $sql_query, "type" => "none" };
    $query->{"session"} = $this->session();
    $query->{"event"} = "tablesCreated";
  #push(@$queries,$query);
  $kernel->post( $this->{"db_slave"}, 'doQuery', $query);

}#sub createTables
######################################################################
=pod

=item sysdata

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
######################################################################
=pod

=item PUBLICaction

a user moves, check if we have messages for him

=cut

######################################################################
sub PUBLICaction
{
  my ($this,$splittedline) = @_;
  my $pam = ($this->sysdata())->module("pam");
  return if($pam->activeForThisChan($splittedline));

  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};


  my $botname = $splittedline->{"heap"}->{"nick"};

  my $msgQueue = $this->{"messages"}->{$usernick};
  if($msgQueue)
  {
    $this->action( $usernick,$this->sysdata()->getMesg("MAILBRING",$splittedline));
    foreach my $msg (@$msgQueue)
    {
      my $missive = $msg->{"message"}." ";
      if($msg->{"sender"} ne 'ANON')
      {
	$missive .= $this->sysdata()->getMesg("MAILBY",$splittedline)." ";
	$missive .= $msg->{"sender"} 
      }# if($msg->{"sender"} ne 'ANON')
      $this->post( $usernick,$missive);
    }# foreach my $msg (@$msgQueue)

    delete $this->{"messages"}->{$usernick};

    my $sql_query = 'DELETE FROM mail WHERE "receiver"=?';
    $splittedline->{"query"} = $sql_query;
    $splittedline->{"type"} = "none";
    $splittedline->{"values"} = [$usernick];
    $splittedline->{"session"} = $this->session();
    $splittedline->{"event"} = "checkResponse";
    $kernel->post( $this->{"db_slave"}, 'doQuery', $splittedline);
  }# if($msgQueue)
  return 0;
}#sub PUBLICaction
######################################################################
=pod

=item _start

session start, here we initalize the DBIAgent

=cut

######################################################################
sub _start
{

  my ($this,$kernel, $heap) = @_[OBJECT, KERNEL, HEAP];
  $kernel->alias_set( $this->session() );

  #check the presence of the tables....
  my $query = { "query" => 'SELECT * FROM mail', "type" => "hash" };

    $query->{"session"} = $this->session();
    $query->{"event"} = "checkTables";
  $kernel->post( $this->{"db_slave"}, 'doQuery', $query);

}# sub _start
######################################################################
=pod

=item checkTables

create the tables to hold the data

=cut

######################################################################
sub checkTables
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";

  if($result->{"status"} eq "failure")
  {
    $kernel->post( $this->session(), 'createTables');
  }# if($result->{"status"} eq "failure")
  else
  {
    foreach my $data (@{$result->{"values"}})
    {
      my $receiver = $data->{"receiver"};
      my $msgQueue = $this->{"messages"}->{$receiver};
      if(!$msgQueue)
      {
	if($receiver)
	{
	$this->{"messages"}->{$receiver} = [];
	$msgQueue = $this->{"messages"}->{$receiver};
	}# if($receiver)
	else
	{
	 print("argss?? mail_pg has a problem with line ".Dumper($data)."\n");
	}# else
      }
      push(@$msgQueue,{ 
	  "message" => $data->{"message"}, 
	  "date" => $data->{"date"}, 
	  "id" => $data->{"id"}, 
	  "sender" => $data->{"sender"}, 
	  });
    }# foreach my $data (@{$result->{"values"}})
  }# else
}#sub checkTables
######################################################################
=pod

=item tablesCreated

create the tables to hold the data

=cut

######################################################################
sub tablesCreated
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";

  if($result->{"status"} eq "failure")
  {
    die("something went wrong with PAM;createTables: ".$result->{"values"}."\n");
  }# if($result->{"status"} eq "failure")
}#sub tablesCreated
######################################################################
=pod

=item checkResponse

we made a DB acces and don't mind the return as long as its not an error

=cut

######################################################################
sub checkResponse
{
  my ($this,$kernel, $heap, $result) = @_[OBJECT, KERNEL, HEAP, ARG0];
  my $errmsg = "";
  my $sender = $result->{"usernick"}; 

  if($result->{"status"} eq "failure")
  {
    $this->print("something went wrong with PAM::checkResponse ".$result->{"values"}."\n");
	$this->post( $sender,$this->sysdata()->getMesg("DBNOSTATEMENT",$result) . $result->{"values"});
  }# if($result->{"status"} eq "failure")
}#sub checkResponse
######################################################################
=pod

=item _stop

close down this thing

=cut

######################################################################
sub _stop
{
  my ($this,$dbh_id, $errtype, $errstr, $err) = @_[OBJECT,ARG0..ARG3];
  $this->print($this->isa()." _STOP!!!!!");
  #$_[KERNEL]->alias_remove( $this->session() );
  $this->{"DBAGENT"}->shutdown() if($this->{"DBAGENT"});
  #exit(0);
}#sub _stop
#########################################################
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

