##############################################################################
=pod

=head1 NAME

toutou graphical interface

=head1 DESCRIPTION

graphical irc client that connects to the zebot server

=head1 COPYRIGHT and LICENCE

Copyright (c) 2002 Bruno Boettcher

tougui.pl is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################


package zebot::gui::toutouGui;
use Gtk2;

use POE;

use Gtk2::SimpleMenu;

use zebot::gui::Channel;
use zebot::gui::Gui;
use zebot::client::Connector;

use Data::Dumper;

use constant FALSE => 0;
use constant TRUE  => 1;

my $version_adjustment = 0.0;
my $VERSION = '$Revision: 1.2 $';
$VERSION =~ s/.*(\d+\.\d+).*/$1/;
$VERSION += $version_adjustment;

#####################################################################
=pod

=item new, Constructor


The constructor of a zebot::gui::toutouGui object, initializes a number of datastructures that will be used later, creates a blessed reference

=cut

#####################################################################
sub new
{
  my ($classname, $settings) = @_;

  my $this = { };

  bless $this, $classname;

  $this->{"settings"} = $settings if ($settings);
  $this->{"subsettings"} = $settings->{"subsettings"}->{"gui"};
  $settings->{"subsettings"}->{"connector"} = $settings->{"subsettings"}->{"gui"};

  return $this;
}# sub new
#####################################################################
=pod

=item init


initialises the different parts, starts the main gui window

=cut

#####################################################################
sub init
{
  my ($this) = @_;

  my($mw);
  $mw = Gtk2::Window->new;
  $this->{"mainwindow"} = $mw;
  $mw->set_title($this->{"settings"}->{"frame_title"});

  my($vb);
  $vb= Gtk2::VBox->new(FALSE, 0);
  $mw->add($vb);
  $this->{"mainvertbox"} = $vb;


  $this->createMenues();
  my $filename = $this->{"settings"}->{"configpath"}."ressources/logo.png";
  #my(@menus) = ({ path => "/_File", type => "<Branch>" },
      #    { path => "/File/_Connect"             },
      #    { path => "/File/_Quit"                });
  #my($itemfact);
  #$itemfact = Gtk2::ItemFactory->new("Gtk2::MenuBar", "<main>", undef);
  #$itemfact->create_items(@menus);
  #$vb->pack_start($itemfact->get_widget("<main>"), FALSE, FALSE, 0);


  $this->{"notebook"} = Gtk2::Notebook->new;
  $vb->pack_start($this->{"notebook"}, TRUE, TRUE, 0);

  my $channel_info = { 
    "channel" => "status",
    "network" => "local.net",
    "callback" => $this,
  };
  $this->{"status"} = zebot::gui::Channel->new($channel_info);

  $mw->show_all;

  $this->{"status"}->{shell}->grab_focus;

  POE::Session->create( object_states => [ 

      $this =>
      {  _start	=> "_start",
      _stop	=> "_stop",
      _default	=> "_default",
      alive	=> "keepalive",
      }
  ]
    );
  #check for presence of settings
  my @profilefields = ("user", "realname", "passwd", "host", "lang");
  foreach my $field (@profilefields)
  {
    if(!($this->setting($field)))
    {
      print("field $field is missing!!\n");
      $this->getProfile(); 
    }# if
  }# foreach my $field (@profilefields)
}#sub init
#########################################################
=pod

=item _start, session initialisation

This gets executed as soon as the kernel sets up this session.

=cut

#########################################################
sub _start 
{
  my ($kernel, $session,$context) = @_[KERNEL, SESSION, SENDER];
  my ($this) = @_;

  # Uncomment this to turn on more verbose POE debugging information.
  # $session->option( trace => 1 );

  # Make an alias for our session, to keep it from getting GC'ed.
  $kernel->alias_set( $this->{"settings"}->{"frame_alias"} );

  $kernel->signal_ui_destroy($this->{"mainwindow"} );
  $kernel->delay(alive => 50);
  #just in case to hold a ref on the kernel to be able to post events
  $this->{"kernel"} = $kernel;

}# sub _start 
#########################################################
=pod

=item _stop

allow the garbage collector to remove this

=cut

#########################################################
sub _stop 
{
  my $kernel = $_[KERNEL];
  my  $context = $_[SENDER];
  my ($this) = @_;

  print "Control session stopped.\n";
  $kernel->post( $context, 'quit', 'Neenios on ice!' );
  $kernel->alias_remove( $this->{"settings"}->{"frame_alias"} );
}
#########################################################
=pod

=item _default, Default handler

for the stuff that couldn't be identifyed, or where we don't have specifyed a
handler

=cut

#########################################################
sub _default 
{
  my ($state, $event, $args,$kernel,$heap) = @_[STATE, ARG0, ARG1,KERNEL,HEAP];
  $args ||= [];
  my ($this) = @_;

  return 0;
}# sub _default 
#########################################################
=pod

=item keepalive

keep alive function to keep the whole alive

=cut

#########################################################
sub keepalive
{
  my ($state, $event, $args,$kernel,$heap) = @_[STATE, ARG0, ARG1,KERNEL,HEAP];
  $args ||= [];
  my ($this) = @_;
  $kernel->delay(alive => 50);

  return 0;
}# sub keepalive
#########################################################
=pod

=item createMenues

build up the menu structure of the GUI and attach it to the main window

=cut

#########################################################
sub createMenues
{
  my ($this) = @_;

    my @menu_tree = (
	'_File' => {
	item_type => '<Branch>',
	children => [
	'_Connect' => {
	callback => sub{ print("diverting ot connect!\n");$this->connect();},
	},
    'Quit' => {
      callback => sub{ $this->ui_quit();},
    },
    ],
	},
    '_Help' => {
      item_type => '<LastBranch>',
      children => [
	'About' => {
	  callback => sub{ $this->ui_about();},
	},
      ],
    },
    );

    my $menu = Gtk2::SimpleMenu->new ( menu_tree => \@menu_tree);

  $this->{"mainvertbox"}->pack_start($menu->{widget},0,0,0);
}# sub createMenues 
##############################################################################
=pod

=item ui_quit 

close down the GUI

=cut

##############################################################################
sub ui_quit 
{
  my($this) = @_;
  #foreach my $arg (@_)
  #{
    #  print("ui_quit arg: $arg of type ".ref($arg)."\n");
    #}# foreach my $arg (@_)
  print("normal shutdown\n");
  my $kernel = $this->{"kernel"};

  if($kernel)
  {
      $kernel->post("ircbridge", "shutdown");
    foreach my $sessionid (@{$this->{"controlledSessions"}})
    {
      $kernel->post($sessionid, "shutdown");
    }# foreach my $sessionid (@{$this->{"controlledSessions"}})
    #shutdown the local Gtk eventloop
    $kernel->post($this->{"settings"}->{"frame_alias"}, "shutdown");
  }
  else
  {
    print("no kernel defined can't call shutdown on socket\n");
  }# else
  exit(0);
}# sub ui_quit 
##############################################################################
=pod

=item ui_about 

generate an about message

=cut

##############################################################################
sub ui_about 
{
  my($this) = @_;
  my $pixbuf = undef;
  my $filename = $this->{"settings"}->{"configpath"}."ressources/logo.png";

  my $about = new Gtk2::Dialog;
  my $label = new Gtk2::Label;
  my $markup = <<"    END";

  <span weight="bold" size="large">Zebot GUI</span>
    v$VERSION

    Transform your own IRC-bot into a regular graphical IRC client

    Copyright (c) 2003 Bruno Bttcher
    bboett at adlp org, 
    ya

    END

    $markup =~ s/\n */\n/gs;
  $label->set_markup($markup);
  $label->set_justify('center');

  my $image = Gtk2::Image->new_from_file ($filename);


  $about->set_title('');
  $about->set_icon ($image->get_pixbuf);
  $about->set_border_width(8);
  $about->set_modal(TRUE);
  $about->set_resizable(FALSE);
  $about->add_buttons('gtk-ok' => 0);
  $about->vbox->set_spacing(8);
  $about->vbox->pack_start(
      $image,
      FALSE, FALSE, 0);
  $about->vbox->pack_start($label, TRUE, TRUE, 0);
  $about->show_all;
  $about->signal_connect(response => sub { $about->destroy(); });
}# sub ui_about 
#########################################################
=pod

=item connect

fire up the connector object and let it connect itself to the hopefully running
bot, otherwise retry until you get a bot connected to.

=cut

#########################################################
sub connect
{
  my ($this) = @_;
  print("connect instantiating connector\n");
  my $connector = new zebot::client::Connector("ircbridge");
  print("instantiated!\n");
  my $callbacks =
  {
    "defaultSession" => "gtkSeries",
    "defaultEvent" => "default",
    "msgevent" => "default",
  };

  print("casting init!\n");
  $connector->init($this->{"settings"}, $callbacks);
}# sub createMenues 
#########################################################
=pod

=item getProfile

User forgot to specify his userprofile in the config files
aks him to complete

=cut

#########################################################
sub getProfile
{
  my ($this) = @_;

  my %switches;

  my @profilefields = ("user", "realname", "passwd", "host", "lang");
  foreach my $field (@profilefields)
  {
    $switches{$field} = $this->setting($field);
  }# foreach my $field (@profilefields)

  my @items;
  foreach my $key (sort(keys(%switches)))
  {
    push(@items, 
	{
	text		=> $key,
	type		=> 'string',
	value		=> $switches{$key},
	}
	);
  }# foreach my $set (@lines)

  use Gtk2::FormFactory;
  my $form = Gtk2::FormFactory->new;

  $form->set_items(@items);
  $form->set_label_align('left', 'left');
  $form->generate;

  my $setDialog = new Gtk2::Dialog;

  $setDialog->set_title('GUI Profile');
  $setDialog->set_border_width(8);
  $setDialog->set_size_request(400,400);
  $setDialog->set_modal(TRUE);
  #$setDialog->set_resizable(FALSE);
  $setDialog->add_buttons('gtk-ok' => 0);
  $setDialog->vbox->set_spacing(8);
  #$setDialog->vbox->pack_start($label, TRUE, TRUE, 0);
  my $scroll_window = Gtk2::ScrolledWindow->new();
  #$setDialog->vbox->pack_start($form->get_widget, TRUE, TRUE, 0);
  $setDialog->vbox->pack_start($scroll_window, TRUE, TRUE, 0);
  $scroll_window->add_with_viewport($form->get_widget);
  $setDialog->show_all;
  $setDialog->signal_connect(response => sub { 
      $this->updateProfile($kernel,$form,$setDialog,\%switches,$connector);
      });

}#sub getProfile
##############################################################################
=pod

=item updateProfile 

Update the Settings the server proposed

=cut

##############################################################################
sub updateProfile 
{
  my($this,$kernel,$form,$setDialog,$switches,$connector) = @_;

  my @newSettings = $form->get_values();
  my @requests;
  my $changed = 0;
  foreach my $key (sort(keys(%$switches)))
  {
    my $newval = shift(@newSettings);
    if($newval)
    {
      if($newval ne $switches->{$key})
      {
	$this->setting($key,$newval);
	$changed = 1;
      }# if($newval ne $switches->{$key})
    }# if($newval ne $switches{$key})
  }# foreach my $set (@lines)
  $setDialog->destroy();
  if($changed)
  {
    my $basepath = $this->{"settings"}->{"configpath"};
    $basepath .= "config/";

    my $path = $basepath."gui.conf";

    open (SETTINGS, ">$path") || die("couldn't open $path");
    foreach $i (sort(keys(%{$this->{"subsettings"}})))
    {
      my $argl = $this->{"subsettings"}->{$i};
      print SETTINGS "$i $argl\n" if (ref(\$argl) eq "SCALAR");
    }# foreach $i (keys(%hash))
    close (SETTINGS);
  }# if($changed)
}#sub updateProfile 
#########################################################
=pod

=item setting 

setter/getter for the settings, to be able to choose any format for those
settings without disturbing the rest of the program...

=cut

#########################################################
sub setting 
{
  my ($this,$key,$value) = @_;
  if(!$value)
  {

    return $this->{"subsettings"}->{$key} if($this->{"subsettings"}->{$key});
    return $this->{"settings"}->{$key};
  }# if ($key)
  $this->{"subsettings"}->{$key} = $value;
  $this->{"settings"}->{$key} = $value;
}#setting
1
__END__


=back

=head1 THANKS

ya for creating the first version of this framework

=head1 AUTHOR

Bruno Bttcher <bboett <at> adlp <dot> org>

=head1 SEE ALSO

  zebot home page  http://www.freesoftware.fsf.org/zebot/ 
  Net::IRC, 
  RFC 1459,
  http://www.irchelp.org/, 
  http://poe.perl.org/
  http://www.cs.cmu.edu/~lenzo/perl/, 
  http://www.infobot.org/,


=cut
