##############################################################################
=pod

=head1 NAME

Commands

=head1 DESCRIPTION

Module containing the callbacks for each command sent by the client

=head1 COPYRIGHT and LICENCE

Copyright (c) 2002 Bruno Boettcher

Commands.pm is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
						

package zebot::gui::Commands;
use strict;

use zebot::gui::Server;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(%Cmd);



our %Cmd = (
		"unknown"  => \&cmd_unknown,
		"noserver" => \&cmd_noserver,
		"server"   => \&cmd_server,
		"join"     => \&cmd_join,
);

##############################################################################
=pod

=item cmd_unknown

UNKNOWN command callback

=cut

##############################################################################

sub cmd_unknown {
	my $self = shift;
	my($cmd) = @_;
	$self->insert("$cmd: Unknown command");
}

##############################################################################
=pod

=item cmd_noserver

NO SERVER callback

=cut

##############################################################################

sub cmd_noserver {
	my $self = shift;
	my($cmd) = shift || "Toutou";
	$self->insert("$cmd: No server selected");
}

##############################################################################
=pod

=item cmd_server

SERVER command callback

=cut

##############################################################################

sub cmd_server {
	my $self = shift;
	my $host = shift;
	my $port = shift || 6667;
	
	if(!$host) {
		$self->input("$1 command error: no server specified");
		return;
	}
	
	my $server = Server->new($host, $port);
	if(!$server) {
		$self->input("$1 command error: unable to connect to $host:$port ($!)");
		return;
	}
	
	my $data = "USER ident - - : realname\012\015"
		     . "NICK yaouuuu\012\015";
	$server->send($data);

	$self->{server} = $server;
}

##############################################################################
=pod

=item cmd_join

JOIN command callback

=cut

##############################################################################

sub cmd_join {
	my $self = shift;
	my($channel) = @_;

	$Cmd{noserver}->($self, "join"), return if(!$self->{server});
	$self->{server}->send("JOIN $channel\012\015");
}


1;
