##############################################################################
=pod

=head1 NAME

triggers

=head1 DESCRIPTION

parse the incoming data streams for eventual references to this bot, or executable commands and react accordingly, uses the messageHandler class

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  triggers.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::triggers;
use strict;
use zebot::baseactor;
use Data::Dumper;
#use ObjectTemplate;
use POSIX qw(strftime);

our @ISA = ("zebot::baseactor");
#attributes("dbname","table","dbh");
zebot::baseactor::_define_constructor("zebot::triggers");
#$dbh;

#####################################################################
=pod

=item init

initialize this element, notably make the connection to the database

=cut

#####################################################################
sub init
{
   my @securedargs = @_;
   my $this = shift;
   my $sysref = shift;
   my $sysrefe = $sysref;
   #$this->print "obj = $this\n";
   #$this->print "syse[botname] = ".$sysrefe{"botname"}."\n";
  $this->SUPER::init($sysref);
   $this->sysdata($sysref);
   #$this->print"mail:: connecting thanks to $dsn,$user,$passwd \n";

}#sub init
######################################################################
=pod

=item PUBLICaction

propose the predefined actions when issued as !trigger commands

=cut

######################################################################
sub PUBLICaction
{
  my ($this,$splittedline) = @_;
  my $pam = (($this->sysdata())->{"actors"})->{"pam"};
  return if($pam->activeForThisChan($splittedline));

  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};


  my $botname = $splittedline->{"heap"}->{"nick"};

  my $accessRights = $pam->findOperator($splittedline);
  #$this->print("searched rights for $usernick = $accessRights\n");

  #if($this->isOwnerOrOper())
  #{
    # $this->print "fileserver debug '$botname': has rights !\n";
    #  #$this->post( $kernel, $usernick,'user is owner or oper');
    #}#if($this->isOwnerOrOper())
  if($line =~ /^!(.*)/)
  {
    my $rest = $1;
    ##$this->post( $usernick,"trigger detected! user is: $accessRights");
    my($trigger, $target, $surplus) = split(/ /,$rest,3);
    $target = $usernick if(!$target);
    $surplus = $usernick if(!$surplus);
    my %subargs = %{$splittedline};

    $subargs{"usernick"} = $target;
    my $targetRights = $pam->findOperator(\%subargs);

    my $msgHand = ($this->sysdata())->{"actors"}->{"messageHandler"};
    #my $actLang = $msgHand->fetchChannelLang($splittedline->{"channel"});
  #$splittedline->{"lang"} = $actLang;
  my $actLang = $splittedline->{"lang"};
   #$this->print("actLang = $actLang\n" );


    my $mode = "default";
    #$this->post($splittedline->{"channel"},"sender='$accessRights', target='$targetRights' mode will be \n");
   #$this->print("sender='$accessRights', target='$targetRights' mode will be \n");
    if($accessRights && ($accessRights =~ /owner/i && !($targetRights =~ /owner/i)))
    {
      # owners don't battle !
      $mode = "owner";
      if($target =~ /$botname/i)
      {
	$target = $usernick;
      }# if($target =~ /$botname/i)
    }# if($target =~ /$botname/i)
    elsif($accessRights =~ /owner/i && $targetRights =~ /owner/i)
      {
	$mode = "owner";
	$usernick = $target;
      }# if ($targetRights =~ /owner/i)
    elsif($target =~ /$botname/i)
    {
      $mode = "self";
    }# if($target =~ /$botname/i)
    elsif ($accessRights =~ /oper/i)
    {
      if ($targetRights =~ /owner/i)
      {
	$mode = "owner";
	$usernick = $target;
      }# if ($targetRights =~ /owner/i)
    }# if($target =~ /$botname/i)
    elsif ($targetRights =~ /oper/i || $targetRights =~ /owner/i)
    {
      $mode = "teki";
    }

    %subargs = %{$splittedline};

    $subargs{"trigger"} = $trigger;
    $subargs{"lang"} = $actLang;
    $subargs{"mode"} = $mode;
    $subargs{"activationtype"} = "trigger";
    $subargs{"lastHandler"} = $this;
    $subargs{"target"} = $target;
    $subargs{"line"} = $surplus;
    #$this->print("calling getEmote with $trigger,$actLang,$mode\n");
    my $message = $msgHand->getEmote(\%subargs);

    if($message)
    {
      #$this->print("fetched message $message\n");
     # $this->print("filling with  s:$usernick, t:$target, r:$surplus\n");
      #$message =~ s/%sender/$usernick/g;
      #$message =~ s/%target/$target/g;
      #$message =~ s/%rest/$surplus/g;
      #$message =~ s/%C//g;
      $this->action($splittedline->{"channel"},$message);
    }# if($message)
    else
    {
     $this->print("trigger not identifyed: $trigger\n");
    }# else

  }# if($line =~ /^!/)
  return 0;
}#sub PUBLICaction
#########################################################
=pod

=item irc_ctcp_action

react on a CTCP action command

=cut

#########################################################
sub irc_ctcp_action
{
  my ($this,$args) = @_;
  my $channel = $args->{"channel"};
  my $pam      = (($this->sysdata())->{"actors"})->{"pam"};
  return 0 if($pam->activeForThisChan($args));

  my $line = $args->{"line"};
  my $usernick = $args->{"usernick"};
  my $kernel = $args->{"kernel"};
  $this->{"kernel"} = $args->{"kernel"};
  $this->{"context"} = $args->{"context"};


  my $botname = $args->{"heap"}->{"nick"};
  #first check if this concerns the bot...
  if($line =~ /$botname/i)
  {
    #hai!! seems we need to investigate further...
    $line =~ s/$botname//g;
    my $msgHand = ($this->sysdata())->{"actors"}->{"messageHandler"};
    #my $actLang = $msgHand->fetchChannelLang($channel);
  #$args->{"lang"} = $actLang;
  my $actLang = $args->{"lang"};
    my $trigList = $msgHand->listTriggers($actLang,"action");
    $trigList =~ s/^\s+//;
    $trigList =~ s/\s+$//;
    $trigList =~ s/\s+/ /;
    #my @triggers = split(/ /,$msgHand->listTriggers($actLang,"action"));
    my @triggers = split(/ /,$trigList);
    my %subargs = %{$args};

    $subargs{"lang"} = $actLang;
    $subargs{"activationtype"} = "action";
    $subargs{"lastHandler"} = $this;
    $subargs{"lang"} = $actLang;
    while(@triggers)
    {
      my $target = "";
      my $actTrig = shift(@triggers);
      if($line =~ /$actTrig/i)
      {
	#got one!!!
	#now we check if the bot is the target or the executioner
	if($line =~ /$botname.*?$actTrig.*?\s+(.*)/)
	{
	  #the bot is not the target, switch 
	  $target = $1;
	}# if($line =~ /$actTrig.*?$botname/)
	else
	{
# 	  the bot was targetted.....
          $target = $usernick;
	}# else
	my $accessRights = $pam->findOperator($args);
	my $mode = "default";
	if($accessRights =~ /owner/i)
	{
	  $mode = "owner";
	}# if($target =~ /$botname/i)
	elsif ($accessRights =~ /oper/i)
	{
	  $mode = "oper";
	}# if($target =~ /$botname/i)
	elsif ($accessRights =~ /teki/i)
	{
	  $mode = "teki";
	}
    $subargs{"trigger"} = $actTrig;
    $subargs{"mode"} = $mode;
       $this->print("mode  is $mode!\n");
          $line =~ s/$actTrig//g;
          $target = $line if(!$target);
    $subargs{"target"} = $target;
    #$subargs{"line"} = $surplus;
    my $message = $msgHand->getEmote(\%subargs);


	if($message)
	{
          #$line =~ s/$actTrig//g;
          #$target = $line if(!$target);
	  #$message =~ s/%sender/$usernick/g;
	  #$message =~ s/%target/$target/g;
	  #$message =~ s/%rest//g;
	  #$message =~ s/%C//g;
	  $this->action($channel,$message);
          return 1;
	}# if($message)
	last;
      }#if($line =~ /$actTrig/i)
    }# while(@triggers)
    #hmmm bot was targetted, but we have no approriated aswer.. thus:
    $subargs{"target"} = $usernick;
    $subargs{"rest"} = $usernick;
    #$subargs{"line"} = $surplus;
    my $message = $msgHand->getMesg("MORDS",\%subargs);
	  #$message =~ s/%target/$usernick/g;
	  $this->action($channel,$message);

  }# if($line =~ /$botname/i)
  return 0;
}#sub irc_ctcp_action
#####################################################################
=pod

=item PRIVMSGaction

react to messages send directly to the bot privately

=cut

#####################################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  my $pam      = (($this->sysdata())->{"actors"})->{"pam"};
  #allways active for private messages...
  #return 0 if($pam->activeForThisChan($splittedline));
  my $botname = $splittedline->{"heap"}->{"nick"};
  my $line = $splittedline->{"line"};
  my $kernel = $splittedline->{"kernel"};
  my $usernick = $splittedline->{"usernick"};

  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};


  my $accessRights = $pam->findOperator($splittedline);
  #$this->print("searched rights for $usernick = $accessRights\n");

  #if($this->isOwnerOrOper
  #{
    # $this->print "fileserver debug '$botname': has rights !\n";
    #  #$this->post( $kernel, $usernick,'user is owner or oper');
    #}#if($this->isOwnerOrOper())
  #extract an eventual channel
  $splittedline->{"channel"} = $1 if( $line =~ /^(#\S+)/);
  if( $line =~ /^\s*(\S+)\s*(#\S+)\s*(.*)$/)
  {
    $splittedline->{"channel"} = $2 ;
    $line = "$1 $3";
  }# if(/^\s*(\S+)\s*(#\S+)\s*(.*)$/)
  my $rest = $line;
  #$this->print("triggers: corrected line = $rest\n");
  my($trigger, $target, $surplus) = split(/ /,$rest,3);
  $target = $usernick if(!$target);
  $surplus = $usernick if(!$surplus);
  my %subargs = %{$splittedline};

  $subargs{"usernick"} = $target;
  my $targetRights = $pam->findOperator(\%subargs);

  my $msgHand = ($this->sysdata())->{"actors"}->{"messageHandler"};
  #my $actLang = $msgHand->fetchChannelLang($splittedline->{"channel"});
  #$splittedline->{"lang"} = $actLang;
  my $actLang = $splittedline->{"lang"};
  #$this->print("actLang = $actLang\n" );



  my $mode = "default";
  #$this->post($splittedline->{"channel"},"sender='$accessRights', target='$targetRights' mode will be \n");
  #$this->print("sender='$accessRights', target='$targetRights' mode will be \n");
  if($accessRights =~ /owner/i && !($targetRights =~ /owner/i))
  {
    # owners don't battle !
    $mode = "owner";
    if($target =~ /$botname/i)
    {
      $target = $usernick;
    }# if($target =~ /$botname/i)
  }# if($target =~ /$botname/i)
  elsif($accessRights =~ /owner/i && $targetRights =~ /owner/i)
  {
    $mode = "owner";
    $usernick = $target;
  }# if ($targetRights =~ /owner/i)
  elsif($target =~ /$botname/i)
  {
    $mode = "self";
  }# if($target =~ /$botname/i)
  elsif ($accessRights =~ /oper/i)
  {
    if ($targetRights =~ /owner/i)
    {
      $mode = "owner";
      $usernick = $target;
    }# if ($targetRights =~ /owner/i)
  }# if($target =~ /$botname/i)
  elsif ($targetRights =~ /oper/i || $targetRights =~ /owner/i)
  {
    $mode = "teki";
  }

  %subargs = %{$splittedline};

  #$this->print("triggers:privmsg: $trigger $actLang $mode $target $surplus \n");
  $subargs{"trigger"} = $trigger;
  $subargs{"lang"} = $actLang;
  $subargs{"mode"} = $mode;
  $subargs{"activationtype"} = "msg";
  $subargs{"lastHandler"} = $this;
  $subargs{"target"} = $target;
  $subargs{"line"} = $surplus;
  #$this->print("calling getEmote with $trigger,$actLang,$mode\n");
  my $message = $msgHand->getEmote(\%subargs);

  if($message)
  {
    $this->action($splittedline->{"channel"},$message);
    return 1;
  }# if($message)
  else
  {
    $this->print("trigger not identifyed: $trigger\n");
  }# else

  return 0;
}#sub PRIVMSGaction
#####################################################################
=pod

=item help

issue the help for this module

=cut

#####################################################################
sub help
{
  my ($this, $splittedline) = @_;
  
  my $botref = $this->sysdata();
  my $botname = $splittedline->{"heap"}->{"nick"};
  my $rest = $splittedline->{"line"};
  my $channel = $splittedline->{"channel"};
  my $msgHand = ($this->sysdata())->{"actors"}->{"messageHandler"};
  #my $actLang = $msgHand->fetchChannelLang($channel);
  #$splittedline->{"lang"} = $actLang;
  my $actLang = $splittedline->{"lang"};

  my  $helpmsg = "";
  $helpmsg = $botref->getMesg("TRIGGERTITLE",$splittedline)."\n";
  #$helpmsg .= $this->dumpLangs();
  $helpmsg .= "   ".$botref->getMesg("TRIGGERTRIGGER",$splittedline)."\n";
  $helpmsg .= "   ".$msgHand->listTriggers($actLang,"trigger")."\n";
  $helpmsg .= "   ".$botref->getMesg("TRIGGERACTION",$splittedline)."\n";
  $helpmsg .= "   ".$msgHand->listTriggers($actLang,"action")."\n";
  $helpmsg .= "   ".$botref->getMesg("TRIGGERCMD",$splittedline)."\n";
  $helpmsg .= "   ".$msgHand->listTriggers($actLang,"msg")."\n";

  return $helpmsg;
}#sub help

#####################################################################
=pod

=item isa

issue the type of this module

=cut

#####################################################################
sub isa
{
  return "triggers";
}#sub isa
#####################################################################
=pod

=item version

issue the version of this module

=cut

#####################################################################
sub version
{
  return '$Revision: 1.13 $';
}#sub isa
#####################################################################
=pod

=item shutdown

close operations, save evenutally necessary data, remove datastructeres etc.

=cut

#####################################################################
sub shutdown
{
   my $this = shift;
  my $owner = $this->setting("owner");
}#sub shutdown
#####################################################################
=pod

=item sysdata

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

