##############################################################################
#  operator operations of the bot
#  author Bruno BTTCHER <bboett at adlp.org>
#  Copyright (c) 2002 Bruno Boettcher
#
# zebot is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##############################################################################

#%commandhash = 
{
  "growls" => sub 
  { 
     my ($this,  $channel, $line) = @_;

     my $theactors = ($this->sysdata())->{"actors"};

     my $usernick = $line->{"usernick"};

       $this->action($channel,'growls at '.$usernick);
  },
  "help" => sub 
  { 
    my ($this,  $channel, $line) = @_;

    my $theactors = ($this->sysdata())->{"actors"};
    my $msgHand = ($this->sysdata())->{"actors"}->{"messageHandler"};
    #my $actLang = $msgHand->fetchChannelLang($channel);
    my $actLang = $line->{"lang"};

    my $usernick = $line->{"usernick"};

    my $cmdlist ="";
    my $helpMsg = 'modules help['.$actLang.']: '."\n";
    foreach my $actorname (keys(%$theactors))
    {
      my $actor = $theactors->{$actorname};
      $helpMsg .= $actor->help($line)."\n";
    }#foreach $actor ($this->sysdata()->setting("actors"))
    $helpMsg .= 'End help';

    my @helplines = split(/\n/,$helpMsg);
    #$this->post($usernick,"issuing help for $actorname: ");
    foreach $i (@helplines)
    {
      chomp $i;
      $this->post($usernick,$i);
    }# foreach $i (@helplines)
  },
  "version" => sub 
   { 
     my ($this,  $channel, $line) = @_;

     my $theactors = ($this->sysdata())->{"actors"};


     my $usernick = $line->{"usernick"};
     if(open (VSTREAM, "CHANGELOG")) 
     {
       my $line = <VSTREAM>;
       #print STREAM "fetched:$line\n";
       my $dump;
       my $versionraw =""; 
       #VersionID = "$Revision: 1.25 $";
       ($dump,$versionraw) = split( /:/,$line);
       $versionraw =~ s/\s*(\S+)\s+.*/$1/;
       $this->post($usernick,'version='.$versionraw);
       $this->post($usernick,'go to http://www.freesoftware.fsf.org/zebot/ to know more');
     }#if(open (STREAM, "CHANGELOG")) 
     else
     {
       $this->post($usernick,"couldn't open CHANGELOG file");
     }
   },
  "clientinfo" => sub 
   { 
     my ($this,  $channel, $line) = @_;

     my $theactors = ($this->sysdata())->{"actors"};

     my $usernick = $line->{"usernick"};

     if(open (VSTREAM, "CHANGELOG")) 
     {
       my $line = <VSTREAM>;
       #print STREAM "fetched:$line\n";
       my $dump;
       my $versionraw =""; 
       #VersionID = "$Revision: 1.25 $";
       ($dump,$versionraw) = split( /:/,$line);
       $versionraw =~ s/\s*(\S+)\s+.*/$1/;
       $this->post($usernick,'version='.$versionraw);
       $this->post($usernick,'go to http://www.freesoftware.fsf.org/zebot/ to know more');
     }#if(open (STREAM, "CHANGELOG")) 
     else
     {
       $this->post($usernick,"couldn't open CHANGELOG file");
     }
   },
  "userversion" => sub 
   { 
     my ($this,  $channel, $line) = @_;

     my $theactors = ($this->sysdata())->{"actors"};

     my $usernick = $line->{"usernick"};

     if(open (VSTREAM, "CHANGELOG")) 
     {
       my $line = <VSTREAM>;
       #print STREAM "fetched:$line\n";
       my $dump;
       my $versionraw =""; 
       #VersionID = "$Revision: 1.25 $";
       ($dump,$versionraw) = split( /:/,$line);
       $versionraw =~ s/\s*(\S+)\s+.*/$1/;
       $this->post($usernick,'version='.$versionraw);
       $this->post($usernick,'go to http://www.freesoftware.fsf.org/zebot/ to know more');
     }#if(open (STREAM, "CHANGELOG")) 
     else
     {
       $this->post($usernick,"couldn't open CHANGELOG file");
     }
   }
};
__END__

=head1 NAME

basic reactions reserved for the zebot irc bot

=head1 SYNOPSIS

  send a PRIVMSG to the bot with one of the triggers 

=head1 DESCRIPTION

Collection of anon subroutines to perform common actions:

=over

=item clientinfo issue the version of this bot

=item version issue the version of this bot

=item apporte let the bot 'bring' the rest of the line

=item fetch let the bot 'bring' the rest of the line

=item help issue user level help about this bot

=item growls growl at someone

=item slaps react to slapping

=item hits react to hitting

=item mords most popular command, let the bot bite someone

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

  zebot home page, http://www.freesoftware.fsf.org/zebot/ 
  Net::IRC, RFC 1459,
  http://www.irchelp.org/, 
  http://www.poe.org/
  http://www.cs.cmu.edu/~lenzo/perl/, 
  http://www.infobot.org/,


=cut

