##############################################################################
=pod

=head1 NAME

operators

=head1 DESCRIPTION

standalone operator module, op, deop etc users on a given channel
distributes access rights given a predefined user list

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  operators.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::operators;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);

our @ISA = ("zebot::baseactor");
#attributes("operators","deb");
zebot::baseactor::_define_constructor("zebot::operators");

##############################################################################
=pod

=item init

initialisation of the baseactor

=cut

##############################################################################
sub init
{
   my @securedargs = @_;
   my $this = shift;
   my $sysref = shift;
   my $sysrefe = $sysref;
   # $this->print("obj = $this\n");
   # $this->print("syse[botname] = ".$sysrefe{"botname"}."\n");
  $this->SUPER::init($sysref);
   $this->sysdata($sysref);
   my $ref = loadOperators($sysref->{"operatorfile"});
   $this->operators($ref);
   $sysref->{"actors"}->{"operators"} = $this;
}#sub init
##############################################################################
=pod

=item PRIVMSGaction

propose the commands addop, delop,dispop, saveop

=cut

##############################################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $botname = $splittedline->{"heap"}->{"nick"};
  # $this->print("debug '$botname': received $line\n");
  my $line = $splittedline->{"restLine"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  my $pam = $this->sysdata()->{"actors"}->{"pam"};
  if($line =~ /$botname\s*:\s*addop (\S+)\s+(\S+)\@(\S+)/)
  {
    my $usertoadd = $1;
    my $username = $2;
    my $newaddress = $3; 
    my $rest = $4;
    # $this->print("m1: search for $usernick\n");
    $splittedline->{"restLine"} = "$botname :adduser $usertoadd $username\@$newaddress 1";
    $pam->PRIVMSGaction($this,$splittedline);
    #$this->post($usernick,'add op ok');
    $this->post($usernick,$this->sysdata()->getMesg("OPOPOK",$splittedline));
  }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
  elsif($line =~ /$botname\s*:\s*delop (\S+)\s+(\S+)\@(\S+)/)
  {
    my $usertoadd = $1;
    my $newusername = $2;
    my $newaddress = $3; 
    my $rest = $4;
    # $this->print("m2: search for $usernick\n");
    my $list = $pam->findOperator($this,$splittedline);
    if($list)
    {
      $splittedline->{"usernick"} = $usertoadd;
      $splittedline->{"username"} = $newusername;
      $splittedline->{"userhost"} = $newaddress;

      my $list = $pam->findOperator($this,$splittedline);
      $list->{"group"} = "2";
    #$this->post($usernick,'remove op privileges');
    $this->post($usernick,$this->sysdata()->getMesg("OPRMOP",$splittedline));
      return 1;
    }#if($list ne "")
  }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
  elsif($line =~ /$botname\s*:\s*dispop/)
  {
    # $this->print("m3: search for $usernick\n");
    my $list = findOperator($this,$splittedline);
    if($list ne "")
    {
      my @helplines = split(/\n/, dumpOperators($this)); 
      foreach my $i (@helplines)
      {
        chomp $i;
        $this->post($usernick,$i);
      }# foreach $i (@helplines)
      return 1;
    }#if($list ne "")
  }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
  elsif($line =~ /$botname\s*:\s*saveop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
  {
    # $this->print("m4: search for $usernick\n");
    my $list = findOperator($this,$splittedline);
    if($list ne "")
    {
      saveOperators($this->setting("operatorfile"));
      return 1;
    }#if($list ne "")
  }#delop (\S+)\s+(\S+)\@(\S+)\s+(.*)$/)
  return 0;
}#sub PRIVMSGaction
##############################################################################
=pod

=item JOINaction

add the correct mode to a newly joining user

=cut

##############################################################################
sub JOINaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $line = $splittedline->{"restLine"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

    # $this->print("m5: search for $usernick\n");
    my $list = findOperator($this,$splittedline);
    # $this->print("m51: found $list\n");
    if($list ne "")
    {
        #$this->post($splittedline->{"channel"},'ouaf ouaf  '.$usernick );
        $this->post($splittedline->{"channel"},$this->sysdata()->getMesg("OPWELCOME",$splittedline).' '.$usernick );
        $this->mode($splittedline->{"channel"},'+o '.$usernick );
      return 0;
    }#if($list ne "")
  return 0;
}#sub JOINaction
######################################################################
=pod

=item help

issue the help for this module

=cut

######################################################################
sub help
{
  my $this = shift;
  my $splittedline = shift;
  my $botname = $splittedline->{"heap"}->{"nick"};
  # $this->print("m6: search for $usernick\n");
  # $this->print("ref = '$splittedline'\n");
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};

  $this->print("help, req by $usernick $username\@$userhost\n");
  $this->print("full-line was ".$splittedline->{"fulline"}."\n");
  my $list = findOperator($this,$splittedline);
  my $helpmsg = "Operator-help:\n";
  if($list ne "")
  {
    $helpmsg   .= "   add operator: addop nick user\@host\n";
    $helpmsg   .= "   remove operator: delop nick user\@host\n";
    $helpmsg   .= "   display operator: dispop\n";
    $helpmsg   .= "   save the operatorlist: saveop\n";
    return $helpmsg;
  }#if($list ne "")
  else 
  { 
     $helpmsg .= "user $usernick, $username\@$userhost is not ";
     $helpmsg .= "Operator, help not available!\n";
     #$helpmsg .= "result query gave: $list";
    return $helpmsg;
  }
}#sub help
##############################################################################
=pod

=item isa

issue the type of this object

=cut

##############################################################################
sub isa
{
  return "operators";
}#sub isa
##############################################################################
=pod

=item loadOperators

load the operators from a file given as argument

=cut

##############################################################################
sub loadOperators 
{
  my $sLine = shift;
  my @operators = ();
  # $this->print("opening: $sLine \n");
  open (OPERATORS, $sLine) || die("couldn't open $sLine");
  while(<OPERATORS>)
  {
    chomp( $_ );
    my $newnick;
    my $newname;
    my $newhost;
    if(/\S+:\S+:\S+.*/)
    {
      my @wholeline = split(/:/,$_);
      $newnick = shift @wholeline;
      $newname = shift @wholeline;
      $newhost = shift @wholeline;
      my $rest = shift @wholeline;
      my $i;
      foreach $i (@wholeline)
      {
        $rest .= ":".$i; 
      }#foreach $i (@wholeline);
      my $newuser = 
      { "nick" => $newnick,
        "user" => $newname,
        "host" => $newhost,
        "rest" => $rest
      };
      push  @operators,$newuser;
      # $this->print("added: $newnick is $newname\@$newhost");
      # $this->print("$rest" if($rest));
      # $this->print("\n");
    }#if(/\w+:\w+:\w+.*/)
    
  }#while(<OPERATORS>)
  close (OPERATORS);
  return  \@operators;
}# sub loadOperators 
##############################################################################
=pod

=item dumpOperators

dump a list with the operators

=cut

##############################################################################
sub dumpOperators 
{
   my ($this) = @_;
  my $i;
  my $listing = "";
  my $ref = $this->operators();

  foreach $i (@$ref)
  {
    my %operdata = %{$i};
    $listing .= $operdata{"nick"}.":".$operdata{"user"}.":";
    $listing .= $operdata{"host"};
    $listing .= ":".$operdata{"rest"} if($operdata{"rest"});
    $listing .= "\n";
  }#foreach $i (@{$sysressource ->{"operators"}})
  # $this->print("dumpOperators: list=$listing\n");
  return $listing;
}# sub dumpOperators 
##############################################################################
=pod

=item findOperators

dump the access rights of a all operators

=cut

##############################################################################
sub findOperators 
{
  my $this = shift;
  my $search = shift;
  my $i;
  my $listing = "";
  my $ref =  $this->operators();
  # $this->print("findOperators search=$search\n");
  #foreach $i (@operators)
  foreach $i (@$ref)
  {
    my %operdata = %{$i};
    if( $operdata{"nick"} =~ /^$search/)
    {
     $listing .= $operdata{"nick"}.":".$operdata{"user"}.":";
     $listing .= $operdata{"host"};
     $listing .= ":".$operdata{"rest"} if($operdata{"rest"});
     $listing .= "\n";
    }
  }#foreach $i (@{$sysressource ->{"operators"}})
  return $listing;
}
##############################################################################
=pod

=item findOperator

find the access rights of a given user

=cut

##############################################################################
sub findOperator 
{
  my $this = shift;
  my $line = shift;
  my $i;
  my $listing = "";
  my $nick = $line->{"usernick"};
  my $name = $line->{"username"};
  my $host = $line->{"userhost"};
  my $ref =  $this->operators();
  # $this->print("findOperator search=$nick\n");
  #foreach $i (@operators)
  # $this->print("findOp, req by $nick $name\@$host\n");
  # $this->print("full-line was ".$line->{"fulline"}."\n");
  foreach $i (@$ref)
  {
    my %operdata = %{$i};
    # $this->print("nick=".$operdata{"nick"}." vs $nick ");
    # $this->print("name=".$operdata{"user"}." vs $name ");
    # $this->print("host=".$operdata{"host"}." vs $host\n");
    my $recnick = $operdata{"nick"};
    my $recname = $operdata{"user"};
    my $rechost = $operdata{"host"};
    if( $nick =~ /^$recnick/ && $name  =~ /$recname/ &&
    $host  =~ /$rechost/)
    {
     $listing .= $operdata{"nick"}.":".$operdata{"user"}.":";
     $listing .= $operdata{"host"};
     $listing .= ":".$operdata{"rest"} if($operdata{"rest"});
     $listing .= "\n";
    last;
    }
  }#foreach $i (@{$sysressource ->{"operators"}})
  return $listing;
}
##############################################################################
=pod

=item deleteOperator

remove operator priviledges to a given user

=cut

##############################################################################
sub deleteOperator 
{
   my $this = shift;
  my $nick = shift;
  my $user = shift;
  my $host = shift;

  my $i;
  my $listing = "";
  my $ref =  $this->operators();
  #foreach $i (@operators)
  my @thecopy = ();
  foreach my $i (@$ref)
  {
    my %operdata = %{$i};
    if( !($operdata{"nick"} eq $nick && $operdata{"user"} eq $user && $operdata{"host"} eq $host) )
    {
      push @thecopy,$i;
    }
  }#foreach $i (@{$sysressource ->{"operators"}})
  $this->operators(\@thecopy);
}# sub deleteOperator 
##############################################################################
=pod

=item saveOperators

save the actual list of opertors

=cut

##############################################################################
sub saveOperators 
{
   my ($this,$sLine) = @_;
  open (OPERATORS, ">".$sLine) || die("couldn't open $sLine");
 print OPERATORS $this->dumpOperators();
  close (OPERATORS);
}# sub saveOperators 
##############################################################################
=pod

=item shutdown

prepare the imminent death of this module

=cut

##############################################################################
sub shutdown
{
   my $this = shift;
   $this->save(); 
}#sub shutdown
#########################################################
=pod

=item save 

save the datastructures if needed, preparation of a shutdown, or a saveguard point...

=cut

#########################################################
sub save 
{
  my ($this) = @_;
  my $owner = $this->setting("owner");
  $this->saveOperators($this->setting("operatorfile")); 
  return 0;
}# sub save
##############################################################################
=pod

=item version

issue the version of this module

=cut

##############################################################################
sub version
{
  return '\$Revision: 1.20 $';
}#sub isa
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

