##############################################################################
#  basic operations of the bot
#  author Bruno BTTCHER <bboett at adlp.org>
#  Copyright (c) 2002 Bruno Boettcher
#
# zebot is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##############################################################################

$operationshash = 
{
  "fuss" => sub 
  { 
    my ( $sysressource, $line) = @_;

    my $kernel = $line->{"kernel"};

    $kernel->post( $line->{"context"}, 'join', $line->{"channel"} );
    $kernel->post( $line->{"context"}, 'privmsg', $line->{"channel"},'arf?!');
    $dessus = 1;
  },
  "viens" => sub 
  { 
    my ( $sysressource, $line) = @_;
      $sysressource->{"running"} = 1;

    my $kernel = $line->{"kernel"};

    #if( ! $dessus ) 
    #{
      $kernel->post( $line->{"context"}, 'join', $line->{"line"} );
      $kernel->post( $line->{"context"}, 'privmsg', $line->{"line"},'arf?!');
      $dessus=1;
    #}
  },
  "assis" => sub 
  { 
    my ( $sysressource, $line) = @_;
    my $kernel = $line->{"kernel"};

    $kernel->post( $line->{"context"}, 'privmsg', $line->{"channel"},'ACTION sits ');
  },
  "showreac" => sub 
  { 
    my ( $sysressource, $line) = @_;
    my $kernel = $line->{"kernel"};


    my $usernick = $line->{"usernick"};
    my $listing = $sysressource->dumpReactions();
    #$listing =~ s/\n/"	"/g;
    my @listintable = split(/\n/,$listing);

    $kernel->post( $line->{"context"}, 'privmsg',$usernick,'start of reactions' );
    my $i;
    foreach $i (@listintable)
    {
      $kernel->post( $line->{"context"}, 'privmsg',$usernick,$i );
      sleep(1);
    }#foreach $i (@listintable)
    $kernel->post( $line->{"context"}, 'privmsg',$usernick,'end of reactions' );
  },

  "set" => sub 
  { 
    my ( $sysressource, $line) = @_;
    my $kernel = $line->{"kernel"};


    my $usernick = $line->{"usernick"};
    my $argument = $line->{"line"};
    if($argument)
    {
      $argument =~ /(\S+)\s+(.*)$/;
      my $tagname = $1; 
      my $values = $2; 
      $sysressource->setting($tagname, $values);
      my $funcname = "set".$tagname;
      #print STREAM "trying to invoke $funcname\n";
      #&{$funcname}();
      eval ("$funcname()");
      $kernel->post( $line->{"context"}, 'privmsg',$usernick,"ok" );
    }#if($argument)
    else
    {
      my $listing = $sysressource->dumpSettings();
      my @listintable = split(/\n/,$listing);
      my $i;
      foreach $i (@listintable)
      {
	$kernel->post( $line->{"context"}, 'privmsg',$usernick,$i );
	#sleep(1);
      }#foreach $i (@listintable)
    }
    #$listing =~ s/\n/"	"/g;
    $kernel->post( $line->{"context"}, 'privmsg',$usernick,'end of set' );
  },

  "pars" => sub 
  { 
    my ( $sysressource, $line) = @_;
    my $kernel = $line->{"kernel"};

    my $theactors = $sysressource->{"actors"};
    my $pam = $theactors->{"pam"};

    my $usernick = $line->{"usernick"};
    my $rest = $line->{"line"};
    print("case pars.... optional $rest\n");
    if($rest)
    {
      if($sysressource->setting("endmsg"))
      {
	$pam->action($rest,$sysressource->setting("endmsg"));
      }#if($sysressource->setting("endmsg"))
      $kernel->post( $line->{"context"}, 'part', $rest );
    }# if($rest)
    else
    {
      $sysressource->{"running"} = 0;
      #print STREAM "saving users\n";
      #saveOperators($sysressource->setting("operatorfile")); 
      if($sysressource->setting("endmsg"))
      {
	print("PARS sending endmsg:".$sysressource->setting("endmsg")." to ".$line->{"channel"}."\n");
	$pam->action($line->{"channel"},$sysressource->setting("endmsg"));
      }#if($sysressource->setting("endmsg"))

      print("PARS before saveset\n");
      $sysressource->saveSettings();
      #$sysressource->saveEmotes($sysressource->setting("emotes")); 
      print("PARS saved settings\n");

      $theactors = $sysressource->{"actors"};
      foreach $actorname (keys(%$theactors))
      {
	my $actor = $theactors->{$actorname};
	print("PARS shutting down $actorname\n");
	$actor->shutdown($line);
      }#foreach $actor ($sysressource->setting("actors"))
      print("PARS done shutting down actors\n");

      print('part'.$line->{"channel"}." killed by $usernick\n");

      $pam->quit(" killed by $usernick");
      #close($oSocket);
      #print STREAM "user asked shutdown\n";
      #close(STREAM);
      print("PARS its the end!!!!\n");
      $running = 0;
      exit;
    }# else
  },
  "save" => sub 
  { 
    my ( $sysressource, $line) = @_;
    my $kernel = $line->{"kernel"};


    my $usernick = $line->{"usernick"};
    #saveOperators($sysressource->setting("operatorfile")); 
    $sysressource->saveSettings();
    #$sysressource->saveEmotes($sysressource->setting("emotes")); 
    $theactors = $sysressource->{"actors"};
    foreach $actorname (keys(%$theactors))
    {
      my $actor = $theactors->{$actorname};
      $actor->save($line);
    }#foreach $actor ($sysressource->setting("actors"))
    $kernel->post( $line->{"context"}, 'privmsg',$usernick,'save ok');
  },
  "reload" => sub 
  { 
    my ( $botref, $line) = @_;
    my $kernel = $line->{"kernel"};


    my $usernick = $line->{"usernick"};
    print "RELOAD\n";
    #loadOperators($botref->setting("operatorfile")); 
    #$kernel->post( $line->{"context"}, 'privmsg',$usernick,"loaded OP's ok");
    #$botref->loadOperations($botref->setting("operationsfile"));
    #$kernel->post( $line->{"context"}, 'privmsg',$usernick,"loaded operations ok");
    #$botref->loadReactions($botref->setting("reactionsfile")); 
    #$kernel->post( $line->{"context"}, 'privmsg',$usernick,"loaded reactions ok");
    #$botref->loadEmotes($botref->setting("emotes")); 
    #$kernel->post( $line->{"context"}, 'privmsg',$usernick,"loaded emotes ok");
    #$kernel->post( $line->{"context"}, 'privmsg',$usernick,"shutting down modules");
    $kernel->post( 'mainframe', 'reloadActors',$line);
    #$kernel->post( 'mainframe', 'closeActors',$line);
    #$kernel->post( 'mainframe', 'loadSettings',$line);

    #$botref->loadSettings();
    #print "zebot::loadSettings\n";
    #$kernel->post( $line->{"context"}, 'privmsg',$usernick,"loaded settings ok");
    #print "posting LOADACTORS \n";
    #$kernel->post( 'mainframe', 'loadActors',$line);
    #$botref->loadActors();
    #print "load actors done \n";
    #$kernel->post( $line->{"context"}, 'privmsg',$usernick,"loaded actors ok");
    #$kernel->post( $line->{"context"}, 'privmsg',$usernick,'reload complete');
    #print "reload done \n";
  },# "reload"
  "connect" => sub 
  { 
    my ( $botref, $line) = @_;

    my $name = $line->{"line"};
    my $msg = $botref->connectServer($line->{"kernel"},$name,1);
    #fetch a baseactor that is likely to be there....
    my $pam = $botref->{"actors"}->{"pam"};
    $pam->action($line,$msg);
  },
};
__END__

=head1 NAME

operations reserved for the operators of the zebot irc bot

=head1 SYNOPSIS

  send a PRIVMSG to the bot with one of the triggers 

=head1 DESCRIPTION

Collection of anon subroutines to perform common actions:

=over

=item reload reload the settings of the bot

=item save save the actual settings of the bot

=item pars shutdown the bot

=item help ask for help about commands

=item assis lets the dog sit

=item viens ask the bot to join the channel

=item showreac issue a listing of possible reactions

=item set changes settings of the bot

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

  zebot home page, http://savannah.gnu.org/projects/zebot
  Net::IRC, RFC 1459,
  http://www.irchelp.org/, 
  http://www.poe.org/
  http://www.cs.cmu.edu/~lenzo/perl/, 
  http://www.infobot.org/,

=cut

