##############################################################################
=pod

=head1 NAME

leveHandler

=head1 DESCRIPTION

leveHandler translates the calls coming from the irc interface into calls understandable by the leverloda leech script

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  leveHandler.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################

package zebot::leveHandler;
use strict;

sub BEGIN
{
  push (@INC,$ENV{HOME}.'/.leve/lib')
  if(!( (join(' ',@INC)) =~ /$ENV{HOME}\/\.leve\/lib/));
}
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);

use Data::Dumper;

# sub POE::Kernel::ASSERT_DEFAULT () { 1 }
# sub POE::Kernel::ASSERT_PONY () { 1 }
# sub POE::Kernel::ASSERT_EVENTS () { 1 }
# sub POE::Kernel::ASSERT_STATES () { 1 }

use POE::Session;
use Leve;

our @ISA = ("zebot::baseactor");
#attributes("users","deb","active","errmsg","dbh");

our(%stack,$jobcount,%channels,$fetchingList,%channelWatch);
%stack =();
%channelWatch =();
$jobcount = 0;
%channels = ();
$fetchingList = 0;

zebot::baseactor::_define_constructor("zebot::leveHandler");

######################################################################
=pod

=item init

Initiaize, means set up this module

=cut

######################################################################
sub init
{
  my @securedargs = @_;
  my $this = shift;
  my $sysref = shift;
  my $sysrefe = $sysref;


  $this->SUPER::init($sysref);

  $this->{"stack"} = {};
  $this->{"channels"} = {};
  $this->{"jobcount"} = 0;
  $this->{"fetchingList"} = 0;


 $this->print(Leve::name()." v".Leve::version()." loaded...");
# end
  #IRC::register(Leve::name(),Leve::version(),"Leve::leve_shutdown","");
 $this->print("LEVE: ".Leve::name()." v".Leve::version()." init... ");
  #IRC::add_message_handler("NOTICE", "Leve::leve_parsenotice");
  #IRC::add_command_handler("leve", "Leve::leve_shell");

  #IRC::add_print_handler("DCC Conection Failed", "Leve::leve_confail");
  #IRC::add_print_handler("DCC Connection Failed", "Leve::leve_confail");#bboett uhm?
  #  IRC::add_print_handler("DCC RECV Failed", "Leve::leve_dccfailure");
  #IRC::add_print_handler("DCC RECV Complete", "Leve::leve_dccsuccess");
  #IRC::add_print_handler("DCC CHAT Offer", "Leve::leve_dcc_init");
  #IRC::add_print_handler("DCC SEND Offer", "Leve::leve_dcc_offer");
  ##IRC::add_print_handler("Channel Message", "Leve::leve_monitor");
  ##IRC::add_print_handler("Channel Msg Hilight", "Leve::leve_monitor");
  #IRC::add_print_handler("Channel Message", "Leve::xchatHandler::pubMsg");
  #IRC::add_print_handler("Channel Msg Hilight", "Leve::xchatHandler::pubMsg");
  #IRC::add_print_handler("Change Nick", "Leve::leve_nickchange");
  #IRC::add_print_handler("Private Message to Dialog", "Leve::leve_dcc_chat");
  #IRC::add_print_handler("Quit", "Leve::leve_check_quit");
  #IRC::add_print_handler("Notice", "Leve::leve_parsenotice");
  #IRC::add_print_handler("Channel Notice", "Leve::leve_parsenotice");

  #IRC::command("/query -debug") if(Leve::debug());
}#sub init

######################################################################
=pod

=item PRIVMSGaction

react on a message addressed directly to this script

=cut

######################################################################
sub PRIVMSGaction
{
  my ($this,$subargs) = @_;
  my $line = $subargs->{"line"};
  my $usernick = $subargs->{"usernick"};
  my $username = $subargs->{"username"};
  my $userhost = $subargs->{"userhost"};
  my $kernel = $subargs->{"kernel"};
  $this->{"kernel"} = $subargs->{"kernel"};
  $this->{"context"} = $subargs->{"context"};
  my $sysressource = $this->sysdata();

  my $botname = $subargs->{"heap"}->{"nick"};

  #$this->print "operator or not: '".$subargs->{"usernick"}."' = '".$this->setting("owner")."' in '$accessRights'\n";

  my $aline = shift(@_);
  my $nick = undef;
  ($nick, $line)=split(' ',$aline,2);
  my $data = {
        "nick"	=>	$nick,
	"line"	=>	$line,
	"channel"	=>	get_info("channel"),
	"server"	=>	get_info("server")
  };
  if(!($channelWatch{$data->{"channel"}}) || 
       $channelWatch{$data->{"channel"}} ne $data->{"server"})
  {
    $channelWatch{$data->{"channel"}} = $data->{"server"};
  }

  Leve::leve_monitor($data);
  run();
  return 1;

  if ($line=~ /\s*(\S+)\s*(.*)/ )
  {
    my $commandtag = $1;
    my $restofline = $2;
    chomp $restofline;
    $subargs->{"command"} = $commandtag;
    $subargs->{"line"} = $restofline;

    #$this->print "operator or not: '".$subargs->{"usernick"}."' = '".$this->setting("owner")."'\n";
    my $pam = ($this->sysdata())->{"actors"}->{"pam"};
    my $accessRights = $pam->findOperator($subargs);

    if($this->isOwnerOrOper($subargs))
    {
      #$this->print "operator!\n";
    }#elsif ($sGens=~/$owner/) 
  }# elsif ($restLine=~ /\s*(\S+)\s*(.*)/ )
  #     $this->print "leveHandler ".Dumper($reactions)." didn't took \n";
  #$kernel->post( $context, 'privmsg', $usernick,"waff??? ($restLine)");

  return 0;
}#sub PRIVMSGaction
######################################################################
=pod

=item help

issue the help for this module

=cut

######################################################################
sub help
{
  my ($this, $splittedline) = @_;
  
  my $botname = $splittedline->{"heap"}->{"nick"};
  #$this->print "m6: search for $usernick\n";
  #$this->print "ref = '$splittedline'\n";
  #my $usernick = $splittedline->{"usernick"};
  #my $username = $splittedline->{"username"};
  #my $userhost = $splittedline->{"userhost"};
  #my $kernel = $splittedline->{"kernel"};


  #$this->print "help, req by $usernick $username\@$userhost\n";
  #$this->print "full-line was ".$splittedline->{"fulline"}."\n";
  #$this->print "-- help FO with ".Dumper($splittedline)."\n";
  #my $pam = ($this->sysdata())->{"actors"}->{"pam"};
  #my $list = $pam->findOperator($splittedline);
  my $helpmsg = "LEVE-help!\n";
  my $pam = ($this->sysdata())->{"actors"}->{"pam"};
 my $accessRights = $pam->findOperator($splittedline);
  if($this->isOwnerOrOper($splittedline))
  {
    $helpmsg .= "\n";
    $helpmsg .= "addemote trigger response\n";
  }# if($this->isOwnerOrOper())
    $helpmsg .= "listemote\n";
  return $helpmsg;
}#sub help

######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "leveHandler";
}#sub isa
######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.11 $';
}#sub isa
######################################################################
=pod

=item get_info

retrieve some system info

=cut

######################################################################
sub get_info
{
  my ($this,$info) = @_;
  my $result = IRC::get_info(2);
  #in case of static call, only the first arg is set...
  $info = $this if(!$info);
SWITCH: {
	  if ($info =~ /channel/) { $result = IRC::get_info(2); last SWITCH; }
	  if ($info =~ /server/) { $result = IRC::get_info(3); last SWITCH; }
	  if ($info =~ /nick/) { $result = IRC::get_info(1); last SWITCH; }
	  if ($info =~ /ARGGG/) { IRC::print("called getinfo without an arg"); last SWITCH; }
	  $result = IRC::get_info($info);
	}#SWITCH
return $result
}#sub get_info
#########################################################
=pod

=item irc_kick

react on some user or the bot itself beeing kicked

=cut

#########################################################
sub irc_kick
{
  my ($self,$splittedline) = @_;

  my $usernick = $_[ARG0]; #kicker
  my ($nick,$name,$host) = ( $usernick =~ /(\S+)!(\S+)@(\S+)/);
  my @addressed = $_[ARG1];
  my $kickeduser = $_[ARG2];
  my $reason = $_[ARG3];
  my $kernel = $_[KERNEL];
  my $context = $_[SENDER];
  my $this = shift;

  my $botname = $splittedline->{"heap"}->{"nick"};

  #eventually dequeue and drop the fservers for this channel
}

######################################################################
=pod

=item dcc_list

retrieve the list of actual DCC transfers

=cut

######################################################################
sub dcc_list
{
  return IRC::dcc_list();
}#sub dcc_list
######################################################################
=pod

=item command

send a line to the server, channel

=cut

######################################################################
sub command
{
  my ($this,$cmd) = @_;
  IRC::command($cmd);
}#sub command
######################################################################
=pod

=item command_with_server

send a line to a submitted server, channel

=cut

######################################################################
sub command_with_server
{
  my ($this,$cmd,$server) = @_;
  IRC::command_with_server($cmd,$server);
}#sub command_with_server
######################################################################
=pod

=item addJob

add a command to be exectued at a given time, or following actual
possibilities

=cut

######################################################################
sub addJob
{
  my ($this,$newjob) = @_;
  #my $stack = $this->{"stack"};
  #increment time until next free slot
  my $at = $newjob->{"time"};
  while($stack{$at})
  {
    $at++;
  }
  #$stack{$at} = $fserver;
 
  $stack{$at} = $newjob;

  my $timeDiff = $at - time(); 
  
  IRC::print("XCHAT:-- added job ".$newjob->{"nick"}." in $timeDiff");
  #if( $jobcount == 0)
  #{
  #  #initialize timer
  #  $timeDiff = ($timeDiff)*1000; #time is in seconds, gtktimer in milli
  #  $timeDiff = 100 if($timeDiff <= 0);
  # $this->print("XCHAT:-- updating timer ".$fserver->{"nick"}." in $timeDiff ms\n");
  #  #IRC::add_timeout_handler($timeDiff, "Leve::xchatHandler::run");
  #}#if( $jobcount == 0)
  $jobcount++;
}#sub addJob
######################################################################
=pod

=item run
extract all queues where time is <= actual time and trigger themrun

=cut

######################################################################
sub run
{
  my ($this) = @_;
  #IRC::print("XCHAT:-- cmd queue exe!! queue=".Dumper(\%stack));
  return if(!%stack);
  my $actTime = time();
  #my $stack = $this->{"stack"};
  #TODO add a similar shorter handling for missing dir - end recognition
  my @jobStack = grep( ($_ <= $actTime), sort ({ $a <=> $b } keys(%stack)));
  if(@jobStack)
  {
    foreach my $job (@jobStack)
    {
      executeJob($stack{$job});
      delete $stack{$job};
      $jobcount-- if($jobcount >0);
    }#foreach my $job (@jobStack)
  }#if(@jobStack)
  #rescedule next job
  my @sortedStack =  sort ({ $a <=> $b } keys(%stack));
  if(@sortedStack)
  {
    my $minTime = shift @sortedStack;
    $minTime -= time();
    #$minTime *= 1000;
    #$minTime = 100 if($minTime <= 0);
    #$this->print("XCHAT:--  sceduling next job in $minTime milli\n");
    #IRC::print("XCHAT:--  next job sceduled in $minTime seconds");
    #IRC::add_timeout_handler($minTime , "Leve::xchatHandler::run");
  }#if(@sortedStack)
  else
  {
    #just in case...
    #IRC::add_timeout_handler($timeDiff, "Leve::xchatHandler::run");
    #IRC::add_timeout_handler(1000, "Leve::xchatHandler::run");
  }#
  return 0;
}#sub run
######################################################################
=pod

=item addList

add another channel to monitor by !list cmd

=cut

######################################################################
sub addList
{
  my ($this,$chanref) = @_;
  my $channels = $chanref ;
  #do we need to launch the list event loop?
  if( $fetchingList == 0)
  {
    #IRC::add_timeout_handler(0, "Leve::xchatHandler::initList");
  }#if( $fetchingList == 0)
}#sub addList
######################################################################
=pod

=item initList

start the processing of !list commands

=cut

######################################################################
sub initList
{
}#sub initList
######################################################################
# react to a message flowing through the channel
######################################################################
######################################################################
=pod

=item dumpStack

show all the jobs that are stocked n the stack and will be batched later on

=cut

######################################################################
sub dumpStack
{
  my $this = shift;
  my $aline = shift(@_);
  $aline = "serv list" if(!$aline);

  my $actime = time();
  my $msg = "";
  if(!%stack)
  {
  $this->print("stack empty");
  return;
  }#if(!%stack)
  foreach my $job (sort ({ $a <=> $b } keys(%stack)))
  {
    if($stack{$job} && (ref($stack{$job}{"server"}) eq "Leve::fserverHandler") && ($aline =~ /serv/i))
    {
    $msg .= ($job - $actime) ."s: ".$stack{$job}{"server"}{"nick"};
    $msg .= "\@".$stack{$job}{"server"}{"channel"}."\n";
    }#if(ref($stack{$job}) eq "Leve::fserverHandler")
    elsif(($stack{$job}{"type"} eq 'list')&& ( $aline =~ /list/i))
    {
    $msg .= ($job - $actime) ."s: list request in ".$stack{$job}{"channel"}."\n";
    }#if(ref($stack{$job}) eq "Leve::fserverHandler")
    else
    {
    $msg .= ($job - $actime) ."s: unkown obj:".Dumper($stack{$job})."\n";
    #delete $stack{$job};
    }
  }#foreach my $job (sort ({ $a <=> $b } keys(%stack)))
  $this->print($msg);
}#sub dumpStack
######################################################################
=pod

=item executeJob

xecute a given job

=cut

######################################################################
sub executeJob
{
  my ($newjob) = @_;

SWITCH: {
	  if ($newjob->{"type"} eq "server") 
	  { 
	    my $fs = $newjob->{"server"};
	    #IRC::print("XCHAT:--  exe job '".$fs->{"nick"}."' ".Dumper($fs));
	    IRC::print("XCHAT:--  exe job '".$fs->{"nick"});
	    $fs->bannerDetected();
	    last SWITCH; 
	  }
	  if ($newjob->{"type"} eq "list") 
	  { 
            my $validServ = validServer($newjob->{"server"});
	    if($validServ == 0 && $channelWatch{$newjob->{"channel"}})
	    {
              $newjob->{"server"} = $channelWatch{$newjob->{"channel"}};
              $validServ = validServer($newjob->{"server"});
	    }#if($validServ == 0)
	    if($validServ == 1)
	    {
	    Leve::leve_triggerlist($newjob->{"server"},$newjob->{"channel"});
	    }#if($validServ == 1)
	    else
	    {
	      delete($Leve::listChans{$newjob->{"channel"}});
	    }
	    last SWITCH; 
	  }
	}# SWITCH: 
}#sub executeJob
######################################################################
=pod

=item stop

stopping, emptying the stack of its content....

=cut

######################################################################
sub stop
{
    foreach my $job (keys(%stack))
    {
      delete $stack{$job};
    }#foreach my $job (@jobStack)
}#sub stop
######################################################################
=pod

=item validServer

check validity of a server

=cut

######################################################################
sub validServer
{
  my $theServ = shift;
  my @servList = IRC::server_list( );
  foreach my $aServ (@servList)
  {
    if($theServ =~/$aServ/i)
    {
      return 1;
    }#if($newjob->{"server"} =~/$aServ/i)
  };#foreach my $aServ (@servList)
  return 0;
}#sub validServer
######################################################################
=pod

=item sysdata

hold the preferences disponibles through the skeleton

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

