##############################################################################
=pod

=head1 NAME

toutou graphical interface

=head1 DESCRIPTION

graphical irc client that connects to the zebot server

=head1 COPYRIGHT and LICENCE

Copyright (c) 2002 Bruno Boettcher

tougui.pl is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################


package zebot::gui::toutouGui;
use Gtk2;

use POE;

use Gtk2::SimpleMenu;

use zebot::gui::Channel;
use zebot::gui::Gui;
use zebot::client::Connector;

use constant FALSE => 0;
use constant TRUE  => 1;

my $version_adjustment = 0.0;
my $VERSION = '$Revision: 1.1 $';
$VERSION =~ s/.*(\d+\.\d+).*/$1/;
$VERSION += $version_adjustment;

#####################################################################
=pod

=item new, Constructor


The constructor of a zebot::gui::toutouGui object, initializes a number of datastructures that will be used later, creates a blessed reference

=cut

#####################################################################
sub new
{
  my ($classname, $settings) = @_;

  my $obj_ref = { };

  bless $obj_ref, $classname;

  $obj_ref->{"settings"} = $settings if ($settings);

  return $obj_ref;
}# sub new
#####################################################################
=pod

=item init


initialises the different parts, starts the main gui window

=cut

#####################################################################
sub init
{
  my ($this) = @_;

  my($mw);
  $mw = Gtk2::Window->new;
  $this->{"mainwindow"} = $mw;
  $mw->set_title($this->{"settings"}->{"frame_title"});

  my($vb);
  $vb= Gtk2::VBox->new(FALSE, 0);
  $mw->add($vb);
  $this->{"mainvertbox"} = $vb;


  $this->createMenues();
  #my(@menus) = ({ path => "/_File", type => "<Branch>" },
  #    { path => "/File/_Connect"             },
  #    { path => "/File/_Quit"                });
  #my($itemfact);
  #$itemfact = Gtk2::ItemFactory->new("Gtk2::MenuBar", "<main>", undef);
  #$itemfact->create_items(@menus);
  #$vb->pack_start($itemfact->get_widget("<main>"), FALSE, FALSE, 0);


  $this->{"notebook"} = Gtk2::Notebook->new;
  $vb->pack_start($this->{"notebook"}, TRUE, TRUE, 0);

  my $channel_info = { 
    "channel" => "status",
    "network" => "local.net",
    "callback" => $this,
  };
  $this->{"status"} = zebot::gui::Channel->new($channel_info);

  $mw->show_all;

  $this->{"status"}->{shell}->grab_focus;

  POE::Session->create( object_states => [ 

      $this =>
      {  _start	=> "_start",
      _stop	=> "_stop",
      _default	=> "_default",
      alive	=> "keepalive",
      }
  ]
    );
}#sub init
#########################################################
=pod

=item _start, session initialisation

This gets executed as soon as the kernel sets up this session.

=cut

#########################################################
sub _start 
{
  my ($kernel, $session,$context) = @_[KERNEL, SESSION, SENDER];
  my ($this) = @_;

  # Uncomment this to turn on more verbose POE debugging information.
  # $session->option( trace => 1 );

  # Make an alias for our session, to keep it from getting GC'ed.
  $kernel->alias_set( $this->{"settings"}->{"frame_alias"} );

  $kernel->signal_ui_destroy($this->{"mainwindow"} );
  $kernel->delay(alive => 50);
  #just in case to hold a ref on the kernel to be able to post events
  $this->{"kernel"} = $kernel;

}# sub _start 
#########################################################
=pod

=item _stop

allow the garbage collector to remove this

=cut

#########################################################
sub _stop 
{
  my $kernel = $_[KERNEL];
  my  $context = $_[SENDER];
  my ($this) = @_;

  print "Control session stopped.\n";
  $kernel->post( $context, 'quit', 'Neenios on ice!' );
  $kernel->alias_remove( $this->{"settings"}->{"frame_alias"} );
}
#########################################################
=pod

=item _default, Default handler

for the stuff that couldn't be identifyed, or where we don't have specifyed a
handler

=cut

#########################################################
sub _default 
{
  my ($state, $event, $args,$kernel,$heap) = @_[STATE, ARG0, ARG1,KERNEL,HEAP];
  $args ||= [];
  my ($this) = @_;

  return 0;
}# sub _default 
#########################################################
=pod

=item keepalive

keep alive function to keep the whole alive

=cut

#########################################################
sub keepalive
{
  my ($state, $event, $args,$kernel,$heap) = @_[STATE, ARG0, ARG1,KERNEL,HEAP];
  $args ||= [];
  my ($this) = @_;
  $kernel->delay(alive => 50);

  return 0;
}# sub keepalive
#########################################################
=pod

=item createMenues

build up the menu structure of the GUI and attach it to the main window

=cut

#########################################################
sub createMenues
{
  my ($this) = @_;

    my @menu_tree = (
	'_File' => {
	item_type => '<Branch>',
	children => [
	'_Connect' => {
	callback => sub{ print("diverting ot connect!\n");$this->connect();},
	},
    'Quit' => {
      callback => sub{ $this->ui_quit();},
    },
    ],
	},
    '_Help' => {
      item_type => '<LastBranch>',
      children => [
	'About' => {
	  callback => sub{ $this->ui_about();},
	},
      ],
    },
    );

    my $menu = Gtk2::SimpleMenu->new ( menu_tree => \@menu_tree);

  $this->{"mainvertbox"}->pack_start($menu->{widget},0,0,0);
}# sub createMenues 
##############################################################################
=pod

=item ui_quit 

close down the GUI

=cut

##############################################################################
sub ui_quit 
{
  my($this) = @_;
  #foreach my $arg (@_)
  #{
    #  print("ui_quit arg: $arg of type ".ref($arg)."\n");
    #}# foreach my $arg (@_)
  print("normal shutdown\n");
  my $kernel = $this->{"kernel"};

  if($kernel)
  {
      $kernel->post("ircbridge", "shutdown");
    foreach my $sessionid (@{$this->{"controlledSessions"}})
    {
      $kernel->post($sessionid, "shutdown");
    }# foreach my $sessionid (@{$this->{"controlledSessions"}})
    #shutdown the local Gtk eventloop
    $kernel->post($this->{"settings"}->{"frame_alias"}, "shutdown");
  }
  else
  {
    print("no kernel defined can't call shutdown on socket\n");
  }# else
  exit(0);
}# sub ui_quit 
##############################################################################
=pod

=item ui_about 

generate an about message

=cut

##############################################################################
sub ui_about 
{
  my($this) = @_;
  my $pixbuf = undef;
  my $filename = $this->{"settings"}->{"configpath"}."ressources/logo.png";

  my $about = new Gtk2::Dialog;
  my $label = new Gtk2::Label;
  my $markup = <<"    END";

  <span weight="bold" size="large">Zebot GUI</span>
    v$VERSION

    Transform your own IRC-bot into a regular grafical IRC client

    Copyright (c) 2003 Bruno Bttcher
    bboett at adlp org, 
    ya

    END

    $markup =~ s/\n */\n/gs;
  $label->set_markup($markup);
  $label->set_justify('center');

  my $image = Gtk2::Image->new_from_file ($filename);


  $about->set_title('');
  $about->set_icon ($image->get_pixbuf);
  $about->set_border_width(8);
  $about->set_modal(TRUE);
  $about->set_resizable(FALSE);
  $about->add_buttons('gtk-ok' => 0);
  $about->vbox->set_spacing(8);
  $about->vbox->pack_start(
      $image,
      FALSE, FALSE, 0);
  $about->vbox->pack_start($label, TRUE, TRUE, 0);
  $about->show_all;
  $about->signal_connect(response => sub { $about->destroy(); });
}# sub ui_about 
#########################################################
=pod

=item connect

fire up the connector object and let it connect itself to the hopefully running
bot, otherwise retry until you get a bot connected to.

=cut

#########################################################
sub connect
{
  my ($this) = @_;
  print("connect isntantiating conector\n");
  my $connector = new zebot::client::Connector("ircbridge");
  print("insantiated!\n");
  my $callbacks =
  {
    "defaultSession" => "gtkSeries",
    "defaultEvent" => "default",
    "msgevent" => "default",
  };

  print("casting init!\n");
  $connector->init($this->{"settings"}, $callbacks);
}# sub createMenues 
1
__END__


=back

=head1 THANKS

ya for creating the first version of this framework

=head1 AUTHOR

Bruno Bttcher <bboett <at> adlp <dot> org>

=head1 SEE ALSO

  zebot home page  http://www.freesoftware.fsf.org/zebot/ 
  Net::IRC, 
  RFC 1459,
  http://www.irchelp.org/, 
  http://poe.perl.org/
  http://www.cs.cmu.edu/~lenzo/perl/, 
  http://www.infobot.org/,


=cut
