##############################################################################
=pod

=head1 NAME

Serevr

=head1 DESCRIPTION

Module handling the connections to the servers

=head1 COPYRIGHT and LICENCE

Copyright (c) 2002 Bruno Boettcher

Server.pm is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################



package zebot::gui::Server;
use strict;
use Errno qw(:POSIX);
use IO::Socket::INET;

use zebot::gui::Signals;
use zebot::gui::Codes;

our @ISA = qw(zebot::gui::Signals);

our %Servers;

##############################################################################
=pod

=item new

create a new Server connection

=cut

##############################################################################

sub new {
#XXX need to handle connection errors
	my $self = bless {}, shift;
	my($host, $port) = @_;
	
	$self->{buff} = "";
#	$self->{host} = $host;
	$self->{sock} = IO::Socket::INET->new(PeerAddr => $host,
			                              PeerPort => $port,
										  Blocking => 0)
	|| return undef;
										  
	$self->{io_in_id} = Glib::IO->add_watch($self->{sock}->fileno, 
			'G_IO_IN',  sub { $self->io_handler; 1;});
	Glib::IO->add_watch($self->{sock}->fileno, 
			'G_IO_HUP', sub { Glib::Source->remove($self->{io_in_id});
							  Glib::Source->remove($self->{io_out_id});
			                  0}); 
	
	return $self;
}

##############################################################################
=pod

=item send

send data to the server

=cut

##############################################################################

sub send {
#XXX need to setup the queue and handle syswrite errors
	my $self  = shift;
	my($data) = @_;
	
	$self->{io_out_id} = Glib::IO->add_watch($self->{sock}->fileno, 'G_IO_OUT',
			sub {
				my $le = syswrite($self->{sock}, $data);
				Glib::Source->remove($self->{io_out_id});
			});
	
}

##############################################################################
=pod

=item io_handler

Handles io data of the server connection

=cut

##############################################################################

sub io_handler {
#XXX need to handle sysread errors
	my $self = shift;

	my $le = sysread($self->{sock}, my $buffer, 4096);
	if(!$le) {	
		Glib::Source->remove($self->{io_in_id});
		$self->signal_emit("eof");
	}
	
	$self->{buff} .= $buffer;
	
	Codes->parse($self);
}

	
1;
