##############################################################################
=pod

=head1 NAME

Codes module

=head1 DESCRIPTION

Module containing the callbacks for each CODE or ACTION received by the client

=head1 COPYRIGHT and LICENCE

 Copyright (c) 2002 Bruno Boettcher

Codes.pm is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

######################################################################
package zebot::gui::Codes;
use strict;

my %Codes = (
		376 => \&code_motd,
		353 => \&code_names,
		366 => \&code_names_end,
);

my %Actions = (
		JOIN => \&act_join,
);

##############################################################################
=pod

=item parse

Parses the received CODE or ACTION

=cut

##############################################################################

sub parse {
	shift;
	my($server) = @_;

	while($server->{buff} =~ s/(.*?)\015\012//) {
		my $buffer = $1;

		if($buffer =~ /^:(\S+) (\d+) (.*)/) {
			$Codes{$2}->($server, $1, $3), return if $Codes{$2};
		}
		if($buffer =~ /^:(.+?)!\S+ (\w+) (\S+)/) {
			$Actions{$2}->($server, $1, $3), return if $Actions{$2};
		}
		$main::status->insert($buffer);
	}
}

##############################################################################
=pod

=item code_motd

MOTD callback

=cut

##############################################################################

sub code_motd {
	my $server = shift;
	my($host)  = @_;
	$server->{host} = $host;

	my $iter = $main::status->{list}->append;
	$main::status->{list}->set($iter, 0, $host);

}

##############################################################################
=pod

=item code_names

NAMES callback

=cut

##############################################################################

sub code_names {
	my $server = shift;
	my($host, $line) = @_;
	my($channel, $names) = $line =~ /([#+]\S+) :(.*)/;
	my @names = split / /, $names;
	my $list = $server->{CHANNELS}{$channel}->{nicks} || [];
	push @$list, @names;
	$server->{CHANNELS}{$channel}->{nicks} = $list;
}


##############################################################################
=pod

=item code_names_end

end NAMES callback

=cut

##############################################################################

sub code_names_end {
	my $server = shift;
	my($host, $line) = @_;
	my($channel) = $line =~ /([#+]\S+)/;
	my $list = $server->{CHANNELS}{$channel}->{nicks};
	while(@$list) {
		my $iter = $server->{CHANNELS}{$channel}->{list}->append;
		$server->{CHANNELS}{$channel}->{list}->set($iter, 0, pop @$list);
	}
}

##############################################################################
=pod

=item act_join

JOIN callback

=cut

##############################################################################

sub act_join {
	my $server  = shift;
	my($nick, $channel) = @_;
	$channel =~ s/^://;	
	
	$server->{CHANNELS}{$channel} = Channel->new($channel, $server);
}

	
1;
