##############################################################################
=pod

=head1 NAME

PAM

=head1 DESCRIPTION

PAM module without any functionality, when you don't have the need to
authenticate users

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  dummypam is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::dummypam;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);
#use DBI;

use Data::Dumper;


# sub POE::Kernel::ASSERT_DEFAULT () { 1 }
# sub POE::Kernel::ASSERT_PONY () { 1 }
# sub POE::Kernel::ASSERT_EVENTS () { 1 }
# sub POE::Kernel::ASSERT_STATES () { 1 }

use POE::Session;

our @ISA = ("zebot::baseactor");
#attributes("users","deb","active","errmsg","dbh");
zebot::baseactor::_define_constructor("zebot::dummypam");



##############################################################################
=pod

=item init

Initiaize, means set up this module

=cut

##############################################################################
sub init
{
  my @securedargs = @_;

  my ($this,$sysref) = @_;
  my $sysrefe = $sysref;
  #$this->print "this = $this\n";
  #$this->print "syse[botname] = ".$sysrefe{"botname"}."\n";


  $this->SUPER::init($sysref);
  $this->sysdata($sysref);

}#sub init
##############################################################################
=pod

=item PRIVMSGaction

 react on a message addressed directly to this script

=cut

##############################################################################
sub PRIVMSGaction
{
  my ($this,$splittedline) = @_;
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  return if($this->SUPER::activeForThisChan($splittedline));

  my $botname = $splittedline->{"heap"}->{"nick"};
  return 0;
}#sub PRIVMSGaction

##############################################################################
=pod

=item setNicksLogged

 since nicks can be assigned to different hostmasks, it is not possible to
 identify a user only by its nick, so its easier to send the users a message
 that they need to auth if they want to use the services of this bot

=cut

##############################################################################
sub setNicksLogged
{
  my ($this,$splittedline) = @_;
  my $names = $splittedline->{"userlist"};
  my $kernel = $splittedline->{"kernel"};
  my $context = $splittedline->{"context"};
  my $channel = $splittedline->{"channel"};

  return 0;
}#sub setNicksLogged
##############################################################################
=pod

=item JOINaction

react on a user joining

=cut

##############################################################################
sub JOINaction
{
  my ($this,$splittedline) = @_;

  return if($this->SUPER::activeForThisChan($splittedline));
  #$this->print "pam dumping this ".$this."\n";
  #$this->print "pam dumping sysdata ".Dumper($this->sysdata())."\n";
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  $username =~ s/~//g;
  return 0;
}#sub JOINaction

######################################################################
=pod

=item PARTaction

react on a user leaving

=cut

######################################################################
sub PARTaction
{
  my ($this,$splittedline) = @_;
  return if($this->SUPER::activeForThisChan($splittedline));
  my $line = $splittedline->{"line"};
  my $usernick = $splittedline->{"usernick"};
  my $username = $splittedline->{"username"};
  my $userhost = $splittedline->{"userhost"};
  my $kernel = $splittedline->{"kernel"};
  $this->{"kernel"} = $splittedline->{"kernel"};
  $this->{"context"} = $splittedline->{"context"};

  $username =~ s/~//g;
  #$this->print "someone leaves: $usernick $username\@$userhost\n";

  return 0;
}#sub PARTaction

######################################################################
=pod

=item help

issue the help for this module

=cut

######################################################################
sub help
{
  my $this = shift;
  my $splittedline = shift;
  my $botname = $splittedline->{"heap"}->{"nick"};
  #$this->print "m6: search for $usernick\n";
  #$this->print "ref = '$splittedline'\n";
  #my $usernick = $splittedline->{"usernick"};
  #my $username = $splittedline->{"username"};
  #my $userhost = $splittedline->{"userhost"};
  #my $kernel = $splittedline->{"kernel"};

  return "PAM-dummy: only a dummy module";
}#sub help

######################################################################
=pod

=item isa

return the type of thie module

=cut

######################################################################
sub isa
{
  return "pam";
}#sub isa
######################################################################
=pod

=item findLogged

search for the online status of someone

=cut

######################################################################
sub findLogged
{
  my $this = shift;
  my $nick = shift;

  return 0;
}

######################################################################
=pod

=item findOperator 

find out if a person should be operator

=cut

######################################################################
sub findOperator 
{
  my $this = shift;
  my $line = shift;
  my $i;
  my $listing = "";
  my $nick = $line->{"usernick"};
  my $name = $line->{"username"};
  my $host = $line->{"userhost"};


  return ;
}
######################################################################
=pod

=item shutdown

close down the activity for a safe shutdown

=cut

######################################################################
sub shutdown
{
  my $this = shift;
  my $owner = $this->setting("owner");
}#sub shutdown

######################################################################
=pod

=item version

return the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.15 $';
}#sub isa
######################################################################
=pod

=item sysdata

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
    $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

