##############################################################################
=pod

=head1 NAME

dbaccess 


=head1 DESCRIPTION

dbaccess generic class that open an instance of a postgres sql DB handle
and allows queries on it, designed to use and display the knowledge DB for the
merchant empires game

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  basereactions is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::dbaccess;
use strict;
use zebot::baseactor;
#use ObjectTemplate;
use POSIX qw(strftime);
use DBI;

our @ISA = ("zebot::baseactor");
#attributes("messages","deb");
zebot::baseactor::_define_constructor("zebot::dbaccess");

######################################################################
=pod

=item init

fetch from the skeleton all the infos we might need

=cut

######################################################################
sub init
{
   my @securedargs = @_;
   my $this = shift;
   my $sysref = shift;
   my $sysrefe = $sysref;
   # $this->print("obj = $this\n");
   # $this->print("syse[botname] = ".$sysrefe{"botname"}."\n");
  $this->SUPER::init($sysref);
   $this->sysdata($sysref);
   my $ref = {};
   $this->messages($ref);
   my $ModRef = $sysref->{"actors"};
   $ModRef->{"dbaccess"} = $this;
}#sub init

#<<-- :Lasade!~bboett@serf-35315.cybercable.tm.fr PRIVMSG toutou :mail aos seomthing

######################################################################
=pod

=item PRIVMSGaction

check if the command line holds the query command

=cut

######################################################################
sub PRIVMSGaction
{
   my ($this,$splitline) = @_;
  return if($this->SUPER::activeForThisChan($splitline));
  my $botname = $splitline->{"heap"}->{"nick"};
   # $this->print("debug '$botname': received $line\n");
   my $line = $splitline->{"line"};
   if($line =~ /query\s+(.*)$/)
   {
     my $condition = $1;

     #my $dbh = DBI->connect('DBI:Pg:dbname=test;host=$host;port=$port;options=$options;tty=$tty')
     my $dsn = 'DBI:Pg:dbname=test';
     $dsn = 'DBI:mysql:database=SPSB;host=sql.free.fr';
     my $dbh = DBI->connect($dsn,"sps.libs",'zigoto')
       or die "dbaccess: Couldn't connect to database: " . DBI->errstr;
     #my $sth = $dbh->prepare('SELECT "tag","name","desc" FROM toto WHERE tag = ?')
     my $sth = $dbh->prepare('SELECT * FROM SPSB WHERE id=?')
       or die "dbaccess: Couldn't prepare statement: " . $dbh->errstr;

     $sth->execute($condition)             # Execute the query
       or die "dbaccess: Couldn't execute statement: " . $sth->errstr;

     # Read the matching records and print them out          
     while (my @data = $sth->fetchrow_array()) 
     {
       my $tag = $data[0];
       my $name = $data[1];
       my $desc = $data[2];
       $this->print("\t$tag : $name $desc\n");
     }

     if ($sth->rows == 0) 
     {
       $this->print("No names matched `$condition'.\n\n");

       $sth->finish;
       $this->print("\n");
     }

     $dbh->disconnect;

     return 1;
   }#if($line =~ /.*:(\S+)!(\S+) PRIVMSG $botname :mail (.*)$/)
   return 0;
}#sub PRIVMSGaction

######################################################################
=pod

=item help

issue the help for the usage of this module

=cut

######################################################################
sub help
{
   my ($this,$splitline) = @_;
  my $botname = $splitline->{"heap"}->{"nick"};
  return "DBACCESS-help:\nmsg: cmd format: msg ".$botname." mail nick message";
}#sub help
######################################################################
=pod

=item isa

issue the type of this module

=cut

######################################################################
sub isa
{
  return "dbaccess";
}#sub isa
######################################################################
=pod

=item version

issue the version of this module

=cut

######################################################################
sub version
{
  return '$Revision: 1.18 $';
}#sub isa
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

