##############################################################################
=pod

=head1 NAME

connector


=head1 DESCRIPTION

Fire up a server socket to allow externale entities to connect to this bot,
  e.g. a GUI and pass through the data in both directions.

=head1 COPYRIGHT and LICENCE

  Copyright (c) 2002 Bruno Boettcher

  connector.pm is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=head1 Methods of this class

=over

=cut

##############################################################################
package zebot::connector;
use strict;
use zebot::baseactor;
use Data::Dumper;
#use ObjectTemplate;
use POSIX qw(strftime);

use POE;
use POE::Filter::Reference;
#use POE::Component::Server::TCP;

our @ISA = ("zebot::baseactor");
zebot::baseactor::_define_constructor("zebot::connector");

#####################################################################
=pod

=item init

initialize this element, notably make the connection to the database

=cut

#####################################################################
sub init
{
  my ($this,$sysref) = @_;
  $this->SUPER::init($sysref);
  $this->sysdata($sysref);

  print("CONNECTOR SERVER firing up!!\n");
  $this->{"server_alias"} = "zebot_server";
  $this->{"links"} = {} ;
  my $authenthications = $this->{"links"};

  $this->setting("address","localhost") if(!($this->setting("address")));
  $this->setting("port","22045") if(!($this->setting("port")));

  use POE::Component::Server::SSL;
  my $keypath = $this->setting("keys");
  $keypath = $ENV{HOME}."/.zebot/keys" if(!$keypath);
  $POE::Component::Server::SSL::keypath = $keypath;
#POE::Component::Server::TCP->new
  $this->{"server"} = POE::Component::Server::SSL->new
    ( Alias => $this->{"server_alias"},
      Address      => $this->setting("address"),
      Port         => $this->setting("port"),
      ClientFilter => "POE::Filter::Reference",

      # Handle client requests here.

      ClientInput => sub { shift(@_); $this->shell(@_);},

      # to the server itself.  Using yield() here would just shut down
      # the client connection.

      ClientDisconnected => sub 
      {
	my ($kernel,$session) = @_[KERNEL,SESSION];
	delete  $authenthications->{$session->ID};
	$kernel->yield("shutdown");
	#$kernel->post( pattern_server => "shutdown" );
      },
      );
}#sub init

#####################################################################
=pod

=item help

issue the help for this module

=cut

#####################################################################
sub help
{
   my ($this,$args) = @_;
  my $msg =  $this->sysdata()->getMesg("CONNECTORHELP",$args);
  return $msg;
}#sub help

#####################################################################
=pod

=item isa

issue the type of this module

=cut

#####################################################################
sub isa
{
  return "connector";
}#sub isa

#####################################################################
=pod

=item version

issue the version of this module

=cut

#####################################################################
sub version
{
  return '$Revision: 1.2 $';
}#sub isa

#####################################################################
=pod

=item shutdown

close operations, save evenutally necessary data, remove datastructeres etc.

=cut

#####################################################################
sub shutdown
{
  my ($this,$args,$kernel) = @_[OBJECT,ARG0,KERNEL];
  my $owner = $this->setting("owner");
  $kernel = $args->{"kernel"} if(!$kernel);
  if($kernel)
  {
    $kernel->post( $this->{"server_alias"} => "shutdown" );
  }#if($kernel)
  delete $this->{"server"};
}#sub shutdown
######################################################################
=pod

=item sysdata

attribute getter previously provided by ObjecTemplate

=cut

######################################################################
sub sysdata
{
  my($this,$lsysdata) = @_;
  if($lsysdata)
  {
      $this->{"sysdata"} = $lsysdata;
  }
  return $this->{"sysdata"};
}# sub sysdata
##############################################################################
=pod

=item shell

the method where the incoming data is redirected to, this thing analyzes
partially the incoming stuff and redirects it to the correct isntance or
processes it itself (e.g. commands as shutdown are processed locally, as is the
    authentication)

=cut
######################################################################
sub shell
{
  my ( $heap, $line,$kernel,$session ) = @_[ HEAP, ARG0, KERNEL,SESSION ];
  print("shell ".Dumper($line)."!\n");


  my $msg = "jobDone";
  #print("sending jobDone\n");
  $heap->{client}->put(\$msg);
}# sub shell
1
__END__

=back

=head1 AUTHOR

Bruno Bttcher <bboett at adlp.org>

=head1 SEE ALSO

zebot home page  http://www.freesoftware.fsf.org/zebot/ 
POD documentation of zebot

=cut

