#!/bin/bash -i
#
# ZigzagDownLoader (ZDL)
# 
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License as published 
# by the Free Software Foundation; either version 3 of the License, 
# or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License 
# along with this program. If not, see http://www.gnu.org/licenses/. 
# 
# Copyright (C) 2011: Gianluca Zoni (zoninoz) <zoninoz@inventati.org>
# 
# For information or to collaborate on the project:
# https://savannah.nongnu.org/projects/zdl
# 
# Gianluca Zoni (author)
# http://inventati.org/zoninoz
# zoninoz@inventati.org
#

## ZDL add-on
## zdl-extension types: streaming
## zdl-extension name: Movshare

if [ "$url_in" != "${url_in//'movshare.'}" ] &&
       [ "$url_in" != "${url_in//video}" ]
then
    html="$(wget -t 1 -T $max_waiting "$url_in" -O- -q)"

    if [ -n "$html" ]
    then
	test_exist=$(grep "This file no longer exists on our servers" <<< "$html")
	if [ -n "$test_exist" ]
	then
	    # not_available=true
	    # break_loop=true
	    _log 3

	else
	    flashvars_file=$(grep "flashvars.file=" <<< "$html")
	    flashvars_file="${flashvars_file#*'flashvars.file='\"}"
	    flashvars_file="${flashvars_file%\"*}"

	    flashvars_key=$(grep "flashvars.filekey=" <<< "$html")
	    flashvars_key="${flashvars_key#*'flashvars.filekey='\"}"
	    flashvars_key="${flashvars_key%\"*}"
	    flashvars_domain=$(grep "flashvars.domain=" <<< "$html")
	    flashvars_domain="${flashvars_domain#*'flashvars.domain='\"}"
	    flashvars_domain="${flashvars_domain%\"*}"

	    rm -f "$path_tmp"/zdl2.tmp
	    axel "${flashvars_domain}/api/player.api.php?user=undefined&cid=1&file=${flashvars_file}&pass=undefined&key=${flashvars_key}" -o "$path_tmp"/zdl2.tmp &>/dev/null 
	    if [ ! -f "$path_tmp"/zdl2.tmp ]
	    then
		_log 5
		
	    elif [ -z $(grep url "$path_tmp"/zdl2.tmp ) ]
	    then
		not_available=true
		break_loop=true
	    else
		url_in_file=$(cat "$path_tmp"/zdl2.tmp)
		url_in_file="${url_in_file#*'url='}"
		url_in_file="${url_in_file%%'&'*}"
		file_in="${url_in_file##*'/'}"
		file_in=$(grep "share" "$path_tmp"/zdl.tmp |grep "title=")
		file_in="${file_in#*'title='}"
		file_in="${file_in%%\"*}.${url_in_file##*'.'}"

		if [[ "$file_in" =~ ^\. ]]
		then
		    url_in="${url_in%%\/}"
		    file_in="${url_in##*\/}$file_in"
		fi
	    fi
	fi
    else
	_log 2
    fi
fi
