/* tiger_cmp_generic.c
 * Copyright (C) 2009 Mario Castelan Castro
 *
 * This file is part of Zirrux 130
 *
 * Zirrux 130 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Zirrux 130 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Zirrux 130.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdint.h>
#include <string.h>
#include "tiger_sbox.h"
#include "tiger_cmp.h"
void
ntiger_compress(uint64_t * registers, uint64_t * keys)
{
  uint64_t a = registers[0];
  uint64_t b = registers[1];
  uint64_t c = registers[2];
  c ^= keys[0];
  a -= t1[(c & 0xFF)] ^ t2[((c >> 16) & 0xFF)] ^ t3[((c >> 32) & 0xFF)] ^ t4[((c >> 48) & 0xFF)];
  b += t4[((c >> 8) & 0xFF)] ^ t3[((c >> 24) & 0xFF)] ^ t2[((c >> 40) & 0xFF)] ^ t1[((c >> 56) & 0xFF)];
  b *= 5;
  a ^= keys[1];
  b -= t1[(a & 0xFF)] ^ t2[((a >> 16) & 0xFF)] ^ t3[((a >> 32) & 0xFF)] ^ t4[((a >> 48) & 0xFF)];
  c += t4[((a >> 8) & 0xFF)] ^ t3[((a >> 24) & 0xFF)] ^ t2[((a >> 40) & 0xFF)] ^ t1[((a >> 56) & 0xFF)];
  c *= 5;
  b ^= keys[2];
  c -= t1[(b & 0xFF)] ^ t2[((b >> 16) & 0xFF)] ^ t3[((b >> 32) & 0xFF)] ^ t4[((b >> 48) & 0xFF)];
  a += t4[((b >> 8) & 0xFF)] ^ t3[((b >> 24) & 0xFF)] ^ t2[((b >> 40) & 0xFF)] ^ t1[((b >> 56) & 0xFF)];
  a *= 5;
  c ^= keys[3];
  a -= t1[(c & 0xFF)] ^ t2[((c >> 16) & 0xFF)] ^ t3[((c >> 32) & 0xFF)] ^ t4[((c >> 48) & 0xFF)];
  b += t4[((c >> 8) & 0xFF)] ^ t3[((c >> 24) & 0xFF)] ^ t2[((c >> 40) & 0xFF)] ^ t1[((c >> 56) & 0xFF)];
  b *= 5;
  a ^= keys[4];
  b -= t1[(a & 0xFF)] ^ t2[((a >> 16) & 0xFF)] ^ t3[((a >> 32) & 0xFF)] ^ t4[((a >> 48) & 0xFF)];
  c += t4[((a >> 8) & 0xFF)] ^ t3[((a >> 24) & 0xFF)] ^ t2[((a >> 40) & 0xFF)] ^ t1[((a >> 56) & 0xFF)];
  c *= 5;
  b ^= keys[5];
  c -= t1[(b & 0xFF)] ^ t2[((b >> 16) & 0xFF)] ^ t3[((b >> 32) & 0xFF)] ^ t4[((b >> 48) & 0xFF)];
  a += t4[((b >> 8) & 0xFF)] ^ t3[((b >> 24) & 0xFF)] ^ t2[((b >> 40) & 0xFF)] ^ t1[((b >> 56) & 0xFF)];
  a *= 5;
  c ^= keys[6];
  a -= t1[(c & 0xFF)] ^ t2[((c >> 16) & 0xFF)] ^ t3[((c >> 32) & 0xFF)] ^ t4[((c >> 48) & 0xFF)];
  b += t4[((c >> 8) & 0xFF)] ^ t3[((c >> 24) & 0xFF)] ^ t2[((c >> 40) & 0xFF)] ^ t1[((c >> 56) & 0xFF)];
  b *= 5;
  a ^= keys[7];
  b -= t1[(a & 0xFF)] ^ t2[((a >> 16) & 0xFF)] ^ t3[((a >> 32) & 0xFF)] ^ t4[((a >> 48) & 0xFF)];
  c += t4[((a >> 8) & 0xFF)] ^ t3[((a >> 24) & 0xFF)] ^ t2[((a >> 40) & 0xFF)] ^ t1[((a >> 56) & 0xFF)];
  c *= 5;
  keys[0] -= keys[7] ^ 0xA5A5A5A5A5A5A5A5;
  keys[1] ^= keys[0];
  keys[2] += keys[1];
  keys[3] -= keys[2] ^ ((~keys[1])<<19);
  keys[4] ^= keys[3];
  keys[5] += keys[4];
  keys[6] -= keys[5] ^ ((~keys[4])>>23);
  keys[7] ^= keys[6];
  keys[0] += keys[7];
  keys[1] -= keys[0] ^ ((~keys[7])<<19);
  keys[2] ^= keys[1];
  keys[3] += keys[2];
  keys[4] -= keys[3] ^ ((~keys[2])>>23);
  keys[5] ^= keys[4];
  keys[6] += keys[5];
  keys[7] -= keys[6] ^ 0x0123456789ABCDEF;
  b ^= keys[0];
  c -= t1[(b & 0xFF)] ^ t2[((b >> 16) & 0xFF)] ^ t3[((b >> 32) & 0xFF)] ^ t4[((b >> 48) & 0xFF)];
  a += t4[((b >> 8) & 0xFF)] ^ t3[((b >> 24) & 0xFF)] ^ t2[((b >> 40) & 0xFF)] ^ t1[((b >> 56) & 0xFF)];
  a *= 7;
  c ^= keys[1];
  a -= t1[(c & 0xFF)] ^ t2[((c >> 16) & 0xFF)] ^ t3[((c >> 32) & 0xFF)] ^ t4[((c >> 48) & 0xFF)];
  b += t4[((c >> 8) & 0xFF)] ^ t3[((c >> 24) & 0xFF)] ^ t2[((c >> 40) & 0xFF)] ^ t1[((c >> 56) & 0xFF)];
  b *= 7;
  a ^= keys[2];
  b -= t1[(a & 0xFF)] ^ t2[((a >> 16) & 0xFF)] ^ t3[((a >> 32) & 0xFF)] ^ t4[((a >> 48) & 0xFF)];
  c += t4[((a >> 8) & 0xFF)] ^ t3[((a >> 24) & 0xFF)] ^ t2[((a >> 40) & 0xFF)] ^ t1[((a >> 56) & 0xFF)];
  c *= 7;
  b ^= keys[3];
  c -= t1[(b & 0xFF)] ^ t2[((b >> 16) & 0xFF)] ^ t3[((b >> 32) & 0xFF)] ^ t4[((b >> 48) & 0xFF)];
  a += t4[((b >> 8) & 0xFF)] ^ t3[((b >> 24) & 0xFF)] ^ t2[((b >> 40) & 0xFF)] ^ t1[((b >> 56) & 0xFF)];
  a *= 7;
  c ^= keys[4];
  a -= t1[(c & 0xFF)] ^ t2[((c >> 16) & 0xFF)] ^ t3[((c >> 32) & 0xFF)] ^ t4[((c >> 48) & 0xFF)];
  b += t4[((c >> 8) & 0xFF)] ^ t3[((c >> 24) & 0xFF)] ^ t2[((c >> 40) & 0xFF)] ^ t1[((c >> 56) & 0xFF)];
  b *= 7;
  a ^= keys[5];
  b -= t1[(a & 0xFF)] ^ t2[((a >> 16) & 0xFF)] ^ t3[((a >> 32) & 0xFF)] ^ t4[((a >> 48) & 0xFF)];
  c += t4[((a >> 8) & 0xFF)] ^ t3[((a >> 24) & 0xFF)] ^ t2[((a >> 40) & 0xFF)] ^ t1[((a >> 56) & 0xFF)];
  c *= 7;
  b ^= keys[6];
  c -= t1[(b & 0xFF)] ^ t2[((b >> 16) & 0xFF)] ^ t3[((b >> 32) & 0xFF)] ^ t4[((b >> 48) & 0xFF)];
  a += t4[((b >> 8) & 0xFF)] ^ t3[((b >> 24) & 0xFF)] ^ t2[((b >> 40) & 0xFF)] ^ t1[((b >> 56) & 0xFF)];
  a *= 7;
  c ^= keys[7];
  a -= t1[(c & 0xFF)] ^ t2[((c >> 16) & 0xFF)] ^ t3[((c >> 32) & 0xFF)] ^ t4[((c >> 48) & 0xFF)];
  b += t4[((c >> 8) & 0xFF)] ^ t3[((c >> 24) & 0xFF)] ^ t2[((c >> 40) & 0xFF)] ^ t1[((c >> 56) & 0xFF)];
  b *= 7;
  keys[0] -= keys[7] ^ 0xA5A5A5A5A5A5A5A5;
  keys[1] ^= keys[0];
  keys[2] += keys[1];
  keys[3] -= keys[2] ^ ((~keys[1])<<19);
  keys[4] ^= keys[3];
  keys[5] += keys[4];
  keys[6] -= keys[5] ^ ((~keys[4])>>23);
  keys[7] ^= keys[6];
  keys[0] += keys[7];
  keys[1] -= keys[0] ^ ((~keys[7])<<19);
  keys[2] ^= keys[1];
  keys[3] += keys[2];
  keys[4] -= keys[3] ^ ((~keys[2])>>23);
  keys[5] ^= keys[4];
  keys[6] += keys[5];
  keys[7] -= keys[6] ^ 0x0123456789ABCDEF;
  a ^= keys[0];
  b -= t1[(a & 0xFF)] ^ t2[((a >> 16) & 0xFF)] ^ t3[((a >> 32) & 0xFF)] ^ t4[((a >> 48) & 0xFF)];
  c += t4[((a >> 8) & 0xFF)] ^ t3[((a >> 24) & 0xFF)] ^ t2[((a >> 40) & 0xFF)] ^ t1[((a >> 56) & 0xFF)];
  c *= 9;
  b ^= keys[1];
  c -= t1[(b & 0xFF)] ^ t2[((b >> 16) & 0xFF)] ^ t3[((b >> 32) & 0xFF)] ^ t4[((b >> 48) & 0xFF)];
  a += t4[((b >> 8) & 0xFF)] ^ t3[((b >> 24) & 0xFF)] ^ t2[((b >> 40) & 0xFF)] ^ t1[((b >> 56) & 0xFF)];
  a *= 9;
  c ^= keys[2];
  a -= t1[(c & 0xFF)] ^ t2[((c >> 16) & 0xFF)] ^ t3[((c >> 32) & 0xFF)] ^ t4[((c >> 48) & 0xFF)];
  b += t4[((c >> 8) & 0xFF)] ^ t3[((c >> 24) & 0xFF)] ^ t2[((c >> 40) & 0xFF)] ^ t1[((c >> 56) & 0xFF)];
  b *= 9;
  a ^= keys[3];
  b -= t1[(a & 0xFF)] ^ t2[((a >> 16) & 0xFF)] ^ t3[((a >> 32) & 0xFF)] ^ t4[((a >> 48) & 0xFF)];
  c += t4[((a >> 8) & 0xFF)] ^ t3[((a >> 24) & 0xFF)] ^ t2[((a >> 40) & 0xFF)] ^ t1[((a >> 56) & 0xFF)];
  c *= 9;
  b ^= keys[4];
  c -= t1[(b & 0xFF)] ^ t2[((b >> 16) & 0xFF)] ^ t3[((b >> 32) & 0xFF)] ^ t4[((b >> 48) & 0xFF)];
  a += t4[((b >> 8) & 0xFF)] ^ t3[((b >> 24) & 0xFF)] ^ t2[((b >> 40) & 0xFF)] ^ t1[((b >> 56) & 0xFF)];
  a *= 9;
  c ^= keys[5];
  a -= t1[(c & 0xFF)] ^ t2[((c >> 16) & 0xFF)] ^ t3[((c >> 32) & 0xFF)] ^ t4[((c >> 48) & 0xFF)];
  b += t4[((c >> 8) & 0xFF)] ^ t3[((c >> 24) & 0xFF)] ^ t2[((c >> 40) & 0xFF)] ^ t1[((c >> 56) & 0xFF)];
  b *= 9;
  a ^= keys[6];
  b -= t1[(a & 0xFF)] ^ t2[((a >> 16) & 0xFF)] ^ t3[((a >> 32) & 0xFF)] ^ t4[((a >> 48) & 0xFF)];
  c += t4[((a >> 8) & 0xFF)] ^ t3[((a >> 24) & 0xFF)] ^ t2[((a >> 40) & 0xFF)] ^ t1[((a >> 56) & 0xFF)];
  c *= 9;
  b ^= keys[7];
  c -= t1[(b & 0xFF)] ^ t2[((b >> 16) & 0xFF)] ^ t3[((b >> 32) & 0xFF)] ^ t4[((b >> 48) & 0xFF)];
  a += t4[((b >> 8) & 0xFF)] ^ t3[((b >> 24) & 0xFF)] ^ t2[((b >> 40) & 0xFF)] ^ t1[((b >> 56) & 0xFF)];
  a *= 9;
  registers[0] = a ^ registers[0];
  registers[1] = b - registers[1];
  registers[2] = c + registers[2];
}
