#!/usr/bin/python

# Handle apache requests for XRT
# Copyright (C) 2006 by Tapsell-Ferrier Limited

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to the
# Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301  USA

"""Apache adaptor for XRT"""

import re
import libxml2
import logging
import xslt
import StringIO
import sys
import os
import urllib

from mod_python import apache
from mod_python import util

import http_handler


def handler(http):
    """mod_python adaptor for xsltpages"""

    hdlr = logging.StreamHandler(sys.stderr)
    hdlr.setFormatter(logging.Formatter('%(asctime)s %(name)s %(lineno)d %(message)s'))
    logging.getLogger().addHandler(hdlr)
    logging.getLogger().setLevel(logging.ERROR)

    # URI resolver... this is really dumb but it kinda works for now.
    def xrt_resolver(url, id, ctxt):
        if os.path.exists(url):
            return open(url)
        else:
            base = os.path.basename(url)
            dir = os.path.dirname(url) + "/../"
            while os.path.abspath(dir + base) != "/" \
                      and not os.path.exists(dir + base):
                dir = dir + "../"
            return open(dir + base)

    libxml2.setEntityLoader(xrt_resolver)


    # Get the parameters
    parameters = util.FieldStorage(http)

    # Process the call
    status, mime_object = http_handler.http_handle(http.document_root() + "/top.xslt",
                                                   http.method,
                                                   http.uri,
                                                   http.headers_in,
                                                   parameters)

    # Default status is success, NB we *must* set the status before tripping the http send.
    if not status:
        http.status = 200
    else:
        http.status = status

    # Dump out the header
    for key,value in mime_object.items():
        if key.lower() == "content-type":
            http.content_type = urllib.quote(value)

        if status >= 200 and status < 300:
            http.headers_out[urllib.quote(key)] = urllib.quote(value)
        else:
            http_err_headers_out[urllib.quote(key)] = urllib.quote(value)

    if not http.headers_out["content-type"]:
        http.content_type = "text/xml"

    # Now write the body
    http.write(mime_object.get_payload())

    if status >= 200 and status < 300:
        return apache.OK
    else:
        raise apache.SERVER_RETURN, status
    

# End
