<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet  version="1.0"
                 xmlns:http="http://www.tapsellferrier.co.uk/namespace/xslt_http_ns"
                 xmlns:python="http://www.tapsellferrier.co.uk/xslt-dynamic-function-languages/python"
                 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                 xsl:exclude-result-prefixes="python">

    <xsl:import href="http.xslt"/>

    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes" />

    <xsl:template match="http:request[http:uri='/' and http:method='GET']">
        <html>
            <head>
                <title>XRT Issue Tracker</title>
                <link rel="stylesheet" href="style.css" type="text/css"/>
            </head>
            <body>
                <h1>An XRT Issue Tracker</h1>

                <fieldset>
                    <legend>Create a new issue</legend>
                    <form method="POST" action="/">
                        <div><label>email address:</label><input type="text" size="40" name="email" value=""/></div>
                        <div><label>problem description:</label>
                            <textarea rows="10" cols="40" name="problem">type your problem here.
                            </textarea>
                        </div>
                        <input id="send" type="submit" name="send" value="submit"/>
                    </form>
                </fieldset>

                <table>
                    <caption>Current issues</caption>
                    <tr>
                        <th width="20%">time/date</th>
                        <th width="20%">email</th>
                        <th width="80%">problem</th>
                    </tr>

                    <!-- An example of how using XRT allows grouping without the meunchian method -->
                    <xsl:variable name="ids" select="python:issue_tracker.list_issue_ids()"/>
                    <xsl:variable name="list" select="python:issue_tracker.list_issues()"/>

                    <xsl:for-each select="$ids/item">
                        <xsl:variable name="currentid" select="items/item[1]"/>
                        <xsl:for-each select="$list/item[items/item[2] = $currentid]">
                            <tr>
                                <xsl:attribute name="id"><xsl:value-of select="number($currentid)"/></xsl:attribute>
                                <td class="timedate">
                                    <!-- here we use some quick python to do a job xslt _could_ do -->
                                    <xsl:value-of select="python:issue_tracker.dateformat(string(items/item[3]))"/>
                                </td>
                                <td class="email"><xsl:value-of select="items/item[4]"/></td>
                                <td class="problem"><xsl:value-of select="items/item[5]"/></td>
                            </tr>
                        </xsl:for-each>
                        <!-- Now the "add a new issue" row -->
                        <tr>
                            <td class="add_button_row" colspan="3">add more detail</td>
                        </tr>
                    </xsl:for-each>
                </table>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="http:request[http:uri='/' and http:method='POST']">
        <xsl:variable name="email" select="//http:parameter[@name = 'email']/http:value"/>
        <xsl:variable name="problem" select="//http:parameter[@name = 'problem']/http:value"/>
        <xsl:variable name="added" select="python:issue_tracker.add_issue(string($email), string($problem))"/>
        <xsl:variable name="newcall" select="python:issue_tracker.list_issues(number($added))"/>
        <html>
            <http:response>
                <http:status>201</http:status>
            </http:response>
            <head>
                <title>XRT Issue Tracker</title>
                <link rel="stylesheet" href="style.css" type="text/css"/>
            </head>
            <body>
                <h1>Got a post!</h1>

                <div style="display: none;">
                    <xsl:copy-of select="/http:request"/>
                </div>
                <p>Added call from <xsl:value-of select="$newcall/item[1]/items/item[4]"/></p>
                <div id="backtolist"><a href="/">Back to list</a></div>
            </body>
        </html>
    </xsl:template>

</xsl:stylesheet>
