#!/usr/bin/python

# Handle http requests for XRT
# Copyright (C) 2006 by Tapsell-Ferrier Limited

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to the
# Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301  USA

"""
Python based server.

Simplifies the testing of XRT.
"""

import BaseHTTPServer
import cgi
import mimetools
import os
import os.path
import shutil
import sys
import urllib
import logging

from StringIO import StringIO
import http_handler


__version__ = "0.1"


class IterableMessage(mimetools.Message): # have to use this deprecated class right now because it's how python is built
    def iteritems(self):
        for key,val in self.items():
            yield key,val
        return
    
    
class XRTHTTPRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):
    """
    XRT http handler.
    """

    MessageClass = IterableMessage
    
    def handle_one_request(self):
        """Handle a single HTTP request. Pinched from python."""

        self.raw_requestline = self.rfile.readline()
        if not self.raw_requestline:
            self.close_connection = 1
            return

        if not self.parse_request(): # An error code has been sent, just exit
            return


        # FieldStorage MUST have be told about the HTTP method
        spoof_env = { "REQUEST_METHOD": self.command }
        params = cgi.FieldStorage(self.rfile, self.headers, "", spoof_env)

        # Make sure this is valid - cgi creates an excepting fs if there are no params
        try:
            params.keys()
        except:
            params = {}

        if os.path.exists(os.getcwd() + "/top.xslt"):
            (sc, msg) = http_handler.http_handle(os.getcwd() + "/top.xslt",
                                                 self.command,
                                                 self.path,
                                                 self.headers,
                                                 params)

            if sc >= 200 and sc < 300:
                self.send_response(sc, self.responses[sc])
            else:
                self.send_error(sc, self.responses[sc])

            # Dump out the header
            for key,value in msg.items():
                if key != "From":
                    self.send_header(key, urllib.quote(value))
            self.end_headers()
            self.wfile.write(msg.get_payload())

        else:
            self.send_error(sc, msg)

        return


def run(HandlerClass = XRTHTTPRequestHandler,
        ServerClass = BaseHTTPServer.HTTPServer):
    BaseHTTPServer.test(HandlerClass, ServerClass)


if __name__ == '__main__':
    import pdb
    import libxml2

    # URI resolver... this is really dumb but it kinda works for now.
    def xrt_resolver(url, id, ctxt):
        if os.path.exists(url):
            return open(url)
        else:
            base = os.path.basename(url)
            dir = os.path.dirname(url) + "/../"
            while os.path.abspath(dir + base) != "/" \
                      and not os.path.exists(dir + base):
                dir = dir + "../"
            return open(dir + base)

    libxml2.setEntityLoader(xrt_resolver)

    def setup_logging():
        hdlr = logging.StreamHandler(sys.stderr)
        hdlr.setFormatter(logging.Formatter('%(asctime)s %(name)s %(lineno)d %(message)s'))
        logging.getLogger().addHandler(hdlr)
        logging.getLogger().setLevel(logging.ERROR)

    setup_logging()

    sys.path = sys.path + [ os.getcwd() ]
    run()

# End
