#!/usr/bin/python
# Copyright (C) 2006 by Tapsell-Ferrier Limited

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to the
# Free Software Foundation, Inc.,   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA


import gadfly
import os


dbtest_name = "dbtest"


def init_db():
    """init the db"""
    os.mkdir(dbtest_name)
    connection = gadfly.gadfly()
    connection.startup("mydatabase", dbtest_name)
    cursor = connection.cursor()
    cursor.execute("create table account (id integer, name varchar, amount float)")
    cursor.execute("insert into account(id, name, amount) values (1, 'nic', 33.00)")
    cursor.execute("insert into account(id, name, amount) values (2, 'cjt', 197.00)")
    cursor.execute("insert into account(id, name, amount) values (3, 'lwf', 196.00)")
    connection.commit()
    connection.close()
    return None


def list_account():
    dbcon = gadfly.gadfly("mydatabase", dbtest_name)
    curs = dbcon.cursor() 
    curs.execute("select id, name, amount from account")
    result = curs.fetchone()
    while result != None:
        yield result
        # Use an exception to catch the error... not sure why gadfly doesn't behave as other pydb's
        try:
            result = curs.fetchone()
        except:
            result = None
    dbcon.close()
    return


def test():
    for x in list_account():
        print x    

# Initialize the database
if not os.path.exists(dbtest_name):
    init_db()


# Command line interface
if __name__ == "__main__":
    import pdb
    test()
   

# End
