/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  

  

#include "xrebind.h"
#include "xrb_strings.h"




void
set_no_repeat ( int code , int on_or_off) 
{
  XKeyboardControl xkbd_ctl ; 

  XKeyboardState xkbd_state ; 

  XGetKeyboardControl ( xrb_data->data_display, &xkbd_state);
  xrb_verbose ("   Global autorepeat            = %d \n", 
	       xkbd_state.global_auto_repeat);
  xrb_verbose ("          autorepeat            = %d \n", 
	       xkbd_state.auto_repeats[code]);
  xrb_verbose ("          AutoRepeatModeOn      = %d \n", 
	       AutoRepeatModeOn);
  xrb_verbose ("          AutoRepeatModeOff     = %d \n", 
	       AutoRepeatModeOff);
  xrb_verbose ("          AutoRepeatModeDefault = %d \n", 
	       AutoRepeatModeDefault);


  xkbd_ctl.key_click_percent = 0 ;
  xkbd_ctl.bell_percent      = 0 ;
  xkbd_ctl.bell_pitch        = 0 ;
  xkbd_ctl.bell_duration     = 0 ;
  xkbd_ctl.led               = 0 ;
  xkbd_ctl.led_mode          = 0 ;
  xkbd_ctl.key               = code;
  if ( on_or_off == XREBIND_REPEAT_OFF) 
    {
      xrb_verbose ("  AutoRepeatModeOff \n");
      xkbd_ctl.auto_repeat_mode  = AutoRepeatModeOff ; 
    }
  else
    { 
      xrb_verbose ("  AutoRepeatModeDefault\n");
      xkbd_ctl.auto_repeat_mode  =  AutoRepeatModeOn ; 
    }
  
  xrb_verbose ("   Handling autorepeat on keycode:%d\n", code);
  XChangeKeyboardControl ( xrb_data->data_display, 
			   KBKey | KBAutoRepeatMode,
			   &xkbd_ctl);
			  
  XGetKeyboardControl ( xrb_data->data_display, &xkbd_state);
  xrb_verbose ("   Global autorepeat            = %d \n", 
	       xkbd_state.global_auto_repeat);
  xrb_verbose ("          autorepeat            = %d \n", 
	       xkbd_state.auto_repeats[code]);
  xrb_verbose ("          AutoRepeatModeOn      = %d \n", 
	       AutoRepeatModeOn);
  xrb_verbose ("          AutoRepeatModeOff     = %d \n", 
	       AutoRepeatModeOff);
  xrb_verbose ("          AutoRepeatModeDefault = %d \n", 
	       AutoRepeatModeDefault);
}



/* ************************************************************ */

int
get_modifier(xrb_prog_data *xd,  char *mod_strs) 
{
  int ret=0;
  int try_ret;
  char *tmp;
  char mod_head[20]="";
  char mod_tail[40]="";
  int i;
  int last=0;
  int len=strlen(mod_strs);
  int found=0;
  static int _level=0;
  int level=_level;
  xrb_rem_blanks(mod_strs);

  _level++;
  
/*   xrb_verbose ("%d ---> get_modifier:\"%s\"\n", level, mod_strs); */
  tmp=mod_strs;
  
  if (!is_last(xd, tmp)==1)
    {
      for (i=0;  (i<len) ; i++)
	{
	  if (tmp[i]=='+')
	    {
	      found=1;
	      strncpy (mod_head, tmp, i); 
	      tmp+=(sizeof(char)*i+1);
	      
	      strcpy (mod_tail, tmp); 
	      ret |= get_modifier_sub (xd, mod_head);
	      ret |= get_modifier (xd, mod_tail);
	      break;
	    }
	}
    }
  else
    {
      ret |= get_modifier_sub (xd, tmp);
/*       xrb_verbose ("%d ---- get_modifier LAST :\"%s\"  ret=%d\n",  */
/* 		   level, tmp, ret); */
      
    }
/*   xrb_verbose ("%d <--- get_modifier:\"%s\" --- ret=%d\n",  */
/* 	       level, mod_strs, ret); */
  return ret;
}


int
get_modifier2(xrb_prog_data *xd,  char *mod_strs) 
{
  int ret=0;
  int try_ret;
  char *tmp;
  char mod_head[20]="";
  char *mod_tail=NULL;
  int i;
  int last=0;
  int len=strlen(mod_strs);
  int found=0;
  static int _level=0;
  int level=_level;
  xrb_rem_blanks(mod_strs);

  _level++;
  
/*   xrb_verbose ("%d ---> get_modifier:\"%s\"\n", level, mod_strs); */
  tmp=mod_strs;
  
  strcpy (mod_head, mod_strs); 
  for (i=0;  (i<len) ; i++)
    {
      if (tmp[i]=='+')
	{
	  found=1;
	  /* xrb_verbose ("\thead:\"%s\"   tmp:\"%s\"\n", mod_head, tmp);*/
	  strncpy (mod_head, tmp, i); 
	  tmp+=(sizeof(char)*i+1);
	  mod_tail=(char*) malloc (sizeof(char)*strlen(tmp));
	  strcpy (mod_tail, tmp); 
	  
/* 	  xrb_verbose ("\t %d head:\"%s\"   tail:\"%s\"\n",  */
/* 		       level, mod_head, mod_tail); */
	  if ( (try_ret=get_modifier(xd, mod_tail)) != -1)
	    {
/* 	      xrb_verbose ("\t %d PLACE 3 %s\n", level, mod_tail); */
	      free (mod_tail);
	      ret |= try_ret;
	    }
	  else
	    {
/* 	      xrb_verbose ("\t %d PLACE 4\n", level); */
	      free (mod_tail);
	      ret=-1;
/* 	      xrb_verbose (" ERROR 12\n"); */
	      exit(0);
	      break;
	    }
	  break;
	}
    }

/*   xrb_verbose ("\t %d PLACE 8 really getting \"%s\" \"%s\" \"%s\" \n",  */
/* 	       level, mod_strs, mod_head, mod_tail); */
  if ( (try_ret=get_modifier_sub(xd, mod_strs)) != -1)
    {
/*       xrb_verbose ("\t %d PLACE 1 (%s)\n", level, mod_head); */
      ret |= try_ret;
    }
  else
    {
/*       xrb_verbose ("\t %d PLACE 2\n", level); */
        ;
      //	  break;
    }
  /*    }*/
/*   xrb_verbose ("%d <--- get_modifier:\"%s\" --- ret=%d\n",  */
/* 	       level, mod_strs, ret); */
  return ret;
}


int
get_modifier_from_mapping_sub(Display *display, char *mod_str) 
{
  XModifierKeymap *mod_keymap;
  KeyCode *keycode_ptr;
  KeySym my_keysym;
  int i, j, max_keys;
  int ret=0;

  static const char *mod_list[8] ;
  static int         mod_list_init = 0;
  if (mod_list_init==0)  
    {
      int i =0 ;
      mod_list_init = 1;
      mod_list[i++] = XREBIND_MODIFIER_SHIFT_MASK;
      mod_list[i++] = XREBIND_MODIFIER_LOCK_MASK;
      mod_list[i++] = XREBIND_MODIFIER_CONTROL_MASK;
      mod_list[i++] = XREBIND_MODIFIER_MOD1MASK;
      mod_list[i++] = XREBIND_MODIFIER_MOD2MASK;
      mod_list[i++] = XREBIND_MODIFIER_MOD3MASK;
      mod_list[i++] = XREBIND_MODIFIER_MOD4MASK;
      mod_list[i++] = XREBIND_MODIFIER_MOD5MASK ;
    }
  

  mod_keymap = XGetModifierMapping(display);
  max_keys = mod_keymap->max_keypermod;
  keycode_ptr = mod_keymap->modifiermap;
  for (i = 0; i < 8; i++) {
    for (j = 0; j < max_keys; j++) {
      my_keysym = XKeycodeToKeysym(display, *keycode_ptr, 0);

      if (XKeysymToString(my_keysym)!=NULL)
	{
	  if (xrb_check (mod_str, 
			 XKeysymToString(my_keysym),
			 XKeysymToString(my_keysym)))
	    {
	      ret |= get_modifier_sub(NULL, mod_list[i]);
/* 	      xrb_verbose ("= %s --> %s .... returning MASK=%d\n",  */
/* 			   mod_str, mod_list[i], ret); */
	      return ret;
	    }
	  else
	    {
	      ;
	    }
	}
      else
	{
	  ;
	}
      keycode_ptr++;
    }
  }
  return ret;
}

int
get_modifier_from_mapping(Display *display, char *mod_str) 
{
  XModifierKeymap *mod_keymap;
  KeyCode *keycode_ptr;
  KeySym my_keysym;
  int i, j, max_keys;
  int ret;

  
  /* xrebind syntax related translations */
  if (xrb_check(mod_str, "Alt", "Alt"))
    {
      ret = get_modifier_from_mapping_sub(display, XREBIND_MODIFIER_ALT_L);
      ret |= get_modifier_from_mapping_sub(display, XREBIND_MODIFIER_ALT_R);
    }
  else if (xrb_check(mod_str, XREBIND_MODIFIER_SHIFT, XREBIND_MODIFIER_SHIFT))
    {
      ret = get_modifier_from_mapping_sub(display, XREBIND_MODIFIER_SHIFT_L);
      ret |= get_modifier_from_mapping_sub(display, XREBIND_MODIFIER_SHIFT_R);
    }
  else if (xrb_check(mod_str, XREBIND_MODIFIER_CONTROL, XREBIND_MODIFIER_CONTROL))
    {
      ret = get_modifier_from_mapping_sub(display, XREBIND_MODIFIER_CONTROL_L);
      ret |= get_modifier_from_mapping_sub(display, XREBIND_MODIFIER_CONTROL_R);
    }
  else if (xrb_check(mod_str, XREBIND_MODIFIER_SCROLL, XREBIND_MODIFIER_SCROLL))
    {
      ret = get_modifier_from_mapping_sub(display, XREBIND_MODIFIER_SCROLL);
    }
  else if (xrb_check(mod_str, XREBIND_MODIFIER_CAPS, XREBIND_MODIFIER_CAPS))
    {
      ret = get_modifier_from_mapping_sub(display, XREBIND_MODIFIER_CAPS);
    }
  else
    {
      ret = get_modifier_from_mapping_sub(display, mod_str);
    }
  return ret;
}


int
get_modifier_sub(xrb_prog_data *xd,  char *mod_str) 
{
  int ret=0;
      
  if( xrb_check (mod_str, XREBIND_MODIFIER_SHIFT_MASK, XREBIND_MODIFIER_SHIFT_MASK  ) )
    {
      ret = ShiftMask;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_LOCK_MASK, XREBIND_MODIFIER_LOCK_MASK  ) )
    {
      ret = LockMask;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_CONTROL_MASK, XREBIND_MODIFIER_CONTROL_MASK  ) )
    {
      ret = ControlMask;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_MOD1MASK, XREBIND_MODIFIER_MOD1MASK  ) )
    {
      ret = Mod1Mask;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_MOD2MASK, XREBIND_MODIFIER_MOD2MASK  ) )
    {
      ret = Mod2Mask;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_MOD3MASK, XREBIND_MODIFIER_MOD3MASK  ) )
    {
      ret = Mod3Mask;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_MOD4MASK, XREBIND_MODIFIER_MOD4MASK  ) )
    {
      ret = Mod4Mask;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_MOD5MASK, XREBIND_MODIFIER_MOD5MASK  ) )
    {
      ret = Mod5Mask;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_ANYMODIFIER, "any"  ) )
    {
      ret = AnyModifier;
    }
  else if( xrb_check (mod_str, XREBIND_MODIFIER_NONE, "0"  ) )
    {
      ret = 0;
    }
  else 
    {

      /* prevent recursive disaster ... */
      if (xd==NULL)
	{
	  ret = 0;
	}
      else
	{
	  ret = get_modifier_from_mapping( xd->data_display, mod_str);
	}
    }

/*   xrb_verbose (" get_modifier_sub return %d\n", ret); */
  return ret;
}

