/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  



  

#include "xrebind.h"


void 
xrb_signal_handler(int sig) 
{
  static int call_ctr = 0;

  if (call_ctr == 0)
    {
      call_ctr=1;
    }
  else
    {
      return;
    }
  xrb_verbose ("Inside handler sig=%d\n",sig);
  
  switch (sig)
    {
    case SIGINT:
      xrb_verbose ("SIGINT\n");
      xrb_close_down (xrb_data);
      exit (0);
      break;
    case SIGTERM:
      xrb_verbose ("SIGTERM\n");
      xrb_close_down (xrb_data);
      exit (0);
      break;
    default:
      xrb_error ( "signal_handler error .... "
		  "unxpected signal (%d)\n .... leaving", sig);
      xrb_close_down (xrb_data);
      exit (sig);
    }
}


int
xrb_err_handler(Display* dpy, XErrorEvent* ev)
{
  int len=100;
  char tmp[len];
  
  xrb_error ("xrb - X11 error handler \n");
  xrb_error ("   type       %d \n",  ev->type);
  xrb_error ("   serial     %lu \n", ev->serial);
  xrb_error ("   error code %lu \n", ev->error_code);
  xrb_error ("   major code %lu \n", ev->request_code);
  xrb_error ("   minor code %lu \n", ev->minor_code);
  
  XGetErrorText (dpy, ev->error_code, tmp, len);
  xrb_error ("   Message: %s\n", tmp);
  return 0;
}




int
xrb_action_handler( xrb_prog_data *xd, XEvent *my_event)
{
  int j;
  char exec_command[256];

  Display   *dpy  ;
  int        tmp_code ; 
  int        tmp_modifier ; 
  int        r_type ;
  int        g_type ;
  int        g_button_nr ;
  int        g_keycode ;
  int        g_direction ;
  int        g_speed ;
  int        g_y ;
  int        g_x ;
  int        g_fake_release ;
  int        g_fake_release_delay ;
  char      *g_command;
  char      *g_comment;
  grab_data *g_data; 


  static int key_presses = 0;
  int  is_button = 0;
  int  is_key    = 0;
  int  i ;

  r_type        = my_event->type;
  dpy           = xrb_data->data_display;


  if ( (r_type == KeyPress) ||  (r_type == KeyRelease) )
  {
      is_button = 0;
      is_key    = 1;
      tmp_modifier  = my_event->xkey.state;
      tmp_code      = my_event->xkey.keycode;
  }
  else if ( (r_type == ButtonPress) ||  (r_type == ButtonRelease) )
  {
      is_button = 1;
      is_key    = 0;
      tmp_modifier  = my_event->xbutton.state;
      tmp_code      = my_event->xbutton.button;
  }

  for (j=0 ; j<xrb_data->gdl_size ; j++)
    {
      if ( (
	    ( (  is_key &&
		 (xrb_data->grab_data_list[j]->code   == tmp_code)  )|| 
	      ( is_button &&
		(xrb_data->grab_data_list[j]->button == tmp_code) ))
	    &&
	    ( (xrb_data->grab_data_list[j]->modifier==tmp_modifier) 
	      ||
	      (xrb_data->grab_data_list[j]->modifier==AnyModifier)
	      )
	    ))
	{
	  g_data      = xrb_data->grab_data_list[j];
	  g_type      = g_data->type;
	  g_button_nr = g_data->xrb_action.ba.nr ; 
	  g_keycode   = g_data->xrb_action.ka.keycode ; 
	  g_speed     = g_data->xrb_action.ma.speed;
	  g_x         = g_data->xrb_action.ma.x_direction ;
	  g_y         = g_data->xrb_action.ma.y_direction ;
	  g_command   = g_data->xrb_action.ea.command_line ;
	  g_comment   = g_data->comment ;
	  g_fake_release       = g_data->fake_release;
	  g_fake_release_delay = g_data->fake_release_delay;

	  if (g_type==XREBIND_BUTTON)
	    {
	      if ( g_fake_release != 0 )
		{
		  if ( ( r_type==KeyPress) || ( r_type==ButtonPress) )
		    {
		      xrb_verbose ("  XTestFakeButtonEvent ( "
				   "%d, %d, %d, %d)\n",
				   dpy, 
				   g_button_nr, 
				   True, 0);
		      XTestFakeButtonEvent ( dpy, 
					     g_button_nr, 
					     True, 
					     0);
		      usleep(g_fake_release_delay*1000);
		      xrb_verbose ("  XTestFakeButtonEvent ( "
				   "%d, %d, %d, %d)\n",
				   dpy, 
				   g_button_nr, 
				   False, 0);
		      XTestFakeButtonEvent ( dpy, 
					     g_button_nr, 
					     False, 
					     0);
		      
		      
		    }
		}
	      else
		{
		  if ( ( r_type==KeyPress) || ( r_type==ButtonPress) )
		    {
		      xrb_verbose ("  XTestFakeButtonEvent ( "
				   "%d, %d, %d, %d)\n",
				   dpy, 
				   g_button_nr, 
				   True, 0);
		      XTestFakeButtonEvent ( dpy, 
					     g_button_nr, 
					     True, 
					     0);
		    }
		  else
		    {
		      xrb_verbose ("  XTestFakeButtonEvent"
				   "( %d, %d, %d, %d)\n",
				   dpy, g_button_nr, False, 0);
		      XTestFakeButtonEvent (dpy, g_button_nr, False, 0);
		    }
		}
	    }
	  else if (g_type==XREBIND_MOTION)
	    {			  
	      if ( ( r_type==KeyPress) ||  ( r_type==ButtonPress) )
		{
		  xrb_verbose ("  XTestFakeRelativeMotionEvent"
			       "(%d, %d, %d, %d)\n",
			       dpy, 
			       g_x * g_speed ,
			       g_y * g_speed ,
			       0);
		  XTestFakeRelativeMotionEvent (dpy, 
						g_x * g_speed ,
						g_y * g_speed ,
						0);
		}
	      else
		{
		  xrb_verbose ("  MOTION (release) ----   TODO %d\n", r_type);
		}
	    }
	  else if (g_type==XREBIND_EXEC)
	    {
	      if ( ( r_type==KeyPress) ||  ( r_type==ButtonPress) )
		{
		  add_feedback ("");
		  add_feedback (g_comment);
		  feedback ();

		  if ( g_data->xrb_action.ea.fork )
		    {
                        xrb_verbose ("  Executing (fork) %s\n", g_comment);
                        strcpy(exec_command, g_command);
                        xrb_remove_trailing_nl( exec_command );
                        strcat(exec_command, " &");
                        system (exec_command);
		    }
		  else
		    {
                        xrb_verbose ("  Executing (no fork) %s\n", g_comment);
                        system (g_command); 
		    }
		}
	      else
		{
		  xrb_verbose ("  Execute release ----   TODO  type=%d\n", r_type);
		}
	    }
	  else if (g_type==XREBIND_KEY)
	    {
	      xrb_verbose ("--->   XREBIND_KEY\n");
	      if ( r_type==KeyPress)
		{
                    xrb_verbose ("   Hold the faking of key pres\n");
                    key_presses++;
		    xrb_verbose ("   XTestFakeKeyEvent ( %d, %d, %d, %d)  press nr %d\n",
				 dpy, g_keycode, 1, 0, key_presses);
		    XTestFakeKeyEvent ( dpy, g_keycode, 0, 10); 

		    usleep(10000);
                    xrb_verbose ("   XTestFakeKeyEvent ( %d, %d, %d, %d)  relese\n",
                                 dpy, g_keycode, False, 0);
                    XTestFakeKeyEvent ( dpy, g_keycode, 1, 100);
		}
	      else
		{
		  /*
                    for (i=0;i<key_presses;i++)
                    {
                        xrb_verbose ("   XTestFakeKeyEvent ( %d, %d, %d, %d)  press nr %d\n",
                                     dpy, g_keycode, False, 0, i);
                        XTestFakeKeyEvent ( dpy, g_keycode, 1, 10); 
                    }
                    key_presses=0;
                    usleep(100);
                    xrb_verbose ("   XTestFakeKeyEvent ( %d, %d, %d, %d)  relese\n",
                                 dpy, g_keycode, False, 0);
                    XTestFakeKeyEvent ( dpy, g_keycode, 0, 100);
		  */
		}
	      xrb_verbose ("<---   XREBIND_KEY\n");
	    }
	  else
	    {
	      xrb_verbose ("XREBIND ... found neither a"
			   "motion or button to that key\n");
	    }
	}
      else
	{
            ;
	}
    }		  
}
