/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  

#ifndef XREBIND_XRB_REOSURCE_H
#define XREBIND_XRB_RESOURCE_H  

#include "xrebind.h"

int
parse_line (xrb_prog_data* xd,
	    char *str, 
	    grab_data *gd, 
	    int fill);

int
rc_lines(xrb_prog_data *xd, int fill);

int 
xrb_open_rc_file (xrb_prog_data *xd);

char *
xrb_move_ptr_to_argument(char *tmp);

int 
get_action_type (xrb_prog_data* xd,char *str);

int 
add_argument (xrb_prog_data* xd, 
	      grab_data *gd, 
	      char *str, 
	      int action_arg);

int 
add_exec_argument (xrb_prog_data* xd, 
		   grab_data *gd, 
		   char *str, int 
		   action_arg);

int 
add_key_argument (xrb_prog_data* xd, 
		  grab_data *gd, 
		  char *str, 
		  int action_arg);

int 
add_button_argument (xrb_prog_data* xd, grab_data *gd, 
		     char *str, int action_arg);

int 
add_motion_argument (xrb_prog_data* xd, grab_data *gd, char *str);

int 
get_key_code (xrb_prog_data* xd,char *_buf);

int 
get_key (xrb_prog_data* xd,char *_buf);

int 
get_button (xrb_prog_data* xd,char *_buf);


#endif /* XREBIND_XRB_RESOURCE_H */
