/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  

#ifndef XREBIND_XRB_HELPER_H
#define XREBIND_XRB_HELPER_H

  

#include "xrebind.h"

int
xrb_remove_trailing_nl( char *str );


/*  
 *  Checks if the first argument equals to any of the other two 
 *   and returns 1 if that's the case, else it returns 0            
 *
 */
int 
xrb_check ( char *arg, char *long_arg , char *short_arg ) ;

/*  
 *  Checks if the first argument equals to the other
 *  and returns 1 if that's the case, else it returns 0            
 *  Checks only the strings for the length of the first str.
 *
 */
int 
xrb_ncheck ( char *arg, char *long_arg ) ;


int
intstr2int(char *arg);

int
boolstr2int (char *arg);

char *
str_strip( char *str );

int 
xrb_strip(char *str) ;

int 
is_comment_or_blank (char *str) ;

int
xrb_rem_blanks_impl (char *array, int mode);

int
xrb_rem_blanks (char *array);

int
xrb_rem_leading_blanks (char *array);


int 
is_last (xrb_prog_data *xd,  char *mod_strs) ;

void
xrb_print_chars ( char **str_arr);


void
xrb_print_opt_chars ( char **str_arr);

void 
xrb_verbose (char *msg, ...);

void 
xrb_error (char *msg, ...);

void
xrb_print_settings(xrb_prog_data *xd);

void
verbose_gd (grab_data *gd);

int
xrb_set_action(xrb_prog_data *xd, char *tmp) ;

int 
count_rc_lines (xrb_prog_data *xd);

void
add_all_data(xrb_prog_data *xd);

void
xrb_version(void);

#endif /* XREBIND_XRB_HELPER_H */
