/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  


  

#include "xrebind.h"
#include "xrb_strings.h"
#include "xrb_helper.h"
#include "xrb_resource.h"


int
parse_line (xrb_prog_data* xd,char *str, grab_data *gd, int fill)
{
  char *tmp=str;
  char *buf ;
  int tmp_member;
  int type;
  int nr;
  char test_[strlen(str)];

  xrb_rem_leading_blanks (tmp);
  
  /*
   *   Action tags (Execute, FakeMotion ....)
   */
  if (xrb_ncheck(XREBIND_ACTION_TAG, tmp))
    {
      /* get action type */
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->type=get_action_type (xd, tmp);
      init_type(gd);
    } 
  /*
   *   Grab tags ( key, keycode, button )
   */
  else if (xrb_ncheck(XREBIND_KEYCODE_TAG, tmp))
    {
        if ( gd->button != 0 )
	{
	  fprintf(stderr, "Parse error: Grabbing key when button is already grabbed \n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->code=get_key_code( xd, tmp);

    }
  else if (xrb_ncheck(XREBIND_KEY_TAG, tmp))
    {
      if ( gd->button != 0 )
	{
	  fprintf(stderr, "Parse error: Grabbing key when "
		  "button is already grabbed \n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->code = get_key( xd, tmp);
    }
  else if (xrb_ncheck(XREBIND_BUTTON_TAG, tmp))
    {
      if ( gd->code != 0 )
	{
	  fprintf(stderr, "Parse error: Grabbing button when key is already grabbed \n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->button=get_button(xd, tmp);
    }
  else if (xrb_ncheck(XREBIND_MODIFIER_TAG, tmp))
    {
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->modifier=get_modifier(xd, tmp);
    }
  else if (xrb_ncheck(XREBIND_AUTOREPEAT_TAG, tmp))
    {
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->autorepeat = boolstr2int(tmp);
      
    }
  else if (xrb_ncheck(XREBIND_FAKERELEASEDELAY_TAG, tmp))
    {
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->fake_release_delay = intstr2int(tmp);
    }
  else if (xrb_ncheck(XREBIND_FAKERELEASE_TAG, tmp))
    {
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->fake_release = boolstr2int(tmp);
      
    }
  /*
   *  Action arguments
   */
  else if (xrb_ncheck(XREBIND_FAKE_BUTTON, tmp))
    {
      if ( (gd->type == 0) || (gd->type != XREBIND_BUTTON) )
	{
	  fprintf(stderr, "Parse error defining fake button but not using fake button action\n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->xrb_action.ba.nr = intstr2int(tmp);
    }
  else if (xrb_ncheck(XREBIND_FAKE_KEY, tmp))
    {
        if ( (gd->type == 0) || (gd->type != XREBIND_KEY) )
	{
            fprintf(stderr, "Parse error defining fake key but not using fake key action\n");
            return XREBIND_PARSE_FAILED;
	}
        tmp = xrb_move_ptr_to_argument (tmp);
        if (tmp==NULL)
	{
            return XREBIND_PARSE_FAILED;
	}
        gd->xrb_action.ka.keycode = get_key(xd, tmp);
    }
  else if (xrb_ncheck(XREBIND_FAKE_MOTION, tmp))
    {
      if ( (gd->type == 0) || (gd->type != XREBIND_MOTION) )
	{
	  fprintf(stderr, "Parse error defining fake motion but not using fake motion action\n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      add_motion_argument (xd, gd, tmp );
    }
  else if (xrb_ncheck(XREBIND_SPEED_TAG, tmp))
    {
      if  ( (gd->type == 0) || (gd->type != XREBIND_MOTION))
	{
	  fprintf(stderr, "Parse error\n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->xrb_action.ma.speed = intstr2int(tmp);
    }
  else if (xrb_ncheck(XREBIND_EXEC_COMMAND, tmp))
    {
      if ( (gd->type == 0) || (gd->type != XREBIND_EXEC) )
	{
	  fprintf(stderr, "Parse error defining exec command but not using execute action\n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      strcpy (gd->xrb_action.ea.command_line,tmp);
    }
  else if (xrb_ncheck(XREBIND_EXEC_FORK, tmp))
    {
      if ( (gd->type == 0) || (gd->type != XREBIND_EXEC) )
	{
	  fprintf(stderr, "Parse error defining exec command but not using execute action\n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      gd->xrb_action.ea.fork = boolstr2int(tmp);
    }
  else if (xrb_ncheck(XREBIND_COMMENT_TAG, tmp))
    {
      if (gd->type == 0)
	{
	  fprintf(stderr, "Parse error\n");
	  return XREBIND_PARSE_FAILED;
	}
      tmp = xrb_move_ptr_to_argument (tmp);
      if (tmp==NULL)
	{
	  return XREBIND_PARSE_FAILED;
	}
      strcpy (gd->comment,tmp);
      xrb_remove_trailing_nl(gd->comment);
    }


  return 0;

  /* get modifier */
  buf=strtok (NULL, ",");


  /* get the rest of the args */
  while ( (buf=strtok (NULL, ","))!=NULL)
    {
      add_argument (xd, gd, buf,0);
    }
  
  verbose_gd(gd);

  return 0;
}


int
rc_lines(xrb_prog_data *xd, int fill)
{
  
  int rc_entries=0;
  int all_entries=0;
  int bytesread;
  int ret=0;
  char tmp[XREBIND_LINE_LENGTH] ;

  rc_parser_state state  = XRB_EXPR_INACTIVE ;  

  while ( fgets(tmp, XREBIND_LINE_LENGTH, xd->fd)!=NULL )
    {
      all_entries++;
      
      bytesread=strlen(tmp);
      if (bytesread==0)
	{
	  ; 
	}
      else if (is_comment_or_blank(tmp)) 
	{
	  ;
	}
      else
	{
	  xrb_rem_leading_blanks (tmp);
	  
	  if ( state == XRB_EXPR_INACTIVE )
	    {
	      if ( xrb_ncheck ( XREBIND_GRAB_EXPR_START, tmp ))
		{
		  state = XRB_EXPR_START ;
		}
	      else
		{
		  return XREBIND_PARSE_FAILED;
		}
	    } 
	  else if ( state == XRB_EXPR_START )
	    {
	      if ( xrb_ncheck ( XREBIND_GRAB_EXPR_START_TAG, tmp ))
		{
		  xd->grab_data_list = alloc_grab_data (xd->grab_data_list, xd);
		  state = XRB_EXPR_DEFINING_DATA ;
		}
	      else
		{
		  return XREBIND_PARSE_FAILED;
		}
	    }
	  else if ( state == XRB_EXPR_DEFINING_DATA )
	    {
	      if ( xrb_ncheck ( XREBIND_GRAB_EXPR_STOP_TAG, tmp ))
		{
		  state = XRB_EXPR_INACTIVE;
		  rc_entries++;
		}
	      else
		{
 		  ret = parse_line (xd, tmp,xd->grab_data_list[rc_entries],fill); 
		  if (ret)
		    {
		      xrb_verbose ("Error in config file (line %d) \n", all_entries);
		      exit (ret);
		    }
		}
	    }
	}
    }
   return rc_entries;
}

int 
xrb_open_rc_file (xrb_prog_data *xd)
{
  char   rc_buf[100];
  char  *rc_file;  

  xrb_verbose ("Open rc file\n");
  
  /* */
  if ( xd->cli_rc != NULL )
    {
      xrb_verbose ("cli file=%s\n", xd->cli_rc);
      xd->fd = fopen (xd->cli_rc,"r");
      xrb_verbose ("cli file=%s called  %d---\n", xd->cli_rc, xd->fd);
      if (xd->fd==NULL)
	{
	  xrb_verbose ("Couldn't find %s\n", xd->cli_rc);
	}
      else
	{
	  xrb_verbose ("found %s (%d)\n", xd->cli_rc, xd->fd);
	  return 1;
	}
    }

  /* Try environment variable first */
  rc_file=getenv(PROGRAM_RC_ENV);
  if (rc_file!=NULL)
    {
      xrb_verbose ("Trying \"%s\"\n", rc_file);
      xd->fd = fopen (rc_file,"r");
      if (xrb_data->fd==NULL)
	{
	  xrb_verbose ("Couldn't find %s\n", rc_file);
	}
      else
	{
	  xrb_verbose ("found %s (%d)\n", rc_file, xd->fd);
	  return 1;
	}
    }
  

  /* Perhaps we have a local rc file */ 
  rc_file=getenv("HOME");
  if (rc_file!=NULL)
    {
      strcpy (rc_buf, rc_file);
      strcat (rc_buf, "/");
      strcat(rc_buf, XREBIND_LOCAL_RC);
      xrb_verbose ("Trying \"%s\"\n", rc_buf);
      xd->fd = fopen (rc_buf,"r");
      if (xrb_data->fd==NULL)
	{
	  xrb_verbose ("Couldn't find %s\n", rc_buf);
	}
      else
	{
	  return 1;
	}
    }

  /* OK, let's try the system rc file */
  xrb_verbose ("Trying %s\n", XREBIND_SYSTEM_RC);
  xd->fd = fopen (XREBIND_SYSTEM_RC,"r");
  if (xrb_data->fd==NULL)
    {
      xrb_verbose ("Couldn't find %s\n", XREBIND_SYSTEM_RC);
    }
  else
    {
      return 1;
    }
  return 0;
}



char *
xrb_move_ptr_to_argument(char *tmp)
{
  do 
    {
      tmp++;
    } while ( (tmp[0] != '=') && (tmp[0] != '\0')) ;
  
  if (tmp==NULL)
    {
      return NULL;
    }
  xrb_rem_leading_blanks(tmp);
  if (tmp==NULL)
    {
      return NULL;
    }
  tmp ++ ;
  if (tmp==NULL)
    {
      return NULL;
    }
  xrb_rem_leading_blanks(tmp);
  return tmp;
}

int 
get_action_type (xrb_prog_data* xd,char *str)
{
  int ret;
  xrb_rem_blanks(str);
/*   xrb_verbose ("\tget_type:\"%s\"\n", str); */
  if (xrb_ncheck (XREBIND_ACTION_EXEC, str ))
    {
      ret = XREBIND_EXEC;
    }
  else if (xrb_ncheck (XREBIND_ACTION_MOTION, str ))
    {
      ret = XREBIND_MOTION;
    }
  else if (xrb_ncheck (XREBIND_ACTION_BUTTON, str ))
    {
      ret = XREBIND_BUTTON;
    }
  else if (xrb_ncheck (XREBIND_ACTION_KEY, str ))
    {
      ret = XREBIND_KEY;
    }
  else
    {
/*       xrb_verbose ("--- get_type we AINT got nothing\n", str); */
      ret = -1;
    }
  return ret;
}


int 
add_argument (xrb_prog_data* xd, grab_data *gd, char *str, int action_arg)
{
  xrb_verbose ("\tadding type=%d\targument=%s\n", gd->type, str); 
  switch (gd->type)
    {
    case XREBIND_BUTTON:
/*       add_button_argument (xd, gd, str, action_arg); */
      break;
    case XREBIND_EXEC:
/*       add_exec_argument (xd, gd, str, action_arg); */
      break;
    case XREBIND_MOTION:
/*       add_motion_argument (xd, gd, str, action_arg); */
      break;
    case XREBIND_KEY:
/*       add_key_argument (xd, gd, str, action_arg); */
      break;
    default:
      xrb_verbose ("adding nothing .... :(\n"); 
      break;
    }
}

int 
add_exec_argument (xrb_prog_data* xd, grab_data *gd, char *str, int action_arg)
{
  if ( action_arg == 1 )
    {
      strcpy (gd->xrb_action.ea.command_line,str);
    }
  else
    {
      xrb_rem_blanks (str); 
      if (xrb_check (str, "NoFork", "NoFork"))
	{
	  ;
	}
      else if (xrb_check (str, "Fork", "Fork"))
	{
	  strcat (gd->xrb_action.ea.command_line," &");
	}
      else if (xrb_check (str, "NoAutoRepeat", "NoAutoRepeat"))
	{
	  gd->autorepeat=XREBIND_REPEAT_OFF;
	}
      else if (xrb_check (str, "AutoRepeat", "AutoRepeat"))
	{
	  gd->autorepeat=XREBIND_REPEAT_ON;
	}
      else if (strncmp (str, "Comment=", strlen("Comment="))==0)
	{
	  char *tmp=str;
	  char speed_buf[300];
	  tmp+=strlen("Comment=");
	  strcpy(gd->comment, tmp);
	  gd->comment[strlen(gd->comment)-1]='\0';
	}
    }

  xrb_verbose ("\t   exec argument= %s\n",   gd->xrb_action.ea.command_line); 
  xrb_verbose ("\t   exec comment = %s\n",   gd->comment); 
}



int 
add_key_argument (xrb_prog_data* xd, grab_data *gd, char *str, int action_arg)
{
  xrb_rem_blanks (str);

  if ( action_arg == 1 )
    {
      if ( sscanf ( str, "%d", &gd->xrb_action.ka.keycode) <= 0 )
	{
	  return -1;
	}
    }
  else
    {
      xrb_rem_blanks (str);
      if (xrb_check (str, "NoAutoRepeat", "NoAutoRepeat"))
	{
	  gd->autorepeat=XREBIND_REPEAT_OFF;
	}
      else if (xrb_check (str, "AutoRepeat", "AutoRepeat"))
	{
	  gd->autorepeat=XREBIND_REPEAT_ON;
	}
    }
}


int 
add_button_argument (xrb_prog_data* xd, grab_data *gd, 
		     char *str, int action_arg)
{
  xrb_rem_blanks (str);
  if ( action_arg == 1 )
    {
      if ( sscanf ( str, "%d", &gd->xrb_action.ba.nr) <= 0 )
	{
	  return -1;
	}
    }
  else 
    {
      
      if (xrb_check (str, "NoAutoRepeat", "NoAutoRepeat"))
	{
	  gd->autorepeat=XREBIND_REPEAT_OFF;
	}
      else if (xrb_check (str, "AutoRepeat", "AutoRepeat"))
	{
	  gd->autorepeat=XREBIND_REPEAT_ON;
	}
    }
}


int 
add_motion_argument (xrb_prog_data* xd, grab_data *gd, char *str)
{
  xrb_rem_blanks (str);

  if (xrb_check (str, "Up", "Up"))
    {
      gd->xrb_action.ma.x_direction=XREBIND_NO_MOTION;
      gd->xrb_action.ma.y_direction=XREBIND_MOTION_UP;
    }
  else if (xrb_check (str, "Left", "Left"))
    {
      gd->xrb_action.ma.x_direction=XREBIND_MOTION_LEFT;
      gd->xrb_action.ma.y_direction=XREBIND_NO_MOTION;
    }
  else if (xrb_check (str, "Down", "Down"))
    {
      gd->xrb_action.ma.x_direction=XREBIND_NO_MOTION;
	  gd->xrb_action.ma.y_direction=XREBIND_MOTION_DOWN;
    }
  else if (xrb_check (str, "Right", "Right"))
    {
      gd->xrb_action.ma.x_direction=XREBIND_MOTION_RIGHT;
      gd->xrb_action.ma.y_direction=XREBIND_NO_MOTION;
    }
  else
  {
      fprintf (stderr, "Parse failed when trying to find fake motion direction\n");
      return XREBIND_PARSE_FAILED;
  }
  return 0;
}


int 
get_key_code (xrb_prog_data* xd,char *_buf)
{
  int tmp_member;
  char *buf=_buf;
  xrb_rem_blanks(buf);

  xrb_verbose ("\tget_key_code:\"%s\"\n", buf);

  if ( sscanf ( buf, "%d", &tmp_member) > 0 )
    {
/*       xrb_verbose ("\tget_key_code:\"%s\"  ---> %d \n", buf, tmp_member); */
      if ( tmp_member < 1024 ) 
	{
/* 	  xrb_verbose ("\tget_key_code:\"%s\"  ---> %d \n", buf, tmp_member); */
	  return tmp_member;
	}
    }
  return -1;
}



int 
get_key (xrb_prog_data* xd,char *_buf)
{
  int tmp_member;
  char *buf=_buf;
  xrb_rem_blanks(buf);
  xrb_verbose ("\tget_key:\"%s\"\n", buf); 

  if (strlen(buf) == 1)
    {
      /* is it a letter */
      tmp_member = XStringToKeysym (buf)  ; 
      if ( tmp_member == 0 )
	{
	  fprintf (stderr, "SYNTAX ERROR\n\tCouldn't convert "
		   "string \"%s\" to an int\n",buf);
	}
      
      tmp_member = XKeysymToKeycode (xd->data_display, 
				     tmp_member);
    }
  else if (strlen(buf) == 2)
    {
      if ( ( buf[0] == 'f' ) ||
	   ( buf[0] == 'F' ) )
	{
	  tmp_member = XStringToKeysym (buf)  ; 
	  if ( tmp_member == 0 )
	    {
	      fprintf (stderr, "SYNTAX ERROR\n\tCouldn't convert "
		       "string \"%s\" to an int\n",buf);
	    }
	  tmp_member = XKeysymToKeycode (xd->data_display, 
					 tmp_member);
	}
      else
	{
	  fprintf (stderr, "perhaps SYNTAX ERROR\n\tCouldn't convert "
		   "string \"%s\" to an int\n",buf);
	}
    }
  else
    {
      fprintf (stderr, "SYNTAX ERROR\n\tCouldn't convert "
	       "string \"%s\" to an int\n",buf);
    }
  
  xrb_verbose ("\tget_key:\"%s\"  returning=%d .... ok?\n", buf, tmp_member); 
  return tmp_member;
}


int 
get_button (xrb_prog_data* xd,char *_buf)
{
  int tmp_member;
  char *buf=_buf;
  xrb_rem_blanks(buf);
  xrb_verbose ("\tget_button:\"%s\"\n", buf);

  xrb_verbose ("\tget_button: now:::: \"%s\"\n", buf);

  if ( sscanf ( buf, "%d", &tmp_member) > 0 )
    {
      return tmp_member;
    }
  else
    {
      return -1;
    }
  return 0;
}

