/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  


  

#include "xrebind.h"
#include "xrb_strings.h"
#include "config.h"

int
xrb_remove_trailing_nl( char *str )
{
  int        len;
  char      *ctmp;
  if (str == NULL)
    {
      return -1 ;
    }
  
  len  = strlen(str) ;
  ctmp = &str[len-1];
  
  if ( ctmp[0] == '\n' )
    {
      ctmp[0] ='\0';
    }
}




/*  
 *  Checks if the first argument equals to any of the other two 
 *   and returns 1 if that's the case, else it returns 0            
 *
 */
int 
xrb_check ( char *arg, char *long_arg , char *short_arg ) 
{
  return ( ! strcmp ( arg, long_arg) || ( ! strcmp ( arg, short_arg) )) ; 
}

/*  
 *  Checks if the first argument equals to the other
 *  and returns 1 if that's the case, else it returns 0            
 *  Checks only the strings for the length of the first str.
 *
 */
int 
xrb_ncheck ( char *arg, char *long_arg ) 
{
  return ( ! strncmp ( arg, long_arg, strlen(arg))); 
}


int
intstr2int(char *arg)
{
  int tmp_member;
  if ( sscanf ( arg, "%d", &tmp_member) > 0 )
    {
      return tmp_member;
    }
  else
    {
      return -1;
    }
}

int
boolstr2int (char *arg)
{
  if (xrb_ncheck(XREBIND_TRUE_TAG, arg))
    {
      return 1;
    }
  return 0;
}


char *
str_strip( char *str )
{
  char ret[ strlen(str)];
  char* p;
  char* ret_char;
  int i;

  for ( p = str; *p != 0; p++ )
    if ( *p != ' ' && *p != '\t' )
      break;

  strcpy( ret, p );
  for ( p = ret; *p != 0; p++ )
    if ( *p == ' ' || *p == '\t' )
      break;
  *p = 0;
  ret_char=(char*) malloc (sizeof (char) * strlen ( ret));
  strcpy (ret_char, ret);

  return ret_char;
}
 


int 
xrb_strip(char *str) 
{
  int i ;
  int nr_of_blanks = 0;

  int blanks_removed = 0 ;


  for (i=0 ; i<=strlen(str) ; i++)
    {
      if ( !blanks_removed && (str[i]==' ') )
	{
	  nr_of_blanks++;
	}
      else
	{
	  blanks_removed=1;
	  break;
	}
    }
  if (nr_of_blanks!=0) 
    {

      for (i=0 ; i<=strlen(str) ; i++)
	{
	  str[i]=str[i+nr_of_blanks];
	}
    }

  for (i=0 ; i<=strlen(str) ; i++)
    {
      if ((str[i]=='\n')) 
	{
	  str[i]='\0';
	}
    }
  return 1;
} 


int 
is_comment_or_blank (char *str) 
{
  if ( (str[0]=='#') || (str[0]=='\n') || (strlen(str)==0))
    { 
      return 1;
    }
  else 
    {
      return 0;
    }
}



int
xrb_rem_blanks_impl (char *array, int mode)
{
  int i=0;
  int j=0;
  int idx=-1;
  int size=strlen(array);

  for (i=0; i<size;i++)
    {
      if ( strncmp( array, "Comment=" , strlen("Comment="))==0)
	{
	  return 0;
	}
      idx++;
      if ( (array[idx]==' ') ||  (array[idx]=='\t') ||  (array[idx]=='\n') )
	{
	  for (j=idx;j<size-1;j++)
	    {
	      array[j]=array[j+1];
	    }
	  array[j]='\0';
	  idx--;
	}
      else if ( mode == XRB_REMOVE_LEADING_BLANKS ) 
	{
	  return 0;
	}
    }
}

int
xrb_rem_blanks (char *array)
{
  xrb_rem_blanks_impl(array, XRB_REMOVE_ALL_BLANKS);
}

int
xrb_rem_leading_blanks (char *array)
{
  xrb_rem_blanks_impl(array, XRB_REMOVE_LEADING_BLANKS);
}


int 
is_last (xrb_prog_data *xd,  char *mod_strs) 
{
  char *tmp;
  int i ;
  int len = strlen (mod_strs);
  tmp=mod_strs;

  for (i=0;  (i<len) ; i++)
    {
      if (tmp[i]=='+')
	{
	  //	  printf ("FOUND + in %s\n", tmp);
	  return 0;
	}
    }
  return 1;
}




void
xrb_print_chars ( char **str_arr)
{
  char **tmp;

  for (tmp=str_arr; *tmp ; tmp++)
    {
      fprintf (stdout, "\t%s\n", *tmp);
    }
}

void
xrb_print_opt_chars ( char **str_arr)
{
  int i=0; 
  char **tmp;

  for (tmp=str_arr; *tmp ; tmp++)
    {
	fprintf (stdout, "\t%s", *tmp);
        if (i++%2)
        {
            fprintf (stdout, "\n");
        }
    }
}

void 
xrb_verbose (char *msg, ...)
{
  va_list ap;
  if (xrb_data->verbose) 
    {
      va_start(ap, msg);
      vfprintf ( stderr, msg, ap );
    }
}


void 
xrb_error (char *msg, ...)
{
  va_list ap;
  if (1) 
    {
      va_start(ap, msg);
      vfprintf ( stderr, msg, ap );
    }
}






void
xrb_print_settings(xrb_prog_data *xd)
{
  int i=0;
  for (i=0;i<xd->gdl_size;i++)
    {
      xrb_verbose ("grab_data_list[%d]=%d\n",i, xd->grab_data_list[i]->type );
    }  
}




void
verbose_gd (grab_data *gd)
{
  xrb_verbose ("################### grab data ############# \n");
  xrb_verbose ("#                                         # \n");
  xrb_verbose ("#  Key              = %.4d                # \n", 
	       gd->code);
  xrb_verbose ("#  Button           = %.10d          # \n", 
	       gd->button);

  xrb_verbose ("#                                         # \n");

  xrb_verbose ("#  Modifier         = %.6d              # \n", 
	       gd->modifier);
  xrb_verbose ("#  Autorepeat       = %.1d                   # \n", 
	       gd->autorepeat);
  xrb_verbose ("#  FakeRelease      = %.1d                   # \n", 
	       gd->fake_release);
  xrb_verbose ("#  FakeReleaseDelay = %.1d                   # \n", 
	       gd->fake_release_delay);
  
  xrb_verbose ("#  Action     = ");
  switch (gd->type)
    {
    case XREBIND_BUTTON:
      xrb_verbose ("FakeButton                # \n");
      xrb_verbose ("#     Button  = %.10d                # \n", 
		   gd->xrb_action.ba.nr);
      break;
    case XREBIND_EXEC: 
      xrb_verbose ("Exec                      # \n");
      xrb_verbose ("#     command line= %s", 
		   gd->xrb_action.ea.command_line);
      xrb_verbose ("#     Fork        = %d    #\n", 
		   gd->xrb_action.ea.fork );
      break;
    case XREBIND_MOTION:
      xrb_verbose ("Motion                    # \n");
      xrb_verbose ("#     speed    = %.2d                       # \n", 
		   gd->xrb_action.ma.speed);
      xrb_verbose ("#     x direction= %.2d                     # \n", 
		   gd->xrb_action.ma.x_direction);
      xrb_verbose ("#     y direction= %.2d                     # \n", 
		   gd->xrb_action.ma.y_direction);
      break;
    case XREBIND_KEY: 
      xrb_verbose ("Key                       # \n");
      xrb_verbose ("#     Keycode    = %.10d           # \n", 
		   gd->xrb_action.ka.keycode);
      break;
    default:
      xrb_verbose ("adding nothing .... :(\n"); 
      break;
    }
  if ( gd->comment!=NULL)
    {
      xrb_verbose ("#  Comment     = %s", gd->comment);
    }
  xrb_verbose ("#                                         # \n");
  xrb_verbose ("########################################### \n");

}


int
xrb_set_action(xrb_prog_data *xd, char *tmp) 
{
  
}



int 
count_rc_lines (xrb_prog_data *xd)
{
  return rc_lines (xd,0);
}


void
add_all_data(xrb_prog_data *xd)
{
  rc_lines (xd,1);
}





/*
 * Print version information etc
 * 
 *
 */
void
xrb_version()
{
  fprintf (stderr, 
	   "Program : %s (version %s) \n",PACKAGE, VERSION);
  fprintf (stderr, 
	   "Copyright (C) 2005 Henrik Sandklef "
	   "(xrb@sandklef.com)\n");
  fprintf (stderr, 
	   "%s and comes with \n", PACKAGE);
  fprintf (stderr, 
	   "\tABSOLUTELY NO WARRANTY\n" );
  fprintf (stderr, 
	   "This is free software, and you are welcome "
	   "to redistribute\n");
  fprintf (stderr, 
	   "it under conditions as specified in GPL\n");
  fprintf (stderr, 
	   "Feel free to make a contribution to the author or the FSF\n");
  fprintf (stderr, 
	   "\n");
  fprintf (stderr, 
	   "GPL: Gnu General Public License (http://www.gnu.org) \n");
  fprintf (stderr, 
	   "FSF: Free Software Foundation (http://www.fsf.org)\n");
  fprintf (stderr, 
	   "xrebind: http://savannah.nongnu.org/projects/xrebind\n");
}
