/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  



  

#include "xrebind.h"

#ifndef XRB_NO_XOSD
#include "xosd.h"
xosd *osd;
#endif

#define FEEDBACK_SIZE 256
static char feedback_buffer[FEEDBACK_SIZE];


void 
add_feedback(char *feedback_str)
{
      strcat(feedback_buffer, feedback_str);
}


void 
reset_feedback(void)
{
  strcpy(feedback_buffer, "");
}



void 
feedback(void)
{
#ifndef XRB_NO_XOSD
  if ( osd != NULL )
    {
      xosd_display(osd,0,XOSD_string, feedback_buffer);
    }
  else
    {
#endif
      fprintf (stderr, "%s",feedback_buffer);
#ifndef XRB_NO_XOSD
    }
#endif
  reset_feedback();
}

