/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  


#ifndef XREBIND_XREBIND_H
#define XREBIND_XREBIND_H

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>



/*
 *  Error codes
 */
#define XREBIND_RC_ERROR            11 
#define XREBIND_ALLOC_FAILED        12 
#define XREBIND_DISPLAY_FAILED      13 
#define XREBIND_NOT_GRAB            14
#define XREBIND_BAD_MODIFIER        15
#define XREBIND_SETUP_FAILED        16
#define XREBIND_PARSE_FAILED        17


#define XREBIND_LOCAL_RC    ".xrbrc"
#define XREBIND_SYSTEM_RC   "/etc/xrbc"
#define XREBIND_NR_OF_KEYS  400 /* number of keys on keyboard, helps avoiding problem */
#define MAX_LINE_LENGTH 200     /*maximum length of line in rc files */
#define XREBIND_LINE_LENGTH 200 /*maximum length of rc line */

#define PROGRAM_NAME     "xrb"
#define PROGRAM_VERSION  "0.4.2"
#define PROGRAM_RC_ENV   "XREBIND_RC"
#define PROGRAM_DATE     "2002-05-14"
#define PROGRAM_URL      "http://www.sandklef.com/xrb/"
#define PROGRAM_MAIL     "xrb@sandklef.com"
#define PROGRAM_AUTHORS  "Henrik Sandklef"
#define GPL_URL          "http://www.fsf.org/copyleft/gpl.html"

#ifndef Button6
# define Button6 6
#endif
#ifndef Button6Mask
# define Button6Mask (1<<13)
#endif

#ifndef Button7
# define Button7 7
#endif
#ifndef Button7Mask
# define Button7Mask (1<<14)
#endif

#ifndef Button8
# define Button8 8
#endif
#ifndef Button8Mask
# define Button8Mask (1<<15)
#endif

#ifndef Button9
# define Button9 9
#endif
#ifndef Button9Mask
# define Button9Mask (1<<16)
#endif


#define XRB_COMMAND_LINE_SIZE      300
#define XRB_COMMENT_SIZE            300


typedef enum 
  {
    XREBIND_BUTTON = 1,
    XREBIND_MOTION,
    XREBIND_EXEC,
    XREBIND_KEY
  } xrebind_action_modes;


#define     XREBIND_PRESS         0 
#define     XREBIND_RELEASE       1 
#define     XREBIND_BUTTON_1      1 
#define     XREBIND_BUTTON_2      2 
#define     XREBIND_BUTTON_3      3 
#define     XREBIND_BUTTON_4      4 
#define     XREBIND_BUTTON_5      5 
#define     XREBIND_REPEAT_ON     1
#define     XREBIND_REPEAT_OFF    0
#define     XREBIND_SINGLE_CLICK  0       
#define     XREBIND_DOUBLE_CLICK  1     
#define     XREBIND_NO_MOTION     0
#define     XREBIND_MOTION_LEFT   -1
#define     XREBIND_MOTION_RIGHT  1 
#define     XREBIND_MOTION_UP     -1
#define     XREBIND_MOTION_DOWN   1

typedef enum
{
  XRB_EXPR_INACTIVE,
  XRB_EXPR_START,
  XRB_EXPR_DEFINING_DATA
} rc_parser_state ; 




enum 
{
  XRB_REMOVE_ALL_BLANKS,
  XRB_REMOVE_LEADING_BLANKS,
  XRB_REMOVE_TRAILING_BLANKS 
} xrb_removals ;

/*
 * Structure for Button actions
 */ 
struct _button_action
{
  int nr;
  int double_click;
} button_action;


/*
 * Structure for Motion actions
 */ 
struct _motion_action
{
  int x_direction;
  int y_direction;
  int speed;
} motion_action;


/*
 * Structure for Key actions
 */ 
struct _key_action
{
  int keycode;
} key_action;


/*
 * Structure for Exec actions
 */ 
struct _exec_action
{
  char command_line[XRB_COMMAND_LINE_SIZE];
  int  fork ; 
} exec_action;


/*
 * Structure for holding XGrab data 
 */
typedef struct _grab_data
{
  int   code;      /* which key shall be grabbed  ... */
  int   button;    /* which button shall be grabbed  ... */
  int   modifier;  /* is there a modifier together with the above code/key */
  int   autorepeat; 
  int   type;      /* What to emulate :  XREBIND_BUTTON, XREBIND_MOTION, XREBIND_KEY, XREBIND_EXEC */

  int   fake_release; /* if we shall fake a release ourself */
  int   fake_release_delay; /* delay for faked release */
  char comment[XRB_COMMENT_SIZE];
  
  union 
  {
    struct _button_action  ba;
    struct _motion_action  ma;
    struct _exec_action    ea;
    struct _key_action     ka;
  } xrb_action;

} grab_data; 




/*
 * Structure for holding xrb program data 
 */
typedef struct {
  char       *program;
  char       *version;

  char       *display_name;
  Display    *data_display;
  int         screen;
  Window      window;

  grab_data **grab_data_list;
  int         gdl_size;
/*   int         size; */

  char       *cli_rc;
  int         close_down;
  int         verbose;

  FILE       *fd;

} xrb_prog_data; 





void 
xrb_signal_handler(int);

int 
count_rc_lines (xrb_prog_data *xd);

void
add_all_data(xrb_prog_data *xd);

/*
 * Grabs or Ungrabs all data in xrb_prog_data
 *
 * int = 1      Grabs
 * int = 0      Ungrabs
 *
 */
int
grab_all_data (xrb_prog_data *xd,int);

int
rc_lines(xrb_prog_data *xd, int fill);

int
read_line (xrb_prog_data *xd,char *, grab_data *, int );

int 
is_comment_or_blank (char *str) ;

int 
xrb_strip(char *) ;

char*
str_strip(char *) ;

void 
xrb_close_down(xrb_prog_data *);


grab_data** 
new_grab_data_list();


grab_data** 
alloc_grab_data (grab_data **gd_list, xrb_prog_data *xd);

grab_data* 
new_grab_data(void);


void 
xrb_error (char *msg, ...);

void 
xrb_verbose ( char *msg, ...);



/*  
 *  Checks if the first argument is equals to any of the other two 
 *   and returns 1 if that's the case, else it returns 0            
 */
int 
xrb_check ( char *arg, char *long_arg , char *short_arg );


int 
xrb_parse_args ( xrb_prog_data *, int, char**);

int
xrb_init (xrb_prog_data *);

int 
xrb_open_rc_file (xrb_prog_data *);


void
xrb_version();

void 
set_no_repeat (int,int);


void
xrb_print_settings(xrb_prog_data*);


xrb_prog_data*
xrb_new_xrb_prog_data(void);

extern xrb_prog_data *xrb_data;




#endif /* XREBIND_XREBIND_H */
