/********************************************************************************
 *  xrebind enables synthezing button events from keyboard events
 *  Copyright (C) 2005 Henrik Sandklef
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************************
 */
  


  

#include "xrebind.h"
#include "xrb_memory.h"
#include "xrb_feedback.h"


xrb_prog_data*
xrb_new_xrb_prog_data(void)
{
  xrb_prog_data *xd;
  
  xd = (xrb_prog_data *) malloc ( sizeof (xrb_prog_data)) ;
  if (xd!=NULL)
    {
      xrb_init(xd);
    }
  return xd;
}

/**
 *
 *
 *
 */
grab_data* 
new_grab_data()
{
  grab_data *internal_gd;
  internal_gd=(grab_data *) malloc ((sizeof (grab_data)) +1);
  if (internal_gd==NULL)
    {
      exit (XREBIND_ALLOC_FAILED);
    }
  internal_gd->code           = 0;
  internal_gd->modifier       = 0;
  internal_gd->type           = -1;
  internal_gd->autorepeat     = XREBIND_REPEAT_OFF;
  return internal_gd;
}

grab_data **
alloc_grab_data (grab_data **gd_list, xrb_prog_data *xd)
{
  
  grab_data** tmp;
  int size=xd->gdl_size;
  if ( (gd_list==NULL) || (size==0) ) 
    {
      tmp = (grab_data **) calloc ( size+1, sizeof (grab_data));
      if (tmp==NULL)
	{
	  exit (XREBIND_ALLOC_FAILED);
	}
      tmp[size] = new_grab_data();
    }
  else
    {
      tmp = (grab_data **) realloc ( gd_list, (size+1)*sizeof(grab_data));
      if (tmp==NULL)
	{
	  exit (XREBIND_ALLOC_FAILED);
	}
      else
	{
	  tmp[size] = new_grab_data();
	}
    }
  xd->gdl_size++;
  return tmp;
}

int
xrb_init (xrb_prog_data *xd)
{
  xd->program=PROGRAM_NAME;
  xd->version=PROGRAM_VERSION;
  xd->gdl_size=0;
#ifndef XRB_NO_XOSD
  osd = xosd_create(2);
  if (osd!=NULL)
    {
      xosd_set_font(osd, 
		    "-adobe-helvetica-bold-r-normal-*-*-320-*-*-p-*-iso8859-1");
      xosd_set_timeout(osd, 2);
      xosd_set_pos(osd, XOSD_bottom);
      xosd_set_shadow_offset(osd, 4);
      
    }
#endif
  return 1;
}

