# xpcomp_setup.sh.in - setup script for use in bash rc file
#
#  Copyright (C) 2001 Ingo K"ohne
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

xpcompfunc() 
{ 
	xpcompcore "$1" "$2" "$3"
}

xpcomp_setup()
{
    # This file is generated by ./configure
    # Substitutions were made in the following four lines:
    local prefix=/usr
    local exec_prefix=${prefix}
    local xpcomp_so=${XPCOMP_SO:-${exec_prefix}/lib/xpcomp/xpcomp.so}
    local cache=/var/cache/xpcomp/cache

    local cmd

    OPTIND=1
    while getopts "X:C:v" option
    do
    	case "$option" in
    	X) xpcomp_so="$OPTARG"; shift; shift;;
    	v) verbose=1; shift; shift;;
    	esac
    done


    # check shared object file
    if test ! -f "$xpcomp_so"; then
	echo "No such file: $xpcomp_so." >&2
        return 1
    fi

    # check cache files
    if test -z "$*" -a ! -f "$cache"; then
	echo "No such file: $cache." >&2
	return 1
    else
	for cache in "$@"
   	do
	    if test ! -f "$cache"; then
		echo "No such file: $cache." >&2
        	return 1
    	    fi
        done
    fi

    # remove current completions
    for cmd in $(complete |sed -n 's/^complete -F xpcompfunc \([^ ]*\)$/\1/p' )
    do
	complete -r "$cmd"
    done

    # unload all cache files
    xpcomp -u > /dev/null 2>&1

    # disable all builtins
    enable -d xpcomp > /dev/null 2>&1
    enable -d xpcompcore > /dev/null 2>&1
    enable -d optcomplete > /dev/null 2>&1

    # enable builtins
    enable -f $xpcomp_so xpcomp || return 1
    enable -f $xpcomp_so xpcompcore || return 1 
    enable -f $xpcomp_so optcomplete || return 1 

    # load cache files
    if test -z "$*"; then
	xpcomp -l "$cache"
    else
	for cache in "$@"
   	do
	    xpcomp -l "$cache"
        done
    fi

    # add completions for all commands in cache which do not already have one
    for cmd in $(xpcomp -p |cut -d\  -f2- |tr ' ' '\n' |sort -u )
    do
	if complete -p "$cmd" > /dev/null 2>&1; then 
	    continue
	fi
    	complete -F xpcompfunc "$cmd"
    done
}

xpcomp_setup "$@"
