/* X Language - the eXtensible Language
 * Copyright (C) 2001 Xiong PuXiang
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef _XHASH_H_
#define _XHASH_H_

#include <xdefs.h>
#include <xobject.h>

typedef unsigned int (*HashFunc) (void* key);

typedef struct _XHashNode XHashNode;
struct _XHashNode
{
  void* key;
  void* value;
  XHashNode *next;
};

typedef struct _HashTable  XHashTable;
struct _HashTable
{
  XObject parent;

  int size;
  int nnodes;
  XHashNode **nodes;
  HashFunc hash_func;
  EqualFunc key_equal_func;
};

/* 
 *Hash tables
 */

XHashTable* x_hash_table_new (HashFunc hash_func, EqualFunc key_equal_func);

void x_hash_table_destroy (XObject *hash_table);

void* x_hash_table_find (XHashTable *hash_table, void* key);

void x_hash_table_insert (XHashTable *hash_table, void* key, void* value);

xbool x_hash_table_remove (XHashTable *hash_table, void* key);

void x_hash_table_foreach(XHashTable *hash_table, UserFunc user_func, void* data);

unsigned int x_hash_table_get_size (XHashTable *hash_table);

/* Hash Functions
 */
unsigned int direct_hash (void* v);

#endif
