/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <wnd/win32/xwnd-win32.h>

LRESULT XDefWindowProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  x_wnd_event_win32_process_event (Msg, hWnd, wParam, lParam);

  return DefWindowProc (hWnd, Msg, wParam, lParam);
}

xbool
x_wnd_window_init ()
{
  WNDCLASSEX wndclass;

  wndclass.cbSize = sizeof (WNDCLASSEX);
  wndclass.style = CS_SAVEBITS | CS_HREDRAW | CS_VREDRAW;
  wndclass.lpfnWndProc = (WNDPROC) XDefWindowProc;
  wndclass.cbClsExtra = 0;
  wndclass.cbWndExtra = 0;
  wndclass.hInstance = GetModuleHandle (NULL);
  wndclass.hIcon = NULL;
  wndclass.hCursor = LoadCursor (NULL, IDC_ARROW);
  wndclass.hbrBackground = (HBRUSH) COLOR_BACKGROUND;
  wndclass.lpszMenuName = NULL;
  wndclass.lpszClassName = "XLWndClassTopLevel";
  wndclass.hIconSm = NULL;

  RegisterClassEx (&wndclass);

  g_window_list = x_list_new ();
}

XWndWindow*
x_wnd_window_open (xstr title, xint x, xint y, xuint w, xuint h, XWndWindow* parent)
{
  XWndWindow* window;

  window = x_wnd_window_new ();
 
  if (!parent)
    {
      window->native_window = (xptr) CreateWindowEx (0, "XLWndClassTopLevel", title, 
						     WS_POPUPWINDOW | 
						     WS_CLIPCHILDREN | WS_CAPTION, 
						     x, y, w, h, NULL, NULL, 
						     GetModuleHandle (NULL), NULL);
    }
  else
    {
      window->native_window = (xptr) CreateWindowEx (0, "XLWndClassTopLevel", title, 
						     WS_CHILDWINDOW | WS_CLIPCHILDREN, 
						     x, y, w, h, (HWND) parent->native_window, NULL, 
						     GetModuleHandle (NULL), NULL);
    }

  x_list_add (g_window_list, X_OBJECT (window));

  return window;
}

xvoid
x_wnd_window_close (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_pos (XWndWindow* self, xint x, xint y)
{
  MoveWindow ((HWND) self->native_window, x, y, 100, 100, TRUE);
}

xint
x_wnd_window_get_pos_x (XWndWindow* self)
{
}

xint
x_wnd_window_get_pos_y (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_size (XWndWindow* self, xuint w, xuint h)
{
  MoveWindow ((HWND) self->native_window, 0, 0, w, h, TRUE);
}

xuint
x_wnd_window_get_size_w (XWndWindow* self)
{
  RECT rect;

  GetClientRect ((HWND) self->native_window, &rect);
  return rect.right;
}

xuint
x_wnd_window_get_size_h (XWndWindow* self)
{
  RECT rect;

  GetClientRect ((HWND) self->native_window, &rect);
  return rect.bottom;
}

xvoid
x_wnd_window_set_show (XWndWindow* self, xbool is_show)
{
  if (is_show)
    ShowWindow ((HWND) self->native_window, SW_SHOW);
  else
    ShowWindow ((HWND) self->native_window, SW_HIDE);
}

xbool
x_wnd_window_get_show (XWndWindow* self)
{
}

xvoid
x_wnd_window_redraw (XWndWindow* self)
{
  InvalidateRect ((HWND) self->native_window, NULL, FALSE);
}

XWndGC*
x_wnd_window_get_gc (XWndWindow* self)
{
  XWndGC* gc;

  gc = x_wnd_gc_new ();
  gc->native_gc = (xptr) GetDC ((HWND) self->native_window);

  return gc;
}

xvoid
x_wnd_window_release_gc (XWndWindow* self, XWndGC* gc)
{
  ReleaseDC ((HWND) self->native_window, (HDC) gc->native_gc);
}

XWndWindow*
x_wnd_window_get_parent (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_parent (XWndWindow* self, XWndWindow* parent)
{
  if (parent->native_window)
    {
      SetWindowLong ((HWND) self->native_window, GWL_STYLE, 
		     WS_CHILDWINDOW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS);
      
      SetWindowPos ((HWND) self->native_window, HWND_TOP, 0, 0, 0, 0, 
		    SWP_NOMOVE | SWP_NOSIZE | SWP_NOOWNERZORDER | SWP_NOZORDER | SWP_FRAMECHANGED);

      SetParent ((HWND) self->native_window, (HWND) parent->native_window);
    }
}

xstr
x_wnd_window_get_title (XWndWindow* self)
{
}

xvoid
x_wnd_window_set_title (XWndWindow* self, xstr title)
{
}
