/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_LANG_H_
#define __XL_LANG_H_

#include <xldefs.h>
#include <xltype.h>

extern XLExpr*   g_lang_expr;
extern xuint     g_lang_line;
extern xuint     g_lang_nberr;
extern XString*  g_lang_filename;

#define XL_LANG(obj) ((XLLang*) obj)

typedef struct _XLLang XLLang;
struct _XLLang
{
  XObject  parent;
  
  XLExpr* (*load) (XLLang* p_lang, XString* p_filename);
};

XLLang*
xl_lang_new (xstr p_filename);

XLExpr*
xl_lang_type_create (XLTypeType p_type, XLTypeArrayType p_array, xuint p_size, XString* p_class);

xvoid
xl_lang_decl_add (XLExpr* p_expr);

xvoid
xl_lang_class_create (XLExpr* p_identifier, XLExpr* p_parent);

XLExpr*
xl_lang_class_finish ();

xvoid
xl_lang_class_add (XLExpr* p_expr);

XLExpr*
xl_lang_data_string_create (xstr p_text);

XLExpr*
xl_lang_data_integer_create (xint p_int);

XLExpr*
xl_lang_data_float_create (xfloat p_value);

XLExpr*
xl_lang_data_bool_create (xbool p_bool);

XLExpr*
xl_lang_data_null_create ();

XLExpr*
xl_lang_efnct_create (xstr p_fnct);

XLExpr*
xl_lang_efnct_create1 (xstr p_fnct, XLExpr* p_expr1);

XLExpr*
xl_lang_efnct_create2 (xstr p_fnct, XLExpr* p_expr1, XLExpr* p_expr2);

XLExpr*
xl_lang_efnct_create3 (xstr p_fnct, XLExpr* p_expr1, XLExpr* p_expr2, XLExpr* p_expr3);

XLExpr*
xl_lang_efnct_create4 (xstr p_fnct, XLExpr* p_expr1, XLExpr* p_expr2, XLExpr* p_expr3, XLExpr* p_expr4);

xvoid
xl_lang_dlfnct_create (XLExpr* p_library, XLExpr* p_api, XLExpr* p_type, XLExpr* p_identifier);

xvoid
xl_lang_fnct_create (XLExpr* p_type, XLExpr* p_identifier);

xvoid
xl_lang_fnct_add_param (XLExpr* p_type, XLExpr* p_name);

xvoid
xl_lang_fnct_set_type (XLExpr* p_type);

XLExpr*
xl_lang_fnct_finish (XLExpr* p_code);

xvoid
xl_lang_fnct_opt_param ();

xvoid
xl_lang_method_create (XLExpr* p_type, XLExpr* p_identifier);

XLExpr*
xl_lang_method_finish (XLExpr* p_code);

xvoid
xl_lang_block_begin ();

xvoid
xl_lang_block_add (XLExpr* p_expr);

XLExpr*
xl_lang_block_end ();

xvoid
xl_lang_call_begin (xstr p_identifier);

xvoid
xl_lang_call_invoke_begin (XLExpr* p_expr, xstr p_identifier);

xvoid
xl_lang_call_add (XLExpr* p_expr);

XLExpr*
xl_lang_call_end ();

#endif

