/* XLanguage - the eXtensible Language
 * Copyright (C) 2002 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xapi/xaapi.h>
#include <scr/xscr.h>

xvoid
xa_scr_init ()
{
  x_scr_init ();

  xa_api_reg_fnct ("scr_clear", x_scr_clear, "void", NULL); 

  xa_api_reg_fnct ("scr_write", x_scr_write, "void", 
		   "string", "data",
		   NULL); 

  xa_api_reg_fnct ("scr_gotoxy", x_scr_gotoxy, "void", 
		   "uint", "x",
		   "uint", "y",
		   NULL); 

  xa_api_reg_fnct ("scr_get_width", x_scr_get_width, "uint", 
		   NULL); 

  xa_api_reg_fnct ("scr_get_height", x_scr_get_height, "uint", 
		   NULL); 

  xa_api_reg_fnct ("scr_set_fgcolor", x_scr_set_fgcolor, "void", 
		   "uint", "color",
		   NULL); 

  xa_api_reg_fnct ("scr_set_bgcolor", x_scr_set_fgcolor, "void", 
		   "uint", "color",
		   NULL); 
}

xvoid
xa_scr_exit ()
{
}
 
