/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xlmain.h>
#include <xlvar.h>
#include <xlexpr.h>
#include <xlclass.h>
#include <xlfield.h>
#include <stdarg.h>

XLType*
xa_api_get_type (xstr p_name)
{
  if (strcmp (p_name, "void") == 0)
    return xl_type_new (XL_TYPE_TYPE_VOID, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "bool") == 0)
    return xl_type_new (XL_TYPE_TYPE_BOOL, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "char") == 0)
    return xl_type_new (XL_TYPE_TYPE_CHAR, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "uchar") == 0)
    return xl_type_new (XL_TYPE_TYPE_UCHAR, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "short") == 0)
    return xl_type_new (XL_TYPE_TYPE_SHORT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "ushort") == 0)
    return xl_type_new (XL_TYPE_TYPE_USHORT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "int") == 0)
    return xl_type_new (XL_TYPE_TYPE_INT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "uint") == 0)
    return xl_type_new (XL_TYPE_TYPE_UINT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "float") == 0)
    return xl_type_new (XL_TYPE_TYPE_FLOAT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "double") == 0)
    return xl_type_new (XL_TYPE_TYPE_DOUBLE, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  if (strcmp (p_name, "string") == 0)
    return xl_type_new (XL_TYPE_TYPE_STRING, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);

  return NULL;
}

xvoid
xa_api_reg_const_uint (xstr p_name, xuint p_value)
{
  XLType*  l_type;
  XString* l_name;
  XLData*  l_data;
  XLVar*   l_var;

  l_type = xl_type_new (XL_TYPE_TYPE_UINT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);
  l_data = xl_data_new (l_type, NULL);
  x_unref (l_type);

  x_access (xl_data_get_raw (l_data), 0, xuint) = p_value;

  l_name = x_string_new ();
  x_string_set_str (l_name, p_name);
  l_var = xl_var_new (l_name, l_data);
  x_unref (l_data);
  x_unref (l_name);

  xl_main_add_var (g_xl_main_global, l_var, TRUE);
  x_unref (l_var);
}

xvoid
xa_api_reg_fnct (xstr p_name, xptr p_fnct, xstr p_rettype, ...)
{
  va_list  marker;
  XLFnct*  l_fnct;
  XLField* l_field;
  XLType*  l_type;
  XString* l_name;
  xstr     l_paramtype;
  xstr     l_paramname;

  l_fnct = xl_main_add_fnct_native (g_xl_main_global, p_name, p_fnct);
  l_fnct->ret_type = xa_api_get_type (p_rettype);

  va_start (marker, p_rettype);     
  l_paramtype = va_arg(marker, xstr);
  while (l_paramtype)
    {
      if (strcmp (l_paramtype, "...") == 0)
	{
	  l_fnct->opt_param = TRUE;
	}
      else
	{
	  l_paramname = va_arg (marker, xstr);
	  
	  l_type = xa_api_get_type (l_paramtype);
	  l_name = x_string_new ();
	  x_string_set_str (l_name, l_paramname);
	  
	  l_field = xl_field_new (l_name, l_type);
	  x_unref (l_type);
	  x_unref (l_name);
	  
	  xl_fnct_add_param (l_fnct, l_field);
	  x_unref (l_field);
	}

      l_paramtype = va_arg(marker, xstr);
    }  

  va_end (marker);
}
