/* Grizzly Studio - the eXtensible Language IDE
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

class GrizzlyFE
{
  GtkWidget   frame;
  GtkWidget   statusbar;
  GtkWidget   menu_bar;
  GtkWidget   menu_bar_handle_box;
  GtkWidget   toolbar;
  GtkWidget   toolbar_handle_box;
  GtkWidget   menu_project;
  GtkWidget   menu_document;
  GtkWidget   menu_run;

  GtkWidget document_view;
  
  GtkTree       project_tree;
  GtkTreeItem   tree_sources;
  GtkTreeItem   tree_windows;
  GtkTreeItem   tree_documents;

  void init_project_tree ()
    {
      GtkTree tree;

      project_tree = gtk_tree_new ();

      tree = gtk_tree_item_new_with_label ("Sources");
      gtk_tree_append (project_tree, tree);
      tree_sources = gtk_tree_new ();
      gtk_tree_item_set_subtree (tree, tree_sources);

      tree = gtk_tree_item_new_with_label ("Windows");
      gtk_tree_append (project_tree, tree);
      tree_windows = gtk_tree_new ();
      gtk_tree_item_set_subtree (tree, tree_windows);

      tree = gtk_tree_item_new_with_label ("Documents");
      gtk_tree_append (project_tree, tree);
      tree_documents = gtk_tree_new ();
      gtk_tree_item_set_subtree (tree, tree_documents);
    }

  void add_source (string name)
    {
      GtkWidget item;
      
      item = gtk_tree_item_new_with_label (name);
      gtk_tree_append (tree_sources, item);
      gtk_widget_show (item);
    }

  void save_project (string filename)
    {
      xmlDocPtr  doc;
      xmlNodePtr tree;
      xmlNodePtr subtree;

      doc = xmlNewDoc("1.0");
      doc.children = xmlNewDocNode (doc, null, "grizzly", null);

      tree = xmlNewChild (doc.children, null, "sources", null);
      subtree = xmlNewChild(tree, null, "source", null);
      xmlSetProp (subtree, "file", "calc.xc");
      subtree = xmlNewChild(tree, null, "source", null);
      xmlSetProp (subtree, "file", "grizzly.xc");

      xmlSaveFile (filename, doc);
    }
 
  void init ()
    {
      GtkWidget vbox;
      GtkWidget hbox;
      GtkWidget project_view;

      frame = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_title (frame, "X Language - Grizzly Studio 0.3");
      gtk_widget_set_usize (frame, 800, 600);

      gtk_widget_set_usize (frame, gdk_screen_width(), gdk_screen_height());


      self.init_menu ();
      toolbar_handle_box = gtk_handle_box_new ();
      toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT); 
      gtk_container_add (toolbar_handle_box, toolbar);

      /* All the rest
       */

      vbox = gtk_vbox_new (false, 0);
      hbox = gtk_hbox_new (false, 0);

      statusbar = gtk_statusbar_new ();

      gtk_box_pack_start (vbox, menu_bar_handle_box, false, false, 2);
      gtk_box_pack_start (vbox, toolbar_handle_box, false, false, 2);
      gtk_box_pack_start (vbox, hbox, true, true, 2);
      gtk_box_pack_end (vbox, statusbar, false, false, 2);

      gtk_container_add (frame, vbox);

      project_view = gtk_notebook_new ();
      document_view = gtk_notebook_new ();
      gtk_widget_show (document_view);

      self.init_project_tree ();
      
      gtk_notebook_append_page (project_view, project_tree, gtk_label_new ("Project"));
      gtk_notebook_append_page (project_view, gtk_text_new (0, 0), gtk_label_new ("Applets"));
      gtk_notebook_append_page (project_view, gtk_text_new (0, 0), gtk_label_new ("Help"));
      
      gtk_box_pack_start (hbox, project_view, false, false, 2);
      gtk_box_pack_end (hbox, document_view, true, true, 2);
    }

  void init_menu ()
    {
      menu_bar_handle_box = gtk_handle_box_new ();
      menu_bar = gtk_menu_bar_new ();
      self.init_menu_project ();
      self.init_menu_document ();
      self.init_menu_run ();

      gtk_container_add (menu_bar_handle_box, menu_bar);
    }

  void init_toolbar ()
    {
      GtkWidget doc_open;
      GtkWidget doc_save;
      GtkWidget doc_close;
      GtkWidget iconw;
      GdkPixmap pixmap;
      GdkBitmap mask;
      GtkPixmap pixmapwid;

      pixmap = gdk_pixmap_create_from_xpm (frame.window, addr_of (mask), null, "icons/tb_new.xpm");
      pixmapwid = gtk_pixmap_new (pixmap, mask);
      gtk_toolbar_append_item (toolbar, "New", "New project", "Private",
			       pixmapwid, GrizzlyFE::project_new_activate, toolbar);

      pixmap = gdk_pixmap_create_from_xpm (frame.window, addr_of (mask), null, "icons/tb_open.xpm");
      pixmapwid = gtk_pixmap_new (pixmap, mask);
      gtk_toolbar_append_item (toolbar, "Open", "Open document", "Private",
			       pixmapwid, GrizzlyFE::project_open_activate, null);
	
      pixmap = gdk_pixmap_create_from_xpm (frame.window, addr_of (mask), null, "icons/tb_save.xpm");
      pixmapwid = gtk_pixmap_new (pixmap, mask);
      gtk_toolbar_append_element(toolbar,
				 GTK_TOOLBAR_CHILD_BUTTON,
				 null, "Save", "Save document", "Private",                    
				 pixmapwid, grizzly_document_save, null);
     
      pixmap = gdk_pixmap_create_from_xpm (frame.window, addr_of (mask), null, "icons/tb_close.xpm");
      pixmapwid = gtk_pixmap_new (pixmap, mask);
      gtk_toolbar_append_element(toolbar,
				 GTK_TOOLBAR_CHILD_BUTTON,
				 null, "Close", "Close document", "Private",                    
				 pixmapwid, grizzly_document_close, null);


      gtk_toolbar_append_space (toolbar);

      pixmap = gdk_pixmap_create_from_xpm (frame.window, addr_of (mask), null, "icons/tb_preferences.xpm");
      pixmapwid = gtk_pixmap_new (pixmap, mask);
      gtk_toolbar_append_element(toolbar,
				 GTK_TOOLBAR_CHILD_BUTTON,
				 null, "Properties", "Project properties", "Private",                    
				 pixmapwid, grizzly_document_save, null);
      
    }

  void init_menu_project ()
    {
      GtkWidget item_project;
      GtkWidget menu_project_new;
      GtkWidget menu_project_open;
      GtkWidget menu_project_save;
      GtkWidget menu_project_close;
      GtkWidget menu_project_prop;
      GtkWidget menu_project_exit;

      menu_project = gtk_menu_new ();
      menu_project_new = gtk_menu_item_new_with_label ("New");
      menu_project_open = gtk_menu_item_new_with_label ("Open");
      menu_project_save = gtk_menu_item_new_with_label ("Save");
      menu_project_close = gtk_menu_item_new_with_label ("Close");
      menu_project_prop = gtk_menu_item_new_with_label ("Properties");
      menu_project_exit = gtk_menu_item_new_with_label ("Exit");

      gtk_signal_connect (menu_project_new, "activate", GrizzlyFE::project_new_activate, null);
      gtk_signal_connect (menu_project_open, "activate", GrizzlyFE::project_open_activate, null);
      gtk_signal_connect (menu_project_save, "activate", GrizzlyFE::project_save_activate, null);        
      gtk_signal_connect (menu_project_prop, "activate", GrizzlyFE::project_prop_activate, null);

      gtk_signal_connect (menu_project_exit, "activate", grizzly_quit, null);
      
      gtk_menu_append (menu_project, menu_project_new);
      gtk_menu_append (menu_project, menu_project_open);
      gtk_menu_append (menu_project, menu_project_save);
      gtk_menu_append (menu_project, menu_project_close);
      gtk_menu_append (menu_project, gtk_menu_item_new ());
      gtk_menu_append (menu_project, menu_project_prop);
      gtk_menu_append (menu_project, gtk_menu_item_new ());
      gtk_menu_append (menu_project, menu_project_exit);
      
      gtk_widget_show (menu_project_new);
      gtk_widget_show (menu_project_open);
      gtk_widget_show (menu_project_save);
      gtk_widget_show (menu_project_close);
      gtk_widget_show (menu_project_prop);
      gtk_widget_show (menu_project_exit);

      gtk_widget_show (menu_project);

      item_project = gtk_menu_item_new_with_label ("Project");
      gtk_menu_item_set_submenu (item_project, menu_project);

      gtk_menu_bar_append (menu_bar, item_project);
    }

  void init_menu_document ()
    {
      GtkWidget item_document;
      GtkWidget menu_document_new;
      GtkWidget menu_document_open;
      GtkWidget menu_document_close;

      menu_document = gtk_menu_new ();
      menu_document_new = gtk_menu_item_new_with_label ("New");
      menu_document_open = gtk_menu_item_new_with_label ("Open");
      menu_document_close = gtk_menu_item_new_with_label ("Close");

      gtk_signal_connect (menu_document_open, "activate", grizzly_document_open, null);
      gtk_signal_connect (menu_document_close, "activate", grizzly_document_close, null);
        
      gtk_menu_append (menu_document, menu_document_new);
      gtk_menu_append (menu_document, menu_document_open);
      gtk_menu_append (menu_document, menu_document_close);
      
      gtk_widget_show (menu_document_new);
      gtk_widget_show (menu_document_open);
      gtk_widget_show (menu_document_close);

      gtk_widget_show (menu_document);

      item_document = gtk_menu_item_new_with_label ("Document");
      gtk_menu_item_set_submenu (item_document, menu_document);

      gtk_menu_bar_append (menu_bar, item_document);
    }

  void init_menu_run ()
    {
      GtkWidget item_run;
      GtkWidget menu_run_run;

      menu_run = gtk_menu_new ();
      menu_run_run = gtk_menu_item_new_with_label ("Run");

      gtk_signal_connect (menu_run_run, "activate", grizzly_run_run, null);
        
      gtk_menu_append (menu_run, menu_run_run);
      
      gtk_widget_show (menu_run_run);

      gtk_widget_show (menu_run);

      item_run = gtk_menu_item_new_with_label ("Run");
      gtk_menu_item_set_submenu (item_run, menu_run);

      gtk_menu_bar_append (menu_bar, item_run);
    }

  void init_view ()
    {
    }

  /* Project menu events
   */

  static void project_new_activate ()
    {
      grizzly.project.new ();
    }

  static void project_open_activate ()
    {
      grizzly.project.choose ();
    }
  
  static void project_save_activate ()
    {
      grizzly.project.save ("project.xml");
    }

  static void project_prop_activate ()
    {
      io_write ("Show properties...\n");
      grizzly.project.show_properties ();
    }
}

void project_prop_activate ()
{
  io_write ("Show properties...\n");
  grizzly.project.show_properties ();
}
