/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xzone.h>

XZone*
x_zone_new ()
{
  XZone* self;

  self = x_new (XZone);
  self->data = NULL;
  self->size = 0;
  x_object_init_object (X_OBJECT (self), (XObjectDestroy) x_zone_destroy);

  x_zone_set_size (self, 0);

  return self;
}

xvoid
x_zone_destroy (XZone* self)
{
  x_destroy (self->data);
  x_destroy (self);
}

xuchar*
x_zone_get_ptr (XZone* self)
{
  return (xuchar*) self->data;
}

xuint
x_zone_get_size (XZone* self)
{
  return self->size;
}

xvoid
x_zone_set_size (XZone* self, xuint p_size)
{
  self->size = p_size;
  self->data = (xptr) x_resize (self->data, self->size);
}

xvoid
x_zone_expand (XZone* self, xuint p_extrasize)
{
  self->size += p_extrasize;
  self->data = (xptr) x_resize (self->data, self->size); 
}

xvoid
x_zone_add_byte (XZone* self, xuchar p_data)
{
  x_zone_expand (self, 1);
  ((xuchar*) self->data) [(self->size)-1] = p_data;
}

xvoid
x_zone_add_dword (XZone* self, xuint p_data)
{
  xuint l_data;

  l_data = p_data;
  x_zone_add_byte (self, ((xuchar*) &l_data)[0]);
  x_zone_add_byte (self, ((xuchar*) &l_data)[1]);
  x_zone_add_byte (self, ((xuchar*) &l_data)[2]);
  x_zone_add_byte (self, ((xuchar*) &l_data)[3]);
}



