/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __X_LIST_H_
#define __X_LIST_H_

#include <xdefs.h>
#include <xobject.h>

#define X_LIST(obj) ((XList*) obj)

typedef struct _XList XList;
struct _XList
{
  XObject parent;

  XObject** data;
  xuint size;
};

XList*
x_list_new ();

xvoid
x_list_destroy (XObject* self);

xvoid
x_list_clear (XList* self);

xuint
x_list_get_size (XList* self);

xvoid
x_list_resize (XList* self, xuint p_newsize);

XObject*
x_list_get (XList* self, xuint p_index);

xvoid
x_list_add (XList* self, XObject* p_item);

xvoid
x_list_remove (XList* self, xuint p_index);

#endif
