/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */
 
#ifdef WIN32

#include <xdynamic.h>
#include <windows.h>

xptr
x_dynamic_load (xstr p_library_name)
{
  return (xptr) LoadLibrary ((LPCSTR) p_library_name);
}

xvoid
x_dynamic_unload (xptr p_library)
{
  FreeLibrary ((HMODULE) p_library);
}

xptr
x_dynamic_get_symbol (xptr p_library, xstr p_symbol)
{
  return (xptr) GetProcAddress ((HMODULE) p_library, (LPCSTR) p_symbol);
}

#else

#include <xdynamic.h>
#include <dlfcn.h>

xptr
x_dynamic_load (xstr p_library_name)
{
  xptr l_library;
  
  l_library = (xptr) dlopen (p_library_name, RTLD_LAZY | RTLD_GLOBAL);
  if (!l_library)
    printf ("dynamic error: %s\n", dlerror ());

  return l_library;
}

xvoid
x_dynamic_unload (xptr p_library)
{
  dlclose (p_library);
}

xptr
x_dynamic_get_symbol (xptr p_library, xstr p_symbol)
{
  xptr l_symbol;

  l_symbol = (xptr) dlsym (p_library, p_symbol);
  if (!l_symbol)
    printf ("dynamic error: %s\n", dlerror ());
}

#endif




