/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __X_WND_WINDOW_H_
#define __X_WND_WINDOW_H_

#include <xdefs.h>
#include <xobject.h>
#include <xlist.h>

#define X_WND_WINDOW(obj) ((XWndWindow*) obj)

struct _XWndWindow
{
  XObject         parent;

  xptr            native_window;
};

extern XList* g_window_list;

XWndWindow*
x_wnd_window_new ();

xvoid
x_wnd_window_destroy (XObject* self);

xvoid
x_wnd_window_add (XWndWindow* self);

xvoid
x_wnd_window_remove (XWndWindow* self);

XWndWindow*
x_wnd_window_lookup (xptr native_window);

xbool
x_wnd_window_init ();

XWndWindow*
x_wnd_window_open (xstr title, xint x, xint y, xuint w, xuint h, XWndWindow* parent);

xvoid
x_wnd_window_close (XWndWindow* self);

xvoid
x_wnd_window_set_pos (XWndWindow* self, xint x, xint y);

xint
x_wnd_window_get_pos_x (XWndWindow* self);

xint
x_wnd_window_get_pos_y (XWndWindow* self);

xvoid
x_wnd_window_set_size (XWndWindow* self, xuint w, xuint h);

xuint
x_wnd_window_get_size_w (XWndWindow* self);

xuint
x_wnd_window_get_size_h (XWndWindow* self);

xvoid
x_wnd_window_set_show (XWndWindow* self, xbool is_show);

xbool
x_wnd_window_get_show (XWndWindow* self);

xvoid
x_wnd_window_redraw (XWndWindow* self);

XWndGC*
x_wnd_window_get_gc (XWndWindow* self);

xvoid
x_wnd_window_release_gc (XWndWindow* self, XWndGC* gc);

XWndWindow*
x_wnd_window_get_parent (XWndWindow* self);

xvoid
x_wnd_window_set_parent (XWndWindow* self, XWndWindow* parent);

xstr
x_wnd_window_get_title (XWndWindow* self);

xvoid
x_wnd_window_set_title (XWndWindow* self, xstr title);

#endif
